/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cfc;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.filter.ClientScopePersistenceFilter;
import coldfusion.filter.DatasourceFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.GlobalsFilter;
import coldfusion.filter.InternalCFCMonitorFilter;
import coldfusion.filter.ServerCFCFilter;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.ByteArrayOutputStream;

public class ServerCFCProxy {
    public static final String ONSSMETHOD = "OnServerStart";
    public static final String CFCNAME = "/server.cfc";
    private static String cfcPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeComponent(ServletContext context) throws Throwable {
        ServerCFCProxy.initCFCPath(context);
        FusionContext fusionContext = ServerCFCProxy.getFusionContext(cfcPath, context);
        FusionContext oldFusionContext = FusionContext.setCurrent(fusionContext);
        FusionFilter filterChain = ServerCFCProxy.getComponentFilterChain();
        try {
            filterChain.invoke(fusionContext);
        }
        finally {
            FusionContext.setCurrent(oldFusionContext);
        }
    }

    private static FusionFilter getComponentFilterChain() {
        FusionFilter filter = new ServerCFCFilter(cfcPath);
        filter = new InternalCFCMonitorFilter(filter, "TEMPLATE REQUEST");
        filter = new ClientScopePersistenceFilter(filter);
        boolean needsFormScope = false;
        filter = new GlobalsFilter(filter, false);
        filter = new DatasourceFilter(filter);
        return filter;
    }

    private static FusionContext getFusionContext(String cfcPath, ServletContext context) {
        FusionContext fusionContext = FusionContext.getCurrent();
        if (fusionContext == null) {
            fusionContext = new FusionContext();
            fusionContext.setUseMappings(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DummyHttpServletRequest req = new DummyHttpServletRequest(cfcPath);
            DummyHttpServletResponse resp = new DummyHttpServletResponse(baos);
            fusionContext.setServletObjects(context, (ServletRequest)req, (ServletResponse)resp);
            fusionContext.setPagePath(cfcPath);
        }
        return fusionContext;
    }

    private static void initCFCPath(ServletContext context) {
        cfcPath = ServiceFactory.getRuntimeService().getServerCFC();
        if ("".equals(cfcPath)) {
            cfcPath = context.getRealPath(CFCNAME);
        }
    }

    public static String getCFCPath() {
        return cfcPath;
    }
}

