/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud;

import coldfusion.cloud.CloudVendorName;
import coldfusion.cloud.VendorServiceFactory;
import coldfusion.cloud.aws.AWSServiceFactory;
import coldfusion.cloud.azure.AzureServiceFactory;
import coldfusion.cloud.gcp.GCPServiceFactory;
import java.util.HashMap;
import java.util.Map;

public class CloudVendorFactory {
    private static Map<CloudVendorName, VendorServiceFactory> vendorServiceFactoryMap = new HashMap<CloudVendorName, VendorServiceFactory>();

    public static void registerServiceFactory(CloudVendorName cloudVendorName, VendorServiceFactory serviceFactory) {
        vendorServiceFactoryMap.put(cloudVendorName, serviceFactory);
    }

    public static VendorServiceFactory getCloudServiceFactory(CloudVendorName vendor) {
        VendorServiceFactory factory = vendorServiceFactoryMap.get((Object)vendor);
        if (factory == null) {
            if (vendor.equals((Object)CloudVendorName.AWS)) {
                factory = new AWSServiceFactory();
            } else if (vendor.equals((Object)CloudVendorName.AZURE)) {
                factory = new AzureServiceFactory();
            } else if (vendor.equals((Object)CloudVendorName.GCP)) {
                factory = new GCPServiceFactory();
            }
            vendorServiceFactoryMap.put(vendor, factory);
        }
        return factory;
    }
}

