/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud;

import coldfusion.cloud.CloudVendorName;
import coldfusion.cloud.VendorCredential;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.azure.AzureCredential;
import coldfusion.cloud.azure.ServiceBusKeyBasedCredential;
import coldfusion.cloud.azure.ServiceBusTokenBasedCredential;
import coldfusion.cloud.consumer.AWSCredentialConsumer;
import coldfusion.cloud.consumer.AzureCredentialConsumer;
import coldfusion.cloud.consumer.GCPCredentialConsumer;
import coldfusion.cloud.consumer.ServiceBusKeyBasedCredentialConsumer;
import coldfusion.cloud.consumer.ServiceBusTokenBasedCredentialConsumer;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.Struct;
import coldfusion.server.ConfigMap;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import coldfusion.util.StructUtil;
import coldfusion.util.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class VendorCredentialService
extends ServiceBase
implements Observer,
StructUtil {
    private Logger logger = CFLogs.SERVER_LOG;
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private File vendorCredentialFile;
    private ConfigMap credentialSetting;
    private String seed;
    private static final String CLOUD_CREDENTIALS_LIST_KEY = "CLOUDCREDENTIALS";
    private static final String ALIAS_KEY = "ALIAS";
    private static final String staticpassword = "***************";
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private static final Set<String> fieldsToBeEncrypted = SetUtils.unmodifiableSet(new HashSet<String>(Arrays.asList("secretAccessKey", "accessKeyId", "connectionString")));

    public VendorCredentialService(File vendorCredentialFile) {
        this.vendorCredentialFile = vendorCredentialFile;
    }

    public void addCredentialsData(Object o) {
        ConfigMap c = (ConfigMap)o;
        Struct s = new Struct();
        s.putAll((Map)c);
        this.addCredentialsData(s);
    }

    public void addCredentialsData(Struct struct) {
        if (Objects.isNull(struct)) {
            throw new ValidationException("null input");
        }
        Struct structCopy = null;
        try {
            structCopy = (Struct)struct.duplicate();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to make a copy of Struct!");
        }
        VendorCredential credential = this.transform(structCopy, true);
        this.encryptField(structCopy);
        if (this.credentialSetting.containsKey(credential.getAlias())) {
            throw new ValidationException(credential.getAlias() + " alias already exists.");
        }
        this.credentialSetting.put(credential.getAlias(), (Object)structCopy);
        try {
            this.store(struct.get("alias"), structCopy, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to update!");
        }
    }

    private void encryptField(Struct struct) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, (Object)PasswordUtils.encryptPassword((String)struct.get(fieldName), PasswordUtils.getInstance().getSeedValue()));
            }
        });
    }

    private void decryptField(Struct struct, String seed) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, (Object)PasswordUtils.decryptPassword((String)struct.get(fieldName), seed));
            }
        });
    }

    public List<Struct> getAllCredentialsData() {
        Collection credentials = this.credentialSetting.values();
        return credentials.stream().map(cred -> {
            Struct struct = new Struct();
            struct.putAll((Map)cred);
            this.decryptField(struct, PasswordUtils.getInstance().getSeedValue());
            return struct;
        }).collect(Collectors.toList());
    }

    public void deleteCredentialsData(String alias) throws ServiceException {
        if (alias == null || alias.equals("")) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "deleteCredEmptyAlias"));
        }
        if (!this.credentialSetting.containsKey(alias)) {
            throw new CredentialDoesNotExistException(alias);
        }
        Object copy = this.credentialSetting.get(alias);
        this.credentialSetting.remove(alias);
        this.store(alias, null, copy);
    }

    public Struct getCredentialDataForCFAdmin(String alias) {
        Struct cred = this.getCredentialData(alias);
        this.removeSecretKey(cred);
        return cred;
    }

    public Struct getCredentialData(String alias) {
        if (alias == null || alias.equals("")) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "getCredEmptyAlias"));
        }
        Map credMap = (Map)this.credentialSetting.get(alias);
        if (credMap != null) {
            Struct vendorCred = new Struct();
            vendorCred.putAll(credMap);
            this.decryptField(vendorCred, PasswordUtils.getInstance().getSeedValue());
            return vendorCred;
        }
        throw new CredentialDoesNotExistException(alias);
    }

    private void removeSecretKey(Struct struct) {
        String vendorName = (String)struct.get("vendorName");
        if (vendorName.toUpperCase().equals(CloudVendorName.AWS.toString())) {
            struct.put("secretAccessKey", (Object)staticpassword);
        }
    }

    public VendorCredential getCredential(String alias) {
        if (this.credentialSetting.containsKey(alias)) {
            Struct struct = this.getCredentialData(alias);
            return this.transform(struct);
        }
        return null;
    }

    public void modifyCredentialsData(String oldAlias, Struct struct) {
        if (Objects.isNull(oldAlias)) {
            throw new ValidationException("oldAlias is null.");
        }
        if (oldAlias.equals("")) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "aliasKeyEmpty"));
        }
        if (Objects.isNull(struct)) {
            throw new ValidationException("config struct is null");
        }
        if (!this.credentialSetting.containsKey(oldAlias)) {
            throw new ValidationException("oldAlias : " + oldAlias + " is not present.");
        }
        Struct oldStruct = this.getCredentialData(oldAlias);
        Struct oldStructCopy = new Struct();
        oldStructCopy.putAll((Map)oldStruct);
        String oldSecretAccessKey = null;
        String newSecretAccessKey = null;
        if (!struct.containsKey("vendorname")) {
            struct.put("vendorname", oldStruct.get("vendorname"));
        }
        if (oldStruct.get("vendorname").equals("AWS") && struct.get("vendorname").equals("AWS")) {
            oldSecretAccessKey = (String)oldStruct.get("secretaccesskey");
            newSecretAccessKey = (String)struct.get("secretaccesskey");
        }
        if (oldStruct.get("vendorname").equals(struct.get("vendorname"))) {
            oldStruct.putAll((Map)struct);
        }
        if (oldSecretAccessKey != null && newSecretAccessKey != null && newSecretAccessKey.equals(staticpassword)) {
            oldStruct.put("secretaccesskey", (Object)oldSecretAccessKey);
        }
        if (struct.containsKey("alias")) {
            throw new ValidationException("Alias cannot be modified once created. Please create credentials with a new alias");
        }
        if (!oldStruct.get("vendorname").equals(struct.get("vendorname"))) {
            oldStruct = struct;
            oldStruct.put("alias", (Object)oldAlias);
        }
        VendorCredential vendorCredential = this.transform(oldStruct);
        vendorCredential.setAlias(oldAlias);
        this.encryptField(oldStruct);
        this.credentialSetting.put(oldAlias, (Object)oldStruct);
        try {
            this.store(oldAlias, struct, oldStructCopy);
        }
        catch (ServiceBase.CCSEnabledButNotAvailableException e) {
            throw new RuntimeException("CCS is enabled but not running");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to update!");
        }
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        if (this.isFirstLoad()) {
            PasswordUtils.getInstance().addObserver(this);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.vendorCredentialFile = Utils.getCanonicalFile(this.vendorCredentialFile);
            this.credentialSetting = (ConfigMap)this.deserialize(this.vendorCredentialFile);
            if (this.credentialSetting == null) {
                this.credentialSetting = new ConfigMap(this, "cloudConfig");
            }
        }
        catch (Exception e) {
            this.logger.error("Error while starting vendor credential service " + e.getMessage(), e);
            throw new ServiceException(e);
        }
    }

    @Override
    public void store() {
        this.serialize(this.credentialSetting, this.vendorCredentialFile);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.serialize(this.credentialSetting, this.vendorCredentialFile, true, key, value, oldValue);
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("cloudConfig.formats", "coldfusion.server.MapFormatter");
            this.rb.put("cloudConfig.value", "");
        }
        return this.rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            String string = seedVal;
            synchronized (string) {
                this.reEncryptPasswords(oldSeed);
            }
        }
    }

    private void reEncryptPasswords(String oldSeed) {
        this.credentialSetting.forEach((k, v) -> {
            this.decryptField((Struct)v, oldSeed);
            this.encryptField((Struct)v);
        });
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reEncryptPasswordsForMigration(String s, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (!PasswordUtils.isAESS(majorVersion, minorVersion)) {
            oldSeed = OLDSEEDVAL;
        }
        if (s != null) {
            ConfigMap configMap = this.credentialSetting;
            synchronized (configMap) {
                try {
                    s = PasswordUtils.reEncryptWithNewSeed(s, oldSeed, this.seed, oldAlgoValue, majorVersion, minorVersion);
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
        }
        return s;
    }

    public String getSeed() {
        return this.seed;
    }

    public VendorCredential fromApplicationScope(String alias, CloudVendorName vendorName) {
        if ((alias = alias.trim()).isEmpty()) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "emptyCredentialAlias"));
        }
        Struct struct = null;
        ApplicationScope appScope = (ApplicationScope)FusionContext.getApplicationScope();
        if (appScope == null) {
            return null;
        }
        List cloudCredentials = (List)appScope.getApplicationSettingsMap().get(CLOUD_CREDENTIALS_LIST_KEY);
        struct = this.getStructFromList(cloudCredentials, ALIAS_KEY, alias);
        if (struct != null) {
            struct.putIfAbsent("vendorName", vendorName);
            return this.transform(struct);
        }
        return null;
    }

    public VendorCredential getVendorCredential(Object vendorCredential, CloudVendorName vendorName) {
        VendorCredential credential;
        if (vendorCredential == null) {
            return vendorName == CloudVendorName.AWS ? new AWSCredential() : null;
        }
        if (vendorCredential instanceof Struct) {
            if (((Struct)vendorCredential).get("alias") == null) {
                ((Struct)vendorCredential).put("alias", (Object)"alias".concat(String.valueOf(System.currentTimeMillis())));
            }
            ((Struct)vendorCredential).putIfAbsent("vendorName", vendorName);
            credential = this.transform((Struct)vendorCredential);
        } else {
            credential = this.fromApplicationScope(FieldTypecastUtil.INSTANCE.getStringProperty(vendorCredential), vendorName);
            if (credential == null) {
                credential = this.getCredential(FieldTypecastUtil.INSTANCE.getStringProperty(vendorCredential));
            }
        }
        return credential;
    }

    public VendorCredential transform(Struct struct) {
        return this.transform(struct, false);
    }

    public VendorCredential transform(Struct struct, boolean checkAlias) {
        CloudVendorName vendorName;
        if (struct.isEmpty()) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "emptyCloudCredentialStruct"));
        }
        if (checkAlias && struct.get("alias") == null || struct.get("alias").equals("")) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "cloudAliasNotFound"));
        }
        if (struct.get("vendorName") == null) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "cloudVendorNameNotFound"));
        }
        if (struct.get("vendorName").equals("")) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "cloudVendorNameEmpty"));
        }
        try {
            String vendor = FieldTypecastUtil.INSTANCE.getStringProperty(struct.get("vendorName"));
            vendor = vendor != null ? vendor.trim().toUpperCase() : vendor;
            vendorName = CloudVendorName.valueOf(vendor);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "invalidCloudVendorName"));
        }
        switch (vendorName) {
            case AWS: {
                if (struct.get("accessKeyId") == null || struct.get("accessKeyId").equals("")) {
                    if (struct.get("secretAccessKey") != null && !struct.get("secretAccessKey").equals("")) {
                        throw new ValidationException(RB.getString(VendorCredentialService.class, "AWSAccessKeyIdNotFound"));
                    }
                } else if (struct.get("secretAccessKey") == null || struct.get("secretAccessKey").equals("")) {
                    throw new ValidationException(RB.getString(VendorCredentialService.class, "AWSSecretAccessKeyNotFound"));
                }
                AWSCredential awsCredential = new AWSCredential();
                this.filler.fillObject(awsCredential, struct, new AWSCredentialConsumer());
                return awsCredential;
            }
            case AZURE: {
                int fieldCount = struct.keySet().size();
                switch (fieldCount) {
                    case 5: {
                        ServiceBusTokenBasedCredential tokenBasedCredential = new ServiceBusTokenBasedCredential();
                        this.filler.fillObject(tokenBasedCredential, struct, new ServiceBusTokenBasedCredentialConsumer());
                        return tokenBasedCredential;
                    }
                    case 6: {
                        ServiceBusKeyBasedCredential keyBasedCredential = new ServiceBusKeyBasedCredential();
                        this.filler.fillObject(keyBasedCredential, struct, new ServiceBusKeyBasedCredentialConsumer());
                        return keyBasedCredential;
                    }
                }
                AzureCredential azureCredential = new AzureCredential();
                this.filler.fillObject(azureCredential, struct, new AzureCredentialConsumer());
                return azureCredential;
            }
            case GCP: {
                GCPCredential gcpCredential = new GCPCredential();
                this.filler.fillObject(gcpCredential, struct, new GCPCredentialConsumer());
                return gcpCredential;
            }
        }
        throw new ValidationException(vendorName.name() + " : is not configured with VendorCredentialService");
    }

    public class CredentialDoesNotExistException
    extends ApplicationException {
        public String credentialAlias;

        public CredentialDoesNotExistException(String credAlias) {
            this.credentialAlias = credAlias;
        }
    }
}

