/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.VendorServiceFactory;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.config.AbstractGCPServiceConfig;
import coldfusion.server.ServiceFactory;
import java.util.Optional;

public class GCPServiceFactory
extends VendorServiceFactory {
    @Override
    public Optional<CloudServiceProducer> getCloudServiceProducer(CloudServiceName serviceName) {
        CloudServiceProducer<GCPCredential, AbstractGCPServiceConfig> producer = (CloudServiceProducer<GCPCredential, AbstractGCPServiceConfig>)serviceProducerMap.get((Object)serviceName);
        if (producer == null) {
            if (CloudServiceName.PUBSUB.equals((Object)serviceName)) {
                producer = ServiceFactory.getPubSubService(true).getPubSubProducer();
            } else if (CloudServiceName.STORAGE.equals((Object)serviceName)) {
                producer = ServiceFactory.getStorageService(true).getStorageProducer();
            }
            if (CloudServiceName.FIRESTORE.equals((Object)serviceName)) {
                producer = ServiceFactory.getFirestoreService(true).getFirestoreProducer();
            }
            serviceProducerMap.put(serviceName, producer);
        }
        return Optional.ofNullable(producer);
    }
}

