/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.util.GsonDeserializationUtil;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public enum CloudDeserializationUtil {
    INSTANCE;

    private static ObjectMapper mapper;

    public String toJsonString(Object obj) {
        String json = "";
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return json;
    }

    public <T> List<T> getAllNodes(JsonNode jsonNode, String handle, Class type) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (jsonNode.get(i) != null) {
            try {
                if (handle != null) {
                    list.add(mapper.treeToValue((TreeNode)jsonNode.get(i).get(handle), type));
                } else {
                    list.add(mapper.treeToValue((TreeNode)jsonNode.get(i), type));
                }
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    public <T> List<T> getAllNodes(String jsonString, String handle, Class type) {
        JsonNode jsonNode = this.toJsonNode(jsonString);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (jsonNode.get(i) != null) {
            try {
                if (handle != null) {
                    list.add(mapper.treeToValue((TreeNode)jsonNode.get(i).get(handle), type));
                } else {
                    list.add(mapper.treeToValue((TreeNode)jsonNode.get(i), type));
                }
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    public JsonNode toJsonNode(String json) {
        JsonNode jsonNode = null;
        try {
            jsonNode = (JsonNode)mapper.readValue(json, JsonNode.class);
        }
        catch (JsonParseException | JsonMappingException throwable) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return jsonNode;
    }

    public <T> T structToBean(Struct struct, Class<T> clazz) {
        return (T)mapper.convertValue((Object)struct, clazz);
    }

    public Struct beanToStruct(Object object) {
        try {
            Struct struct = (Struct)JSONUtils.deserializeJSON(mapper.writeValueAsString(object));
            return struct;
        }
        catch (JsonProcessingException jsonProcessingException) {
            return new Struct();
        }
    }

    public Struct beanToStructUsingGson(Object object) {
        try {
            Struct struct = (Struct)JSONUtils.deserializeJSON(GsonDeserializationUtil.INSTANCE.toJsonString(object), false, true, true);
            GsonDeserializationUtil.INSTANCE.updateMessageResponse(struct);
            return struct;
        }
        catch (Exception exception) {
            return new Struct();
        }
    }

    static {
        mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

