/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.gcp.model.PubSubMessageWrapper;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public enum GsonDeserializationUtil {
    INSTANCE;

    private static Gson gson;

    public String toJsonString(Object obj) {
        return gson.toJson(obj);
    }

    public Struct updateMessageResponse(Struct response) {
        String schemaEncoding;
        Struct attributesStruct;
        if (response != null && response.containsKey("attributes") && response.containsKey("data") && (attributesStruct = (Struct)response.get("attributes")).containsKey("googclient_schemaencoding") && (schemaEncoding = (String)attributesStruct.get("googclient_schemaencoding")) != null && schemaEncoding.equalsIgnoreCase("BINARY") && response.get("data") != null) {
            response.put("data", (Object)Cast.ToBinary(response.get("data")));
        }
        return response;
    }

    static {
        gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new CustomGSONExclusionStrategy()).setFieldNamingStrategy((FieldNamingStrategy)new CustomGSONFieldNamingStrategy()).registerTypeAdapter(ByteString.class, (Object)new ByteStringToBase64TypeAdapter()).registerTypeAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).registerTypeAdapter(Duration.class, (Object)new ProtobufDurationToStringTypeAdapter()).registerTypeAdapter(QueryTable.class, (Object)new CFQueryToJSONObjectTypeAdapter()).registerTypeAdapter(PubSubMessageWrapper.class, (Object)new PubSubMessageWrapperToJSONObjectTypeAdapter()).create();
    }

    private static class CustomGSONExclusionStrategy
    implements ExclusionStrategy {
        List<String> fieldExclusions = Arrays.asList("memoizedHashCode", "memoizedIsInitialized", "memoizedSize", "unknownFields", "state", "auditConfigs_");

        private CustomGSONExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> arg0) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return this.fieldExclusions.contains(f.getName());
        }
    }

    private static class CustomGSONFieldNamingStrategy
    implements FieldNamingStrategy {
        private CustomGSONFieldNamingStrategy() {
        }

        public String translateName(Field field) {
            String fieldName = field.getName();
            if (fieldName != null && fieldName.endsWith("_")) {
                fieldName = fieldName.substring(0, fieldName.length() - 1);
                return fieldName;
            }
            return fieldName;
        }
    }

    private static class ByteStringToBase64TypeAdapter
    implements JsonSerializer<ByteString> {
        private ByteStringToBase64TypeAdapter() {
        }

        public JsonElement serialize(ByteString src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(src.toByteArray()));
        }
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public JsonElement serialize(byte[] src, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(src));
        }
    }

    private static class ProtobufDurationToStringTypeAdapter
    implements JsonSerializer<Duration> {
        private ProtobufDurationToStringTypeAdapter() {
        }

        public JsonElement serialize(Duration duration, Type type, JsonSerializationContext jsonSerializationContext) {
            return JsonParser.parseString((String)FieldTypecastUtil.toDurationString(duration.getSeconds()));
        }
    }

    private static class CFQueryToJSONObjectTypeAdapter
    implements JsonSerializer<QueryTable> {
        private CFQueryToJSONObjectTypeAdapter() {
        }

        public JsonElement serialize(QueryTable queryTable, Type type, JsonSerializationContext jsonSerializationContext) {
            return JsonParser.parseString((String)JSONUtils.serializeJSON(queryTable));
        }
    }

    private static class PubSubMessageWrapperToJSONObjectTypeAdapter
    implements JsonSerializer<PubSubMessageWrapper> {
        private PubSubMessageWrapperToJSONObjectTypeAdapter() {
        }

        public JsonElement serialize(PubSubMessageWrapper pubSubMessageWrapper, Type type, JsonSerializationContext jsonSerializationContext) {
            return JsonParser.parseString((String)pubSubMessageWrapper.getData());
        }
    }
}

