/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.Objects;

public class CFPositiveLongValidator
implements Validator {
    private String fieldName;

    public CFPositiveLongValidator(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean validate(Object obj) {
        try {
            if (Objects.isNull(obj) || obj instanceof String && ((String)obj).trim().length() == 0) {
                return true;
            }
            long value = Cast._long(obj);
            if (value <= 0L) {
                throw new FieldValidationFailedException(RB.getString(CFPositiveLongValidator.class, "POSITIVE_INTEGER_VALUE_VALIDATION_ERROR", (Object)this.fieldName, obj));
            }
            return true;
        }
        catch (Cast.NumberConversionException e) {
            throw new FieldValidationFailedException(RB.getString(CFPositiveLongValidator.class, "POSITIVE_INTEGER_VALUE_VALIDATION_ERROR", (Object)this.fieldName, obj), e);
        }
    }
}

