/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.Objects;

public class IntegerRangeValidator
implements Validator {
    String fieldName;
    Integer minRange;
    Integer maxRange;

    public boolean validate(Object obj) {
        if (Objects.isNull(obj)) {
            return true;
        }
        try {
            int val = Cast._int(obj);
            if (this.minRange != null && val < this.minRange || this.maxRange != null && val > this.maxRange) {
                throw new FieldValidationFailedException(RB.getString(IntegerRangeValidator.class, "INTEGER_RANGE_VALIDATION_ERROR", obj, (Object)this.fieldName, (Object)this.minRange, (Object)this.maxRange));
            }
            return true;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect type for field name " + this.fieldName, ex);
        }
    }

    public IntegerRangeValidator(String fieldName, Integer minRange, Integer maxRange) {
        this.fieldName = fieldName;
        this.minRange = minRange;
        this.maxRange = maxRange;
    }
}

