/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTObjectDestructuring;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.DuplicateVariableDeclarationException;
import java.util.HashSet;
import java.util.Set;

public class ASTDestructParamValidator {
    private String functionName = "";
    private final Set<String> paramKeys = new HashSet<String>();

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setParamKeys(String paramName) {
        if (this.paramKeys.contains(paramName.trim())) {
            throw new DuplicateVariableDeclarationException(paramName, this.functionName);
        }
        this.paramKeys.add(paramName);
    }

    public void validateAndAddParam(ASTObjectDestructuring astObjectDestructuring) {
        ASTsimpleVariableReference varRef = null;
        for (ASTDestructring.AssignmentElement assignmentElement : astObjectDestructuring.assignmentElements) {
            if (!(assignmentElement instanceof ASTObjectDestructuring.ObjectAssignmentProperty)) continue;
            ASTObjectDestructuring.ObjectAssignmentProperty objectAssignmentProperty = (ASTObjectDestructuring.ObjectAssignmentProperty)assignmentElement;
            if (objectAssignmentProperty.label != null) {
                varRef = (ASTsimpleVariableReference)objectAssignmentProperty.label;
                this.setParamKeys(varRef.getCodegenVariableName());
                continue;
            }
            if (objectAssignmentProperty.value == null) {
                varRef = (ASTsimpleVariableReference)objectAssignmentProperty.key;
                this.setParamKeys(varRef.getCodegenVariableName());
                continue;
            }
            if (!(objectAssignmentProperty.value instanceof ASTObjectDestructuring)) continue;
            this.validateAndAddParam((ASTObjectDestructuring)objectAssignmentProperty.value);
        }
        if (astObjectDestructuring.restOpKeyName != null) {
            varRef = (ASTsimpleVariableReference)astObjectDestructuring.restOpKeyName;
            this.setParamKeys(varRef.getCodegenVariableName());
        }
    }
}

