/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagNode;
import coldfusion.runtime.Cast;
import java.util.Date;

public class ASTcfcase
extends TagNode {
    private ExprNode caseSpec = null;
    boolean isCfcase = false;

    public ASTcfcase(int id) {
        super(id);
    }

    void setCfcase(boolean b) {
        this.isCfcase = b;
    }

    void setCasespec(ExprNode n) {
        if (n == null) {
            throw new CompilerInternalException(this);
        }
        this.caseSpec = n;
        this.putAttrNode("CASESPEC", n);
        n.jjtSetParent(this);
    }

    String getCasespec() throws ParseException {
        ExprNode valueNode = this.getAttrNode("VALUE");
        if (valueNode != null) {
            return EvaluateEngine._String(valueNode);
        }
        if (this.caseSpec != null) {
            if (this.caseSpec.id == 10003 || this.caseSpec.id == 10000 || this.caseSpec.id == 10002) {
                return "";
            }
            return EvaluateEngine._String(this.caseSpec);
        }
        return null;
    }

    ExprNode getDynamicCaseValue() throws ParseException {
        ExprNode valueNode = this.getAttrNode("VALUE");
        if (valueNode != null) {
            return valueNode;
        }
        if (this.caseSpec != null) {
            return this.caseSpec;
        }
        return null;
    }

    Object normalizedConstant(String constValue) {
        try {
            double d = Cast._double(constValue, false);
            return new Double(d);
        }
        catch (Exception ne) {
            try {
                Date date = Cast._Date(constValue);
                if (date != null) {
                    return date;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return constValue.toUpperCase();
        }
    }

    boolean isDefaultcase() throws ParseException {
        return this.getCasespec() == null;
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        cfml.visit(this);
        this.walkChildren(cfml);
    }

    ASTcfswitch getSwitch() throws ParseException {
        Node n;
        for (n = this.jjtGetParent(); n != null && n instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)n).getStatementType() == 1; n = n.jjtGetParent()) {
        }
        if (n instanceof ASTcfswitch) {
            return (ASTcfswitch)n;
        }
        throw new InvalidCaseStructureException(this);
    }

    public class InvalidCaseStructureException
    extends ParseException {
        public ASTcfcase invalidCase;

        public InvalidCaseStructureException(ASTcfcase invalid) {
            super(invalid.getStartToken());
            this.invalidCase = invalid;
        }
    }
}

