/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.Token;
import coldfusion.util.FastHashtable;
import java.util.HashMap;
import java.util.Map;

public class ASTfunctionDefinition
extends StatementNode {
    static final String CLOSURE_PREFIX = "_CF_ANONYMOUSCLOSURE_";
    Token functionName;
    ASTparameterDefinition parameterDefinition = null;
    public static final int GENFUNCTIONDEFINITION = 43334;
    String calledName = null;
    boolean closure = false;
    boolean anonymousClosure = false;
    static volatile int closureCount = 0;
    private Boolean isStatic = null;
    public boolean retStatementDebugCodeGenerated = false;
    private Map<String, Boolean> jsVarDecl = new HashMap<String, Boolean>();
    FastHashtable localVars = new FastHashtable();
    ASTexprlist attrList;

    public Map<String, Boolean> getJsVarDecl() {
        if (this.jsVarDecl.size() > 0) {
            return this.jsVarDecl;
        }
        return null;
    }

    public void addJsVarDecl(String jsVar, boolean isGlobal) {
        if (this.jsVarDecl.get(jsVar) == null) {
            this.jsVarDecl.put(jsVar, isGlobal);
        }
    }

    public void registerName(String calledName) {
        this.calledName = calledName;
    }

    ASTfunctionDefinition(int id) {
        super(id);
    }

    ASTfunctionDefinition() {
        super(43334);
    }

    void setName(Token name) {
        this.functionName = name;
        String sName = name.image;
        if (ExprNode.getMethodMap(this.getTranslationContext().getBaseClass()).containsKey(sName) && !this.getTranslationContext().getPageFile().getName().toLowerCase().endsWith(".cfc")) {
            throw new InvalidUDFNameException(name);
        }
        if (!CFMLParserBase.isValidSimpleIdentifier(sName)) {
            throw new IllegalUDFNameException(name);
        }
        if (this.closure) {
            this.getTranslationContext().registerUserDefinedClosure(this);
        } else {
            this.getTranslationContext().registerUserDefinedFunction(this);
        }
    }

    void setNameForClosure(Token name) {
        this.setNameForClosure(name, true);
    }

    void setNameForClosure(Token name, boolean anon) {
        this.anonymousClosure = anon;
        if (name.image == null) {
            name.image = CLOSURE_PREFIX + this.getTranslationContext().getClosureCount();
            this.anonymousClosure = true;
        }
        this.closure = true;
        this.functionName = name;
        String sName = name.image;
        if (anon) {
            this.getTranslationContext().unregisterUserDefinedFunction(sName.toUpperCase());
        }
        this.getTranslationContext().registerUserDefinedClosure(this);
    }

    public void setClosure(boolean closure) {
        this.closure = closure;
    }

    public boolean isClosure() {
        return this.closure;
    }

    @Override
    public boolean isStatic() {
        if (!this.parser.supportStatic()) {
            return false;
        }
        if (this.isStatic != null) {
            return this.isStatic;
        }
        if (this.attrList == null) {
            return false;
        }
        Node[] children = this.attrList.children;
        for (int i = 0; children != null && i < children.length; ++i) {
            ASTtagAttribute n;
            if (children[i] == null || (n = (ASTtagAttribute)children[i]) == null || !n.getName().equalsIgnoreCase("static")) continue;
            this.isStatic = true;
            return this.isStatic;
        }
        this.isStatic = false;
        return this.isStatic;
    }

    public boolean isAnonymousClosure() {
        return this.anonymousClosure;
    }

    void setParameterdefinition(ASTparameterDefinition p) {
        this.parameterDefinition = p;
        p.jjtSetParent(this);
    }

    ASTparameterDefinition getParameterdefinition() {
        return this.parameterDefinition;
    }

    public String getCodeGenName() {
        return this.functionName.image.toUpperCase();
    }

    public String getUserName() {
        return this.functionName.image;
    }

    public Token getNameToken() {
        return this.functionName;
    }

    public boolean isLocalReference(String name) {
        return this.isParameter(name) || this.isLocalVariable(name) || name.equalsIgnoreCase("ARGUMENTS") || name.equalsIgnoreCase("THIS");
    }

    public boolean isParameter(String name) {
        if (this.getParameterdefinition() == null) {
            return false;
        }
        return this.getParameterdefinition().hasParameter(name);
    }

    private boolean isLocalVariable(String name) {
        return this.localVars.containsKey(name);
    }

    void addLocalVariable(ASTvariableDefinition vardef) {
        this.localVars.put(vardef.name, (Object)vardef);
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        this.walkChildren(cfml);
    }

    public static final class InvalidUDFNameException
    extends AbstractParseException {
        private String m_sName;

        InvalidUDFNameException(Token name) {
            super(name);
            this.m_sName = name.image;
        }

        public String getUDFName() {
            return this.m_sName;
        }
    }

    public static final class IllegalUDFNameException
    extends AbstractParseException {
        private String m_sName;

        IllegalUDFNameException(Token name) {
            super(name);
            this.m_sName = name.image;
        }

        public String getUDFName() {
            return this.m_sName;
        }
    }
}

