/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.StmtAssembler;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import coldfusion.util.FastHashtable;
import java.util.Map;
import java.util.Vector;

public final class ASTsimpleVariableReference
extends VariableReference {
    private boolean isImplicitVariable = false;
    private boolean usedAsRestOperator = false;
    private static String[] potentialBuiltinScopeNameList = new String[]{"SERVER", "APPLICATION", "SESSION", "REQUEST", "VARIABLES", "CGI", "HTTP", "FILE", "URL", "FORM", "COOKIE", "CLIENT", "FLASH"};
    private static FastHashtable potentialBuiltinScopeNames = new FastHashtable();
    private String codegenVarName;
    private boolean isSafePreHook = false;

    public boolean isUsedAsRestOperator() {
        return this.usedAsRestOperator;
    }

    public void setUsedAsRestOperator(boolean restParameter) {
        this.usedAsRestOperator = restParameter;
    }

    public static boolean isBuiltinScopeName(String name) {
        return potentialBuiltinScopeNames.containsKey(name);
    }

    public boolean isSafePreHook() {
        return this.isSafePreHook;
    }

    public void setSafePreHook(boolean isSafePreHook) {
        this.isSafePreHook = isSafePreHook;
    }

    private ASTsimpleVariableReference(int id) {
        super(id);
        this.setType(Object.class);
    }

    ASTsimpleVariableReference(Token tok) {
        this(10002);
        this.init(tok);
    }

    private void init(Token tok) {
        this.codegenVarName = tok.image.toUpperCase();
        if (!CFMLParserBase.isValidSimpleIdentifier(this.codegenVarName)) {
            throw new InvalidIdentifierException(tok);
        }
        this.setStartToken(tok);
    }

    public String getVariableName() {
        return this.getStartToken().image;
    }

    public String getCodegenVariableName() {
        return this.codegenVarName;
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        cfml.visit(this);
    }

    boolean referenceNeedsSymTabSupport(StmtAssembler assmbler) {
        return this.referenceNeedsSymTabSupport(assmbler, false);
    }

    boolean referenceNeedsSymTabSupport(StmtAssembler assmbler, boolean forAssigning) {
        ASTfunctionDefinition def = this.getFunctionDef();
        if (def != null) {
            if (!forAssigning && def.isParameter(this.codegenVarName)) {
                return true;
            }
            if (assmbler.findLocal(this.codegenVarName) != null) {
                return false;
            }
        }
        boolean retVal = false;
        if (def != null) {
            if (!def.isLocalReference(this.codegenVarName)) {
                retVal = true;
            }
        } else if (ASTsimpleVariableReference.isBuiltinScopeName(this.codegenVarName)) {
            retVal = true;
        }
        return retVal;
    }

    private boolean processPrefixedFinalVariables() {
        boolean isPrefixedFinalVariableFound;
        block6: {
            Node parent;
            block5: {
                String[] keys;
                parent = this.jjtGetParent();
                isPrefixedFinalVariableFound = false;
                if (parent == null || !(parent instanceof ASTstructureReference)) break block5;
                if (!((ASTstructureReference)parent).isFinal() || (keys = ((ASTstructureReference)parent).getStructureKeys()) == null || keys.length <= 0) break block6;
                isPrefixedFinalVariableFound = true;
                for (String key : keys) {
                    Map<String, String> finalVarsAsDSKeyMap = this.parser.translationContext.getFinalVariablesAsDSKey();
                    finalVarsAsDSKeyMap.put(key, key);
                }
                break block6;
            }
            if (parent != null && parent instanceof ASTarrayReference && ((ASTarrayReference)parent).isFinal()) {
                Vector indices = ((ASTarrayReference)parent).indices;
                int size = indices.size();
                if (indices != null && size > 0) {
                    isPrefixedFinalVariableFound = true;
                    for (int index = 0; index < size; ++index) {
                        if (indices.get(index) instanceof ASTliteral) {
                            ASTliteral literal = (ASTliteral)indices.get(index);
                            if (literal == null || literal.tokens == null || literal.tokens.size() <= 0) continue;
                            String val = (String)literal.tokens.get(0);
                            Map<String, String> finalVarsAsDSKeyMap = this.parser.translationContext.getFinalVariablesAsDSKey();
                            finalVarsAsDSKeyMap.put(val, val);
                            continue;
                        }
                        if (!(indices.get(index) instanceof ASTsimpleVariableReference)) continue;
                        String key = ((ASTsimpleVariableReference)indices.get(index)).getCodegenVariableName();
                        throw new InvalidFinalVariableDeclarationException(key);
                    }
                }
            }
        }
        return isPrefixedFinalVariableFound;
    }

    private boolean processPrefixedFunctionNonLocalFinalVariables(String functionName) {
        boolean isPrefixedFinalVariableFound;
        block6: {
            Node parent;
            block5: {
                String[] keys;
                parent = this.jjtGetParent();
                isPrefixedFinalVariableFound = false;
                if (parent == null || !(parent instanceof ASTstructureReference)) break block5;
                if (!((ASTstructureReference)parent).isFinal() || (keys = ((ASTstructureReference)parent).getStructureKeys()) == null || keys.length <= 0) break block6;
                isPrefixedFinalVariableFound = true;
                for (String key : keys) {
                    this.getTranslationContext().saveFunctionNonLocalPrefixedFinalVariable(functionName, key);
                }
                break block6;
            }
            if (parent != null && parent instanceof ASTarrayReference && ((ASTarrayReference)parent).isFinal()) {
                Vector indices = ((ASTarrayReference)parent).indices;
                int size = indices.size();
                if (indices != null && size > 0) {
                    isPrefixedFinalVariableFound = true;
                    for (int index = 0; index < size; ++index) {
                        if (indices.get(index) instanceof ASTliteral) {
                            ASTliteral literal = (ASTliteral)indices.get(index);
                            if (literal == null || literal.tokens == null || literal.tokens.size() <= 0) continue;
                            String val = (String)literal.tokens.get(0);
                            this.getTranslationContext().saveFunctionNonLocalPrefixedFinalVariable(functionName, val);
                            continue;
                        }
                        if (!(indices.get(index) instanceof ASTsimpleVariableReference)) continue;
                        String key = ((ASTsimpleVariableReference)indices.get(index)).getCodegenVariableName();
                        throw new InvalidFinalVariableDeclarationException(key);
                    }
                }
            }
        }
        return isPrefixedFinalVariableFound;
    }

    void declareVariable(String varName, boolean isFinal) {
        ASTfunctionDefinition functionDef = this.getFunctionDef();
        if (functionDef == null) {
            this.processPrefixedFinalVariables();
            if (!ASTsimpleVariableReference.isBuiltinScopeName(varName) && !this.isStaticAccessor()) {
                this.getTranslationContext().declarePageVariable(varName, this.isImplicitVariable, isFinal, this.isStatic(), this.getAccessModifier());
            }
        } else if (functionDef != null) {
            String funName = this.getFunctionDef().functionName.image;
            if (isFinal && functionDef.localVars.containsKey(varName)) {
                this.getTranslationContext().saveFunctionFinalVariables(funName, varName);
            } else if (!this.processPrefixedFunctionNonLocalFinalVariables(funName) && isFinal) {
                this.getTranslationContext().saveFunctionFinalNonLocalVariables(funName, varName);
            }
        }
    }

    public boolean isLval() {
        Node node = this.jjtGetParent();
        while (node != null) {
            if (node instanceof ASTcfscriptStatement) {
                if (((ASTcfscriptStatement)node).getStatementType() == 3 && node.getNamedAttribute("LVAL") instanceof VariableReference) {
                    return ((VariableReference)node.getNamedAttribute("LVAL")).getStem() == this || node.getNamedAttribute("LVAL") == this;
                }
                return false;
            }
            if (node instanceof ASTstart || node instanceof ASTfunctionDefinition) {
                return false;
            }
            node = node.jjtGetParent();
        }
        return false;
    }

    public boolean hasAssignment() {
        Node node = this.jjtGetParent();
        while (node != null) {
            if (node instanceof ASTcfscriptStatement) {
                Token assignmentOp = ((ASTcfscriptStatement)node).assignmentOpToken;
                return assignmentOp != null && assignmentOp.image.equals("=");
            }
            if (node instanceof ASTstart || node instanceof ASTfunctionDefinition) {
                return false;
            }
            node = node.jjtGetParent();
        }
        return false;
    }

    public ASTvariableDefinition getVariableDefinition() {
        Node node = this.jjtGetParent();
        while (node != null) {
            if (node instanceof ASTvariableDefinition) {
                return (ASTvariableDefinition)node;
            }
            if (node instanceof ASTstart || node instanceof ASTfunctionDefinition) {
                return null;
            }
            node = node.jjtGetParent();
        }
        return null;
    }

    public boolean isFinalVariable() {
        String finalYesNo;
        boolean isFinal = false;
        ASTliteral finalMarker = (ASTliteral)this.getNamedAttribute("IS_FINAL_VARIABLE");
        if (finalMarker != null && finalMarker.tokens != null && finalMarker.tokens.size() > 0 && "TRUE".equals(finalYesNo = (String)finalMarker.tokens.get(0))) {
            isFinal = true;
        }
        return isFinal;
    }

    public boolean isImplicitVariable() {
        return this.isImplicitVariable;
    }

    public void setImplicitVariable(boolean isImplicitVariable) {
        this.isImplicitVariable = isImplicitVariable;
    }

    public void checkForFinalArgumentOverride() {
        ASTparameterDefinition paramDef;
        ASTfunctionDefinition functionDef;
        if (this.getVariableDefinition() == null && this.hasAssignment() && (functionDef = this.getFunctionDef()) != null && (paramDef = functionDef.getParameterdefinition()) != null) {
            String paramName = this.getCodegenVariableName();
            if (this.isFinalVariable() && paramDef.hasParameter(paramName)) {
                throw new VarRedeclarationException(paramName);
            }
            if (paramDef.hasFinalParameter(paramName)) {
                throw new FunctionFinalParamMutationException(paramName, functionDef.functionName.image);
            }
        }
    }

    static {
        int index = 0;
        for (index = 0; index < potentialBuiltinScopeNameList.length; ++index) {
            potentialBuiltinScopeNames.put(potentialBuiltinScopeNameList[index], (Object)"junk");
        }
    }

    public class InvalidIdentifierException
    extends ParseException {
        InvalidIdentifierException(Token t) {
            super(t);
        }
    }

    public class InvalidFinalVariableDeclarationException
    extends ParseException {
        public String key;

        InvalidFinalVariableDeclarationException(String key) {
            this.key = key;
        }
    }

    public static final class VarRedeclarationException
    extends AbstractParseException {
        public String varName;

        VarRedeclarationException(String varName) {
            this.varName = varName;
        }
    }

    public static final class FunctionFinalParamMutationException
    extends AbstractParseException {
        public String finalVar;
        public String func;

        FunctionFinalParamMutationException(String finalVar, String func) {
            this.finalVar = finalVar;
            this.func = func;
        }
    }
}

