/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTtoolkit;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.IndexedVariable;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;

public final class ASTstructureReference
extends VariableReference
implements IndexedVariable {
    private String[] keys;
    private boolean isSafePreHook = false;
    private boolean isSafePostHook = false;
    boolean isLHS = false;
    private boolean isCaseSensitive = false;

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    ASTstructureReference(String[] keys) {
        super(10003);
        this.setType(Object.class);
        this.keys = keys;
    }

    public boolean isSafePreHook() {
        return this.isSafePreHook;
    }

    public void setSafePreHook(boolean isSafePreHook) {
        this.isSafePreHook = isSafePreHook;
    }

    public boolean isSafePostHook() {
        return this.isSafePostHook;
    }

    public void setSafePostHook(boolean isSafePostHook) {
        this.isSafePostHook = isSafePostHook;
    }

    public String[] getStructureKeys() {
        return this.keys;
    }

    @Override
    public void accept(JJTreeVisitor cfml) throws ParseException {
        cfml.visit(this);
        this.getStem().accept(cfml);
    }

    public String validatableName() {
        return this.getStartToken().image;
    }

    @Override
    public ExprNode getIndex(int i) {
        return ASTtoolkit.literal(this.jjtGetParent(), this.keys[i]);
    }

    public boolean isFinal() {
        String finalYesNo;
        ASTliteral finalMarker;
        boolean isFinal = false;
        if (this.getNamedAttribute("IS_FINAL_VARIABLE") != null && (finalMarker = (ASTliteral)this.getNamedAttribute("IS_FINAL_VARIABLE")) != null && finalMarker.tokens != null && finalMarker.tokens.size() > 0 && "TRUE".equals(finalYesNo = (String)finalMarker.tokens.get(0))) {
            isFinal = true;
        }
        return isFinal;
    }

    public boolean hasAssignment() {
        Node node = this.jjtGetParent();
        while (node != null) {
            if (node instanceof ASTcfscriptStatement) {
                Token assignmentOp = ((ASTcfscriptStatement)node).assignmentOpToken;
                return assignmentOp != null && assignmentOp.image.equals("=");
            }
            if (node instanceof ASTstart || node instanceof ASTfunctionDefinition) {
                return false;
            }
            node = node.jjtGetParent();
        }
        return false;
    }

    public void checkForFinalArgumentOverride() {
        String stemName;
        ASTsimpleVariableReference varRef;
        ASTfunctionDefinition functionDef = this.getFunctionDef();
        if (functionDef != null && this.hasAssignment() && this.getStem() != null && this.getStem() instanceof ASTsimpleVariableReference && (varRef = (ASTsimpleVariableReference)this.getStem()) != null && (stemName = varRef.getCodegenVariableName()) != null && stemName.equalsIgnoreCase("ARGUMENTS")) {
            String[] keys = this.getStructureKeys();
            ASTparameterDefinition paramDef = functionDef.getParameterdefinition();
            if (paramDef != null) {
                for (String key : keys) {
                    if (!paramDef.hasFinalParameter(key)) continue;
                    throw new ASTsimpleVariableReference.FunctionFinalParamMutationException(key, functionDef.functionName.image);
                }
            }
        }
    }
}

