/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;

public class ClassReader
extends ByteArrayInputStream {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private int[] cpoolIndex;

    public ClassReader(byte[] b) throws IOException {
        super(b);
        if (this.readInt() != -889275714) {
            throw new IOException("this does not appear to be a valid class file");
        }
    }

    private int readShort() {
        return this.read() << 8 | this.read();
    }

    private int readInt() {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    private void skipFully(int n) throws IOException {
        while (n > 0) {
            int c = (int)this.skip(n);
            if (c < 0) {
                throw new EOFException();
            }
            n -= c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUtf8(int i) throws IOException {
        int oldPos = this.pos;
        try {
            this.pos = this.cpoolIndex[i];
            this.read();
            int len = this.readShort();
            this.skipFully(len);
            String string = new String(this.buf, this.pos - len, len, "utf-8");
            return string;
        }
        finally {
            this.pos = oldPos;
        }
    }

    private void readCpool() throws IOException {
        int count = this.readShort();
        this.cpoolIndex = new int[count];
        block7: for (int i = 1; i < count; ++i) {
            this.cpoolIndex[i] = this.pos;
            int c = this.read();
            switch (c) {
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.readShort();
                }
                case 7: 
                case 8: {
                    this.readShort();
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.readInt();
                    ++i;
                }
                case 3: 
                case 4: {
                    this.readInt();
                    continue block7;
                }
                case 1: {
                    int len = this.readShort();
                    this.skipFully(len);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("unexpected constant #" + i + " " + c);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName() throws IOException {
        this.readShort();
        this.readShort();
        this.readCpool();
        this.readShort();
        int i = this.readShort();
        int oldPos = this.pos;
        try {
            this.pos = this.cpoolIndex[i];
            this.read();
            i = this.readShort();
            String string = this.getUtf8(i);
            return string;
        }
        finally {
            this.pos = oldPos;
        }
    }

    public long getSourceModTime() throws IOException {
        this.readShort();
        this.readShort();
        this.readCpool();
        this.readShort();
        int i = this.readShort();
        this.readShort();
        int int_count = this.readShort();
        this.skipInterfaces(int_count);
        int field_count = this.readShort();
        this.skipFields(field_count);
        int method_count = this.readShort();
        this.skipMethods(method_count);
        int attr_count = this.readShort();
        return this.getSourceModTime(attr_count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findEndOfClass(int start) throws IOException {
        int oldPos = this.pos;
        this.pos = start;
        int result = -1;
        try {
            if (this.readInt() != -889275714) {
                throw new IOException("this does not appear to be a valid class byte array");
            }
            this.readShort();
            this.readShort();
            this.readCpool();
            this.readShort();
            int i = this.readShort();
            this.readShort();
            int int_count = this.readShort();
            this.skipInterfaces(int_count);
            int field_count = this.readShort();
            this.skipFields(field_count);
            int method_count = this.readShort();
            this.skipMethods(method_count);
            int attr_count = this.readShort();
            this.skipAttrs(attr_count);
            result = this.pos;
        }
        finally {
            this.pos = oldPos;
        }
        return result;
    }

    private void skipInterfaces(int intCount) throws IOException {
        for (int i = 0; i < intCount; ++i) {
            this.skipFully(3);
        }
    }

    private void skipFields(int fieldCount) throws IOException {
        for (int i = 0; i < fieldCount; ++i) {
            this.skipFully(6);
            int attr_count = this.readShort();
            this.skipAttrs(attr_count);
        }
    }

    private void skipAttrs(int attrCount) throws IOException {
        for (int i = 0; i < attrCount; ++i) {
            this.skipFully(2);
            int attr_length = this.readInt();
            this.skipFully(attr_length);
        }
    }

    private void skipMethods(int methodCount) throws IOException {
        for (int i = 0; i < methodCount; ++i) {
            this.skipFully(6);
            int attr_count = this.readShort();
            this.skipAttrs(attr_count);
        }
    }

    private long getSourceModTime(int attr_count) throws IOException {
        for (int i = 0; i < attr_count; ++i) {
            int length;
            int nameIndex = this.readShort();
            String name = this.getUtf8(nameIndex);
            if (name.equals("com.macromedia.SourceModTime")) {
                length = this.readInt();
                if (length != 2) continue;
                int longPos = this.readShort();
                long value = this.getLong(longPos);
                return value;
            }
            length = this.readInt();
            this.skipFully(length);
        }
        return -1L;
    }

    private long readLong() {
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLong(int index) {
        int oldPos = this.pos;
        try {
            this.pos = this.cpoolIndex[index];
            this.read();
            long l = this.readLong();
            return l;
        }
        finally {
            this.pos = oldPos;
        }
    }
}

