/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class CustomTagTable {
    private Vector primaryCanonicalDirs = new Vector();
    private Hashtable tagFiles = new Hashtable();

    public CustomTagTable(Map pathMap) {
        for (Map.Entry entry : pathMap.entrySet()) {
            String realPath = (String)entry.getValue();
            this.primaryCanonicalDirs.add(Utils.getCanonicalFile(realPath));
        }
        this.scanTags();
    }

    private void scanTags() {
        int count = this.primaryCanonicalDirs.size();
        for (int i = 0; i < count; ++i) {
            File canonicalDir = (File)this.primaryCanonicalDirs.elementAt(i);
            this.scanTags(canonicalDir, canonicalDir);
        }
    }

    private void scanTags(File canonicalDir, File primaryDir) {
        File[] files = canonicalDir.listFiles();
        for (int j = 0; files != null && j < files.length; ++j) {
            String name;
            File canonicalFile = files[j];
            if (canonicalFile.isDirectory()) {
                this.scanTags(canonicalFile, primaryDir);
                continue;
            }
            if (!canonicalFile.isFile() || !(name = canonicalFile.getName().toLowerCase()).endsWith(".cfm") && !name.endsWith(".cfc")) continue;
            String longName = canonicalFile.getPath();
            longName = longName.substring(primaryDir.getPath().length());
            if (!this.tagFiles.containsKey(longName = longName.replace(File.separatorChar, '/').toLowerCase())) {
                this.tagFiles.put(longName, canonicalFile);
            }
            if (this.tagFiles.containsKey(name)) continue;
            this.tagFiles.put(name, canonicalFile);
        }
    }

    public File findTemplate(String template) {
        return (File)this.tagFiles.get(template);
    }

    public String getFullTagName(String canonicalPath) throws IOException {
        int count = this.primaryCanonicalDirs.size();
        for (int i = 0; i < count; ++i) {
            File canonicalDir = (File)this.primaryCanonicalDirs.elementAt(i);
            String dirPath = canonicalDir.getPath();
            if (!canonicalPath.startsWith(dirPath)) continue;
            String relPath = canonicalPath.substring(dirPath.length() + 1);
            if (relPath.indexOf(46) != -1) {
                relPath = relPath.substring(0, relPath.indexOf(46));
            }
            return relPath.replace(File.separatorChar, '.');
        }
        return null;
    }
}

