/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTArrayInitializer;
import coldfusion.compiler.ASTStructInitializer;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ArrayStructInitializer;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import coldfusion.runtime.ApplicationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;

public class ImplicitInitializerTransformer {
    static Node pretransformStructInitialzer(ASTcfscriptStatement n) {
        ASTStructInitializer initializerNode = (ASTStructInitializer)n.getNamedAttribute("RVAL");
        Node lval = n.getNamedAttribute("LVAL");
        VariableReference lvalVariableRef = null;
        if (lval instanceof ASTliteral && ((ASTliteral)lval).tokens != null) {
            String litConst = null;
            try {
                litConst = EvaluateEngine._String((ExprNode)lval);
            }
            catch (Exception e) {
                litConst = null;
            }
            if (litConst == null) {
                return ImplicitInitializerTransformer.pretransformStructInitialzer((ASTliteral)lval, n);
            }
            throw new ImplicitArrayStructConstantVarException(lval.getLine());
        }
        if (!(lval instanceof VariableReference)) {
            throw new ImplicitArrayStructDynamicVarException(lval.getLine());
        }
        lvalVariableRef = (VariableReference)lval;
        ArrayList<ASTcfscriptStatement> children = new ArrayList<ASTcfscriptStatement>();
        ASTcfscriptStatement statement = new ASTcfscriptStatement(3, 3);
        statement.insertedNode = true;
        statement.setNamedAttribute("LVAL", lvalVariableRef);
        Node[] args = null;
        args = initializerNode.isOrderedStruct() && initializerNode.isCaseSensitiveStruct() ? new Node[]{new ASTliteral("ordered-casesensitive")} : (initializerNode.isOrderedStruct() ? new Node[]{new ASTliteral("ordered")} : (initializerNode.isCaseSensitiveStruct() ? new Node[]{new ASTliteral("casesensitive")} : new Node[]{}));
        statement.setNamedAttribute("RVAL", ImplicitInitializerTransformer.createRuntimeCallForInitializer(n, "StructNew", args));
        statement.jjtSetParent(n);
        children.add(statement);
        children.addAll(ImplicitInitializerTransformer.createChildStatements(initializerNode, n));
        if (initializerNode.getFunctions() != null) {
            children.addAll(Arrays.asList(ImplicitInitializerTransformer.getFunctionCalls(initializerNode, lvalVariableRef, n)));
        }
        if (n.isStatic()) {
            for (Object e : children) {
                ((ASTcfscriptStatement)e).markStatic();
            }
        }
        n.children = (ASTcfscriptStatement[])children.stream().toArray(ASTcfscriptStatement[]::new);
        n.setNamedAttribute("LVAL", null);
        n.setNamedAttribute("RVAL", null);
        n.stmtType = 11;
        return n;
    }

    private static ASTcfscriptStatement[] getFunctionCalls(ArrayStructInitializer initializer, VariableReference lvalRef, Node parent) {
        ASTcfscriptStatement[] functionCallStatements = new ASTcfscriptStatement[initializer.functions.size()];
        int index = 0;
        ASTcfscriptStatement statement = null;
        for (ASTruntimeCall call : initializer.getFunctions()) {
            statement = new ASTcfscriptStatement(3, 3);
            statement.jjtSetParent(parent);
            statement.setNamedAttribute("LVAL", lvalRef);
            call.setStem(lvalRef);
            statement.setNamedAttribute("RVAL", call);
            functionCallStatements[index++] = statement;
        }
        return functionCallStatements;
    }

    private static ArrayList<ASTcfscriptStatement> createChildStatements(ASTStructInitializer initializerNode, ASTcfscriptStatement n) {
        Node lval = n.getNamedAttribute("LVAL");
        VariableReference lvalVariableRef = null;
        if (lval instanceof VariableReference) {
            lvalVariableRef = (VariableReference)lval;
        }
        ArrayList<ASTcfscriptStatement> children = new ArrayList<ASTcfscriptStatement>();
        for (Map.Entry entry : initializerNode.getInitializers().entrySet()) {
            Object key = entry.getKey();
            Node value = (Node)entry.getValue();
            ASTcfscriptStatement statement = new ASTcfscriptStatement(3, 3);
            statement.insertedNode = true;
            if (key instanceof Token) {
                VariableReference variableReference = VariableReference.createSimpleReference((Token)key, lvalVariableRef, lval.parser);
                if (initializerNode.isCaseSensitiveStruct() && variableReference instanceof ASTstructureReference) {
                    ((ASTstructureReference)variableReference).setCaseSensitive(true);
                }
                statement.setNamedAttribute("LVAL", variableReference);
            } else {
                if (key instanceof String && key.equals("__SPREAD_Struct")) {
                    ASTStructInitializer structInitializer = (ASTStructInitializer)value;
                    ArrayList<ASTcfscriptStatement> spreadChildren = ImplicitInitializerTransformer.createChildStatements(structInitializer, n);
                    children.addAll(spreadChildren);
                    statement.setNamedAttribute("RVAL", value);
                    statement.jjtSetParent(n);
                    continue;
                }
                if (lvalVariableRef instanceof ASTarrayReference) {
                    statement.setNamedAttribute("LVAL", VariableReference.createArrayReference((ExprNode)key, lvalVariableRef, lvalVariableRef.parser));
                } else {
                    ASTarrayReference arrayRef = VariableReference.createArrayReference(lvalVariableRef.getStartToken(), (ExprNode)key, null, lval.parser);
                    if (arrayRef != null && arrayRef.getStem() instanceof ASTsimpleVariableReference && lvalVariableRef instanceof ASTsimpleVariableReference && ((ASTsimpleVariableReference)lvalVariableRef).isImplicitVariable()) {
                        ((ASTsimpleVariableReference)arrayRef.getStem()).setImplicitVariable(true);
                    }
                    statement.setNamedAttribute("LVAL", arrayRef);
                }
            }
            statement.setNamedAttribute("RVAL", value);
            statement.jjtSetParent(n);
            children.add(statement);
        }
        return children;
    }

    static Node pretransformStructInitialzer(ASTliteral lval, ASTcfscriptStatement n) {
        ASTStructInitializer initializerNode = (ASTStructInitializer)n.getNamedAttribute("RVAL");
        int childrenLen = initializerNode.getInitializers().size();
        ASTcfscriptStatement[] children = new ASTcfscriptStatement[childrenLen + 1];
        ASTcfscriptStatement statement = new ASTcfscriptStatement(3, 3);
        statement.setNamedAttribute("LVAL", lval);
        Node[] args = null;
        args = initializerNode.isOrderedStruct() ? new Node[]{new ASTliteral("ordered")} : (initializerNode.isCaseSensitiveStruct() ? new Node[]{new ASTliteral("casesensitive")} : new Node[]{});
        statement.setNamedAttribute("RVAL", ImplicitInitializerTransformer.createRuntimeCallForInitializer(n, "StructNew", args));
        statement.jjtSetParent(n);
        children[0] = statement;
        int i = 0;
        for (Map.Entry entry : initializerNode.getInitializers().entrySet()) {
            Object key = entry.getKey();
            Node value = (Node)entry.getValue();
            statement = new ASTcfscriptStatement(3, 3);
            ASTliteral lit = new ASTliteral(27);
            lit.tokens = new Vector(lval.tokens);
            lit.parser = lval.parser;
            lit.children = lval.children;
            if (key instanceof Token) {
                lit.tokens.add("." + ((Token)key).image);
            } else {
                lit.tokens.add(".");
                lit.tokens.add(key);
            }
            statement.setNamedAttribute("LVAL", lit);
            statement.setNamedAttribute("RVAL", value);
            statement.jjtSetParent(n);
            children[++i] = statement;
        }
        n.children = children;
        n.setNamedAttribute("LVAL", null);
        n.setNamedAttribute("RVAL", null);
        n.stmtType = 11;
        return n;
    }

    private static ASTruntimeCall createRuntimeCallForInitializer(ASTcfscriptStatement parent, String functionName, Node[] args) {
        ASTruntimeCall call = new ASTruntimeCall((Node)parent, functionName, args);
        call.setImplicitInitializerNode(true);
        return call;
    }

    static Node pretransformArrayInitialzer(ASTcfscriptStatement n) {
        ASTArrayInitializer rvalInitializerNode = (ASTArrayInitializer)n.getNamedAttribute("RVAL");
        Node lval = n.getNamedAttribute("LVAL");
        VariableReference lvalVariableRef = null;
        ASTcfscriptStatement[] children = null;
        int functionCalls = rvalInitializerNode.getFunctions().size();
        int numChildren = rvalInitializerNode.getInitializers().size();
        ASTcfscriptStatement statement = new ASTcfscriptStatement(3, 3);
        if (lval instanceof VariableReference) {
            lvalVariableRef = (VariableReference)lval;
            children = new ASTcfscriptStatement[numChildren + 1 + functionCalls];
            statement.insertedNode = true;
            statement.setNamedAttribute("LVAL", lvalVariableRef);
            ASTruntimeCall runtimeCall = ImplicitInitializerTransformer.createRuntimeCallForInitializer(n, "ArrayNew", new Node[]{new ASTliteral("1")});
            ASTfuncparams funcArgs = runtimeCall.getArguments();
            if (rvalInitializerNode != null && rvalInitializerNode.getTypeDeclaration() != null && funcArgs != null) {
                funcArgs.setIsTyped(true);
                funcArgs.setTypeDeclaration(rvalInitializerNode.getTypeDeclaration());
            }
            statement.setNamedAttribute("RVAL", runtimeCall);
            statement.jjtSetParent(n);
            children[0] = statement;
            int i = 0;
            boolean spreadOperation = false;
            for (Node value : rvalInitializerNode.getInitializers()) {
                statement = new ASTcfscriptStatement(3, 3);
                statement.insertedNode = true;
                ASTarrayReference arrayRef = new ASTarrayReference(lvalVariableRef, new ASTliteral(++i, statement), lval.parser);
                if (spreadOperation) {
                    arrayRef.setAfterSpread(true);
                }
                statement.setNamedAttribute("LVAL", arrayRef);
                statement.setNamedAttribute("RVAL", value);
                statement.jjtSetParent(n);
                children[i] = statement;
                if (!(value instanceof ExprNode) || !((ExprNode)value).isSpreadOperationType()) continue;
                spreadOperation = true;
            }
            if (functionCalls != 0) {
                for (ASTcfscriptStatement funcStatement : ImplicitInitializerTransformer.getFunctionCalls(rvalInitializerNode, lvalVariableRef, n)) {
                    children[++i] = funcStatement;
                }
            }
        } else {
            throw new ImplicitArrayStructDynamicVarException(lval.getLine());
        }
        n.stmtType = 11;
        if (n.isStatic()) {
            for (ASTcfscriptStatement stmt : children) {
                stmt.markStatic();
            }
        }
        n.children = children;
        n.setNamedAttribute("LVAL", null);
        n.setNamedAttribute("RVAL", null);
        return n;
    }

    static Node pretransformInitializer(ASTcfscriptStatement cfscriptstmtNode) {
        if (cfscriptstmtNode.getNamedAttribute("RVAL") instanceof ASTStructInitializer) {
            return ImplicitInitializerTransformer.pretransformStructInitialzer(cfscriptstmtNode);
        }
        if (cfscriptstmtNode.getNamedAttribute("RVAL") instanceof ASTArrayInitializer) {
            return ImplicitInitializerTransformer.pretransformArrayInitialzer(cfscriptstmtNode);
        }
        return null;
    }

    static boolean isInitNodeReqd(ASTcfscriptStatement cfscriptstmtNode) {
        Node rvalNode = cfscriptstmtNode.getNamedAttribute("RVAL");
        return rvalNode instanceof ASTStructInitializer || rvalNode instanceof ASTArrayInitializer;
    }

    public static class ImplicitArrayStructConstantVarException
    extends ApplicationException {
        public int line;

        public ImplicitArrayStructConstantVarException(int line) {
            this.line = line;
        }
    }

    public static class ImplicitArrayStructDynamicVarException
    extends ApplicationException {
        public int line;

        public ImplicitArrayStructDynamicVarException(int line) {
            this.line = line;
        }
    }
}

