/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfargument;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import java.util.Objects;

public class InterfaceParseExceptions {
    private static InterfaceParseExceptions cfiException = new InterfaceParseExceptions();

    private InterfaceParseExceptions() {
    }

    public static void throwInvalidImplementsException(Token t, String filePath) throws InvalidImplementsException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InvalidImplementsException(t, filePath);
    }

    public static void throwInterfaceRolesAttibException() throws InterfaceRolesAttibException {
        throw cfiException.new InterfaceRolesAttibException();
    }

    public static void throwInvalidInterfaceMethodAccess(String accessValue) throws InvalidInterfaceMethodAccess {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InvalidInterfaceMethodAccess(accessValue);
    }

    public static void throwInvalidDefaultArgumentAttribute(String argumentName) throws InvalidDefaultArgumentAttribute {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InvalidDefaultArgumentAttribute(argumentName);
    }

    public static boolean handleInvalidCFMLConsctuctException(ParseException e) throws InvalidCFMLConstructException {
        if (e instanceof InvalidFunctionDefinitionException) {
            return false;
        }
        if (e instanceof InvalidDefaultArgumentAttribute) {
            return false;
        }
        if (e instanceof ASTcfargument.IllegalArgumentRedefinitionException) {
            return false;
        }
        InterfaceParseExceptions.throwInvalidCFMLConstructException(e._getErrorToken());
        return true;
    }

    public static void throwInvalidCFMLConstructException(Token errorToken) throws InvalidCFMLConstructException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InvalidCFMLConstructException(errorToken);
    }

    public static InvalidCFMLConstructException createInvalidCFMLConstructException(Token errorToken) {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        return interfaceParseExceptions.new InvalidCFMLConstructException(errorToken);
    }

    public static void throwInvalidFunctionDefinitionException(Token errorToken) throws InvalidFunctionDefinitionException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InvalidFunctionDefinitionException(errorToken);
    }

    public static void throwInterfaceFunctionDefinitionException(Token errorToken) throws InvalidFunctionDefinitionException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InterfaceFunctionDefinitionException(errorToken);
    }

    public static void throwNonInterfaceDefaultFunctionException(Token errorToken) throws NonInterfaceDefaultFunctionException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new NonInterfaceDefaultFunctionException(errorToken);
    }

    public static void throwNonComponentAbstractMethodException(Token errorToken) throws NonComponentAbstractMethodException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new NonComponentAbstractMethodException(errorToken);
    }

    public static void throwNonComponentStaticMethodException(Token errorToken) throws NonComponentStaticMethodException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new NonComponentStaticMethodException(errorToken);
    }

    public static void throwNonComponentFinalMethodException(Token errorToken) throws NonComponentFinalMethodException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new NonComponentFinalMethodException(errorToken);
    }

    public static void throwInvalidOutputAttributeException(Token errorToken) throws InvalidOutputAttributeException {
        InterfaceParseExceptions interfaceParseExceptions = cfiException;
        Objects.requireNonNull(interfaceParseExceptions);
        throw interfaceParseExceptions.new InvalidOutputAttributeException(errorToken);
    }

    public class InvalidImplementsException
    extends ParseException
    implements InterfaceExceptionType {
        public String filePath;

        public InvalidImplementsException(Token t, String filePath) {
            super(t);
            String fileSeperator = System.getProperty("file.separator");
            int i = filePath.lastIndexOf(fileSeperator);
            this.filePath = i < 0 ? filePath : filePath.substring(i + 1);
        }
    }

    public class InterfaceRolesAttibException
    extends ParseException
    implements InterfaceExceptionType {
    }

    public class InvalidInterfaceMethodAccess
    extends ParseException
    implements InterfaceExceptionType {
        public String accessValue;

        public InvalidInterfaceMethodAccess(String accessValue) {
            this.accessValue = accessValue;
        }
    }

    public class InvalidDefaultArgumentAttribute
    extends ParseException
    implements InterfaceExceptionType {
        public String argumentName;
        public String functionName;

        public InvalidDefaultArgumentAttribute(String argumentName) {
            this.argumentName = argumentName;
        }
    }

    public class InvalidFunctionDefinitionException
    extends ParseException
    implements InterfaceExceptionType {
        public InvalidFunctionDefinitionException(Token errorToken) {
            super(errorToken);
        }
    }

    public class InvalidCFMLConstructException
    extends ParseException
    implements InterfaceExceptionType {
        public InvalidCFMLConstructException(Token errorToken) {
            super(errorToken);
        }
    }

    public class InterfaceFunctionDefinitionException
    extends ParseException
    implements InterfaceExceptionType {
        public InterfaceFunctionDefinitionException(Token errorToken) {
            super(errorToken);
        }
    }

    public class NonInterfaceDefaultFunctionException
    extends ParseException
    implements InterfaceExceptionType {
        public NonInterfaceDefaultFunctionException(Token errorToken) {
            super(errorToken);
        }
    }

    public class NonComponentAbstractMethodException
    extends ParseException
    implements InterfaceExceptionType {
        public NonComponentAbstractMethodException(Token errorToken) {
            super(errorToken);
        }
    }

    public class NonComponentStaticMethodException
    extends ParseException
    implements InterfaceExceptionType {
        public NonComponentStaticMethodException(Token errorToken) {
            super(errorToken);
        }
    }

    public class NonComponentFinalMethodException
    extends ParseException
    implements InterfaceExceptionType {
        public NonComponentFinalMethodException(Token errorToken) {
            super(errorToken);
        }
    }

    public class InvalidOutputAttributeException
    extends ParseException
    implements InterfaceExceptionType {
        public InvalidOutputAttributeException(Token errorToken) {
            super(errorToken);
        }
    }

    public static interface InterfaceExceptionType {
    }
}

