/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfcase;
import coldfusion.compiler.ASTcfscript;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.ASTevalcfoutput;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.FactoredNodeAggregation;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.NamedAttributeNode;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.compiler.cfml40TreeConstants;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class Node
implements cfml40TreeConstants,
NamedAttributeNode {
    static final int FACTOREDNODE = 100;
    static final int TAGBODY = 101;
    private Node parent;
    private Node defaultVal;
    CFMLParserBase parser;
    Node[] children;
    int id;
    int siblingSequence;
    boolean insertedNode = false;
    int insertedNodeCount = 0;
    private Hashtable namedChildren;
    private Token startToken;
    private Token endToken;
    private boolean escapeSingleQuotes;
    private Object label = null;
    protected boolean isStatic = false;
    protected int codeSizeWeight = -1;
    protected Node selfFactoringTarget;
    private Node aggregateFactoringTarget;
    private static final int FACTORING_DEFAULT_THRESHOLD = 6000;
    private static final int FACTORING_MINIMUM_THRESHOLD = 600;
    private static final int FACTORING_CASE_THRESHOLD = 200;
    private static final int FACTORING_CASE_MIN_THRESHOLD = 100;
    private static Enumeration emptyEnumeration = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };

    public Node getDefaultVal() {
        return this.defaultVal;
    }

    public void setDefaultVal(Node defaultVal) {
        this.defaultVal = defaultVal;
    }

    void setEscapeSingleQuotes(boolean b) {
        this.escapeSingleQuotes = b;
    }

    boolean isEscapeSingleQuotes() {
        for (Node parent = this.jjtGetParent(); parent != null; parent = parent.jjtGetParent()) {
            if (parent instanceof ASTtagAttribute) {
                return false;
            }
            if (parent instanceof ASTfunctionDefinition) break;
            if (!parent.escapeSingleQuotes) continue;
            return true;
        }
        return false;
    }

    protected Node(int id) {
        this.id = id;
    }

    void jjtOpen() {
    }

    void jjtClose() {
    }

    void jjtSetParent(Node n) {
        this.parent = n;
        if (this.parser == null && n != null && n.parser != null) {
            this.parser = this.parent.parser;
        }
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
        if (n != null) {
            n.jjtSetParent(this);
            n.siblingSequence = i;
        }
    }

    void jjtRemoveChild(int i) {
        if (this.children == null) {
            return;
        }
        if (i == this.children.length - 1) {
            Node[] c = new Node[this.children.length - 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length - 1);
            this.children = c;
        } else if (i < this.children.length - 1) {
            Node[] c = new Node[this.children.length - 1];
            System.arraycopy(this.children, 0, c, 0, i);
            System.arraycopy(this.children, i + 1, c, i, this.children.length - i - 1);
            for (int j = i; j < c.length; ++j) {
                --c[j].siblingSequence;
            }
            this.children = c;
        }
    }

    void resetSiblingSequence() {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].siblingSequence = i;
        }
    }

    void jjtInsertChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i];
        }
        if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        } else {
            Node[] c = new Node[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            for (int j = i + 1; j < c.length; ++j) {
                ++c[j].siblingSequence;
            }
            this.children = c;
        }
        this.children[i] = n;
        if (n != null) {
            n.jjtSetParent(this);
            n.siblingSequence = i;
        }
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    protected boolean isValidChildIndex(int i) {
        return this.children != null && i < this.children.length;
    }

    void setParser(CFMLParserBase p) {
        this.parser = p;
    }

    void setStartToken(Token t) {
        this.startToken = t;
    }

    void setEndToken(Token t) {
        this.endToken = t;
    }

    public Token getStartToken() {
        if (this.startToken == null) {
            Node parent;
            for (parent = this.jjtGetParent(); parent != null && parent.startToken == null; parent = parent.jjtGetParent()) {
            }
            if (parent != null) {
                this.startToken = parent.startToken;
            } else {
                throw new CompilerInternalException(this);
            }
        }
        return this.startToken;
    }

    int getLine() {
        if (this.startToken != null) {
            if (this.startToken.image != null && (ASTpcdata.isWhitespace(this.startToken.image) || this.startToken.image.length() == 0)) {
                return -1;
            }
            return this.startToken.beginLine;
        }
        if (this.endToken != null) {
            return this.endToken.beginLine;
        }
        return -1;
    }

    public Token getEndToken() {
        if (this.endToken == null) {
            Node parent;
            for (parent = this.jjtGetParent(); parent != null && parent.endToken == null; parent = parent.jjtGetParent()) {
            }
            if (parent != null) {
                this.endToken = parent.endToken;
            } else {
                throw new IllegalStateException("no token or parent associated with this node: " + this.getClass());
            }
        }
        return this.endToken;
    }

    public void accept(JJTreeVisitor cfml) throws ParseException {
        this.walkChildren(cfml);
    }

    void walkChildren(JJTreeVisitor cfml) throws ParseException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Node n = this.children[i];
                if (n == null) continue;
                n.accept(cfml);
            }
        }
    }

    NeoTranslationContext getTranslationContext() {
        if (this.parser == null) {
            throw new IllegalStateException("parser not set on " + this.getClass().getName() + " " + this.id);
        }
        if (this.parser.translationContext == null) {
            throw new IllegalStateException("translation context not set on " + this.getClass().getName() + " " + this.id);
        }
        return this.parser.translationContext;
    }

    public boolean hasAncestor(String ancestor) {
        for (Node node = this.jjtGetParent(); node != null; node = node.jjtGetParent()) {
            TagNode tagNode;
            if (!(node instanceof TagNode) || !ancestor.equalsIgnoreCase((tagNode = (TagNode)node).getTagName())) continue;
            return true;
        }
        return false;
    }

    Node findAncestor(int kidId, int aId) {
        for (Node parent = this.jjtGetParent(); parent != null; parent = parent.jjtGetParent()) {
            if (parent.id != aId) continue;
            return parent;
        }
        throw new AncestorNotFoundException(aId, kidId, this.startToken);
    }

    protected boolean isCFScript() {
        for (Node node = this.jjtGetParent(); node != null; node = node.jjtGetParent()) {
            if (node instanceof ASTcfscript) {
                return true;
            }
            if (!(node instanceof ASTcftag) || ((ASTcftag)node).getCalledName() == null) continue;
            return true;
        }
        return false;
    }

    public ASTfunctionDefinition getFunctionDef() {
        Node node = this.jjtGetParent();
        while (true) {
            if (node == null) {
                throw new IllegalStateException("no parent");
            }
            if (node instanceof ASTfunctionDefinition) {
                return (ASTfunctionDefinition)node;
            }
            if (node instanceof ASTstart) {
                return null;
            }
            node = node.jjtGetParent();
        }
    }

    public ASTcfscriptStatement getLoopDef() {
        Node node = this;
        while (true) {
            if (node == null) {
                throw new IllegalStateException("no parent");
            }
            if (node instanceof ASTcfscriptStatement && (((ASTcfscriptStatement)node).stmtType == 5 || ((ASTcfscriptStatement)node).stmtType == 6 || ((ASTcfscriptStatement)node).stmtType == 7)) {
                return (ASTcfscriptStatement)node;
            }
            if (node instanceof ASTstart) {
                return null;
            }
            node = node.jjtGetParent();
        }
    }

    public List<Node> getAllChildren() {
        ArrayList<Node> children = new ArrayList<Node>();
        if (this.children != null) {
            children.addAll(Arrays.asList(this.children));
        }
        if (this instanceof NamedAttributeNode) {
            Enumeration attrNames = this.getAttrNames();
            while (attrNames != null && attrNames.hasMoreElements()) {
                String key = attrNames.nextElement().toString();
                Node oldAttr = this.getNamedAttribute(key);
                if (oldAttr == null) continue;
                children.add(oldAttr);
            }
        }
        return children;
    }

    public List<Node> getDirectChildren() {
        ArrayList<Node> children = new ArrayList<Node>();
        if (this.children != null) {
            children.addAll(Arrays.asList(this.children));
        }
        return children;
    }

    public ASTcftag getClientScriptParent() {
        Node node = this.jjtGetParent();
        while (node != null) {
            if (node instanceof ASTcftag && "cfclient".equalsIgnoreCase(((ASTcftag)node).getTagName())) {
                return (ASTcftag)node;
            }
            if (node instanceof ASTstart) {
                String value;
                ExprNode clientNode = ((ASTstart)node).getAttrNode("client");
                if (clientNode != null && clientNode.id == 27 && ("true".equalsIgnoreCase(value = StatementNode.extractToken((ExprNode)((ASTliteral)clientNode), (String)((String)null), (String)"client").image) || "yes".equalsIgnoreCase(value))) {
                    return (ASTcftag)node;
                }
                return null;
            }
            node = node.jjtGetParent();
        }
        return null;
    }

    public File getPageFile() {
        return this.getTranslationContext().getPageFile();
    }

    protected Node sortOutParent(Node n1, Node n2) {
        Node parent2;
        Node parent1;
        for (parent1 = n1.jjtGetParent(); parent1 != null && parent1 != n2; parent1 = parent1.jjtGetParent()) {
        }
        for (parent2 = n2.jjtGetParent(); parent2 != null && parent2 != n1; parent2 = parent2.jjtGetParent()) {
        }
        if (parent1 != null && parent2 == null) {
            return n2;
        }
        if (parent2 != null && parent1 == null) {
            return n1;
        }
        return null;
    }

    private int getSelfCodeSizeWeight() {
        int result = 0;
        switch (this.id) {
            case 1: {
                result = 100;
                break;
            }
            case 14: {
                result = 20;
                break;
            }
            case 17: {
                result = 10 + ((ASTcfswitch)this).getSwitchexpression().getCodeSizeWeight();
                break;
            }
            case 19: {
                result = 10;
                break;
            }
            case 216: 
            case 217: {
                result = 10;
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 24: 
            case 43334: {
                result = 0;
                break;
            }
            default: {
                result = 5;
            }
        }
        return result;
    }

    protected int getCodeSizeWeight() {
        if (this.codeSizeWeight == -1) {
            int accum = this.getSelfCodeSizeWeight();
            if (this instanceof NamedAttributeNode) {
                Node tn = this;
                Enumeration eAttrs = tn.getAttrNames();
                while (eAttrs != null && eAttrs.hasMoreElements()) {
                    try {
                        accum += tn.getNamedAttribute(eAttrs.nextElement().toString()).getCodeSizeWeight();
                    }
                    catch (Exception ex) {
                        Node.unexpected(ex);
                    }
                }
            }
            int i = 0;
            while (this.isValidChildIndex(i)) {
                accum += this.children[i].getCodeSizeWeight();
                ++i;
            }
            this.codeSizeWeight = accum;
        }
        return this.codeSizeWeight;
    }

    protected Node getSelfFactoringTarget() {
        if (this.selfFactoringTarget == null) {
            Node result = null;
            block2 : switch (this.id) {
                case 10: {
                    if (this.isCFScript()) break;
                    try {
                        result = ((StatementNode)this).getEnclosingStatement();
                        break;
                    }
                    catch (IllegalStateException ex) {
                        throw new AncestorNotFoundException(11, this.id, this.startToken);
                    }
                }
                case 9: {
                    if (this.isCFScript()) {
                        result = this.findScriptBreakTarget();
                        break;
                    }
                    try {
                        result = ((StatementNode)this).getEnclosingStatement();
                        break;
                    }
                    catch (IllegalStateException ex) {
                        throw new AncestorNotFoundException(11, this.id, this.startToken);
                    }
                }
                case 19: {
                    result = this.findAncestor(this.id, 17);
                    break;
                }
                case 14: {
                    result = this.findAncestor(this.id, 12);
                    break;
                }
                case 15: {
                    result = this.findAncestor(this.id, 14);
                    break;
                }
                case 3: {
                    switch (((ASTcfscriptStatement)this).getStatementType()) {
                        case 9: {
                            result = this.findScriptBreakTarget();
                            break block2;
                        }
                        case 11: {
                            ASTfunctionDefinition functionDef = this.getFunctionDef();
                            if (functionDef == null) break;
                            result = functionDef;
                            break block2;
                        }
                    }
                    result = this;
                    break;
                }
                case 101: {
                    result = this.jjtGetParent();
                    break;
                }
                case 10002: {
                    ASTfunctionDefinition functionDef = this.getFunctionDef();
                    if (functionDef != null && functionDef.isLocalReference(((ASTsimpleVariableReference)this).getCodegenVariableName())) {
                        result = functionDef;
                        break;
                    }
                    if (this.parent instanceof ASTevalcfoutput) {
                        result = this.parent;
                        break;
                    }
                    result = this;
                    break;
                }
                case 6: 
                case 22: 
                case 23: {
                    result = this.getFunctionDef();
                    break;
                }
                case 5: {
                    result = this.getFunctionDef();
                    if (result != null) break;
                    result = this.findAncestor(5, 25);
                    break;
                }
                default: {
                    result = this instanceof ExprNode && this.parent instanceof ASTevalcfoutput ? this.parent : this;
                }
            }
            this.selfFactoringTarget = result;
        }
        return this.selfFactoringTarget;
    }

    private Node findScriptBreakTarget() {
        int type;
        Node parent;
        boolean isContinue = this.id == 3 && ((ASTcfscriptStatement)this).getStatementType() == 9;
        for (parent = this.jjtGetParent(); parent != null && !(parent instanceof ASTcfscriptStatement ? (type = ((ASTcfscriptStatement)parent).getStatementType()) == 7 || type == 5 || type == 6 || type == 10 : parent instanceof ASTfunctionDefinition || parent instanceof ASTcfswitch && !isContinue); parent = parent.jjtGetParent()) {
        }
        return parent;
    }

    protected Node getFactoringTarget() {
        if (this.aggregateFactoringTarget == null) {
            this.aggregateFactoringTarget = this.getSelfFactoringTarget();
            int i = 0;
            while (this.aggregateFactoringTarget != null && this.isValidChildIndex(i)) {
                this.updateAggregateFactoringTarget(this.children[i]);
                ++i;
            }
            Enumeration attrNames = this.getAttrNames();
            while (attrNames != null && attrNames.hasMoreElements()) {
                String key = attrNames.nextElement().toString();
                Node attr = this.getNamedAttribute(key);
                if (attr == null) continue;
                this.updateAggregateFactoringTarget(attr);
            }
        }
        return this.aggregateFactoringTarget;
    }

    private void updateAggregateFactoringTarget(Node child) {
        Node nextFactoringTarget = child.getFactoringTarget();
        if (nextFactoringTarget == null) {
            if (child instanceof StatementNode) {
                this.aggregateFactoringTarget = null;
            }
        } else if (nextFactoringTarget != this && nextFactoringTarget != child) {
            this.aggregateFactoringTarget = this.aggregateFactoringTarget != null && nextFactoringTarget != this.aggregateFactoringTarget ? this.sortOutParent(this.aggregateFactoringTarget, nextFactoringTarget) : nextFactoringTarget;
        }
    }

    protected boolean isSelfContained() {
        return this.getFactoringTarget() == this;
    }

    final void factorNodes(Map factoredNodes) {
        this.factorNodes(factoredNodes, 6000, 600);
    }

    private void factorNodes(Map factoredNodes, int threshold, int minThreshold) {
        if (this.children == null || this.getCodeSizeWeight() < threshold) {
            return;
        }
        int subThreshold = threshold;
        if (this.children != null) {
            subThreshold = Math.max(threshold / this.children.length, minThreshold);
        }
        int i = 0;
        while (this.isValidChildIndex(i)) {
            this.children[i].factorNodes(factoredNodes, subThreshold, minThreshold);
            ++i;
        }
        int nextNodeToFactor = 0;
        while (this.getCodeSizeWeight() > threshold) {
            while (this.isValidChildIndex(nextNodeToFactor) && !this.children[nextNodeToFactor].isSelfContained()) {
                if (this.canHoist(this.children[nextNodeToFactor], this)) {
                    int hoistableWeight = this.children[nextNodeToFactor].getCodeSizeWeight();
                    this.codeSizeWeight -= hoistableWeight;
                    this.children[nextNodeToFactor] = this.children[nextNodeToFactor].hoistControlFlow(factoredNodes);
                }
                ++nextNodeToFactor;
            }
            if (this.isValidChildIndex(nextNodeToFactor)) {
                int accumWeight = this.children[nextNodeToFactor].getCodeSizeWeight();
                int j = nextNodeToFactor + 1;
                while (this.isValidChildIndex(j) && this.children[j].isSelfContained() && accumWeight < threshold) {
                    accumWeight += this.children[j].getCodeSizeWeight();
                    ++j;
                }
                if (accumWeight >= minThreshold) {
                    this.factorChildren(factoredNodes, nextNodeToFactor, j - 1);
                    this.codeSizeWeight -= accumWeight;
                    ++nextNodeToFactor;
                    continue;
                }
                nextNodeToFactor = j;
                continue;
            }
            if (this.getCodeSizeWeight() <= threshold) break;
            Node.unexpected(new IllegalStateException("Unable to factor " + this.toString()));
            break;
        }
        this.factorNamedChildren(factoredNodes, threshold, minThreshold);
    }

    private void factorNamedChildren(Map factoredNodes, int threshold, int minThreshold) {
        Enumeration attrNames = this.getAttrNames();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = attrNames.nextElement().toString();
            Node attr = this.getNamedAttribute(key);
            if (attr == null || attr instanceof ExprNode) continue;
            attr.factorNodes(factoredNodes, threshold, minThreshold);
        }
    }

    private void factorChildren(Map factoredNodesTable, int startIndex, int endIndex) {
        int nFactored = endIndex + 1 - startIndex;
        Node[] factoredChildren = new Node[nFactored];
        System.arraycopy(this.children, startIndex, factoredChildren, 0, nFactored);
        FactoredNodeAggregation aggr = new FactoredNodeAggregation(this, factoredChildren);
        String callSite = "_factor" + factoredNodesTable.size();
        aggr.setCallSite(callSite);
        factoredNodesTable.put(callSite, aggr);
        Node[] compactedChildren = new Node[this.children.length + 1 - nFactored];
        if (startIndex > 0) {
            System.arraycopy(this.children, 0, compactedChildren, 0, startIndex);
        }
        compactedChildren[startIndex] = aggr;
        if (startIndex + 1 < compactedChildren.length) {
            System.arraycopy(this.children, endIndex + 1, compactedChildren, startIndex + 1, compactedChildren.length - startIndex - 1);
        }
        this.children = compactedChildren;
    }

    public static void unexpected(Throwable t) {
        try {
            DebuggingService debuggingService = ServiceFactory.getDebuggingService();
            if (debuggingService != null) {
                debuggingService.getDebugger().unexpected(t);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean canHoist(Node n, Node parent) {
        return n.getFactoringTarget() == parent && n instanceof ASTcfcase;
    }

    private Node hoistControlFlow(Map factoredNodesTable) {
        ASTcfcase caseNode = (ASTcfcase)this;
        if (this.children != null) {
            this.factorNodes(factoredNodesTable, 200, 100);
        }
        return this;
    }

    @Override
    public Enumeration getAttrNames() {
        if (this.namedChildren == null || this.namedChildren.isEmpty()) {
            return emptyEnumeration;
        }
        return this.namedChildren.keys();
    }

    @Override
    public Node getNamedAttribute(String key) {
        if (this.namedChildren == null) {
            return null;
        }
        return (Node)this.namedChildren.get(key);
    }

    @Override
    public void setNamedAttribute(String key, Node value) {
        if (this.namedChildren == null) {
            this.namedChildren = new Hashtable();
        }
        if (value != null) {
            this.namedChildren.put(key, value);
            value.jjtSetParent(this);
        } else {
            this.namedChildren.remove(key);
        }
    }

    public Object getLabel() {
        return this.label;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public Node getParentOfType(Class parentClass) {
        return Node.getParentNodeOfType(this, parentClass);
    }

    public static Node getParentNodeOfType(Node node, Class type) {
        return Node.getParentNodeOfType(node, type, null);
    }

    public static Node getParentNodeOfType(Node node, Class type, Class[] exclude) {
        if (node == null) {
            return null;
        }
        Node parentNode = node.jjtGetParent();
        if (parentNode == null) {
            return null;
        }
        Class<?> parentClass = parentNode.getClass();
        boolean skip = false;
        if (exclude != null) {
            for (int i = 0; i < exclude.length; ++i) {
                if (!parentClass.equals(exclude[i])) continue;
                skip = true;
                break;
            }
        }
        if (!skip && type.isAssignableFrom(parentClass)) {
            return parentNode;
        }
        if ((parentNode = Node.getParentNodeOfType(parentNode, type)) != null) {
            return parentNode;
        }
        return null;
    }

    protected void markStatic() {
        this.isStatic = true;
    }

    public boolean staticSupportDisabled() {
        if (this.parser == null) {
            return false;
        }
        return !this.parser.supportStatic();
    }

    public boolean isStatic() {
        if (this.parser != null && !this.parser.supportStatic()) {
            return false;
        }
        if (this.isStatic) {
            return true;
        }
        Node parent = this.jjtGetParent();
        if (parent != null) {
            if (parent instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)parent).stmtType == 20) {
                return true;
            }
            return parent.isStatic();
        }
        return false;
    }

    public class AncestorNotFoundException
    extends ParseException {
        public String childTagName;
        public String parentTagName;

        AncestorNotFoundException(int aId, int kidId, Token tok) {
            super(tok);
            this.parentTagName = cfml40TreeConstants.jjtNodeName[aId];
            this.childTagName = cfml40TreeConstants.jjtNodeName[kidId];
        }
    }
}

