/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.Node;
import coldfusion.compiler.Token;
import coldfusion.runtime.ExceptionInformation;
import coldfusion.runtime.TemplateException;
import coldfusion.util.FastHashtable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class ParseException
extends TemplateException {
    protected Token errorToken = null;
    protected Token currentToken = null;
    private File pageFile;
    private Vector annotations = null;
    public String snippet = null;

    ParseException(Token errorTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        this();
        if (errorTokenVal != null) {
            this.currentToken = errorTokenVal;
            this.errorToken = errorTokenVal.next;
        }
        if (this.errorToken.kind == 1) {
            this.addAnnotation(new UnexpectedStartTagException(this.errorToken));
        }
    }

    protected ParseException(Token errorToken) {
        this();
        this.errorToken = errorToken;
    }

    ParseException() {
    }

    protected void setMessage(String errMsg) {
        this.msg = errMsg;
    }

    private ParseException(Exception ex, Node n) {
        super(ex);
        this.errorToken = n.getStartToken();
        this.patchPagePosition(n);
    }

    public String getTokenText() {
        if (this.errorToken != null) {
            return ParseException.add_escapes(this.errorToken.image);
        }
        return "&lt;unknown parse element&gt;";
    }

    public int getLine() {
        if (this.errorToken != null) {
            return this.errorToken.beginLine;
        }
        return -1;
    }

    public int getColumn() {
        if (this.errorToken != null) {
            return this.errorToken.beginColumn;
        }
        return -1;
    }

    public String getKnownText() {
        if (this.currentToken != null) {
            return ParseException.add_escapes(this.currentToken.image);
        }
        return "&lt;unknown&gt;";
    }

    public int getKnownLine() {
        if (this.currentToken != null) {
            return this.currentToken.beginLine;
        }
        return -1;
    }

    public int getKnownColumn() {
        if (this.currentToken != null) {
            return this.currentToken.beginColumn;
        }
        return -1;
    }

    public Token _getErrorToken() {
        return this.errorToken;
    }

    public void _setPageFile(File file) {
        this.pageFile = file;
    }

    public File _getPageFile() {
        return this.pageFile;
    }

    public ExceptionInformation getTagContext() {
        ExceptionInformation result = new ExceptionInformation(this);
        if (this.pageFile != null) {
            FastHashtable newEntry = new FastHashtable();
            newEntry.put("TEMPLATE", this.pageFile.getPath());
            newEntry.put("TYPE", "SYNTAX");
            newEntry.put("LINE", new Integer(this.getLine()));
            newEntry.put("COLUMN", new Integer(this.getColumn()));
            result.insertElementAt(newEntry, 0);
        }
        return result;
    }

    @Override
    public String getDetail() {
        if (this.annotations != null) {
            StringBuffer result = new StringBuffer(super.getDetail());
            result.append(new StartAnnotations().getMessage());
            int count = this.annotations.size();
            for (int i = 0; i < count; ++i) {
                ParseException nextAnnotation = (ParseException)this.annotations.elementAt(i);
                result.append(nextAnnotation.getMessage());
                result.append(nextAnnotation.getDetail());
            }
            result.append("</ul>");
            return result.toString();
        }
        return super.getDetail();
    }

    void addAnnotation(ParseException annotation) {
        if (this.annotations == null) {
            this.annotations = new Vector();
        }
        this.annotations.add(annotation);
    }

    public void setSnippet(String s) {
        this.snippet = s;
    }

    public void setStartToken(Token t) {
        this.errorToken = t;
    }

    public void patchPagePosition(Node n, Token t) {
        if (this.errorToken == null) {
            this.errorToken = t;
        }
        if (this.pageFile == null) {
            this.pageFile = n.getTranslationContext().getPageFile();
        }
    }

    public void patchPagePosition(Node n) {
        this.patchPagePosition(n, n.getStartToken());
    }

    public static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            retval.append(ParseException.escapeChar(str.charAt(i)));
        }
        return retval.toString();
    }

    public static String escapeChar(char curChar) {
        return switch (curChar) {
            case '\b' -> "\\b";
            case '\t' -> "\\t";
            case '\n' -> "\\n";
            case '\f' -> "\\f";
            case '\r' -> "\\r";
            case '\"' -> "\\\"";
            case '\'' -> "\\'";
            case '\\' -> "\\\\";
            case '<' -> "&lt;";
            case '>' -> "&gt;";
            default -> {
                if (curChar < ' ' || curChar > '~') {
                    String s = "0000" + Integer.toString(curChar, 16);
                    yield "\\u" + s.substring(s.length() - 4, s.length());
                }
                yield String.valueOf(curChar);
            }
        };
    }

    public static ParseException wrap(Exception ex, Node n) {
        return ParseException.wrap(ex, n, n.getStartToken());
    }

    public static ParseException wrap(Exception ex, Node n, Token t) {
        ParseException result;
        if (ex instanceof ParseException) {
            result = (ParseException)ex;
            result.patchPagePosition(n, t);
        } else {
            result = new CompilerExceptionWrapper(ex, n, t);
        }
        return result;
    }

    public class UnexpectedStartTagException
    extends ParseException {
        UnexpectedStartTagException(Token startToken) {
            super(startToken);
        }
    }

    public class StartAnnotations
    extends ParseException {
        StartAnnotations() {
        }
    }

    public static class CompilerExceptionWrapper
    extends ParseException {
        private Throwable t;

        CompilerExceptionWrapper(Exception t, Node n, Token errorToken) {
            super(t, n);
            this.t = t;
            this.errorToken = errorToken;
        }

        public String getWrappedClassName() {
            return this.t.getClass().getName();
        }

        public String getWrappedMessage() {
            return this.t.getMessage();
        }

        public String getWrappedStackTrace() {
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            this.t.printStackTrace(p);
            return w.toString();
        }
    }
}

