/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.EvaluateAssembler;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.EvaluateFunction;
import coldfusion.compiler.ExprClassLoader;
import coldfusion.compiler.ExprVisitor;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Treewalker;
import coldfusion.runtime.CFPage;
import coldfusion.util.AbstractCache;
import coldfusion.util.LruCache;
import coldfusion.util.SoftCache;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;

public class PrecisionEvalExprClassLoader
extends ClassLoader {
    private static long id;
    private static final ExprCache stmtCache;

    protected PrecisionEvalExprClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    Class defineStatement(ASTcfscriptStatement statement) throws IOException {
        statement.preTransformAssignment(JavaAssembler.BigDecimalClass);
        Treewalker.postorder(statement, new ExprVisitor());
        String className = PrecisionEvalExprClassLoader.createName("Statement");
        EvaluateAssembler asm = new EvaluateAssembler(className);
        byte[] bytes = asm.assembleStatement(statement);
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    public static Object evaluate(String expr, CFPage page) throws ParseException {
        if ((expr = expr.trim()).length() == 0) {
            return expr;
        }
        switch (expr.charAt(0)) {
            case 'T': 
            case 't': {
                if (!expr.equalsIgnoreCase("true")) break;
                return expr;
            }
            case 'F': 
            case 'f': {
                if (!expr.equalsIgnoreCase("false")) break;
                return expr;
            }
        }
        Object number = null;
        if (ExprClassLoader.isIdentifierExpr(expr)) {
            return page._autoscalarize(expr);
        }
        number = PrecisionEvalExprClassLoader.isNumber(expr);
        if (number != null) {
            return number;
        }
        return PrecisionEvalExprClassLoader.compileStatement(expr).evaluate(page, null);
    }

    public static EvaluateFunction compileStatement(String expr) throws ParseException {
        return (EvaluateFunction)stmtCache.get(expr);
    }

    private static synchronized String createName(String prefix) {
        return prefix + id++;
    }

    private static void saveClass(String className, byte[] classBytes) throws IOException {
        try (FileOutputStream out = new FileOutputStream(className + ".clas");){
            out.write(classBytes);
        }
    }

    public static void main(String[] args) throws Throwable {
        CFPage testPage = null;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String expr = args[i];
                System.out.print(expr + " => ");
                PrecisionEvalExprClassLoader.test(expr, testPage);
            }
        } else {
            int c;
            StringBuffer b = new StringBuffer();
            System.out.print("=> ");
            System.out.flush();
            while ((c = System.in.read()) != -1) {
                b.append((char)c);
                if (c != 10) continue;
                String expr = b.toString();
                PrecisionEvalExprClassLoader.test(expr, testPage);
                b = new StringBuffer();
                System.out.print("=> ");
                System.out.flush();
            }
        }
    }

    private static void test(String expr, CFPage page) {
        try {
            Object value = PrecisionEvalExprClassLoader.evaluate(expr, page);
            System.out.println(value);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    private static Object isNumber(String expr) {
        try {
            BigDecimal b = new BigDecimal(expr);
            return b;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        stmtCache = new ExprCache(new StatementCache());
    }

    private static class ExprCache
    extends SoftCache {
        final AbstractCache secondary;

        ExprCache(AbstractCache secondary) {
            this.secondary = secondary;
        }

        @Override
        public synchronized void clear() {
            super.clear();
            this.secondary.clear();
        }

        @Override
        protected Object fetchSerial(Object expr) {
            return this.secondary.get(expr);
        }

        @Override
        public synchronized void setSize(int capacity) {
            super.setSize(capacity);
            this.secondary.setSize(capacity);
        }

        @Override
        public synchronized void remove(Object expr) {
            super.remove(expr);
            this.secondary.remove(expr);
        }

        public String toString() {
            return "Expression Soft Cache";
        }
    }

    static class StatementCache
    extends LruCache {
        StatementCache() {
        }

        @Override
        protected Object fetch(Object expr) {
            ASTcfscriptStatement statement = EvaluateEngine.parsePrecisionEvaluate((String)expr, null);
            try {
                PrecisionEvalExprClassLoader loader = new PrecisionEvalExprClassLoader();
                return (EvaluateFunction)loader.defineStatement(statement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ParseException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

