/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTArrayInitializer;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTStructInitializer;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfargument;
import coldfusion.compiler.ASTcfcase;
import coldfusion.compiler.ASTcfcatch;
import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfloop;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.ASTcftry;
import coldfusion.compiler.ASTevalcfoutput;
import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ASTtoolkit;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.ArrayStructInitializer;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.ImplicitInitializerTransformer;
import coldfusion.compiler.InstanceFieldReference;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.TagBodyNode;
import coldfusion.compiler.TagInfoNotFoundException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.compiler.TreeTransformer;
import coldfusion.compiler.Treewalker;
import coldfusion.compiler.VariableReference;
import coldfusion.compiler.cfml40TreeConstants;
import coldfusion.jsp.JSTTagInfo;
import coldfusion.log.CFLogs;
import coldfusion.runtime.CFComponent;
import coldfusion.runtime.CFInterface;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.RWLock;
import coldfusion.runtime.Variable;
import coldfusion.tagext.FunctionGeneratorTag;
import coldfusion.tagext.lang.CustomTag;
import coldfusion.tagext.lang.ImportedTag;
import coldfusion.tagext.validation.CFMLTagLibrary;
import jakarta.servlet.jsp.tagext.TagData;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class SemanticAnalyzer
implements TreeTransformer,
cfml40TreeConstants {
    public static final String LOCAL = "LOCAL";
    protected static final String DEFAULT_EXPRESSION_STMT = "DEFAULT_EXPRESSION_STMT";
    protected static final String DEFAULT = "default";
    NeoTranslationContext tc;
    private int count = 0;
    static final String IMPLICIT_ARRAY_STRUCT_VAR = "___IMPLICITARRYSTRUCTVAR";

    SemanticAnalyzer(NeoTranslationContext tc) {
        this.tc = tc;
    }

    @Override
    public Node preTransform(Node n) {
        block1 : switch (n.id) {
            case 1: 
            case 11: {
                Node[] attrs;
                TagNode tag = (TagNode)n;
                this.preTransformCftag(tag);
                ASTexprlist exprList = ((TagNode)n).attrList;
                if (exprList == null || (attrs = exprList.children) == null) break;
                for (int i = 0; i < attrs.length; ++i) {
                    Node valueNode;
                    Node child = attrs[i];
                    if (!(child instanceof ASTtagAttribute) || !((valueNode = ((ASTtagAttribute)child).getValueNode()) instanceof ASTStructInitializer) && !(valueNode instanceof ASTArrayInitializer)) continue;
                    ASTcfscriptStatement statement = this.createInitializerStatement(child, valueNode, i, (TagNode)n, ((ASTtagAttribute)child).getName());
                    this.adjustInitializerStmtNodeTagAttr(child, statement);
                }
                break;
            }
            case 24: {
                TagNode tNode = (TagNode)n;
                ExprNode exprValueNode = tNode.getAttrNode(DEFAULT);
                if (exprValueNode == null) break;
                Node child = exprValueNode.jjtGetParent();
                if (exprValueNode instanceof ASTStructInitializer || exprValueNode instanceof ASTArrayInitializer) {
                    ASTcfscriptStatement stmt = this.createInitializerStatement(child, exprValueNode, 0, (TagNode)n, ((ASTtagAttribute)child).getName());
                    stmt.jjtSetParent(n);
                    n.setNamedAttribute(DEFAULT_EXPRESSION_STMT, this.preTransform(stmt));
                }
                tNode.putAttrNode(DEFAULT, (ExprNode)this.preTransform(tNode.getAttrNode(DEFAULT)));
                break;
            }
            case 22: {
                ASTparameterDefinition paramDefinition = (ASTparameterDefinition)n;
                for (int i = 0; i < paramDefinition.complexParams.size(); ++i) {
                    Node lvalNode = (Node)paramDefinition.complexParams.get(i);
                    lvalNode.jjtSetParent(n.jjtGetParent());
                    if (lvalNode instanceof ASTDestructring) {
                        ((ASTDestructring)lvalNode).preTransformRoot(this.tc);
                        continue;
                    }
                    if (!(lvalNode instanceof ASTcfscriptStatement)) continue;
                    this.preTransform(lvalNode);
                }
                break;
            }
            case 3: {
                Node namedAttribute;
                Node lvalNode;
                ASTcfscriptStatement cfscriptstmtNode = (ASTcfscriptStatement)n;
                if (cfscriptstmtNode.isStringLiteralInvocation()) {
                    Node parent = cfscriptstmtNode.jjtGetParent();
                    Node swapNode = parent.jjtGetChild(cfscriptstmtNode.siblingSequence + 1);
                    parent.jjtAddChild(swapNode, cfscriptstmtNode.siblingSequence);
                    cfscriptstmtNode.setStringLiteralInvocation(false);
                    parent.jjtAddChild(n, cfscriptstmtNode.siblingSequence + 1);
                    n = swapNode;
                    cfscriptstmtNode = (ASTcfscriptStatement)n;
                }
                if (cfscriptstmtNode.stmtType == 20) {
                    cfscriptstmtNode.markStatic();
                    break;
                }
                if (cfscriptstmtNode.stmtType == 3) {
                    lvalNode = cfscriptstmtNode.getNamedAttribute("LVAL");
                    if (lvalNode instanceof ASTDestructring) {
                        ((ASTDestructring)lvalNode).preTransformRoot(this.tc);
                    }
                    if (!ImplicitInitializerTransformer.isInitNodeReqd(cfscriptstmtNode)) break;
                    return this.createInitializerStatementforAssignment(cfscriptstmtNode, cfscriptstmtNode.jjtGetParent(), cfscriptstmtNode.siblingSequence);
                }
                if (cfscriptstmtNode.stmtType != 10) break;
                lvalNode = cfscriptstmtNode.getNamedAttribute("ITERATOR");
                if (lvalNode instanceof ASTDestructring) {
                    ((ASTDestructring)lvalNode).preTransformRoot(this.tc);
                }
                if (!((namedAttribute = cfscriptstmtNode.getNamedAttribute("COLLECTION")) instanceof ASTStructInitializer) && !(namedAttribute instanceof ASTArrayInitializer)) break;
                ASTcfscriptStatement statement = this.createInitializerStatement(n, namedAttribute, 0, null, null);
                this.adjustInitializerStmtNode(n, statement);
                break;
            }
            case 6: {
                ASTvariableDefinition vardef = (ASTvariableDefinition)n;
                int numOfChildren = n.jjtGetNumChildren();
                for (int i = 0; i < numOfChildren; ++i) {
                    Node child = n.jjtGetChild(i);
                    if (!(child instanceof ASTcfscriptStatement)) continue;
                    ASTcfscriptStatement scriptStmt = (ASTcfscriptStatement)child;
                    ExprNode lvalExprNode = scriptStmt.getExpression("LVAL");
                    String lvalVar = null;
                    if (lvalExprNode instanceof ASTsimpleVariableReference && LOCAL.equalsIgnoreCase(lvalVar = ((ASTsimpleVariableReference)lvalExprNode).getCodegenVariableName()) && scriptStmt.getStatementType() == 3) {
                        ASTStructInitializer initializer;
                        boolean removeNode = false;
                        if (scriptStmt.getExpression("RVAL") instanceof ASTStructInitializer && (initializer = (ASTStructInitializer)scriptStmt.getExpression("RVAL")).getInitializers().isEmpty()) {
                            removeNode = true;
                        }
                        if (removeNode) {
                            scriptStmt.setNamedAttribute("LVAL", null);
                            scriptStmt.setNamedAttribute("RVAL", null);
                            scriptStmt.setStatementType(1);
                            break block1;
                        }
                    }
                    if (!ImplicitInitializerTransformer.isInitNodeReqd(scriptStmt)) continue;
                    this.createInitializerStatementforAssignment(scriptStmt, scriptStmt.jjtGetParent(), scriptStmt.siblingSequence);
                }
                break;
            }
            case 21: {
                Node valueNode = ((ASTtagAttribute)n).getValueNode();
                if (valueNode == null || !(valueNode instanceof ASTStructInitializer) && !(valueNode instanceof ASTArrayInitializer)) break;
                ASTcfscriptStatement statement = this.createInitializerStatement(n, valueNode, 0, null, null);
                Node tagNode = CFMLParserBase.getParentNodeOfType(n, TagNode.class);
                if (tagNode == null) {
                    this.adjustInitializerStmtNode(n, statement);
                    break;
                }
                this.adjustInitializerStmtNodeTagAttr(n, statement);
                break;
            }
            case 28: {
                Node[] funcParamsChild = n.children;
                if (funcParamsChild == null) break;
                for (int i = 0; i < funcParamsChild.length; ++i) {
                    Node child = funcParamsChild[i];
                    Node grandParentNode = n.jjtGetParent().jjtGetParent();
                    if (grandParentNode != null && grandParentNode instanceof ASTevalcfoutput && child instanceof ASTtagAttribute && ((ASTfuncparams)n).getFunctionName().equalsIgnoreCase("serializejson")) {
                        child = child.getNamedAttribute(((ASTtagAttribute)child).getName());
                    }
                    if (!(child instanceof ASTStructInitializer) && !(child instanceof ASTArrayInitializer)) continue;
                    ASTcfscriptStatement statement = this.createInitializerStatement(n, child, i, null, null);
                    if (((ArrayStructInitializer)child).isSpreadOperationType()) {
                        ASTsimpleVariableReference arrayStructImplicitVar = (ASTsimpleVariableReference)n.children[i];
                        arrayStructImplicitVar.setSpreadOperation(true);
                    }
                    this.adjustInitializerStmtNodeFuncParams(n, statement);
                }
                break;
            }
            case 18: {
                Node[] attributes;
                ASTexprlist attrList = ((ASTcffunction)n).attrList;
                if (attrList == null || (attributes = attrList.children) == null) break;
                for (int i = 0; i < attributes.length; ++i) {
                    Vector tokens;
                    if (!(attributes[i] instanceof ASTtagAttribute)) continue;
                    ASTtagAttribute attr = (ASTtagAttribute)attributes[i];
                    Node attrValue = attr.getValueNode();
                    String attrName = attr.getName();
                    if (!attrName.equalsIgnoreCase("type") || !(attrValue instanceof ASTliteral) || (tokens = ((ASTliteral)attrValue).tokens) == null || tokens.size() <= 0) continue;
                    Object token = tokens.get(0);
                    String typeValue = "";
                    if (token instanceof String) {
                        typeValue = (String)token;
                    }
                    if (!typeValue.equalsIgnoreCase("java")) continue;
                    List<Node> childs = n.getAllChildren();
                    ArrayList<String> argsData = new ArrayList<String>();
                    for (Node child : childs) {
                        if (child instanceof ASTpcdata) {
                            String data;
                            ASTpcdata pcdata = (ASTpcdata)child;
                            if (pcdata.buffer == null || (data = pcdata.buffer.toString()).length() <= 0) continue;
                            pcdata.isJavaCode = true;
                            pcdata.javaArgs = argsData;
                            continue;
                        }
                        if (!(child instanceof ASTparameterDefinition)) continue;
                        ASTparameterDefinition paramDef = (ASTparameterDefinition)child;
                        List<Node> args = paramDef.getAllChildren();
                        for (Node arg : args) {
                            ASTexprlist attrs;
                            if (!(arg instanceof ASTcfargument) || (attrs = ((ASTcfargument)arg).attrList) == null) continue;
                            Node[] attrchilds = attrs.children;
                            String argtype = "";
                            String argname = "";
                            if (attrchilds == null) continue;
                            for (Node attrchild : attrchilds) {
                                Node argnamen;
                                if (!(attrchild instanceof ASTtagAttribute)) continue;
                                ASTtagAttribute tagAttr = (ASTtagAttribute)attrchild;
                                Node type = tagAttr.getNamedAttribute("type");
                                if (type != null && type instanceof ASTliteral && ((ASTliteral)type).tokens != null && ((ASTliteral)type).tokens.size() > 0) {
                                    argtype = (String)((ASTliteral)type).tokens.get(0);
                                }
                                if ((argnamen = tagAttr.getNamedAttribute("name")) == null || !(argnamen instanceof ASTliteral) || ((ASTliteral)argnamen).tokens == null || ((ASTliteral)argnamen).tokens.size() <= 0) continue;
                                argname = (String)((ASTliteral)argnamen).tokens.get(0);
                            }
                            argsData.add(argtype);
                            argsData.add(argname);
                        }
                    }
                }
                break;
            }
            case 23: {
                Node[] attributes;
                ASTexprlist attrList = ((ASTcfargument)n).attrList;
                if (attrList == null || (attributes = attrList.children) == null) break;
                for (int i = 0; i < attributes.length; ++i) {
                    ASTtagAttribute attr = (ASTtagAttribute)attributes[i];
                    Node attrValue = attr.getValueNode();
                    String attrName = attr.getName();
                    if (!(attrValue instanceof ASTStructInitializer) && !(attrValue instanceof ASTArrayInitializer)) continue;
                    ASTcfscriptStatement statement = this.createInitializerStatement(n, attrValue, i, null, attrName);
                    this.adjustInitializerStmtNode(n, statement);
                }
                break;
            }
            case 5: {
                Node returnNode = n.getNamedAttribute("RVAL");
                if (returnNode == null || !(returnNode instanceof ASTStructInitializer) && !(returnNode instanceof ASTArrayInitializer)) break;
                ASTcfscriptStatement statement = this.createInitializerStatement(n, returnNode, 0, null, null);
                this.adjustInitializerStmtNode(n, statement);
                break;
            }
            case 238: 
            case 242: {
                ASTcfscriptStatement statement;
                ASToperator operator = (ASToperator)n;
                Node leftChild = operator.jjtGetChild(0);
                Node rightChild = operator.jjtGetChild(1);
                if (leftChild instanceof ASTArrayInitializer || leftChild instanceof ASTStructInitializer) {
                    statement = this.createInitializerStatementforColon(operator, leftChild, 0);
                    operator.setNamedAttribute("LEFT-INIT", statement);
                }
                if (!(rightChild instanceof ASTArrayInitializer) && !(rightChild instanceof ASTStructInitializer)) break;
                statement = this.createInitializerStatementforColon(operator, rightChild, 1);
                operator.setNamedAttribute("RIGHT-INIT", statement);
                break;
            }
            case 17: {
                ASTcfswitch cfswitch = (ASTcfswitch)n;
                if (cfswitch.getClientScriptParent() == null) {
                    return n;
                }
                if (cfswitch.isCFSWITCH) break;
                Node[] stmtList = cfswitch.children;
                Node[] children = stmtList[0].children;
                ArrayList<Node> cfcaseList = new ArrayList<Node>();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] instanceof ASTcfcase) {
                        cfcaseList.add(children[i]);
                        continue;
                    }
                    try {
                        Node cfcase = (Node)cfcaseList.get(cfcaseList.size() - 1);
                        int cfcasechildrenSize = cfcase.jjtGetNumChildren();
                        cfcase.jjtAddChild(children[i], cfcasechildrenSize);
                        continue;
                    }
                    catch (Exception e) {
                        CFLogs.SERVER_LOG.error(e);
                    }
                }
                cfswitch.children = cfcaseList.toArray(new Node[0]);
            }
        }
        return n;
    }

    @Override
    public Node transform(Node n) {
        Node result = n;
        block0 : switch (n.id) {
            case 25: {
                ASTstart start = (ASTstart)n;
                if (start.isComponent()) {
                    this.tc.setBaseClass(CFComponent.class);
                } else if (start.parser.isInterface()) {
                    this.tc.setBaseClass(CFInterface.class);
                }
                start.initAttr();
                start.factoredNodes = new HashMap();
                start.factorNodes(start.factoredNodes);
                break;
            }
            case 11: {
                this.cfloop((ASTcfloop)n);
                break;
            }
            case 1: {
                TagNode tag = (TagNode)n;
                this.cftag(tag);
                String tagName = tag.getTagName();
                if (tagName.equalsIgnoreCase("CFPARAM")) {
                    result = this.transformCFPARAM(tag);
                    break;
                }
                if (tagName.equalsIgnoreCase("CFLOCK")) {
                    result = this.transformCFLOCK(tag);
                    break;
                }
                if (!tagName.equalsIgnoreCase("CFDUMP")) break;
                result = this.transformCFDUMP(tag);
                break;
            }
            case 3: {
                ASTcfscriptStatement cfscriptStmt = (ASTcfscriptStatement)n;
                switch (cfscriptStmt.getStatementType()) {
                    case 3: {
                        ExprNode lhs = cfscriptStmt.getExpression("LVAL");
                        if (lhs instanceof ASTruntimeCall) {
                            throw new InvalidRuntimeCallAsLvarException(lhs.getStartToken());
                        }
                        boolean isStatic = false;
                        while (lhs != null && lhs instanceof VariableReference) {
                            if (lhs instanceof ASTstructureReference) {
                                ((ASTstructureReference)lhs).isLHS = true;
                            } else if (lhs instanceof ASTarrayReference) {
                                ((ASTarrayReference)lhs).setIsLHS();
                            }
                            if (!isStatic && ((VariableReference)lhs).isStatic()) {
                                cfscriptStmt.markStatic();
                                isStatic = true;
                            }
                            lhs = ((VariableReference)lhs).getStem();
                        }
                        cfscriptStmt.preTransformAssignment(JavaAssembler.doubleClass);
                        break block0;
                    }
                }
                break;
            }
            case 24: {
                Node exprStmt;
                ExprNode exprValueNode = ((TagNode)n).getAttrNode(DEFAULT);
                if (exprValueNode != null) {
                    ((TagNode)n).putAttrNode(DEFAULT, (ExprNode)this.transform(exprValueNode));
                }
                if ((exprStmt = n.getNamedAttribute(DEFAULT_EXPRESSION_STMT)) == null) break;
                n.setNamedAttribute(DEFAULT_EXPRESSION_STMT, this.transform(exprStmt));
                break;
            }
            case 10001: {
                result = this.transformRuntimeCall((ASTruntimeCall)n);
                break;
            }
            case 12: {
                ASTcftry cftry = (ASTcftry)n;
                cftry.tryCatchUniqueSuffix = this.tc.getTempCounter();
                if (cftry.catchBlocks.size() == 0 && cftry.finallyStmt == null) {
                    if (cftry.isCFScript()) {
                        throw new InvalidTryCatchFinallyException(cftry.getEndToken(), "");
                    }
                    throw new InvalidTryCatchFinallyException(cftry.getEndToken(), "CF");
                }
                int count = cftry.catchBlocks.size();
                for (int i = 0; i < count; ++i) {
                    ASTcfcatch cfcatch = (ASTcfcatch)cftry.catchBlocks.elementAt(i);
                    ASTfunctionDefinition functionDef = cfcatch.getFunctionDef();
                    if (functionDef == null || !functionDef.isLocalReference(cfcatch.getVarname())) continue;
                    throw new ASTvariableDefinition.CannotRedefineException(cfcatch.getVarname());
                }
                break;
            }
            case 27: {
                result = this.transformLiteral((ASTliteral)n);
                break;
            }
            case 6: {
                ASTvariableDefinition vardef = (ASTvariableDefinition)n;
                vardef.register();
                return n;
            }
            case 18: {
                Node tagNode = CFMLParserBase.getParentNodeOfType(n, ASTcffunction.class);
                if (tagNode != null && !((ASTfunctionDefinition)n).isClosure()) {
                    ((ASTfunctionDefinition)n).setNameForClosure(((ASTfunctionDefinition)n).functionName, true);
                }
                this.cffunction((ASTfunctionDefinition)n);
            }
        }
        if (n instanceof ASTsimpleVariableReference) {
            ((ASTsimpleVariableReference)n).checkForFinalArgumentOverride();
        } else if (n instanceof ASTstructureReference) {
            ((ASTstructureReference)n).checkForFinalArgumentOverride();
        } else if (n instanceof ASTarrayReference) {
            ((ASTarrayReference)n).checkForFinalArgumentOverride();
        }
        return result;
    }

    private void cfloop(ASTcfloop cfloop) {
        ExprNode query = cfloop.getAttrNode("QUERY");
        ExprNode file = cfloop.getAttrNode("FILE");
        ExprNode groupNode = cfloop.getAttrNode("GROUP");
        if (query != null || file != null || groupNode != null || cfloop.attrList.children == null || cfloop.attrList.children.length == 0) {
            cfloop.id = 1;
            this.cftag(cfloop);
        } else if (cfloop.getAttrNode("FROM") != null && cfloop.getAttrNode("TO") != null && cfloop.getAttrNode("STEP") == null) {
            ASTliteral one = new ASTliteral(new Double(1.0), cfloop);
            cfloop.putAttrNode("STEP", one);
        }
    }

    private void cffunction(ASTfunctionDefinition cffunction) {
        ASTfunctionDefinition enclosing;
        if (!cffunction.isClosure() && (enclosing = cffunction.getFunctionDef()) != null) {
            throw new IllegallyNestedFunctionException(cffunction.getNameToken(), enclosing.getNameToken());
        }
    }

    private void preTransformCftag(TagNode cftag) {
        String tagName = cftag.getTagName();
        if (tagName.toLowerCase().startsWith("cfx_") || !this.tc.isKnownTag(tagName) || tagName.equalsIgnoreCase("CFMODULE")) {
            return;
        }
        TagInfo tagInfo = this.tc.getTagInfo(cftag.getTagName());
        if (tagInfo instanceof JSTTagInfo) {
            return;
        }
        cftag.tagInfo = tagInfo;
        cftag.templateInfo = null;
        cftag.tagClass = cftag.getTagClass(tagInfo);
        if (FunctionGeneratorTag.class.isAssignableFrom(cftag.tagClass) && cftag.children != null) {
            ASTfunctionDefinition func = new ASTfunctionDefinition();
            func.setParser(cftag.parser);
            func.jjtSetParent(cftag);
            ASTparameterDefinition paramDefn = new ASTparameterDefinition(22);
            Token paramToken = new Token();
            paramToken.image = "attributes";
            paramToken.beginLine = cftag.getEndToken().endLine;
            paramToken.beginColumn = cftag.getEndToken().endColumn;
            paramToken.endLine = paramToken.beginLine;
            paramToken.endColumn = paramToken.beginColumn;
            paramDefn.addParameter(paramToken);
            paramDefn.setParser(cftag.parser);
            func.setParameterdefinition(paramDefn);
            Token token = new Token();
            String name = this.tc.getClassName().replace('.', '_');
            token.image = "_cffunc" + tagName + "_" + name + ++this.count;
            token.beginLine = cftag.getEndToken().endLine;
            token.beginColumn = cftag.getEndToken().endColumn;
            token.endLine = token.beginLine;
            token.endColumn = token.beginColumn;
            func.setName(token);
            int childrenLen = cftag.jjtGetNumChildren();
            Node[] newNodes = new Node[childrenLen + 1];
            newNodes[0] = paramDefn;
            if (cftag.children != null) {
                System.arraycopy(cftag.children, 0, newNodes, 1, childrenLen);
            }
            func.children = newNodes;
            for (int i = 0; i < func.children.length; ++i) {
                func.children[i].jjtSetParent(func);
            }
            cftag.children = new Node[]{func};
        }
    }

    private void cftag(TagNode cftag) {
        Object tagName = cftag.getTagName();
        if (((String)tagName).toLowerCase().startsWith("cfx_")) {
            cftag.setTagName("cfx");
            if (!((String)tagName).equalsIgnoreCase("cfx_j")) {
                cftag.putAttrNode("class", new ASTliteral(((String)tagName).substring(4), cftag));
            }
        } else if (!this.tc.isKnownTag((String)tagName)) {
            throw new TagInfoNotFoundException((String)tagName);
        }
        if (((String)tagName).equalsIgnoreCase("CFMODULE")) {
            try {
                ExprNode tagNameNode = cftag.getAttrNode("TEMPLATE");
                if (tagNameNode == null) {
                    tagNameNode = cftag.getAttrNode("NAME");
                }
                if (((String)(tagName = EvaluateEngine._String(tagNameNode))).length() > 4 && ((String)tagName).toUpperCase().endsWith(".CFM")) {
                    tagName = "CF_" + ((String)tagName).substring(0, ((String)tagName).length() - 4);
                }
            }
            catch (Exception tagNameNode) {
                // empty catch block
            }
        }
        TagInfo tagInfo = this.tc.getTagInfo(cftag.getTagName());
        this.validate(cftag, tagInfo);
        if (tagInfo instanceof JSTTagInfo) {
            cftag.templateInfo = (JSTTagInfo)tagInfo;
            cftag.tagInfo = this.tc.getTagInfo("cfmodule");
            String ttl = cftag.getTagName().toLowerCase();
            cftag.tagClass = ttl.startsWith("cf_") || ttl.startsWith("cfa_") ? CustomTag.class : ImportedTag.class;
        } else {
            cftag.tagInfo = tagInfo;
            cftag.templateInfo = null;
            cftag.tagClass = cftag.getTagClass(tagInfo);
            if (cftag.tagClass == null) {
                System.out.println("class null");
            }
        }
        cftag.tagCount = this.tc.getTagCount();
        cftag.tagVar = cftag.tagInfo.getTagName() + cftag.tagCount;
        cftag.slot = cftag.tagCount;
        if (cftag.getFunctionDef() != null) {
            cftag.slot = -1;
        }
        if (((String)tagName).equalsIgnoreCase("cfquery")) {
            cftag.setEscapeSingleQuotes(true);
        }
        if ((cftag.tagInfo.getBodyContent() != "empty" && cftag.isEmpty() || cftag.hasEndTag() || cftag.isCalledFromScript() && cftag.tagInfo.getBodyContent() != "empty" && (!cftag.getTagName().equalsIgnoreCase("cfmodule") || cftag.hasEndTag())) && !FunctionGeneratorTag.class.isAssignableFrom(cftag.tagClass) && !this.tagBodyprocessed(cftag)) {
            TagBodyNode tagbody = new TagBodyNode(cftag);
            tagbody.children = cftag.children;
            int childrenLen = tagbody.jjtGetNumChildren();
            for (int i = 0; i < childrenLen; ++i) {
                tagbody.children[i].jjtSetParent(tagbody);
            }
            cftag.children = new Node[]{tagbody};
        }
    }

    private void validate(TagNode cftag, TagInfo tagInfo) {
        String tagName = "cf" + tagInfo.getTagName();
        if (!CFMLTagLibrary.isCFTag(tagName) && !cftag.containsArgumentsAttr()) {
            TagData tagData = new TagData(cftag.attrMap);
            tagInfo.isValid(tagData);
        }
    }

    private Node transformCFPARAM(TagNode tag) {
        Node parent = tag.jjtGetParent();
        ASTfunctionDefinition enclosingFunction = tag.getFunctionDef();
        StatementNode result = tag;
        ExprNode typeExpr = tag.getAttrNode("TYPE");
        if (typeExpr == null && !(enclosingFunction instanceof ASTfunctionDefinition)) {
            ExprNode nameExpr = tag.getRequiredAttrNode("NAME");
            CanonicalStringifiedVariable cName = new CanonicalStringifiedVariable(nameExpr);
            if (cName.getSuccessStatus()) {
                String[] canonicalNameArray = cName.getCanonicalNames();
                if (canonicalNameArray.length == 1) {
                    String constantVarName = canonicalNameArray[0];
                    this.tc.declarePageVariable(constantVarName);
                    result = ASTtoolkit.statementLevelExpr(ASTtoolkit.builtin(parent, "checkSimpleParameter", new Node[]{this.pageVariableReference(parent, constantVarName), tag.getAttrNode("DEFAULT")}));
                } else if (canonicalNameArray.length == 2) {
                    String stem = canonicalNameArray[0];
                    String key = canonicalNameArray[1];
                    this.tc.declarePageVariable(stem);
                    result = ASTtoolkit.statementLevelExpr(ASTtoolkit.builtin(parent, "checkSimpleParameter", new Node[]{this.pageVariableReference(parent, stem), ASTtoolkit.literal(parent, key), ASTtoolkit.literal(parent, cName.getBaseString()), tag.getAttrNode("DEFAULT")}));
                }
            } else {
                result = ASTtoolkit.statementLevelExpr(ASTtoolkit.builtin(parent, "_checkParam", new Node[]{nameExpr, tag.getAttrNode("DEFAULT"), ASTtoolkit.pageInstanceExpr(parent, tag)}));
            }
        }
        return result;
    }

    private Node transformCFLOCK(TagNode tag) {
        TagNode result = tag;
        if (tag.getAttrNode("NAME") == null && tag.getAttrNode("SCOPE") == null) {
            tag.putAttrNode("GENERATEDLOCK", ASTtoolkit.staticObject(tag, LockManager.DEFAULT_LOCK_FAIRNESS_POLICY ? ReentrantFairnessLock.class : RWLock.class));
        }
        return result;
    }

    private Node transformCFDUMP(TagNode tag) {
        TagNode result = tag;
        ASTfunctionDefinition functionDef = tag.getFunctionDef();
        if (functionDef instanceof ASTcffunction) {
            ASTcffunction function = (ASTcffunction)functionDef;
            if (function.attrMap.get("output") != null && !function.output) {
                ExprNode outputAttr = tag.getAttrNode("output");
                boolean insideFunctionNode = true;
                if (outputAttr != null) {
                    try {
                        String value = EvaluateEngine._String(outputAttr);
                        if (!value.trim().isEmpty() && !value.equalsIgnoreCase("browser")) {
                            insideFunctionNode = false;
                        }
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
                if (insideFunctionNode) {
                    ASTliteral noOutput = new ASTliteral(Boolean.TRUE, tag);
                    tag.putAttrNode("insideFunctionNode", noOutput);
                }
            }
        }
        return result;
    }

    private ASTruntimeCall transformRuntimeCall(ASTruntimeCall call) {
        ASTruntimeCall result = call;
        Node parent = call.jjtGetParent();
        if (parent.getFunctionDef() == null && !call.isAssociativeArrayNotation() && call.getFunctionName().equalsIgnoreCase("IsDefined")) {
            Node[] callParams = call.getParameters().children;
            if (callParams != null && callParams.length == 1) {
                CanonicalStringifiedVariable cName;
                if (callParams[0] instanceof ASTtagAttribute) {
                    Node grandChildren;
                    String argName = ((ASTtagAttribute)call.arguments.children[0]).getName();
                    callParams[0] = grandChildren = call.arguments.children[0].getNamedAttribute(argName);
                }
                if ((cName = new CanonicalStringifiedVariable((ExprNode)callParams[0])).getSuccessStatus()) {
                    String[] nameArray = cName.getCanonicalNames();
                    switch (nameArray.length) {
                        case 1: {
                            result = ASTtoolkit.builtin(parent, "isDefinedCanonicalVariable", new Node[]{cName.baseVariableReference(parent)});
                            break;
                        }
                        case 2: {
                            result = ASTtoolkit.builtin(parent, "isDefinedCanonicalVariableAndKey", new Node[]{cName.baseVariableReference(parent), ASTtoolkit.literal(parent, nameArray[1]), ASTtoolkit.literal(parent, cName.getBaseString())});
                            break;
                        }
                        default: {
                            result = ASTtoolkit.builtin(parent, "isDefinedCanonicalName", new Node[]{ASTtoolkit.literal(parent, cName.getBaseString())});
                        }
                    }
                }
            }
        } else if (call.isBuiltin()) {
            call.setNamedAttribute("STEM", null);
        }
        return result;
    }

    private Node transformLiteral(ASTliteral literal) {
        ASTliteral result = literal;
        for (int i = 0; i < literal.tokens.size(); ++i) {
            Object o = literal.tokens.get(i);
            if (!(o instanceof Node)) continue;
            Node temp = Treewalker.postorder((Node)o, this);
            literal.tokens.setElementAt(temp, i);
        }
        return result;
    }

    private ExprNode pageVariableReference(Node parent, String varName) {
        this.tc.declarePageVariable(varName);
        InstanceFieldReference ref = new InstanceFieldReference(parent, varName);
        ref.setType(Variable.class);
        return ref;
    }

    private ASTcfscriptStatement createInitializerStatement(Node n, Node node, int childSequence, TagNode cftag, String attrName) {
        boolean isStatic = false;
        if (n.parser.supportStatic() && n.getNamedAttribute("LVAL") instanceof VariableReference) {
            isStatic = ((VariableReference)n.getNamedAttribute("LVAL")).isStatic();
        }
        String varName = IMPLICIT_ARRAY_STRUCT_VAR + this.tc.getImplicitArrayStructCount();
        Token varNameTok = Token.newToken(0);
        varNameTok.image = varName;
        ASTcfscriptStatement statement = new ASTcfscriptStatement(3);
        statement.insertedNode = true;
        statement.implicitArrayStructVarName = varName;
        statement.parser = n.parser;
        statement.setStatementType(3);
        statement.setStartToken(node.getStartToken());
        ASTsimpleVariableReference implictVar = new ASTsimpleVariableReference(varNameTok);
        implictVar.setImplicitVariable(true);
        statement.setNamedAttribute("LVAL", implictVar);
        statement.setNamedAttribute("RVAL", node);
        if (isStatic) {
            statement.markStatic();
        }
        statement = (ASTcfscriptStatement)ImplicitInitializerTransformer.pretransformInitializer(statement);
        if (n.id == 21) {
            ((ASTtagAttribute)n).setRuntimeValue(implictVar);
        } else if (n.id == 5) {
            n.setNamedAttribute("RVAL", implictVar);
        } else if (n.id == 28) {
            n.children[childSequence] = implictVar;
        } else if (n.id == 23) {
            ((ASTtagAttribute)((ASTcfargument)n).attrList.children[childSequence]).setRuntimeValue(implictVar);
            if (attrName != null) {
                ((ASTcfargument)n).putAttrNode(attrName, implictVar);
            }
        } else if (n.id == 3) {
            ASTcfscriptStatement cfscriptstmtNode = (ASTcfscriptStatement)n;
            if (cfscriptstmtNode.stmtType == 10) {
                cfscriptstmtNode.setNamedAttribute("COLLECTION", implictVar);
            }
        }
        if (cftag != null) {
            cftag.putAttrNode(attrName, implictVar);
        }
        return statement;
    }

    private ASTcfscriptStatement createInitializerStatementforColon(Node n, Node node, int childSequence) {
        boolean isStatic = false;
        if (n.parser.supportStatic() && n.getNamedAttribute("LVAL") instanceof VariableReference) {
            isStatic = ((VariableReference)n.getNamedAttribute("LVAL")).isStatic();
        }
        String varName = IMPLICIT_ARRAY_STRUCT_VAR + this.tc.getImplicitArrayStructCount();
        Token varNameTok = Token.newToken(0);
        varNameTok.image = varName;
        ASTcfscriptStatement statement = new ASTcfscriptStatement(3);
        statement.insertedNode = true;
        statement.implicitArrayStructVarName = varName;
        statement.parser = n.parser;
        statement.setStatementType(3);
        statement.setStartToken(node.getStartToken());
        ASTsimpleVariableReference implictVar = new ASTsimpleVariableReference(varNameTok);
        implictVar.setImplicitVariable(true);
        implictVar.parser = node.parser;
        statement.setNamedAttribute("LVAL", implictVar);
        statement.setNamedAttribute("RVAL", node);
        if (isStatic) {
            statement.markStatic();
        }
        statement = (ASTcfscriptStatement)ImplicitInitializerTransformer.pretransformInitializer(statement);
        n.children[childSequence] = implictVar;
        return statement;
    }

    private Node createInitializerStatementforAssignment(ASTcfscriptStatement n, Node parent, int childSequence) {
        ArrayStructInitializer rNode;
        boolean isStatic = false;
        if (n.parser.supportStatic() && n.getNamedAttribute("LVAL") instanceof VariableReference) {
            isStatic = ((VariableReference)n.getNamedAttribute("LVAL")).isStatic();
        }
        if ((rNode = (ArrayStructInitializer)n.getNamedAttribute("RVAL")).isSynthetic()) {
            rNode.setSynthetic(false);
            String varName = IMPLICIT_ARRAY_STRUCT_VAR + this.tc.getImplicitArrayStructCount();
            Token varNameTok = Token.newToken(0);
            varNameTok.image = varName;
            ASTcfscriptStatement statement = new ASTcfscriptStatement(3);
            statement.insertedNode = true;
            statement.implicitArrayStructVarName = varName;
            statement.parser = n.parser;
            statement.setStatementType(3);
            statement.setStartToken(n.getStartToken());
            ASTsimpleVariableReference implictVar = new ASTsimpleVariableReference(varNameTok);
            implictVar.setImplicitVariable(true);
            implictVar.parser = n.parser;
            statement.setNamedAttribute("LVAL", implictVar);
            statement.setNamedAttribute("RVAL", rNode);
            n.setNamedAttribute("RVAL", implictVar);
            parent.jjtInsertChild(statement, childSequence);
            if (isStatic) {
                statement.markStatic();
            }
            statement = (ASTcfscriptStatement)ImplicitInitializerTransformer.pretransformInitializer(statement);
            return statement;
        }
        ImplicitInitializerTransformer.pretransformInitializer(n);
        return n;
    }

    private void adjustInitializerStmtNode(Node n, ASTcfscriptStatement statement) {
        Node start = n;
        int sequence = 0;
        Node temp = start;
        while (start.jjtGetParent() != null && start.id != 1 && start.id != 11 && start.id != 4 && start.id != 18 && start.id != 43334) {
            if (start.id == 3) {
                ASTcfscriptStatement cfScript = (ASTcfscriptStatement)start;
                if ((cfScript.getStatementType() == 1 || cfScript.getStatementType() == 2 || cfScript.getStatementType() == 5 || cfScript.getStatementType() == 7 || cfScript.getStatementType() == 6 || cfScript.getStatementType() == 10) && this.checkConditionForInsertion(cfScript, temp)) {
                    start.jjtInsertChild(statement, sequence);
                    break;
                }
            } else if (start.id == 14 || start.id == 19 || start.id == 13 || start.id == 17 || start.id == 12) {
                start.jjtInsertChild(statement, sequence);
                break;
            }
            sequence = start.siblingSequence;
            temp = start;
            start = start.jjtGetParent();
        }
        if (start.id == 11) {
            if (temp instanceof ASTexprlist) {
                sequence = start.siblingSequence;
                start = start.jjtGetParent();
            }
            start.jjtInsertChild(statement, sequence);
        } else if (start.id == 1 || start.id == 4 || start.id == 25 || start.id == 18 && start.id != 43334) {
            start.jjtInsertChild(statement, sequence);
        }
        statement.jjtSetParent(start);
        statement.insertedNode = true;
        ++start.insertedNodeCount;
        Treewalker.postorder(statement, this);
    }

    private void adjustInitializerStmtNodeTagAttr(Node n, ASTcfscriptStatement statement) {
        boolean insertedNode = false;
        Node start = n;
        int sequence = 0;
        int sequence1 = 0;
        Node temp = start;
        while (start.jjtGetParent() != null && start.id != 1 && start.id != 11 && start.id != 4 && start.id != 18) {
            ASTcfscriptStatement cfScript;
            if (start.id == 3 && ((cfScript = (ASTcfscriptStatement)start).getStatementType() == 1 || cfScript.getStatementType() == 2 || cfScript.getStatementType() == 5 || cfScript.getStatementType() == 7 || cfScript.getStatementType() == 6 || cfScript.getStatementType() == 10) && this.checkConditionForInsertion(cfScript, temp)) {
                if (temp.getStartToken().image.equalsIgnoreCase("cfelseif")) {
                    while (!temp.getStartToken().image.equalsIgnoreCase("cfif")) {
                        temp = temp.jjtGetParent();
                    }
                    sequence1 = temp.siblingSequence;
                    start = temp.jjtGetParent();
                }
                start.jjtInsertChild(statement, sequence1);
                insertedNode = true;
                if (cfScript.getStatementType() != 1) break;
                ++start.insertedNodeCount;
                break;
            }
            sequence1 = start.siblingSequence;
            temp = start;
            start = start.jjtGetParent();
            sequence = start.siblingSequence;
        }
        if (start.id == 1 || start.id == 11) {
            if (temp != null && temp instanceof ASTevalcfoutput) {
                start.jjtInsertChild(statement, sequence1);
                statement.jjtSetParent(start.jjtGetParent());
            } else if (!insertedNode && start.jjtGetParent() != null) {
                start.jjtGetParent().jjtInsertChild(statement, sequence);
                statement.jjtSetParent(start.jjtGetParent());
            }
        } else if (!(insertedNode || start.id != 4 && start.id != 25 && start.id != 18)) {
            start.jjtInsertChild(statement, sequence1);
            statement.jjtSetParent(start);
        }
        statement.insertedNode = true;
        Treewalker.postorder(statement, this);
    }

    private void adjustInitializerStmtNodeFuncParams(Node n, ASTcfscriptStatement statement) {
        Node start = n;
        int sequence = 0;
        int sequence1 = 0;
        Node temp = start;
        boolean nodeInserted = false;
        while (start.jjtGetParent() != null && start.id != 1 && start.id != 11 && start.id != 12 && start.id != 14 && start.id != 13 && start.id != 4 && start.id != 18 && start.id != 43334 && start.id != 101 && !SemanticAnalyzer.isRightChildOfAndOrOperator(start, temp)) {
            ASTcfscriptStatement cfScript;
            if (start.id == 3 && ((cfScript = (ASTcfscriptStatement)start).getStatementType() == 1 || cfScript.getStatementType() == 2 || cfScript.getStatementType() == 5 || cfScript.getStatementType() == 7 || cfScript.getStatementType() == 6 || cfScript.getStatementType() == 10) && this.checkConditionForInsertion(cfScript, temp)) {
                if (temp.getStartToken().image.equalsIgnoreCase("cfelseif")) {
                    nodeInserted = true;
                    while (!temp.getStartToken().image.equalsIgnoreCase("cfif")) {
                        temp = temp.jjtGetParent();
                    }
                    sequence1 = temp.siblingSequence;
                    start = temp.jjtGetParent();
                    start.jjtInsertChild(statement, sequence1);
                    break;
                }
                start.jjtInsertChild(statement, sequence);
                break;
            }
            sequence = start.siblingSequence;
            temp = start;
            start = start.jjtGetParent();
            sequence1 = start.siblingSequence;
        }
        boolean setParent = true;
        if (start.id == 1 || start.id == 12 || start.id == 14 || start.id == 13) {
            if (start.children != null && start.jjtGetChild((int)sequence).id == 8) {
                start.jjtInsertChild(statement, sequence);
                statement.jjtSetParent(start);
                ++start.insertedNodeCount;
            } else if (statement.getStatementType() == 11 && temp instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)temp).getStatementType() == 2) {
                int insertPos = temp.siblingSequence;
                statement.jjtSetParent(start);
                start.jjtInsertChild(statement, insertPos);
                ++start.insertedNodeCount;
            } else if (start.jjtGetParent() != null) {
                Node node = start.jjtGetParent();
                if (start instanceof ASTcfcatch) {
                    node = start;
                }
                node.jjtInsertChild(statement, sequence1);
                statement.jjtSetParent(node);
                ++node.insertedNodeCount;
            }
            setParent = false;
        } else if (start.id == 11) {
            if (temp instanceof ASTexprlist) {
                sequence = start.siblingSequence;
                start = start.jjtGetParent();
            }
            start.jjtInsertChild(statement, sequence);
        } else if (!(nodeInserted || start.id != 216 && start.id != 217)) {
            start.setNamedAttribute("INITIALIZERSTMT", statement);
        } else if (!nodeInserted && (start.id == 4 || start.id == 25 || start.id == 18 || start.id == 101 && start.id != 43334)) {
            start.jjtInsertChild(statement, sequence);
        }
        if (setParent) {
            statement.jjtSetParent(start);
            ++start.insertedNodeCount;
        }
        statement.insertedNode = true;
        Treewalker.postorder(statement, this);
    }

    private static boolean isRightChildOfAndOrOperator(Node start, Node temp) {
        return (start.id == 216 || start.id == 217) && start.jjtGetChild(1) == temp;
    }

    private boolean checkConditionForInsertion(ASTcfscriptStatement cfScript, Node temp) {
        if (cfScript.getStatementType() == 2 && cfScript.getExpression("PREDICATE") == temp) {
            return false;
        }
        if ((cfScript.getStatementType() == 5 || cfScript.getStatementType() == 7 || cfScript.getStatementType() == 6) && cfScript.getExpression("TEST") == temp) {
            return false;
        }
        return cfScript.getStatementType() != 10 || cfScript.getNamedAttribute("COLLECTION") != temp && cfScript != temp;
    }

    private boolean tagBodyprocessed(TagNode cftag) {
        Node[] children = cftag.children;
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof TagBodyNode)) continue;
                return true;
            }
        }
        return false;
    }

    public static class InvalidRuntimeCallAsLvarException
    extends ParseException {
        InvalidRuntimeCallAsLvarException(Token t) {
            super(t);
        }
    }

    public static class InvalidTryCatchFinallyException
    extends ParseException {
        public String prefix;

        InvalidTryCatchFinallyException(Token t, String prefix) {
            super(t);
            this.prefix = prefix;
        }
    }

    public static class IllegallyNestedFunctionException
    extends ParseException {
        public String funcName;
        Token enclosingFunc;

        IllegallyNestedFunctionException(Token funcToken, Token enclosingFunc) {
            super(funcToken);
            this.funcName = funcToken.image;
            this.enclosingFunc = enclosingFunc;
        }

        public int getEnclosingLine() {
            return this.enclosingFunc.beginLine;
        }

        public int getEnclosingColumn() {
            return this.enclosingFunc.beginColumn;
        }

        public String getEnclosingFuncName() {
            return this.enclosingFunc.image;
        }
    }

    private class CanonicalStringifiedVariable {
        private boolean successful;
        private String baseString;
        private String[] canonicalNames;

        CanonicalStringifiedVariable(ExprNode n) {
            try {
                this.baseString = EvaluateEngine._String(n).toUpperCase();
                if (CFMLParserBase.isValidSimpleIdentifier(this.baseString)) {
                    this.successful = true;
                    this.canonicalNames = new String[1];
                    this.canonicalNames[0] = this.baseString;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(this.baseString, ".");
                    this.canonicalNames = new String[tokenizer.countTokens()];
                    this.successful = true;
                    for (int i = 0; this.successful && i < this.canonicalNames.length; ++i) {
                        try {
                            String nextKey = tokenizer.nextToken();
                            if (CFMLParserBase.isValidSimpleIdentifier(nextKey)) {
                                this.canonicalNames[i] = nextKey;
                                continue;
                            }
                            this.successful = false;
                            continue;
                        }
                        catch (Exception tokenizerProblem) {
                            this.successful = false;
                        }
                    }
                }
            }
            catch (Exception notConstantStringExpr) {
                this.successful = false;
            }
        }

        String getBaseString() {
            return this.baseString;
        }

        boolean getSuccessStatus() {
            return this.successful;
        }

        String[] getCanonicalNames() {
            return this.canonicalNames;
        }

        ExprNode baseVariableReference(Node parent) {
            String varName = this.canonicalNames[0];
            if (parent.getFunctionDef() == null) {
                return SemanticAnalyzer.this.pageVariableReference(parent, varName);
            }
            return ASTtoolkit.literal(parent, varName);
        }
    }

    public static class ReentrantFairnessLock
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;

        public ReentrantFairnessLock() {
            super(true);
        }
    }
}

