/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfloop;
import coldfusion.compiler.ASTcfscript;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.LabelNotFoundException;
import coldfusion.compiler.Node;
import coldfusion.compiler.Token;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import java.util.Vector;

abstract class StatementNode
extends Node {
    Vector continueLabels;
    Vector breakLabels;
    Vector finallyLabels;
    Vector caseLabels;
    boolean hasFinally;
    int whiteSpaceSetting = 1;
    String asyncLoopName = null;
    static final int WHITESPACE_DEFAULT = 1;
    static final int WHITESPACE_SUPPRESS_IMMEDIATE_CHILD = 2;
    static final int WHITESPACE_EMIT = 7;

    StatementNode(int id) {
        super(id);
    }

    void addContinueLabel(Object label) {
        if (this.continueLabels == null) {
            this.continueLabels = new Vector();
        }
        this.continueLabels.add(label);
    }

    void addBreak(Object label) {
        if (this.breakLabels == null) {
            this.breakLabels = new Vector();
        }
        if (label == null) {
            throw new NullPointerException();
        }
        this.breakLabels.add(label);
    }

    void addCaseLabel(Object label, Object value) {
        if (this.caseLabels == null) {
            this.caseLabels = new Vector();
        }
        this.caseLabels.add(label);
        this.caseLabels.add(value);
    }

    void addFinally(Object label) {
        if (this.finallyLabels == null) {
            this.finallyLabels = new Vector();
        }
        this.finallyLabels.add(label);
    }

    final void setWhitespaceSuppression(int setting) {
        this.whiteSpaceSetting = setting;
    }

    int getWhitespaceManagementSetting() {
        int result;
        Node n = this.jjtGetParent();
        int n2 = result = n instanceof StatementNode ? ((StatementNode)n).whiteSpaceSetting : 1;
        while (n != null && result == 1) {
            int wsSetting;
            if (!((n = n.jjtGetParent()) instanceof StatementNode) || (wsSetting = ((StatementNode)n).whiteSpaceSetting) == 2) continue;
            result = wsSetting;
        }
        return result;
    }

    StatementNode getEnclosingStatement() {
        boolean isContinue = this.id == 3 && ((ASTcfscriptStatement)this).getStatementType() == 9;
        boolean isScript = this.isCFScript();
        String label = "";
        for (Node n = this.jjtGetParent(); n != null; n = n.jjtGetParent()) {
            if (n instanceof ASTcfswitch && !isContinue) {
                if (!isScript) continue;
                return (StatementNode)n;
            }
            if (n instanceof ASTcfscriptStatement) {
                if (this instanceof ASTcfscriptStatement) {
                    label = ((ASTcfscriptStatement)this).getLabel();
                } else if (this.getLabel() != null) {
                    label = this.getLabel().toString();
                }
                if (label != null && !label.isEmpty()) {
                    while (!(n instanceof ASTcfscript)) {
                        if (n instanceof ASTcfloop && n.getLabel() != null) {
                            if (label.equalsIgnoreCase(n.getLabel().toString())) break;
                            n = n.jjtGetParent();
                            continue;
                        }
                        if (n instanceof ASTcfscriptStatement && label.equalsIgnoreCase(((ASTcfscriptStatement)n).getLabel())) break;
                        n = n.jjtGetParent();
                    }
                    if (!(n instanceof ASTcfscript)) {
                        return (StatementNode)n;
                    }
                    throw new LabelNotFoundException(label);
                }
                switch (((ASTcfscriptStatement)n).getStatementType()) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: {
                        return (StatementNode)n;
                    }
                }
                continue;
            }
            if (n instanceof ASTcfloop) {
                if (this.getLabel() != null) {
                    label = this.getLabel().toString();
                }
                if (label != null && !label.isEmpty()) {
                    while (n != null && !label.equalsIgnoreCase(n.getLabel().toString())) {
                        n = n.jjtGetParent();
                    }
                }
                return (StatementNode)n;
            }
            if (!(n instanceof ASTcfscript) && !(n instanceof ASTfunctionDefinition)) continue;
            return (StatementNode)n;
        }
        throw new IllegalStateException("no enclosing statement for this node " + this + " line " + this.getStartToken().beginLine);
    }

    static Token extractToken(ExprNode node, Token tagName, String attributeName) {
        try {
            return StatementNode.extractToken(node);
        }
        catch (IllegalAttributeValueException illegalattrexcep) {
            illegalattrexcep.tagName = tagName == null ? "" : tagName.image.toUpperCase();
            illegalattrexcep.attribute = attributeName.toUpperCase();
            illegalattrexcep.detailMessage = " ";
            throw illegalattrexcep;
        }
    }

    static Token extractToken(ExprNode node, String tagName, String attributeName) {
        try {
            return StatementNode.extractToken(node);
        }
        catch (IllegalAttributeValueException illegalattrexcep) {
            illegalattrexcep.tagName = tagName == null ? "" : tagName.toUpperCase();
            illegalattrexcep.attribute = attributeName.toUpperCase();
            illegalattrexcep.detailMessage = " ";
            throw illegalattrexcep;
        }
    }

    static Token extractToken(ExprNode node) {
        String value = EvaluateEngine._String(node);
        Token t = node.getStartToken();
        do {
            if (!t.image.equalsIgnoreCase(value)) continue;
            return t;
        } while (t != node.getEndToken() && (t = t.next) != null);
        throw new IllegalAttributeValueException();
    }
}

