/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfbreak;
import coldfusion.compiler.ASTcfcase;
import coldfusion.compiler.ASTcfcatch;
import coldfusion.compiler.ASTcffinally;
import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfloop;
import coldfusion.compiler.ASTcfproperty;
import coldfusion.compiler.ASTcfrethrow;
import coldfusion.compiler.ASTcfscript;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.ASTcftry;
import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ASTtoolkit;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprAssembler;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.FactoredNodeAggregation;
import coldfusion.compiler.FunctionAssembler;
import coldfusion.compiler.MethodNotFoundException;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.Node;
import coldfusion.compiler.NonConstantExpressionException;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.RequiredAttributeException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.StaticFieldReference;
import coldfusion.compiler.TagAttributeNotFoundException;
import coldfusion.compiler.TagBodyNode;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.Closure;
import coldfusion.runtime.ImplementationUtil;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.StaticScope;
import coldfusion.runtime.SwitchTable;
import coldfusion.runtime.TransientVariableHolder;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.UDFMethodIterator;
import coldfusion.runtime.VariableScope;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.tagext.FunctionGeneratorTag;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.QueryLoop;
import coldfusion.tagext.io.OutputTag;
import coldfusion.tagext.lang.CustomTag;
import coldfusion.tagext.lang.ImportedTag;
import coldfusion.tagext.lang.ModuleTag;
import coldfusion.tagext.lang.ThrowTag;
import coldfusion.tagext.validation.CFMLTagLibrary;
import coldfusion.util.FastHashtable;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.IterationTag;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;

public class StmtAssembler
extends ExprAssembler {
    Object outVar;
    Object parentVar;
    static final Class WriterClass = Writer.class;
    static final Class JspWriterClass = JspWriter.class;
    static final Class TagClass = Tag.class;
    static final Class ModuleTagClass = ModuleTag.class;
    static final Class CustomTagClass = CustomTag.class;
    static final Class ImportedTagClass = ImportedTag.class;
    static final Class TryCatchFinallyClass = TryCatchFinally.class;
    static final Class BodyTagClass = BodyTag.class;
    static final Class IterationTagClass = IterationTag.class;
    static final Class VariableScopeClass = VariableScope.class;
    static final Class StaticScopeClass = StaticScope.class;
    static final Class LocalScopeClass = LocalScope.class;
    static final Class UDFMethodClass = UDFMethod.class;
    static final Class ClosureClass = Closure.class;
    static final Class NeoExceptionClass = NeoException.class;
    static final Class ExceptionClass = Exception.class;
    static final Class AbortExceptionClass = AbortException.class;
    static final Class SetClass = Set.class;
    static final Class FastHashtableClass = FastHashtable.class;
    static final Class PageContextClass = PageContext.class;
    static final Class NeoPageContextClass = NeoPageContext.class;
    static final Class StringTokenizerClass = StringTokenizer.class;
    static final Class SwitchTableClass = SwitchTable.class;
    static final Class TransientVariableHolderClass = TransientVariableHolder.class;
    static final Class DateClass = Date.class;
    static final Class GenericTagClass = GenericTag.class;
    static final Class ListClass = List.class;
    static final Class IntegerClass = Integer.class;
    static final Class udfMethodIteratorClass = UDFMethodIterator.class;
    static final String ENCODEFOR = "encodefor";
    static final String CANONICALIZE = "canonicalize";
    private static final Method writeSpace = StmtAssembler.getInstanceMethod(CfJspPageClass, "_whitespace", new Class[]{WriterClass, StringClass});
    private static final Method writeJavaBodyContent = StmtAssembler.getInstanceMethod(CfJspPageClass, "writeJavaBodyContent", new Class[]{WriterClass, StringClass});
    private static final Method write = StmtAssembler.getInstanceMethod(WriterClass, "write", new Class[]{StringClass});
    private static final Method keySet = StmtAssembler.getInstanceMethod(MapClass, "keySet", new Class[0]);
    private static final Method entrySet = StmtAssembler.getInstanceMethod(MapClass, "entrySet", new Class[0]);
    private static final Method getKey = StmtAssembler.getInstanceMethod(MapEntryClass, "getKey", new Class[0]);
    private static final Method iterator = StmtAssembler.getInstanceMethod(SetClass, "iterator", new Class[0]);
    private static final Method listIterator = StmtAssembler.getInstanceMethod(ListClass, "iterator", new Class[0]);
    private static final Method hasNext = StmtAssembler.getInstanceMethod(IteratorClass, "hasNext", new Class[0]);
    private static final Method getNext = StmtAssembler.getInstanceMethod(IteratorClass, "next", new Class[0]);
    private static final Method size = StmtAssembler.getInstanceMethod(ListClass, "size", new Class[0]);
    private static final Method getAt = StmtAssembler.getInstanceMethod(ListClass, "get", new Class[]{intClass});
    private static final Method prepareCondition = StmtAssembler.getStaticMethod(CFPageClass, "prepareCondition", new Class[]{StringClass});
    private static final Method evaluateCondition = StmtAssembler.getInstanceMethod(CFPageClass, "evaluateCondition", new Class[]{ObjectClass});
    private static final Method getRowVector = StmtAssembler.getInstanceMethod(QueryTableClass, "getRowVector", new Class[0]);
    private static final Method getColumnList = StmtAssembler.getInstanceMethod(QueryTableClass, "getColumnList", new Class[0]);
    private static final Method getQueryMetaData = StmtAssembler.getInstanceMethod(QueryTableClass, "getMetaData", new Class[0]);
    private static final Method incrementCurrentRowCountRelatively = StmtAssembler.getInstanceMethod(QueryTableClass, "relative", new Class[]{intClass});
    private static final Method resetRowCountForQuery = StmtAssembler.getInstanceMethod(QueryTableClass, "absolute", new Class[]{intClass});
    private static final Method queryRowDataToStruct = StmtAssembler.getStaticMethod(CfJspPageClass, "_queryRowDataToStruct", new Class[]{ObjectClass, StringArrayClass, ObjectClass});
    private static final Method checkRequestTimeout = StmtAssembler.getStaticMethod(CfJspPageClass, "checkRequestTimeout", new Class[]{StringClass});
    private static final Method unwrap = StmtAssembler.getStaticMethod(NeoExceptionClass, "unwrap", new Class[]{ThrowableClass});
    private static final Method findThrowableTarget = StmtAssembler.getStaticMethod(NeoExceptionClass, "findThrowableTarget", new Class[]{ThrowableClass, StringArrayClass});
    protected static final Method caseValue = StmtAssembler.getStaticMethod(CfJspPageClass, "__caseValue", new Class[]{FastHashtableClass, ObjectClass});
    private static final Method initTag = StmtAssembler.getInstanceMethod(CfJspPageClass, "_initTag", new Class[]{ClassClass, intClass, TagClass});
    private static final Method importedTagSetName = StmtAssembler.getInstanceMethod(ImportedTagClass, "setName", new Class[]{StringClass, StringClass, StringClass, booleanClass});
    private static final Method customTagSetName = StmtAssembler.getInstanceMethod(CustomTagClass, "setName", new Class[]{StringClass, StringClass});
    private static final Method setDeferattributeprocessing = StmtAssembler.getInstanceMethod(QueryLoop.class, "setDeferattributeprocessing", new Class[]{booleanClass});
    private static Method processAttributes = null;
    private static final Method validateTagAttrConfiguration;
    private static final Method hasEndTag;
    private static final Method setCalledName;
    private static final Method emptyTag;
    private static final Method emptyTcfTag;
    private static final Method pushBody;
    private static final Method popBody;
    private static final Method setVariable;
    private static final Method checkCondition;
    private static final Method hasMoreTokens;
    private static final Method nextToken;
    private static final Method addDoubleCase;
    protected static final Method addStringCase;
    private static final Method _compare;
    private static final Method addDateCase;
    private static final Method tvhBind;
    private static final Method tvhUnbind;
    private static final Method validatingMap;
    private static final Method escapeSingleQuotes;
    private static final Method setArguments;
    private static final Method setExplicitAttrInAttrColl;
    private static final Method bindPageVariable;
    static final Method bindStaticVariable;
    private static final Method markStatic;
    static final Method getOut;
    static final Method getMetaData;
    static final Method setPageEncoding;
    static final Constructor newTransientVariableHolder;
    static final Constructor newAttributeCollectionMap;
    static final Constructor newStringTokenizer;
    static final Constructor newSwitchTable;
    static final Field pageContext;
    static final Field pageParent;
    private static final Method bindImportPath;
    private static final Method javarun;
    private static final Method listToArray;
    private static final Method objectAsList;
    private static final Method getClass;
    private static final Method isArray;
    static final Method encodeFor;
    static final Method iteratorForCFC;
    static final Constructor udfMethodIteratorConstructor;
    private static final HashMap attrValidators;
    private boolean processedCFOutPutTag;
    private boolean processedCFOutPutTagEarlier;
    private int skipWhiteSpaceOptimization;
    private static List<String> tagsToSkipWhiteSpaceOptimization;

    private static Method attrValidator(Class type) {
        Method m = (Method)attrValidators.get(type);
        if (m == null) {
            return (Method)attrValidators.get(ObjectClass);
        }
        return m;
    }

    private static void initProcessAttributes() {
        if (null != processAttributes) {
            return;
        }
        try {
            Class<?> cls = ServerlessUtil.isLambdaEnv() ? Class.forName("coldfusion.tagext.mail.MailTag", true, (ClassLoader)BootstrapClassLoader.instance()) : Class.forName("coldfusion.tagext.mail.MailTag");
            processAttributes = StmtAssembler.getInstanceMethod(cls, "processAttributes", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    Object block(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return this.label();
        }
        Object label = this.assembleStatement(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            this.assembleStatement(nodes[i]);
        }
        return label;
    }

    Object assembleStatement(Node node) {
        Object label = null;
        if (this.tc.staticSupport() && !this.tc.allowAllProcessing() && this.isStaticStatement(node) != this.tc.isProcessingStatic()) {
            return this.label();
        }
        if (this.processedCFOutPutTag && !(node instanceof ASTpcdata)) {
            this.processedCFOutPutTag = false;
        }
        if (node.id == 101) {
            TagNode cftag = (TagNode)node.jjtGetParent();
            if (cftag != null && tagsToSkipWhiteSpaceOptimization.contains(cftag.getTagName().toLowerCase())) {
                ++this.skipWhiteSpaceOptimization;
            }
        } else if (node.id == 3 && node.getStartToken() != null && node.getStartToken().image != null && node.getStartToken().image.equalsIgnoreCase("writeoutput")) {
            ++this.skipWhiteSpaceOptimization;
        }
        block0 : switch (node.id) {
            case 0: {
                label = this.pcdata((ASTpcdata)node, true);
                break;
            }
            case 4: {
                if (node instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)node).implicitArrayStructVarName != null) {
                    label = this.declareImplicitVar(node, ((ASTcfscriptStatement)node).implicitArrayStructVarName);
                }
                if (label == null) {
                    label = this.block(node.children);
                } else {
                    this.block(node.children);
                }
                Object end = this.label();
                this.patchBreaks((StatementNode)node, end);
                this.patchContinues((StatementNode)node, end);
                break;
            }
            case 3: {
                ASTcfscriptStatement cfscript = (ASTcfscriptStatement)node;
                switch (cfscript.getStatementType()) {
                    case 4: {
                        label = this.cast(cfscript.getExpression("EXPR"), voidClass);
                        break block0;
                    }
                    case 3: {
                        if (cfscript.children != null) {
                            label = this.block(cfscript.children);
                        }
                        Object temp = this.assignStatement(cfscript.getExpression("LVAL"), cfscript.getNode("RVAL"));
                        label = label == null ? temp : label;
                        break block0;
                    }
                    case 2: {
                        label = this.cfif(cfscript);
                        break block0;
                    }
                    case 7: {
                        label = this.cfdowhile(cfscript);
                        break block0;
                    }
                    case 6: {
                        label = this.cfwhile(cfscript);
                        break block0;
                    }
                    case 5: {
                        label = this.cffor(cfscript);
                        break block0;
                    }
                    case 9: {
                        label = this.cfcontinue(cfscript);
                        break block0;
                    }
                    case 10: {
                        label = this.cfforin(cfscript);
                        break block0;
                    }
                    case 20: {
                        if (cfscript.children == null) break block0;
                        label = this.block(cfscript.children);
                        break block0;
                    }
                    default: {
                        throw new CompilerInternalException(cfscript);
                    }
                }
            }
            case 5: {
                label = this.cfreturn((StatementNode)node);
                break;
            }
            case 9: {
                StatementNode cfbreak = (StatementNode)node;
                StatementNode enclosingStmt = cfbreak.getEnclosingStatement();
                if (enclosingStmt != null && enclosingStmt instanceof ASTcfscript && this.hasParentLoop(enclosingStmt)) {
                    enclosingStmt = enclosingStmt.getEnclosingStatement();
                }
                label = this.cfbreak(enclosingStmt, cfbreak);
                break;
            }
            case 10: {
                label = this.cfcontinue((StatementNode)node);
                break;
            }
            case 8: {
                label = this.cfoutputExpr(node);
                break;
            }
            case 11: {
                label = this.cfloop((ASTcfloop)node);
                break;
            }
            case 12: {
                label = this.cftry((ASTcftry)node);
                break;
            }
            case 15: {
                label = this.cfrethrow((ASTcfrethrow)node);
                break;
            }
            case 17: {
                label = this.cfswitch((ASTcfswitch)node);
                break;
            }
            case 19: {
                label = this.cfcase((ASTcfcase)node);
                break;
            }
            case 1: {
                label = this.cftag((TagNode)node);
                break;
            }
            case 16: {
                label = this.label();
                break;
            }
            case 101: {
                label = this.cftagbody((TagBodyNode)node);
                break;
            }
            case 100: {
                label = this.factoredNode((FactoredNodeAggregation)node);
                break;
            }
            default: {
                throw new CompilerInternalException((Object)("unsupported statement: " + node.getClass()));
            }
        }
        if (!(node instanceof ASTpcdata)) {
            int lineNum;
            Token startToken;
            boolean addLineNumber = true;
            if (node instanceof ASTcfscriptStatement && (startToken = node.getStartToken()) != null && startToken.image.equals("{")) {
                addLineNumber = false;
            }
            if (addLineNumber && label != null && (lineNum = node.getLine()) > 0) {
                this.addLineNumber(label, node.getLine());
            }
        }
        if (node.id == 101) {
            TagNode cftag = (TagNode)node.jjtGetParent();
            if (cftag != null && tagsToSkipWhiteSpaceOptimization.contains(cftag.getTagName().toLowerCase())) {
                if (cftag.getTagName().equalsIgnoreCase("cfoutput")) {
                    this.processedCFOutPutTag = true;
                    this.processedCFOutPutTagEarlier = true;
                }
                --this.skipWhiteSpaceOptimization;
            } else if (node.id == 3) {
                if (this.isStaticStatement(node) == this.tc.isProcessingStatic() && node.getStartToken() != null && node.getStartToken().image != null && node.getStartToken().image.equalsIgnoreCase("writeoutput")) {
                    this.processedCFOutPutTag = true;
                    this.processedCFOutPutTagEarlier = true;
                    --this.skipWhiteSpaceOptimization;
                }
            } else {
                this.processedCFOutPutTag = false;
            }
        }
        return label;
    }

    private boolean isStaticStatement(Node node) {
        return node.isStatic();
    }

    @Override
    Object assignStatement(ExprNode lval, Node rval) {
        if (rval instanceof ASTcffunction) {
            ASTcffunction rvalNode = (ASTcffunction)rval;
            switch (lval.id) {
                case 10002: {
                    return this.assignClosureToVar((ASTsimpleVariableReference)lval, rvalNode);
                }
                case 10000: {
                    return this.assignClosureToArray((ASTarrayReference)lval, rvalNode);
                }
                case 10003: {
                    return this.assignClosureToStruct((ASTstructureReference)lval, rvalNode);
                }
                case 202: {
                    return this.assignClosureToDynamicExpr((ASToperator)lval, rvalNode);
                }
            }
            throw new ParseException(lval.getStartToken());
        }
        return super.assignStatement(lval, rval);
    }

    private Object assignClosureToDynamicExpr(ExprNode lval, ASTcffunction rval) {
        ASTsimpleVariableReference varRef;
        if (lval instanceof ASTsimpleVariableReference && (varRef = (ASTsimpleVariableReference)lval).isStatic()) {
            return this.handleStaticClosures(rval, varRef.getCodegenVariableName());
        }
        Object label = this.load(this.pageVar);
        this.cast(lval, StringClass);
        String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
        this.newinstance(funcClassName);
        this.invokespecial(funcClassName, "<init>");
        this.invokeVoid(set);
        return label;
    }

    private Object assignClosureToVar(ExprNode lval, ASTcffunction rval) {
        ASTsimpleVariableReference varRef = (ASTsimpleVariableReference)lval;
        if (varRef.isStatic()) {
            return this.handleStaticClosures(rval, varRef.getCodegenVariableName());
        }
        String varName = ((ASTsimpleVariableReference)lval).getVariableName().toUpperCase();
        Object label = this.load(this.pageVar);
        this.aconst(varName);
        String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
        this.newinstance(funcClassName);
        this.invokespecial(funcClassName, "<init>");
        this.invokeVoid(set);
        return label;
    }

    private Object handleStaticClosures(ASTcffunction rval, String varRef) {
        String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
        Object methodRef = this.getReferenceToClosure(funcClassName);
        Object label = this.assignNewClosureToRef(funcClassName, methodRef);
        this.getstatic(this.findField(varRef));
        this.load(methodRef);
        this.invoke(setVar);
        this.linkStaticScope(methodRef);
        return label;
    }

    private Object assignNewClosureToRef(String funcClassName, Object methodRef) {
        this.newinstance(funcClassName);
        Object label = this.invokespecial(funcClassName, "<init>");
        this.store(methodRef);
        return label;
    }

    private Object getReferenceToClosure(String funcClassName) {
        String methodStr = funcClassName + "Instance";
        Object methodRef = this.findLocal(methodStr);
        if (methodRef == null) {
            methodRef = this.createLocal(UDFMethodClass, methodStr);
            this.aconst(null);
            this.store(methodRef);
        }
        return methodRef;
    }

    private void linkStaticScope(Object udfRef) {
        Object o = this.findField(this.getStaticScopeVarName());
        if (o != null) {
            this.load(this.pageVar);
            this.load(udfRef);
            this.getstatic(o);
            this.invokeVoid(linkStaticScope);
        }
    }

    private Object assignClosureToArray(ASTarrayReference array, ASTcffunction rval) {
        if (array.getStem() instanceof ASTsimpleVariableReference) {
            Object label = this.load(this.pageVar);
            Method m = this.simpleref((ASTsimpleVariableReference)array.getStem(), arraySetString, arraySetVar);
            this.newarray(ObjectClass, array.indices.toArray());
            String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
            if (array.getStem().isStatic()) {
                this.handleStaticClosureToStructOrArray(m, funcClassName);
            } else {
                this.newinstance(funcClassName);
                this.invokespecial(funcClassName, "<init>");
                this.invokeVoid(m);
            }
            return label;
        }
        Object label = this.cast(array.getStem(), ObjectClass);
        this.newarray(ObjectClass, array.indices.toArray());
        String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
        this.newinstance(funcClassName);
        this.invokespecial(funcClassName, "<init>");
        this.invokeVoid(arraySetObject);
        return label;
    }

    public Object assignClosureToStruct(ASTstructureReference struct, ASTfunctionDefinition rval) {
        VariableReference stem = struct.getStem();
        if (stem instanceof ASTsimpleVariableReference) {
            Object label = this.load(this.pageVar);
            Method m = this.simpleref((ASTsimpleVariableReference)stem, structSetString, structSetVar);
            this.newarray(StringClass, struct.getStructureKeys());
            String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
            if (stem.isStatic()) {
                this.handleStaticClosureToStructOrArray(m, funcClassName);
            } else {
                this.newinstance(funcClassName);
                this.invokespecial(funcClassName, "<init>");
                this.invokeVoid(m);
            }
            return label;
        }
        Object label = this.load(this.pageVar);
        this.cast(stem, MapClass);
        this.newarray(StringClass, struct.getStructureKeys());
        String funcClassName = this.tc.getClassName() + "$func" + rval.getCodeGenName();
        this.newinstance(funcClassName);
        this.invokespecial(funcClassName, "<init>");
        this.invokeVoid(structSetObject);
        return label;
    }

    public void handleStaticClosureToStructOrArray(Method m, String funcClassName) {
        Object methodRef = this.getReferenceToClosure(funcClassName);
        this.assignNewClosureToRef(funcClassName, methodRef);
        this.load(methodRef);
        this.invoke(m);
        this.linkStaticScope(methodRef);
    }

    private Object cfoutputExpr(Node node) {
        Object label = this.load(this.outVar);
        ExprNode eval = (ExprNode)node.children[0];
        Boolean encode = null;
        if (this.isEncodeForRuntimeCall(eval).booleanValue() || (encode = this.encode(node, eval)) != null) {
            this.assembleExpr(eval);
        }
        if (encode == Boolean.TRUE) {
            this.invoke(encodeFor);
        }
        this.invokeVoid(write);
        return label;
    }

    protected Boolean isEncodeForRuntimeCall(ExprNode eval) {
        Node childNode;
        if (eval.children != null && eval.children.length > 0 && (childNode = eval.children[0]) instanceof ASTruntimeCall) {
            ASTruntimeCall functionCall = (ASTruntimeCall)childNode;
            return functionCall.isBuiltin() && functionCall.getFunctionName().toLowerCase().startsWith(ENCODEFOR);
        }
        return false;
    }

    private Boolean encode(Node node, ExprNode eval) {
        ASTcftag outputTag = null;
        do {
            if ((outputTag = StmtAssembler.getOutputTag(node)) != null && this.encodeForAttribute(outputTag, ENCODEFOR)) {
                return true;
            }
            node = outputTag;
        } while (outputTag != null);
        return false;
    }

    private static ASTcftag getOutputTag(Node node) {
        Node parent = node;
        while ((parent = parent.jjtGetParent()) != null) {
            if (!(parent instanceof ASTcftag)) continue;
            ASTcftag tag = (ASTcftag)parent;
            if (tag.tagClass != OutputTag.class) continue;
            return tag;
        }
        return null;
    }

    private boolean encodeForAttribute(ASTcftag outputTag, String attributeName) {
        ASTtagAttribute attribute = outputTag.getAttributeKeyNode(attributeName);
        if (attribute != null) {
            Node valueNode = attribute.getValueNode();
            if (valueNode instanceof ExprNode) {
                this.assembleExpr((ExprNode)valueNode);
                return true;
            }
        } else {
            Node valueNode;
            attribute = outputTag.getAttributeKeyNode("attributecollection");
            if (attribute != null && (valueNode = attribute.getValueNode()) instanceof ExprNode) {
                this.encodeFromAttributeCollection((ExprNode)valueNode, attributeName);
                return true;
            }
        }
        return false;
    }

    private Object encodeFromAttributeCollection(ExprNode valueNode, String member) {
        this.assembleExpr(valueNode);
        this.aconst(member);
        return this.invoke(mapGet);
    }

    @Override
    Object cast(ExprNode node, Class to) {
        ASTruntimeCall call;
        Object label = null;
        if (node.getExprInitializer() != null) {
            label = this.assembleStatement(node.getExprInitializer());
        }
        if (node.isIIFE()) {
            this.assembleStatement(node.jjtGetChild(0));
        }
        if (node instanceof ASTliteral && node.children != null && node.jjtGetChild(0) instanceof ASTruntimeCall && (call = (ASTruntimeCall)node.jjtGetChild(0)).isIIFE()) {
            label = this.assembleStatement(call.jjtGetChild(0));
        }
        if (label == null) {
            label = super.cast(node, to);
        } else {
            super.cast(node, to);
        }
        if (to == StringClass && node instanceof VariableReference) {
            VariableReference ref = (VariableReference)node;
            if (ref.isLeafReference && node.isEscapeSingleQuotes()) {
                this.invoke(escapeSingleQuotes);
            }
        }
        return label;
    }

    Object castObject(Object obj, Class from, Class to) {
        super.cast(from, to);
        if (obj instanceof ExprNode) {
            ExprNode node = (ExprNode)obj;
            if (to == StringClass && node instanceof VariableReference) {
                VariableReference ref = (VariableReference)node;
                if (ref.isLeafReference && node.isEscapeSingleQuotes()) {
                    this.invoke(escapeSingleQuotes);
                }
            }
        }
        return obj;
    }

    protected Object factoredNode(FactoredNodeAggregation factor) {
        Object method = this.createFactoredMethod(factor);
        Object label = this.load(this.pageVar);
        this.load(this.tagParentVar(factor));
        this.load(this.outVar);
        this.invokespecial(method);
        Object factorIf = this.ifacmpne(null, null);
        this.aconst(null);
        this.doReturn(factor);
        this.setTarget(factorIf, this.label());
        return label;
    }

    protected Object createFactoredMethod(FactoredNodeAggregation factor) {
        String parentVarName = factor.getParentVar();
        Object method = this.startMethod(factor.callSite, new Class[]{TagClass, JspWriterClass}, new String[]{parentVarName, "out"}, ObjectClass, 2);
        String oldMethod = this.setMethod(factor.callSite);
        Object oldValueVar = this.valueVar;
        Object oldParentVar = this.parentVar;
        Object oldOutVar = this.outVar;
        this.valueVar = this.createLocal(ObjectClass, "value");
        this.parentVar = this.findLocal(parentVarName);
        this.outVar = this.findLocal("out");
        this.block(factor.children);
        this.load(this.pageVar);
        this.areturn();
        this.setMethod(oldMethod);
        this.valueVar = oldValueVar;
        this.parentVar = oldParentVar;
        this.outVar = oldOutVar;
        return method;
    }

    private Object cfreturn(StatementNode node) {
        Node rvalNode = node.getNamedAttribute("RVAL");
        if (rvalNode instanceof ASTcffunction) {
            ASTcffunction functionNode = (ASTcffunction)rvalNode;
            String funcClassName = this.tc.getClassName() + "$func" + functionNode.getCodeGenName();
            Object label = this.newinstance(funcClassName);
            this.invokespecial(funcClassName, "<init>");
            this.areturn();
            return label;
        }
        if (rvalNode instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)rvalNode).getNode("RVAL") instanceof ASToperator) {
            Object label = null;
            ASTcfscriptStatement childcfscript = (ASTcfscriptStatement)rvalNode;
            Object temp = this.assignStatement(childcfscript.getExpression("LVAL"), childcfscript.getNode("RVAL"));
            label = label == null ? temp : label;
            ExprNode lvalExpr = childcfscript.getExpression("LVAL");
            label = this.assembleExpr(lvalExpr);
            this.doReturn(node);
            return label;
        }
        ExprNode rvalExpr = (ExprNode)node.getNamedAttribute("RVAL");
        Object label = this.assembleExpr(rvalExpr);
        this.doReturn(node);
        return label;
    }

    protected void doReturn(StatementNode origin) {
        boolean hasFinally = false;
        boolean parentFinally = false;
        StatementNode target = origin;
        do {
            if (target.hasFinally && !parentFinally) {
                hasFinally = true;
            }
            if (parentFinally) {
                parentFinally = false;
            }
            if (!(target instanceof ASTcffinally)) continue;
            parentFinally = true;
        } while ((!(target instanceof ASTfunctionDefinition) && !(target instanceof ASTstart) && !(target instanceof FactoredNodeAggregation) || origin.equals(target)) && (target = (StatementNode)target.jjtGetParent()) != null);
        if (hasFinally) {
            Object tempVar = this.createLocal(ObjectClass);
            this.store(tempVar);
            this.doFinally(target, origin);
            this.load(tempVar);
            this.areturn();
        } else {
            this.areturn();
        }
    }

    protected Object tagParentVar(Node node) {
        ASTfunctionDefinition enclosingFunction = node.getFunctionDef();
        for (Node n = node.jjtGetParent(); n != enclosingFunction && n != null; n = n.jjtGetParent()) {
            if (n instanceof TagNode && ((TagNode)n).getTagVar() != null) {
                return this.findLocal(((TagNode)n).getTagVar());
            }
            if (!(n instanceof FactoredNodeAggregation)) continue;
            return this.parentVar;
        }
        return this.parentVar;
    }

    private Object cftag(TagNode cftag) {
        boolean isTryCatchFinally;
        Map distributedAttributes;
        boolean isAttrCollStructPresent = false;
        Class tagClass = cftag.tagClass;
        Object tagVar = this.createLocal(tagClass, cftag.tagVar);
        Object initLabel = this.load(this.pageVar);
        this.aconst(tagClass);
        this.iconst(cftag.slot);
        this.load(this.tagParentVar(cftag));
        this.invoke(initTag);
        this.cast(initTag.getReturnType(), tagClass);
        this.store(tagVar);
        if (cftag.isStatic) {
            this.load(tagVar);
            this.invoke(markStatic);
        }
        if (GenericTagClass.isAssignableFrom(tagClass)) {
            this.generateLineNo(cftag.getLine());
        }
        if (cftag instanceof ASTcftag && ((ASTcftag)cftag).getCalledName() != null) {
            this.load(tagVar);
            this.aconst(((ASTcftag)cftag).getCalledName());
            this.invokeVoid(setCalledName);
        }
        if ((distributedAttributes = cftag.distributeAttributes()) != null) {
            this.load(tagVar);
            this.zconst(true);
            this.invokeVoid(setDeferattributeprocessing);
        } else {
            this.emitSwitchAttrValidation(cftag);
        }
        isAttrCollStructPresent = this.isAttributeCollectionGeneric(cftag);
        Vector coll = this.setAttributes(cftag, tagVar, isAttrCollStructPresent);
        ExprNode valNode = cftag.getAttrNode("attributecollection");
        if (valNode != null && isAttrCollStructPresent) {
            this.setArguments(cftag, valNode, "attributecollection", tagVar, !cftag.isDistributedTag());
        }
        this.setAttributeCollection(cftag, coll, tagVar);
        if (GenericTagClass.isAssignableFrom(tagClass)) {
            this.load(tagVar);
            if (cftag.isCalledFromScript() && cftag.tagInfo.getBodyContent() != "empty") {
                if (cftag.getTagName().equalsIgnoreCase("cfcache")) {
                    if (cftag.children != null) {
                        Node child = cftag.children[0];
                        if (child.children == null) {
                            this.zconst(false);
                        } else {
                            this.zconst(true);
                        }
                    } else {
                        this.zconst(false);
                    }
                } else if (!cftag.getTagName().equalsIgnoreCase("cfmodule") || cftag.hasEndTag()) {
                    this.zconst(true);
                } else {
                    this.zconst(false);
                }
            } else {
                this.zconst(cftag.hasEndTag() || cftag.isEmpty());
            }
            this.invokeVoid(hasEndTag);
        }
        boolean bl = isTryCatchFinally = TryCatchFinallyClass.isAssignableFrom(tagClass) && tagClass != ThrowTag.class;
        if (cftag.tagInfo.getBodyContent() != "empty" && cftag.isEmpty() || cftag.hasEndTag()) {
            if (isTryCatchFinally) {
                cftag.hasFinally = true;
            }
            Object modeVar = this.createLocal(intClass, "mode" + cftag.tagCount);
            Object tryLabel = this.load(tagVar);
            this.invoke(StmtAssembler.getInstanceMethod(tagClass, "doStartTag", new Class[0]));
            this.dup();
            this.store(modeVar);
            Object startIf = this.ificmpeq(0, null);
            if (FunctionGeneratorTag.class.isAssignableFrom(cftag.tagClass) && cftag.children != null) {
                ASTfunctionDefinition func = null;
                Node cftagChild = cftag.children[0];
                if (cftagChild instanceof FactoredNodeAggregation) {
                    func = this.getASTFunctionDefinitionNode((FactoredNodeAggregation)cftagChild);
                } else if (cftagChild instanceof ASTfunctionDefinition) {
                    func = (ASTfunctionDefinition)cftagChild;
                }
                if (func != null) {
                    String funcName = func.getNameToken().image;
                    this.load(tagVar);
                    this.aconst(funcName);
                    this.invokeVoid(StmtAssembler.getInstanceMethod(tagClass, "setFunctionName", new Class[]{String.class}));
                    cftag.children = new Node[0];
                }
            }
            this.block(cftag.children);
            this.setTarget(startIf, this.label());
            this.load(tagVar);
            this.invoke(StmtAssembler.getInstanceMethod(tagClass, "doEndTag", new Class[0]));
            Object endIf = this.ificmpne(5, null);
            this.aconst(null);
            this.doReturn(cftag);
            this.setTarget(endIf, this.label());
            if (isTryCatchFinally) {
                cftag.addFinally(this.jsr(null));
                Object endLabel2 = this.jmp(null);
                cftag.addBreak(endLabel2);
                Object catchExVar = this.createLocal(ThrowableClass);
                Object catchExLbl = this.store(catchExVar);
                this.load(tagVar);
                this.load(catchExVar);
                this.invokeVoid(StmtAssembler.getInstanceMethod(tagClass, "doCatch", new Class[]{ThrowableClass}));
                cftag.addFinally(this.jsr(null));
                Object catchEnd = this.jmp(null);
                cftag.addBreak(catchEnd);
                Object finallyExVar = this.createLocal(ThrowableClass);
                Object finallyExVarbl = this.store(finallyExVar);
                Object finallyEnd = this.jsr(null);
                cftag.addFinally(finallyEnd);
                this.load(finallyExVar);
                this.athrow();
                Object returnAddr = this.createLocal(ObjectClass);
                Object finallyLabel = this.store(returnAddr);
                this.load(tagVar);
                this.invokeVoid(StmtAssembler.getInstanceMethod(tagClass, "doFinally", new Class[0]));
                this.ret(returnAddr);
                this.patchFinally(cftag, finallyLabel);
                Object jmpLabel = this.label();
                this.patchBreaks(cftag, jmpLabel);
                this.addExceptionHandlers(tryLabel, endLabel2, ThrowableClass, catchExLbl, jmpLabel);
                this.addExceptionHandlers(tryLabel, finallyEnd, ThrowableClass, finallyExVarbl, jmpLabel);
            }
        } else {
            this.load(tagVar);
            this.invoke(isTryCatchFinally ? emptyTcfTag : emptyTag);
            Object emptyIf = this.ifeq(null);
            this.aconst(null);
            this.doReturn(cftag);
            this.setTarget(emptyIf, this.label());
            this.patchBreaks(cftag, this.label());
        }
        return initLabel;
    }

    private ASTfunctionDefinition getASTFunctionDefinitionNode(FactoredNodeAggregation cftagChild) {
        Node child = cftagChild.children[0];
        while (child instanceof FactoredNodeAggregation) {
            child = child.children[0];
        }
        return (ASTfunctionDefinition)child;
    }

    private Object cftagbody(TagBodyNode tagbody) {
        Object label = this.label();
        TagNode cftag = (TagNode)tagbody.jjtGetParent();
        boolean isAttrCollStructPresent = this.isAttributeCollectionGeneric(cftag);
        Class tagClass = cftag.tagClass;
        boolean isBodyTag = BodyTagClass.isAssignableFrom(tagClass);
        boolean isIterationTag = isBodyTag | IterationTagClass.isAssignableFrom(tagClass);
        Object tagVar = this.findLocal(cftag.tagVar);
        Object modeVar = this.findLocal("mode" + cftag.tagCount);
        Map distributedAttributes = cftag.distributeAttributes();
        if (isBodyTag) {
            tagbody.hasFinally = true;
            this.load(this.pageVar);
            this.load(tagVar);
            this.load(modeVar);
            this.load(this.outVar);
            this.invoke(pushBody);
            this.store(this.outVar);
        }
        Object bodyLabel = this.label();
        if (distributedAttributes != null) {
            this.emitDistributedAttributes(cftag, distributedAttributes, tagVar, isAttrCollStructPresent);
            ExprNode valNode = cftag.getAttrNode("attributecollection");
            if (valNode != null && isAttrCollStructPresent) {
                this.setArguments(cftag, valNode, "attributecollection", tagVar, true);
            }
            this.load(tagVar);
            StmtAssembler.initProcessAttributes();
            this.invokeVoid(processAttributes);
            this.emitSwitchAttrValidation(cftag);
        }
        if (cftag.hasEndTag()) {
            this.block(tagbody.children);
        }
        if (isIterationTag) {
            Object lbl = this.load(tagVar);
            this.invoke(StmtAssembler.getInstanceMethod(tagClass, "doAfterBody", new Class[0]));
            this.ificmpne(0, bodyLabel);
            if (cftag instanceof ASTcfloop) {
                this.patchContinues(cftag, lbl);
            }
        }
        if (isBodyTag) {
            tagbody.addFinally(this.jsr(null));
            Object endLabel2 = this.jmp(null);
            tagbody.addBreak(endLabel2);
            Object finallyEx = this.createLocal(ThrowableClass);
            Object finallyExbl = this.store(finallyEx);
            Object finallyEnd = this.jsr(null);
            tagbody.addFinally(finallyEnd);
            this.load(finallyEx);
            this.athrow();
            Object retAddr = this.createLocal(ObjectClass);
            Object finallyStart = this.store(retAddr);
            this.load(this.pageVar);
            this.load(modeVar);
            this.load(this.outVar);
            this.invoke(popBody);
            this.store(this.outVar);
            this.ret(retAddr);
            this.patchFinally(tagbody, finallyStart);
            Object jmpLabel = this.label();
            this.patchBreaks(tagbody, jmpLabel);
            this.addExceptionHandlers(label, finallyEnd, ThrowableClass, finallyExbl, jmpLabel);
        } else {
            this.patchBreaks(tagbody, this.label());
        }
        return label;
    }

    private Vector setAttributes(TagNode cftag, Object tagVar, boolean isAttrCollStructPresent) {
        if (cftag.templateInfo != null) {
            TagLibraryInfo lib = cftag.templateInfo.getTagLibrary();
            if (cftag.tagClass == ImportedTagClass) {
                this.load(tagVar);
                this.aconst(cftag.templateInfo.getTagName());
                this.aconst(lib == null ? null : lib.getURI());
                this.aconst(cftag.getPrefix());
                this.aconst(CFMLTagLibrary.isCFTag(cftag.getTagName()) ? Boolean.TRUE : Boolean.FALSE);
                this.invokeVoid(importedTagSetName);
            } else {
                this.load(tagVar);
                this.aconst(cftag.templateInfo.getTagName());
                this.aconst(lib == null ? null : lib.getURI());
                this.invokeVoid(customTagSetName);
            }
        }
        Vector<Object> coll = null;
        Enumeration e = cftag.getAttrNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            if (attrName.equalsIgnoreCase("attributecollection") || attrName.equalsIgnoreCase("attributecollection")) continue;
            ExprNode valNode = cftag.getAttrNode(attrName, "true");
            TagAttributeNotFoundException notFoundEx = null;
            boolean didSet = false;
            if (cftag.templateInfo == null) {
                try {
                    this.emitSetter(cftag, valNode, attrName, tagVar, isAttrCollStructPresent);
                    didSet = true;
                }
                catch (TagAttributeNotFoundException ex) {
                    notFoundEx = ex;
                }
            }
            if (didSet) continue;
            String tagName = "cf" + (cftag.templateInfo == null ? null : cftag.templateInfo.getTagName());
            Object localAttributeValue = null;
            if (CFMLTagLibrary.isCFTag(tagName) && cftag.tagClass == ImportedTag.class && !(valNode instanceof StaticFieldReference)) {
                Method validator = StmtAssembler.attrValidator(Object.class);
                this.cast(valNode, validator.getParameterTypes()[2]);
                localAttributeValue = this.createLocal(validator.getParameterTypes()[2]);
                this.store(localAttributeValue);
                this.aconst(cftag.getTagName());
                this.aconst(attrName);
                this.load(localAttributeValue);
                if (cftag instanceof ASTcftag) {
                    this.aconst(((ASTcftag)cftag).getCalledName());
                } else {
                    this.aconst(null);
                }
                this.invoke(validator);
                this.pop(validator.getReturnType());
            }
            try {
                cftag.getAttributeInfo(cftag.tagInfo, "attributecollection");
                if (coll == null) {
                    coll = new Vector<Object>();
                }
                coll.add(attrName);
                if (cftag.tagClass == CustomTagClass) {
                    ASTruntimeCall arrayAssign = ASTtoolkit.builtin(cftag, "_arrayAssign", new Node[]{valNode});
                    coll.add(arrayAssign);
                    continue;
                }
                if (localAttributeValue != null) {
                    coll.add(localAttributeValue);
                    continue;
                }
                coll.add(valNode);
            }
            catch (TagAttributeNotFoundException ex2) {
                throw notFoundEx != null ? notFoundEx : ex2;
            }
        }
        return coll;
    }

    private void setAttributeCollection(TagNode cftag, Vector coll, Object tagVar) {
        ExprNode attributeCollection = cftag.getAttrNode("attributecollection");
        if (coll != null) {
            Method setAttributecollection = StmtAssembler.getInstanceMethod(cftag.tagClass, "setAttributecollection", new Class[]{MapClass});
            if (attributeCollection != null) {
                this.load(tagVar);
                this.newinstance(AttributeCollectionClass);
                this.newarray(ObjectClass, coll.toArray());
                this.cast(attributeCollection, MapClass);
                this.invokespecial(newAttributeCollectionMap);
                this.invokeVoid(setAttributecollection);
            } else {
                this.load(tagVar);
                this.newinstance(AttributeCollectionClass);
                this.newarray(ObjectClass, coll.toArray());
                this.invokespecial(newAttributeCollection);
                this.invokeVoid(setAttributecollection);
            }
        } else if (attributeCollection != null) {
            try {
                if (cftag.tagClass != null && ModuleTag.class.isAssignableFrom(cftag.tagClass)) {
                    this.emitSetter(cftag, attributeCollection, "attributecollection", tagVar, false);
                }
            }
            catch (TagAttributeNotFoundException tagAttributeNotFoundException) {
                // empty catch block
            }
        }
    }

    private void emitSwitchAttrValidation(TagNode cftag) {
        if (cftag.runtimeValidation) {
            this.aconst(cftag.getTagName());
            this.cast(cftag.getAttrNode(cftag.switchAttrName), StringClass);
            this.aconst(cftag.switchAttrList);
            if (cftag instanceof ASTcftag) {
                this.aconst(((ASTcftag)cftag).getCalledName());
            } else {
                this.aconst(null);
            }
            this.invokeVoid(validateTagAttrConfiguration);
        }
    }

    private void patchFinally(StatementNode tryNode, Object finallyLabel) {
        if (tryNode.finallyLabels != null) {
            for (Object jsrInstruction : tryNode.finallyLabels) {
                this.setTarget(jsrInstruction, finallyLabel);
            }
        }
    }

    private Object emitSetter(TagNode cftag, ExprNode valNode, String attrName, Object tagVar, boolean isAttrCollStructPresent) {
        TagAttributeInfo info = cftag.getAttributeInfo(cftag.tagInfo, attrName);
        Class attrType = cftag.getAttributeClass(cftag.tagInfo, attrName, cftag.tagClass);
        Method setMethod = StmtAssembler.getInstanceMethod(cftag.tagClass, "set" + Character.toUpperCase(attrName.charAt(0)) + info.getName().substring(1), new Class[]{attrType});
        if (CFMLTagLibrary.isCFTag(cftag.getTagName()) && !(valNode instanceof StaticFieldReference)) {
            if (valNode instanceof ASTliteral && valNode.children == null) {
                String tagName = cftag.getTagName();
                Object value = ((ASTliteral)valNode).tokens.elementAt(0);
                Method validator = StmtAssembler.attrValidator(attrType);
                Object label = this.load(tagVar);
                Class<?> toClass = validator.getParameterTypes()[2];
                if (toClass.isPrimitive()) {
                    Object val = CfJspPage._validateTagAttrValue(tagName, attrName, Cast._cast(value, toClass), null);
                    this.aconst(val);
                } else {
                    this.cast(valNode, toClass);
                }
                this.invokeVoid(setMethod);
                this.setExplicitAttrInAttrColl(valNode, attrName, tagVar, isAttrCollStructPresent);
                return label;
            }
            Method validator = StmtAssembler.attrValidator(attrType);
            Object label = this.load(tagVar);
            this.aconst(cftag.getTagName());
            this.aconst(attrName);
            this.cast(valNode, validator.getParameterTypes()[2]);
            if (cftag instanceof ASTcftag) {
                this.aconst(((ASTcftag)cftag).getCalledName());
            } else {
                this.aconst(null);
            }
            this.invoke(validator);
            this.cast(validator.getReturnType(), attrType);
            this.invokeVoid(setMethod);
            this.setExplicitAttrInAttrColl(valNode, attrName, tagVar, isAttrCollStructPresent);
            return label;
        }
        Object label = this.load(tagVar);
        this.cast(valNode, attrType);
        this.invokeVoid(setMethod);
        this.setExplicitAttrInAttrColl(valNode, attrName, tagVar, isAttrCollStructPresent);
        return label;
    }

    private void emitDistributedAttributes(TagNode cftag, Map distributedAttrs, Object tagVar, boolean isAttrCollStructPresent) throws ParseException {
        Iterator attrNames = distributedAttrs.keySet().iterator();
        while (attrNames.hasNext()) {
            try {
                String attrName = attrNames.next().toString();
                ExprNode attrNode = (ExprNode)distributedAttrs.get(attrName);
                this.emitSetter(cftag, attrNode, attrName, tagVar, isAttrCollStructPresent);
            }
            catch (NoSuchElementException ex) {
                throw new CompilerInternalException((Object)ex);
            }
        }
    }

    private Object cfrethrow(ASTcfrethrow cfrethrow) {
        ASTcftry cftry = cfrethrow.getTryParent();
        Object exVar = this.findLocal(cftry.getThrowableName());
        Object l1 = this.load(exVar);
        this.athrow();
        return l1;
    }

    private Object cfbreak(StatementNode target, StatementNode origin) {
        Object label = this.doFinally(target, origin);
        target.addBreak(this.jmp(null));
        return label;
    }

    private Object doFinally(StatementNode target, StatementNode origin) {
        Object label = this.label();
        boolean parentFinally = false;
        StatementNode node = origin;
        while (true) {
            if (node == null) {
                throw new IllegalStateException("break target " + target + " is not a parent node of " + origin);
            }
            if (node.hasFinally && !parentFinally) {
                node.addFinally(this.jsr(null));
            }
            if (parentFinally) {
                parentFinally = false;
            }
            if (node instanceof ASTcffinally) {
                parentFinally = true;
            }
            if (node == target) {
                return label;
            }
            node = (StatementNode)node.jjtGetParent();
        }
    }

    private Object doFinallyforContinue(StatementNode target, StatementNode origin) {
        Object label = this.label();
        boolean parentFinally = false;
        StatementNode node = origin;
        while (true) {
            if (node == null) {
                throw new IllegalStateException("break target " + target + " is not a parent node of " + origin);
            }
            if (node == target) {
                return label;
            }
            if (node.hasFinally && !parentFinally) {
                node.addFinally(this.jsr(null));
            }
            if (parentFinally) {
                parentFinally = false;
            }
            if (node instanceof ASTcffinally) {
                parentFinally = true;
            }
            node = (StatementNode)node.jjtGetParent();
        }
    }

    private Object cfswitch(ASTcfswitch cfswitch) {
        List<Class> allowedClasses = Arrays.asList(ASToperator.class, ASTruntimeCall.class, ASTsimpleVariableReference.class, ASTarrayReference.class, ASTstructureReference.class);
        for (Node n : cfswitch.isCFSWITCH ? cfswitch.children : cfswitch.children[0].children) {
            if (!(n instanceof ASTcfcase) || ((ASTcfcase)n).getDynamicCaseValue() == null) continue;
            ExprNode expr = ((ASTcfcase)n).getDynamicCaseValue();
            if (allowedClasses.contains(expr.getClass())) {
                return this.dynamicSwitch(cfswitch);
            }
            if (!cfswitch.isCFSWITCH || !(((ASTliteral)expr).tokens.elementAt(0) instanceof ExprNode)) continue;
            return this.dynamicSwitch(cfswitch);
        }
        Object lookupTableField = this.createField(FastHashtableClass, cfswitch.lookupTableName, 26);
        Object label = this.getstatic(lookupTableField);
        this.cast(cfswitch.getSwitchexpression(), ObjectClass);
        this.invoke(caseValue);
        Object sw = this.tableswitch();
        cfswitch.setLookupTableField(lookupTableField);
        this.block(cfswitch.children);
        Object end = this.label();
        this.patchBreaks(cfswitch, end);
        this.patchCases(cfswitch, sw, end);
        this.initSwitchTable(cfswitch, lookupTableField);
        return label;
    }

    private Object dynamicSwitch(ASTcfswitch cfswitch) {
        Object label = this.label();
        cfswitch.setDynamic(true);
        Node[] children = cfswitch.isCFSWITCH ? cfswitch.children : cfswitch.children[0].children;
        int counter = 0;
        if (cfswitch.isCFSWITCH) {
            children = this.reorderDefaultSection(children, false);
            cfswitch.children = children;
        } else {
            children = this.reorderDefaultSection(children, true);
            cfswitch.children[0].children = children;
        }
        Object evaluatedExpr = this.createLocal(ObjectClass);
        this.cast(cfswitch.getSwitchexpression(), ObjectClass);
        this.store(evaluatedExpr);
        Object caseVal = this.createLocal(intClass);
        this.aconst(-1);
        this.store(caseVal);
        Object ifLabel = null;
        Object startLabel = null;
        Object elseLabel = null;
        for (int i = 0; i < children.length; ++i) {
            ASTcfcase caze;
            if (!(children[i] instanceof ASTcfcase)) continue;
            if (ifLabel != null) {
                this.setTarget(ifLabel, this.label());
            }
            if (!this.isDefaultNode(caze = (ASTcfcase)children[i])) {
                this.cast(caze.getDynamicCaseValue(), ObjectClass);
                this.load(evaluatedExpr);
                this.invoke(_compare);
            } else {
                if (cfswitch.isDefaultCase()) {
                    throw new ASTcfswitch.DuplicateDefaultCaseException();
                }
                cfswitch.setDefaultCase(true);
                this.aconst(0.0);
            }
            this.aconst(0.0);
            this.dcmpl();
            ifLabel = this.ifne(null);
            if (startLabel == null) {
                startLabel = ifLabel;
            }
            this.aconst(counter++);
            this.store(caseVal);
            if (elseLabel == null) {
                elseLabel = this.jmp(null);
                continue;
            }
            this.jmp(elseLabel);
        }
        Object end = this.label();
        this.setTarget(ifLabel, end);
        this.setTarget(elseLabel, end);
        this.aconst(caseVal);
        Object sw = this.tableswitch();
        this.block(cfswitch.children);
        end = this.label();
        this.patchBreaks(cfswitch, end);
        this.patchCases(cfswitch, sw, end);
        return label;
    }

    private boolean isDefaultNode(ASTcfcase caze) {
        return caze.isCfcase && caze.getTagName().equals("cfdefaultcase") || !caze.isCfcase && caze.getStartToken().image.equals("default");
    }

    private Node[] reorderDefaultSection(Node[] children, boolean isBreakAllowed) {
        ArrayList<Node> finalCaseList = new ArrayList<Node>();
        ArrayList<Node> defaultCaseBlock = new ArrayList<Node>();
        ArrayList<Node> currCaseBlock = new ArrayList<Node>();
        boolean defaultFound = false;
        for (int i = 0; i < children.length; ++i) {
            Node currentNode = children[i];
            if (currentNode instanceof ASTcfcase) {
                if (!currCaseBlock.isEmpty()) {
                    if (defaultFound) {
                        if (!isBreakAllowed) {
                            defaultCaseBlock.addAll(currCaseBlock);
                            defaultFound = false;
                        } else {
                            this.updateDefaultAndFinalCaseList(finalCaseList, defaultCaseBlock, currCaseBlock);
                        }
                    } else {
                        finalCaseList.addAll(currCaseBlock);
                    }
                    currCaseBlock.clear();
                }
                if (this.isDefaultNode((ASTcfcase)currentNode)) {
                    defaultFound = true;
                }
            }
            currCaseBlock.add(currentNode);
            if (!isBreakAllowed || !(currentNode instanceof ASTcfbreak)) continue;
            if (defaultFound) {
                if (!this.isDefaultNode((ASTcfcase)currCaseBlock.get(0))) {
                    this.copyAllNodesExceptFirst(defaultCaseBlock, currCaseBlock);
                    finalCaseList.addAll(currCaseBlock);
                } else {
                    defaultCaseBlock.addAll(currCaseBlock);
                    if (this.isPreviousCaseWithoutBreak(finalCaseList)) {
                        this.copyAllNodesExceptFirst(finalCaseList, currCaseBlock);
                    }
                }
                defaultFound = false;
            } else {
                finalCaseList.addAll(currCaseBlock);
            }
            currCaseBlock.clear();
        }
        if (!currCaseBlock.isEmpty()) {
            if (defaultFound && isBreakAllowed) {
                this.updateDefaultAndFinalCaseList(finalCaseList, defaultCaseBlock, currCaseBlock);
            } else {
                finalCaseList.addAll(currCaseBlock);
            }
        }
        Node lastNode = (Node)finalCaseList.get(finalCaseList.size() - 1);
        if (isBreakAllowed && !defaultCaseBlock.isEmpty() && !(lastNode instanceof ASTcfbreak)) {
            this.addDummyCFBreakNode(finalCaseList, defaultCaseBlock, lastNode);
        }
        finalCaseList.addAll(defaultCaseBlock);
        return finalCaseList.toArray(new Node[0]);
    }

    private void addDummyCFBreakNode(ArrayList<Node> finalCaseList, ArrayList<Node> defaultCaseBlock, Node lastNode) {
        ASTcfbreak cfbreak = new ASTcfbreak(9);
        Token beginToken = Token.newToken(77);
        beginToken.image = "break";
        beginToken.next = defaultCaseBlock.get(0).getStartToken();
        Token lastToken = lastNode.getEndToken();
        beginToken.beginLine = lastToken.endLine;
        beginToken.endLine = lastToken.endLine;
        beginToken.beginColumn = lastToken.endColumn + 1;
        beginToken.endColumn = lastToken.endColumn + 6;
        cfbreak.setStartToken(beginToken);
        cfbreak.setEndToken(beginToken);
        while (lastNode != null && !(lastNode instanceof ASTcfscriptStatement)) {
            lastNode = lastNode.jjtGetParent();
        }
        cfbreak.jjtSetParent(lastNode);
        finalCaseList.add(cfbreak);
    }

    private void copyAllNodesExceptFirst(ArrayList<Node> destinationBlock, ArrayList<Node> sourceBlock) {
        for (int j = 1; j < sourceBlock.size(); ++j) {
            destinationBlock.add(sourceBlock.get(j));
        }
    }

    private void updateDefaultAndFinalCaseList(ArrayList<Node> finalCaseList, ArrayList<Node> defaultCaseBlock, ArrayList<Node> currCaseBlock) {
        for (Node node : currCaseBlock) {
            if (node instanceof ASTcfcase && !this.isDefaultNode((ASTcfcase)node)) continue;
            defaultCaseBlock.add(node);
        }
        if (!this.isDefaultNode((ASTcfcase)currCaseBlock.get(0))) {
            finalCaseList.addAll(currCaseBlock);
        } else if (this.isPreviousCaseWithoutBreak(finalCaseList)) {
            this.copyAllNodesExceptFirst(finalCaseList, currCaseBlock);
        }
    }

    private boolean isPreviousCaseWithoutBreak(ArrayList<Node> finalCaseList) {
        return !finalCaseList.isEmpty() && !(finalCaseList.get(finalCaseList.size() - 1) instanceof ASTcfbreak);
    }

    private void initSwitchTable(ASTcfswitch cfswitch, Object lookupTableField) {
        Map switchLookups = this.tc.getSwitchLookups();
        Hashtable table = (Hashtable)switchLookups.get(cfswitch.getLookupTableName());
        String oldMethod = this.setMethod("<clinit>");
        this.newinstance(SwitchTableClass);
        this.invokespecial(newSwitchTable);
        Enumeration eInits = table.keys();
        while (eInits.hasMoreElements()) {
            Object constValue = eInits.nextElement();
            Integer lookupValue = (Integer)table.get(constValue);
            if (constValue instanceof Double) {
                this.aconst(constValue);
                this.aconst(lookupValue);
                this.invoke(addDoubleCase);
                continue;
            }
            if (constValue instanceof Date) {
                Object date = this.newinstance(constValue.getClass());
                Constructor<?> con = null;
                try {
                    con = constValue.getClass().getConstructor(Long.TYPE);
                }
                catch (NoSuchMethodException e) {
                    throw new CompilerInternalException((Object)e);
                }
                this.aconst(new Long(((Date)constValue).getTime()));
                this.invokespecial(con);
                this.aconst(lookupValue);
                this.invoke(addDateCase);
                continue;
            }
            if (constValue instanceof ASTsimpleVariableReference) continue;
            this.aconst(constValue);
            this.aconst(lookupValue);
            this.invoke(addStringCase);
        }
        this.putstatic(lookupTableField);
        this.setMethod(oldMethod);
    }

    protected void patchCases(StatementNode cfswitch, Object sw, Object end) {
        if (cfswitch.caseLabels != null) {
            int nCases;
            int totalCases = nCases = cfswitch.caseLabels.size() / 2;
            for (int i = 0; i < nCases; ++i) {
                if (cfswitch.caseLabels.get(i * 2 + 1) != null) continue;
                end = cfswitch.caseLabels.get(i * 2);
                --nCases;
            }
            int[] values = new int[nCases];
            Object[] targets = new Object[nCases];
            int j = 0;
            for (int i = 0; i < totalCases; ++i) {
                Object target = cfswitch.caseLabels.get(2 * i);
                Object value = cfswitch.caseLabels.get(2 * i + 1);
                if (value == null) continue;
                values[j] = (Integer)value;
                targets[j] = target;
                ++j;
            }
            this.setSwitchTargets(sw, values, targets, end);
        }
    }

    private Object cfcase(ASTcfcase cfcase) {
        ASTcfswitch cfswitch = cfcase.getSwitch();
        Object label = this.label();
        if (cfcase.getSwitch().isDynamic()) {
            int caseNumber = cfcase.getSwitch().getDynamicCaseNumber();
            cfswitch.addCaseLabel(label, caseNumber);
            cfcase.getSwitch().setDynamicCaseNumber(caseNumber + 1);
            if (cfcase.isCfcase) {
                this.block(cfcase.children);
                this.cfbreak(cfswitch, cfcase);
            }
            return label;
        }
        if (!cfcase.isDefaultcase()) {
            String delimiter;
            String casePrototype = cfcase.getCasespec();
            ExprNode delimNode = cfcase.getAttrNode("DELIMITERS");
            String string = delimiter = delimNode != null ? EvaluateEngine._String(delimNode) : ",";
            if (cfcase.isCfcase && casePrototype.length() > 0) {
                StringTokenizer cases = new StringTokenizer(casePrototype, delimiter);
                while (cases.hasMoreElements()) {
                    try {
                        Object caseSpec = cfcase.normalizedConstant(cases.nextToken());
                        Integer caseInt = this.tc.registerCase(cfswitch.getLookupTableName(), caseSpec, cfcase);
                        cfswitch.addCaseLabel(label, caseInt);
                    }
                    catch (NoSuchElementException ex) {
                        throw new CompilerInternalException(cases);
                    }
                }
            } else {
                Object caseSpec = cfcase.normalizedConstant(casePrototype);
                Integer caseInt = this.tc.registerCase(cfswitch.getLookupTableName(), caseSpec, cfcase);
                cfswitch.addCaseLabel(label, caseInt);
            }
        } else {
            if (cfswitch.emittedDefault) {
                throw new ASTcfswitch.DuplicateDefaultCaseException();
            }
            cfswitch.addCaseLabel(label, null);
            cfswitch.emittedDefault = true;
        }
        if (cfcase.isCfcase) {
            this.block(cfcase.children);
            this.cfbreak(cfswitch, cfcase);
        }
        return label;
    }

    private Object cftry(ASTcftry cftry) {
        Object cfcatchVar = this.createLocal(TransientVariableHolderClass);
        Object label = this.newinstance(TransientVariableHolderClass);
        this.load(this.pageVar);
        this.getfield(pageContext);
        this.invokespecial(newTransientVariableHolder);
        this.store(cfcatchVar);
        cftry.hasFinally = true;
        Object tryStart = null;
        Object sw = null;
        Object tryCatchEnd = null;
        Object tryEndJmp = null;
        Object abortVarLbl = null;
        Object exVarLbl = null;
        if (!cftry.isCFScript() || cftry.children[0].children != null) {
            tryStart = this.block(cftry.children);
        }
        Object emptytryStart = this.jsr(null);
        cftry.addFinally(emptytryStart);
        Object tryEnd = this.jmp(null);
        cftry.addBreak(tryEnd);
        if (tryStart != null && cftry.catchBlocks.size() != 0) {
            Object abortVar = this.createLocal(AbortExceptionClass);
            abortVarLbl = this.store(abortVar);
            this.load(abortVar);
            this.athrow();
            Object exVar = this.createLocal(ExceptionClass);
            exVarLbl = this.store(exVar);
            this.load(exVar);
            this.invoke(unwrap);
            Object unwrappedVar = this.createLocal(ThrowableClass, cftry.getThrowableName());
            this.store(unwrappedVar);
            Object catchTypesField = this.createStringTable(cftry.getCatchTypes());
            this.load(unwrappedVar);
            this.getstatic(catchTypesField);
            this.invoke(findThrowableTarget);
            sw = this.tableswitch();
            int count = cftry.catchBlocks.size();
            int j = 0;
            for (int i = 0; i < count; ++i) {
                ASTcfcatch cfcatch = (ASTcfcatch)cftry.catchBlocks.elementAt(i);
                int exceptionCount = cfcatch.getExceptionTypes().size();
                for (int k = 0; k < exceptionCount; ++k) {
                    cftry.addCaseLabel(this.label(), j++);
                }
                this.load(cfcatchVar);
                this.aconst(cfcatch.getVarname());
                this.load(unwrappedVar);
                this.invokeVoid(tvhBind);
                this.block(cfcatch.children);
                cfcatch.addBreak(this.jmp(null));
            }
            Object defaultCase = this.load(exVar);
            cftry.addCaseLabel(defaultCase, null);
            this.athrow();
            tryCatchEnd = this.jsr(null);
            cftry.addFinally(tryCatchEnd);
            tryEndJmp = this.jmp(null);
            for (int i = 0; i < count; ++i) {
                ASTcfcatch cfcatch = (ASTcfcatch)cftry.catchBlocks.elementAt(i);
                this.patchBreaks(cfcatch, tryCatchEnd);
            }
        }
        tryCatchEnd = tryCatchEnd != null ? tryCatchEnd : this.label();
        Object finallyEx = this.createLocal(ThrowableClass);
        Object finallyExLbl = this.store(finallyEx);
        Object finallyEnd = this.jsr(null);
        cftry.addFinally(finallyEnd);
        this.load(finallyEx);
        this.athrow();
        Object retAddrVar = this.createLocal(ObjectClass);
        Object finallyStart = this.store(retAddrVar);
        if (cftry.catchBlocks.size() != 0) {
            this.load(cfcatchVar);
            this.invokeVoid(tvhUnbind);
        }
        if (cftry.finallyStmt != null) {
            this.block(cftry.finallyStmt.children);
        }
        this.ret(retAddrVar);
        this.patchFinally(cftry, finallyStart);
        Object lbl = this.label();
        if (tryEndJmp != null) {
            this.setTarget(tryEndJmp, lbl);
        }
        this.patchBreaks(cftry, lbl);
        if (abortVarLbl != null) {
            this.addExceptionHandlers(tryStart, tryEnd, AbortExceptionClass, abortVarLbl, lbl);
        }
        if (exVarLbl != null) {
            this.addExceptionHandlers(tryStart, tryEnd, ExceptionClass, exVarLbl, lbl);
        }
        if (tryStart != null) {
            this.addExceptionHandlers(tryStart, finallyEnd, ThrowableClass, finallyExLbl, lbl);
        } else {
            this.addExceptionHandlers(emptytryStart, finallyEnd, ThrowableClass, finallyExLbl, lbl);
        }
        if (sw != null) {
            this.patchCases(cftry, sw, tryCatchEnd);
        }
        return label;
    }

    private Object createStringTable(String[] strings) {
        Object field = this.createField(StringArrayClass, null, 26);
        String oldMethod = this.setMethod("<clinit>");
        this.newarray(StringClass, strings);
        this.putstatic(field);
        this.setMethod(oldMethod);
        return field;
    }

    private Object cfloop(ASTcfloop cfloop) {
        ExprNode condition = cfloop.getAttrNode("CONDITION");
        ExprNode from = cfloop.getAttrNode("FROM");
        ExprNode list = cfloop.getAttrNode("LIST");
        ExprNode to = cfloop.getAttrNode("TO");
        ExprNode collection = cfloop.getAttrNode("COLLECTION");
        ExprNode array = cfloop.getAttrNode("ARRAY");
        if (condition != null) {
            return this.cfloopCondition(condition, cfloop);
        }
        if (from != null && to != null) {
            return this.cfloopRegular(cfloop, to, from);
        }
        if (list != null) {
            return this.cfloopList(cfloop, list);
        }
        if (collection != null) {
            return this.cfloopCollection(cfloop, collection);
        }
        if (array != null) {
            return this.cfloopArray(array, cfloop);
        }
        throw new UnsupportedOperationException("unsupported statement: " + cfloop.getClass());
    }

    private Object cfloopArray(ExprNode array, ASTcfloop cfloop) {
        Object arrayVar = this.createLocal(ListClass);
        Object label = this.cast(array, ListClass);
        this.store(arrayVar);
        Object stepVar = this.createLocal(intClass);
        this.iconst(1);
        this.store(stepVar);
        Object loopIndexVar = this.createLocal(intClass);
        this.iconst(0);
        this.store(loopIndexVar);
        Object sizeVar = this.createLocal(intClass);
        this.load(arrayVar);
        this.invoke(size);
        this.store(sizeVar);
        ExprNode index = cfloop.getAttrNode("INDEX");
        ExprNode item = cfloop.getAttrNode("ITEM");
        boolean honorItem = false;
        if (item != null) {
            honorItem = true;
        } else if (index == null) {
            throw new RequiredAttributeException(cfloop.tagName, "ITEM");
        }
        boolean withinStaticBlock = this.isStaticStatement(cfloop);
        Object itemVariable = null;
        Object indexVariable = null;
        if (index != null) {
            indexVariable = this.createCFloopIndexVariable(index, withinStaticBlock);
        }
        if (item != null) {
            itemVariable = this.createCFloopIndexVariable(item, withinStaticBlock);
        }
        Object loopStart = this.jmp(null);
        Object loopBody = this.load(arrayVar);
        this.load(loopIndexVar);
        this.invoke(getAt);
        this.store(this.valueVar);
        if (honorItem) {
            if (itemVariable != null) {
                this.load(itemVariable);
                this.load(this.valueVar);
                this.invokeVoid(setVar);
            } else {
                this.dumpSetExpr(item);
            }
            if (index != null) {
                if (indexVariable != null) {
                    this.load(indexVariable);
                    this.load(loopIndexVar);
                    this.iconst(1);
                    this.add(intClass);
                    this.cast(intClass, ObjectClass);
                    this.invokeVoid(setVar);
                } else {
                    Object temp = this.createLocal(ObjectClass);
                    this.load(this.valueVar);
                    this.store(temp);
                    this.load(loopIndexVar);
                    this.iconst(1);
                    this.add(intClass);
                    this.cast(intClass, ObjectClass);
                    this.store(this.valueVar);
                    this.dumpSetExpr(index);
                    this.load(temp);
                    this.store(this.valueVar);
                }
            }
        } else if (indexVariable != null) {
            this.load(indexVariable);
            this.load(this.valueVar);
            this.invokeVoid(setVar);
        } else {
            this.dumpSetExpr(index);
        }
        Object innerLoopCheck = null;
        if (!FusionContext.isPreserveNullValues()) {
            this.load(this.valueVar);
            innerLoopCheck = this.ifacmpeq(null, null);
        }
        this.block(cfloop.children);
        if (!FusionContext.isPreserveNullValues()) {
            this.setTarget(innerLoopCheck, this.label());
        }
        Object contRet = this.load(loopIndexVar);
        this.load(stepVar);
        this.add(intClass);
        this.store(loopIndexVar);
        Object loopCheck = this.load(loopIndexVar);
        this.load(sizeVar);
        Object ifLabel = this.ificmplt(loopBody);
        int lineNum = cfloop.getLine();
        if (lineNum > 0) {
            this.addLineNumber(ifLabel, lineNum);
        }
        this.setTarget(loopStart, loopCheck);
        this.patchContinues(cfloop, contRet);
        this.patchBreaks(cfloop, this.label());
        return label;
    }

    private Object cfloopCollection(ASTcfloop cfloop, ExprNode collection) {
        ExprNode item = cfloop.getRequiredAttrNode("ITEM");
        Object iteratorVar = this.createLocal(IteratorClass);
        Object label = this.cast(collection, ObjectClass);
        this.invoke(validatingMap);
        this.invoke(entrySet);
        this.invoke(iterator);
        this.store(iteratorVar);
        Object loopStart = this.jmp(null);
        Object loopBody = this.load(iteratorVar);
        this.invoke(getNext);
        this.cast(getNext.getReturnType(), MapEntryClass);
        this.invoke(getKey);
        this.store(this.valueVar);
        this.dumpSetExpr(item);
        this.block(cfloop.children);
        this.checkRequestTimeout("CFLOOP");
        Object loopIf = this.load(iteratorVar);
        this.invoke(hasNext);
        Object ifLabel = this.ifne(loopBody);
        int lineNum = cfloop.getLine();
        if (lineNum > 0) {
            this.addLineNumber(ifLabel, lineNum);
        }
        this.setTarget(loopStart, loopIf);
        this.patchContinues(cfloop, loopIf);
        this.patchBreaks(cfloop, this.label());
        return label;
    }

    private Object cfloopList(ASTcfloop cfloop, ExprNode list) {
        ExprNode delimiters = cfloop.getAttrNode("DELIMITERS", ",");
        ExprNode index = cfloop.getAttrNode("INDEX");
        ExprNode item = cfloop.getAttrNode("ITEM");
        Object listVar = this.createLocal(StringClass);
        Object label = this.cast(list, StringClass);
        this.store(listVar);
        Object delimsVar = this.createLocal(StringClass);
        this.cast(delimiters, StringClass);
        this.store(delimsVar);
        Object loopIndexVar = this.createLocal(intClass);
        this.iconst(1);
        this.store(loopIndexVar);
        boolean honorItem = false;
        if (item != null) {
            honorItem = true;
        } else if (index == null) {
            throw new RequiredAttributeException(cfloop.tagName, "ITEM");
        }
        Object itemVariable = null;
        Object indexVariable = null;
        boolean withinStaticBlock = this.isStaticStatement(cfloop);
        if (index != null) {
            indexVariable = this.createCFloopIndexVariable(index, withinStaticBlock);
        }
        if (item != null) {
            itemVariable = this.createCFloopIndexVariable(item, withinStaticBlock);
        }
        Object tokenizerVar = this.createLocal(StringTokenizerClass);
        this.newinstance(StringTokenizerClass);
        this.load(listVar);
        this.load(delimsVar);
        this.invokespecial(newStringTokenizer);
        this.store(tokenizerVar);
        Object loopStart = this.jmp(null);
        Object loopBody = this.load(tokenizerVar);
        this.invoke(nextToken);
        this.store(this.valueVar);
        if (honorItem) {
            if (itemVariable != null) {
                this.load(itemVariable);
                this.load(this.valueVar);
                this.invokeVoid(setVar);
            } else {
                this.dumpSetExpr(item);
            }
            if (index != null) {
                if (indexVariable != null) {
                    this.load(indexVariable);
                    this.load(loopIndexVar);
                    this.cast(intClass, ObjectClass);
                    this.invokeVoid(setVar);
                } else {
                    Object temp = this.createLocal(ObjectClass);
                    this.load(this.valueVar);
                    this.store(temp);
                    this.load(loopIndexVar);
                    this.cast(intClass, ObjectClass);
                    this.store(this.valueVar);
                    this.dumpSetExpr(index);
                    this.load(temp);
                    this.store(this.valueVar);
                }
            }
        } else if (indexVariable != null) {
            this.load(indexVariable);
            this.load(this.valueVar);
            this.invokeVoid(setVar);
        } else {
            this.dumpSetExpr(index);
        }
        this.load(loopIndexVar);
        this.iconst(1);
        this.add(intClass);
        this.store(loopIndexVar);
        this.block(cfloop.children);
        this.checkRequestTimeout("CFLOOP");
        Object loopIf = this.load(tokenizerVar);
        this.invoke(hasMoreTokens);
        Object ifLabel = this.ifne(loopBody);
        int lineNum = cfloop.getLine();
        if (lineNum > 0) {
            this.addLineNumber(ifLabel, lineNum);
        }
        this.setTarget(loopStart, loopIf);
        this.patchContinues(cfloop, loopIf);
        this.patchBreaks(cfloop, this.label());
        return label;
    }

    private Object cfloopRegular(ASTcfloop cfloop, ExprNode to, ExprNode from) {
        ExprNode step = cfloop.getAttrNode("STEP");
        ExprNode index = cfloop.getRequiredAttrNode("INDEX");
        Object stepVar = this.createLocal(doubleClass);
        Object label = this.validateCast(cfloop, "STEP", step, doubleClass);
        this.store(stepVar);
        Object toVar = this.createLocal(doubleClass);
        this.validateCast(cfloop, "TO", to, doubleClass);
        this.store(toVar);
        Object indexVar = this.createLocal(doubleClass);
        this.validateCast(cfloop, "FROM", from, doubleClass);
        this.store(indexVar);
        this.load(indexVar);
        this.cast(doubleClass, ObjectClass);
        this.store(this.valueVar);
        Object indexVariable = this.createCFloopIndexVariable(index, this.isStaticStatement(cfloop));
        if (indexVariable != null) {
            this.load(indexVariable);
            this.load(this.valueVar);
            this.invokeVoid(setVar);
        } else {
            this.dumpSetExpr(index);
        }
        Object loopStart = this.jmp(null);
        Object loopBody = this.block(cfloop.children);
        Object contRet = this.load(indexVar);
        this.load(stepVar);
        this.dadd();
        this.dup2();
        this.store(indexVar);
        this.cast(doubleClass, ObjectClass);
        this.store(this.valueVar);
        if (indexVariable != null) {
            this.load(indexVariable);
            this.load(this.valueVar);
            this.invokeVoid(setVar);
        } else {
            this.dumpSetExpr(index);
        }
        this.checkRequestTimeout("CFLOOP");
        Object loopCheck = this.load(stepVar);
        this.load(indexVar);
        this.load(toVar);
        this.invoke(checkCondition);
        Object ifLabel = this.ifne(loopBody);
        this.setTarget(loopStart, loopCheck);
        this.patchContinues(cfloop, contRet);
        this.patchBreaks(cfloop, this.label());
        int lineNumber = cfloop.getLine();
        if (lineNumber > 0) {
            this.addLineNumber(ifLabel, lineNumber);
        }
        return label;
    }

    private Object cfloopCondition(ExprNode condition, ASTcfloop cfloop) {
        Object loopCondVar = super.createLocal(ObjectClass);
        Object label = this.cast(condition, StringClass);
        this.invoke(prepareCondition);
        this.store(loopCondVar);
        Object jmpLabel = this.jmp(null);
        Object bodyLabel = this.block(cfloop.children);
        this.checkRequestTimeout("CFLOOP");
        Object testLabel = this.load(this.pageVar);
        this.load(loopCondVar);
        this.invoke(evaluateCondition);
        Object ifLabel = this.ifne(bodyLabel);
        int lineNum = cfloop.getLine();
        if (lineNum > 0) {
            this.addLineNumber(ifLabel, lineNum);
        }
        this.setTarget(jmpLabel, testLabel);
        this.patchContinues(cfloop, testLabel);
        this.patchBreaks(cfloop, this.label());
        return label;
    }

    private Object createCFloopIndexVariable(ExprNode index, boolean isStatic) {
        boolean isSimpleLiteral = false;
        String indexName = "";
        if (index.id == 27) {
            indexName = (String)((ASTliteral)index).tokens.get(0);
            isSimpleLiteral = (indexName = indexName.toUpperCase()).indexOf(".") == -1 && indexName.indexOf(91) == -1;
        }
        Object indexVariable = null;
        if (isSimpleLiteral) {
            indexVariable = this.createLocal(VariableClass);
            this.load(this.pageVar);
            this.aconst(indexName);
            if (!isStatic) {
                Object localScopeParam = this.findLocal("__localScope");
                if (localScopeParam != null) {
                    this.load(localScopeParam);
                } else {
                    this.aconst(null);
                }
                this.invoke(bindPageVariable);
            } else {
                this.getstatic(this.findField(this.getStaticScopeVarName()));
                this.aconst(false);
                this.aconst(8);
                this.invoke(bindStaticVariable);
            }
            this.store(indexVariable);
        }
        return indexVariable;
    }

    private Object validateCast(TagNode cftag, String attrName, ExprNode expr, Class type) {
        if (expr.id == 27) {
            return this.cast(expr, type);
        }
        Method validator = StmtAssembler.attrValidator(type);
        Object label = this.aconst(cftag.getTagName());
        this.aconst(attrName);
        this.cast(expr, validator.getParameterTypes()[2]);
        if (cftag instanceof ASTcftag) {
            this.aconst(((ASTcftag)cftag).getCalledName());
        } else {
            this.aconst(null);
        }
        this.invoke(validator);
        this.cast(validator.getReturnType(), type);
        return label;
    }

    private void checkRequestTimeout(String tag) {
        this.aconst(tag);
        this.invokeVoid(checkRequestTimeout);
    }

    private Object dumpSetExpr(ExprNode target) {
        if (target instanceof VariableReference) {
            return this.assignStatement(target);
        }
        Object label = this.load(this.pageVar);
        this.cast(target, StringClass);
        this.load(this.valueVar);
        this.invokeVoid(setVariable);
        return label;
    }

    private Object cfforin(ASTcfscriptStatement statement) {
        Object labelSet;
        Object label = this.label();
        Object iteratorVar = this.createLocal(IteratorClass);
        this.aconst(null);
        this.store(iteratorVar);
        Object queryVar = this.createLocal(QueryTableClass);
        this.aconst(null);
        this.store(queryVar);
        Object queryMetaVar = this.createLocal(QueryTableMetaDataClass);
        this.aconst(null);
        this.store(queryMetaVar);
        ExprNode collection = statement.getExpression("COLLECTION");
        if (collection != null && collection.isIIFE()) {
            this.assembleStatement(collection.jjtGetChild(0));
        }
        Object assembledExpr = this.createLocal(ObjectClass);
        this.castObject(super.assembleExpr(statement.getExpression("COLLECTION")), ObjectClass, ObjectClass);
        this.store(assembledExpr);
        this.load(assembledExpr);
        this.instanceOf(StringClass);
        Object listComp = this.ifeq(null);
        this.load(assembledExpr);
        super.cast(ObjectClass, StringClass);
        this.invoke(listToArray);
        this.invoke(listIterator);
        this.store(iteratorVar);
        Object listCond = this.jmp(null);
        Object objIntStart = this.load(assembledExpr);
        this.instanceOf(IntegerClass);
        Object intComp = this.ifeq(null);
        this.load(assembledExpr);
        super.cast(ObjectClass, StringClass);
        this.invoke(listToArray);
        this.invoke(listIterator);
        this.store(iteratorVar);
        this.jmp(listCond);
        Object objArrStart = this.load(assembledExpr);
        Object objNotNull = this.ifnull(null);
        this.load(assembledExpr);
        this.invoke(getClass);
        this.invoke(isArray);
        Object objComp = this.ifeq(null);
        this.load(assembledExpr);
        this.invoke(objectAsList);
        this.invoke(listIterator);
        this.store(iteratorVar);
        this.jmp(listCond);
        Object arrStart = this.load(assembledExpr);
        this.instanceOf(ListClass);
        Object comp = this.ifeq(null);
        Object label1 = this.castObject(this.load(assembledExpr), ObjectClass, ListClass);
        this.invoke(listIterator);
        this.store(iteratorVar);
        this.jmp(listCond);
        Object label_query = this.load(assembledExpr);
        this.instanceOf(QueryTableClass);
        Object comp_query = this.ifeq(null);
        this.load(assembledExpr);
        super.cast(ObjectClass, QueryTableClass);
        this.store(queryVar);
        this.load(queryVar);
        this.invoke(getQueryMetaData);
        this.store(queryMetaVar);
        this.load(queryVar);
        this.invoke(getRowVector);
        this.invoke(listIterator);
        this.store(iteratorVar);
        this.load(queryVar);
        this.aconst(0);
        this.invoke(resetRowCountForQuery);
        this.pop(booleanClass);
        this.jmp(listCond);
        Object udfMethodStart = this.load(assembledExpr);
        this.instanceOf(UDFMethodClass);
        Object udfMethodComp = this.ifeq(null);
        Object udfLabel = this.newinstance(udfMethodIteratorClass);
        this.castObject(this.load(assembledExpr), ObjectClass, UDFMethodClass);
        this.invokespecial(udfMethodIteratorConstructor);
        this.store(iteratorVar);
        this.jmp(listCond);
        Object cfcLabel = this.load(assembledExpr);
        this.invoke(iteratorForCFC);
        this.store(iteratorVar);
        this.load(iteratorVar);
        Object itrNull = this.ifnull(null);
        this.jmp(listCond);
        Object label2 = this.castObject(this.load(assembledExpr), ObjectClass, MapClass);
        this.invoke(keySet);
        this.invoke(iterator);
        this.store(iteratorVar);
        this.setTarget(listCond, this.label());
        this.setTarget(listComp, objIntStart);
        this.setTarget(intComp, objArrStart);
        this.setTarget(objNotNull, arrStart);
        this.setTarget(objComp, arrStart);
        this.setTarget(comp, label_query);
        this.setTarget(comp_query, udfMethodStart);
        this.setTarget(udfMethodComp, cfcLabel);
        this.setTarget(itrNull, label2);
        Object l1 = this.jmp(null);
        Object l3 = this.load(iteratorVar);
        this.invoke(getNext);
        this.store(this.valueVar);
        Object innerLoopCheck = null;
        if (!FusionContext.isPreserveNullValues()) {
            this.load(this.valueVar);
            innerLoopCheck = this.ifacmpeq(null, null);
        }
        this.load(this.valueVar);
        this.instanceOf(RowClass);
        Object comp_query1 = this.ifeq(null);
        this.load(this.valueVar);
        this.load(queryVar);
        this.invoke(getColumnList);
        this.load(queryMetaVar);
        this.invoke(queryRowDataToStruct);
        this.store(this.valueVar);
        this.load(queryVar);
        this.aconst(1);
        this.invoke(incrementCurrentRowCountRelatively);
        this.pop(booleanClass);
        Node itrNode = statement.getNode("ITERATOR");
        if (itrNode instanceof ASTvariableDefinition) {
            itrNode = ((ASTvariableDefinition)itrNode).children[0];
        }
        if (itrNode instanceof ASTDestructring) {
            labelSet = this.load(this.valueVar);
            ((ASTDestructring)itrNode).handle(null, this);
        } else {
            labelSet = this.assignStatement((ExprNode)itrNode);
        }
        this.block(statement.children);
        if (!FusionContext.isPreserveNullValues()) {
            this.setTarget(innerLoopCheck, this.label());
        }
        Object l2 = this.load(iteratorVar);
        this.invoke(hasNext);
        this.ifne(l3);
        this.setTarget(comp_query1, labelSet);
        this.setTarget(l1, l2);
        this.patchContinues(statement, l2);
        this.patchBreaks(statement, this.label());
        statement.addFinally(this.jmp(null));
        Object finallyLabel = this.label();
        this.load(queryVar);
        Object resetQueryLabel = this.ifacmpeq(null, null);
        this.load(queryVar);
        this.aconst(0);
        this.invoke(resetRowCountForQuery);
        this.pop(booleanClass);
        this.setTarget(resetQueryLabel, this.label());
        this.patchFinally(statement, finallyLabel);
        return label;
    }

    private Object cffor(ASTcfscriptStatement statement) {
        StatementNode init = statement.getStatement("INIT");
        ExprNode test = statement.getExpression("TEST");
        StatementNode fin = statement.getStatement("FINAL");
        Object label = init != null ? this.assembleStatement(init) : this.label();
        Object l2 = this.jmp(null);
        Object l3 = this.block(statement.children);
        Object l1 = fin != null ? this.assembleStatement(fin) : this.label();
        Object l4 = this.loopTest(test, l3);
        this.setTarget(l2, l4);
        this.patchContinues(statement, l1);
        this.patchBreaks(statement, this.label());
        return label;
    }

    private Object loopTest(ExprNode test, Object target) {
        Object label;
        if (test != null) {
            block0 : switch (test.id) {
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 239: 
                case 240: {
                    ExprNode lhs = test.subexpr(0);
                    ExprNode rhs = test.subexpr(1);
                    if (lhs.getType().isPrimitive() && rhs.getType().isPrimitive()) {
                        label = this.cast(lhs, doubleClass);
                        this.cast(rhs, doubleClass);
                        switch (test.id) {
                            case 222: 
                            case 239: {
                                this.dcmpl();
                                this.ifeq(target);
                                break block0;
                            }
                            case 223: 
                            case 240: {
                                this.dcmpl();
                                this.ifne(target);
                                break block0;
                            }
                            case 218: {
                                this.dcmpl();
                                this.iflt(target);
                                break block0;
                            }
                            case 220: {
                                this.dcmpg();
                                this.ifgt(target);
                                break block0;
                            }
                            case 219: {
                                this.dcmpl();
                                this.ifle(target);
                                break block0;
                            }
                            case 221: {
                                this.dcmpg();
                                this.ifge(target);
                            }
                        }
                        break;
                    }
                }
                default: {
                    label = this.cast(test, booleanClass);
                    this.ifne(target);
                    break;
                }
            }
        } else {
            label = this.jmp(target);
        }
        return label;
    }

    private Object cfwhile(ASTcfscriptStatement statement) {
        Object label = this.jmp(null);
        Object l2 = this.block(statement.children);
        Object l3 = this.loopTest(statement.getExpression("TEST"), l2);
        this.setTarget(label, l3);
        this.patchContinues(statement, l3);
        this.patchBreaks(statement, this.label());
        return label;
    }

    private Object cfdowhile(ASTcfscriptStatement statement) {
        Object label = this.block(statement.children);
        Object l2 = this.loopTest(statement.getExpression("TEST"), label);
        this.patchContinues(statement, l2);
        this.patchBreaks(statement, this.label());
        return label;
    }

    private Object cfif(ASTcfscriptStatement statement) {
        Object label;
        Object l1 = null;
        ExprNode predicate = statement.getExpression("PREDICATE");
        switch (predicate.id) {
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 239: 
            case 240: {
                ExprNode lhs = predicate.subexpr(0);
                ExprNode rhs = predicate.subexpr(1);
                if (lhs.getType().isPrimitive() && rhs.getType().isPrimitive()) {
                    label = this.cast(lhs, doubleClass);
                    this.cast(rhs, doubleClass);
                    switch (predicate.id) {
                        case 222: 
                        case 239: {
                            this.dcmpl();
                            l1 = this.ifne(null);
                            break;
                        }
                        case 223: 
                        case 240: {
                            this.dcmpl();
                            l1 = this.ifeq(null);
                            break;
                        }
                        case 218: {
                            this.dcmpl();
                            l1 = this.ifge(null);
                            break;
                        }
                        case 220: {
                            this.dcmpg();
                            l1 = this.ifle(null);
                            break;
                        }
                        case 219: {
                            this.dcmpl();
                            l1 = this.ifgt(null);
                            break;
                        }
                        case 221: {
                            this.dcmpg();
                            l1 = this.iflt(null);
                        }
                    }
                    break;
                }
            }
            default: {
                label = this.cast(predicate, booleanClass);
                l1 = this.ifeq(null);
            }
        }
        this.block(statement.children);
        StatementNode s = statement.getStatement("ELSE");
        if (s != null) {
            Object l3 = this.jmp(null);
            Object l2 = this.assembleStatement(s);
            this.setTarget(l1, l2);
            this.setTarget(l3, this.label());
        } else {
            this.setTarget(l1, this.label());
        }
        return label;
    }

    private Object cfcontinue(StatementNode cfcontinue) {
        StatementNode loop = cfcontinue.getEnclosingStatement();
        if (loop != null && loop instanceof ASTcfscript && this.hasParentLoop(loop)) {
            loop = loop.getEnclosingStatement();
        }
        Object label = this.doFinallyforContinue(loop, cfcontinue);
        loop.addContinueLabel(this.jmp(null));
        return label;
    }

    private boolean hasParentLoop(StatementNode origin) {
        StatementNode node = origin;
        while (node != null) {
            if (node instanceof ASTcfloop) {
                return true;
            }
            if (node instanceof ASTcfscriptStatement) {
                switch (((ASTcfscriptStatement)node).getStatementType()) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: {
                        return true;
                    }
                }
            }
            try {
                node = node.getEnclosingStatement();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    protected void patchBreaks(StatementNode statement, Object breakTarget) {
        int count = statement.breakLabels == null ? 0 : statement.breakLabels.size();
        for (int i = 0; i < count; ++i) {
            this.setTarget(statement.breakLabels.get(i), breakTarget);
        }
    }

    protected void patchContinues(StatementNode statement, Object continueTarget) {
        int count = statement.continueLabels == null ? 0 : statement.continueLabels.size();
        for (int i = 0; i < count; ++i) {
            this.setTarget(statement.continueLabels.get(i), continueTarget);
        }
    }

    private Object pcdata(ASTpcdata pcdata, boolean emitWhitespace) {
        Node parent;
        Object l1;
        if (pcdata.buffer == null) {
            return this.label();
        }
        Object label = null;
        int count = pcdata.overflowData == null ? 0 : pcdata.overflowData.size();
        for (int i = 0; i < count; ++i) {
            l1 = this.emitText(pcdata.overflowData.elementAt(i).toString(), false);
            if (label != null) continue;
            label = l1;
        }
        if (pcdata.isJavaCode) {
            label = this.load(this.pageVar);
            this.aconst(pcdata.buffer.toString());
            List<String> args = pcdata.javaArgs;
            this.newarray(ObjectClass, args.toArray(new String[args.size()]));
            this.invoke(javarun);
            this.areturn();
            return label;
        }
        boolean isJava = false;
        if (pcdata.jjtGetParent() != null && pcdata.jjtGetParent().jjtGetParent() != null && (parent = pcdata.jjtGetParent().jjtGetParent()) instanceof ASTcftag && ((ASTcftag)parent).getTagName() != null) {
            isJava = ((ASTcftag)parent).getTagName().equalsIgnoreCase("cfjava");
        }
        l1 = this.emitText(pcdata.buffer.toString(), isJava);
        if (label == null) {
            label = l1;
        }
        return label;
    }

    private Object emitText(String text, boolean isJava) {
        if (ASTpcdata.isWhitespace(text)) {
            RuntimeService runtimeService = null;
            try {
                runtimeService = ServiceFactory.getRuntimeService();
            }
            catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {
                // empty catch block
            }
            boolean emitWhitespace = false;
            if (runtimeService != null) {
                boolean bl = emitWhitespace = runtimeService.getWhitespace() == false;
            }
            if (!text.contains("\n") && !text.contains("\r") && text.trim().length() == 0) {
                emitWhitespace = true;
            }
            if (emitWhitespace || this.skipWhiteSpaceOptimization > 0 || this.processedCFOutPutTag || this.processedCFOutPutTagEarlier || this instanceof FunctionAssembler) {
                Object label = this.load(this.pageVar);
                this.load(this.outVar);
                this.aconst(text);
                this.invokeVoid(writeSpace);
                this.processedCFOutPutTagEarlier = false;
                return label;
            }
            return this.label();
        }
        if (!isJava) {
            Object label = this.load(this.outVar);
            this.aconst(text);
            this.invokeVoid(write);
            return label;
        }
        Object label = this.load(this.pageVar);
        this.load(this.outVar);
        this.aconst(text);
        this.invokeVoid(writeJavaBodyContent);
        return label;
    }

    ArrayList beginAttrMetadata(ASTexprlist attrList, ASTcfproperty property) {
        ArrayList<String> attrData = new ArrayList<String>();
        if (attrList != null && attrList.children != null) {
            for (int i = 0; i < attrList.children.length; ++i) {
                ASTtagAttribute n = (ASTtagAttribute)attrList.children[i];
                if (n == null) continue;
                String name = n.getName();
                attrData.add(name);
                String value = "";
                Node valueNode = n.getValueNode();
                try {
                    try {
                        if (valueNode instanceof ExprNode) {
                            value = property != null && name.equalsIgnoreCase("default") ? this.handleDynamicDefault((ExprNode)valueNode, property) : EvaluateEngine._String((ExprNode)valueNode);
                        }
                    }
                    catch (NullPointerException npe) {
                        value = "";
                    }
                    attrData.add(value);
                    continue;
                }
                catch (NonConstantExpressionException nonConstantExpressionException) {
                    // empty catch block
                }
            }
        }
        return attrData;
    }

    ArrayList beginAttrMetadata(ASTexprlist attrList) {
        return this.beginAttrMetadata(attrList, null);
    }

    private String handleDynamicDefault(ExprNode value, ASTcfproperty property) {
        try {
            return EvaluateEngine._String(value);
        }
        catch (MethodNotFoundException | NonConstantExpressionException | CfJspPage.ComplexObjectException | UnsupportedOperationException ex) {
            property.setHasDynamicDefaultExpr();
            return "$DYNAMIC_EXPR$";
        }
    }

    void attrGetter(Map attrMap, String name) {
        Object attrValueObj = attrMap.get(name);
        if (attrValueObj != null && attrValueObj instanceof ExprNode) {
            ExprNode node = (ExprNode)attrValueObj;
            String value = EvaluateEngine._String(node);
            if (name.equals("Implements") || name.equals("Extends")) {
                String oMethodName = name.equals("Implements") ? "getOtherImplementations" : "getOtherExtends";
                String newvalue = this.callOtherImplementationMethod(oMethodName, value);
                if (newvalue == null) {
                    return;
                }
                value = newvalue;
            }
            String methodName = "get" + name;
            this.startMethod(methodName, new Class[0], new String[0], StringClass, 17);
            this.setMethod(methodName);
            this.aconst(value);
            this.areturn();
        }
    }

    private String callOtherImplementationMethod(String oMethodName, String value) {
        Map<String, List<String>> implementations = ImplementationUtil.extractOtherImplementations(value, true);
        String otherImplementation = String.join((CharSequence)",", implementations.entrySet().stream().filter(e -> !((String)e.getKey()).equals("cfc")).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList()));
        if (!otherImplementation.isEmpty()) {
            this.startMethod(oMethodName, new Class[0], new String[0], StringClass, 17);
            this.setMethod(oMethodName);
            this.aconst(otherImplementation);
            this.areturn();
        }
        if (implementations.get("cfc") != null && !implementations.get("cfc").isEmpty()) {
            return String.join((CharSequence)",", (Iterable<? extends CharSequence>)implementations.get("cfc"));
        }
        return null;
    }

    private Object setArguments(TagNode cftag, ExprNode valNode, String attrName, Object tagVar, boolean validate) {
        Object label = this.load(tagVar);
        this.aconst(attrName);
        this.cast(valNode, ObjectClass);
        this.aconst(validate ? Boolean.TRUE : Boolean.FALSE);
        this.invokeVoid(setArguments);
        return label;
    }

    private Object setExplicitAttrInAttrColl(ExprNode valNode, String attrName, Object tagVar, boolean isAttrCollStructPresent) {
        if (isAttrCollStructPresent) {
            Object label = this.load(tagVar);
            this.aconst(attrName);
            this.cast(valNode, ObjectClass);
            this.invokeVoid(setExplicitAttrInAttrColl);
            return label;
        }
        return null;
    }

    private boolean isAttributeCollectionGeneric(TagNode cftag) {
        String tagName;
        ExprNode valNode = cftag.getAttrNode("attributecollection");
        return valNode != null && (tagName = cftag.getTagName()) != null && (cftag.tagClass == null || !ModuleTag.class.isAssignableFrom(cftag.tagClass)) && (CFMLTagLibrary.isCFTag(tagName) || tagName.length() > 2 && NeoTranslator.getCftaglibInfo().getTag(tagName.substring(2)) != null);
    }

    public void declareImports() {
        String path = this.tc.getImportPath();
        if (path != null && path.length() > 0) {
            this.load(this.pageVar);
            this.aconst(path);
            this.invoke(bindImportPath);
        }
    }

    static {
        StmtAssembler.initProcessAttributes();
        validateTagAttrConfiguration = StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrConfiguration", new Class[]{StringClass, StringClass, StringClass, StringClass});
        hasEndTag = StmtAssembler.getInstanceMethod(GenericTagClass, "hasEndTag", new Class[]{booleanClass});
        setCalledName = StmtAssembler.getInstanceMethod(GenericTagClass, "setCalledName", new Class[]{StringClass});
        emptyTag = StmtAssembler.getStaticMethod(CfJspPageClass, "_emptyTag", new Class[]{TagClass});
        emptyTcfTag = StmtAssembler.getStaticMethod(CfJspPageClass, "_emptyTcfTag", new Class[]{TagClass});
        pushBody = StmtAssembler.getInstanceMethod(CfJspPageClass, "_pushBody", new Class[]{BodyTagClass, intClass, JspWriterClass});
        popBody = StmtAssembler.getInstanceMethod(CfJspPageClass, "_popBody", new Class[]{intClass, JspWriterClass});
        setVariable = StmtAssembler.getInstanceMethod(CFPageClass, "SetVariable", new Class[]{StringClass, ObjectClass});
        checkCondition = StmtAssembler.getStaticMethod(CfJspPageClass, "_checkCondition", new Class[]{doubleClass, doubleClass, doubleClass});
        hasMoreTokens = StmtAssembler.getInstanceMethod(StringTokenizerClass, "hasMoreTokens", new Class[0]);
        nextToken = StmtAssembler.getInstanceMethod(StringTokenizerClass, "nextToken", new Class[0]);
        addDoubleCase = StmtAssembler.getInstanceMethod(SwitchTableClass, "addDoubleCase", new Class[]{doubleClass, intClass});
        addStringCase = StmtAssembler.getInstanceMethod(SwitchTableClass, "addStringCase", new Class[]{StringClass, intClass});
        _compare = StmtAssembler.getStaticMethod(CfJspPageClass, "_compare", new Class[]{ObjectClass, ObjectClass});
        addDateCase = StmtAssembler.getInstanceMethod(SwitchTableClass, "addDateCase", new Class[]{Date.class, intClass});
        tvhBind = StmtAssembler.getInstanceMethod(TransientVariableHolderClass, "bind", new Class[]{StringClass, ObjectClass});
        tvhUnbind = StmtAssembler.getInstanceMethod(TransientVariableHolderClass, "unbind", new Class[0]);
        validatingMap = StmtAssembler.getStaticMethod(CfJspPageClass, "_validatingMap", new Class[]{ObjectClass});
        escapeSingleQuotes = StmtAssembler.getStaticMethod(CfJspPageClass, "_escapeSingleQuotes", new Class[]{StringClass});
        setArguments = StmtAssembler.getInstanceMethod(GenericTagClass, "_setArguments", new Class[]{StringClass, ObjectClass, booleanClass});
        setExplicitAttrInAttrColl = StmtAssembler.getInstanceMethod(GenericTagClass, "_setExplicitAttrInAttrColl", new Class[]{StringClass, ObjectClass});
        bindPageVariable = StmtAssembler.getDeclaredMethod(CfJspPageClass, "bindPageVariable", new Class[]{StringClass, LocalScopeClass});
        bindStaticVariable = StmtAssembler.getDeclaredMethod(CfJspPageClass, "bindStaticVariable", new Class[]{StringClass, StaticScopeClass, booleanClass, intClass});
        markStatic = StmtAssembler.getInstanceMethod(GenericTagClass, "markStatic", new Class[0]);
        getOut = StmtAssembler.getInstanceMethod(PageContextClass, "getOut", new Class[0]);
        getMetaData = StmtAssembler.getInstanceMethod(UDFMethodClass, "getMetadata", new Class[0]);
        setPageEncoding = StmtAssembler.getInstanceMethod(NeoPageContextClass, "setPageEncoding", new Class[]{String.class});
        newTransientVariableHolder = StmtAssembler.getConstructor(TransientVariableHolderClass, new Class[]{NeoPageContextClass});
        newAttributeCollectionMap = StmtAssembler.getConstructor(AttributeCollectionClass, new Class[]{ObjectArrayClass, MapClass});
        newStringTokenizer = StmtAssembler.getConstructor(StringTokenizerClass, new Class[]{StringClass, StringClass});
        newSwitchTable = StmtAssembler.getConstructor(SwitchTableClass, new Class[0]);
        pageContext = StmtAssembler.getInstanceField(CfJspPageClass, "pageContext");
        pageParent = StmtAssembler.getInstanceField(CfJspPageClass, "parent");
        bindImportPath = StmtAssembler.getDeclaredMethod(CfJspPageClass, "bindImportPath", new Class[]{StringClass});
        javarun = StmtAssembler.getDeclaredMethod(CfJspPageClass, "javarun", new Class[]{StringClass, ObjectClass});
        listToArray = StmtAssembler.getStaticMethod(CFPageClass, "ListToArray", new Class[]{StringClass});
        objectAsList = StmtAssembler.getStaticMethod(CastClass, "_List", new Class[]{ObjectClass});
        getClass = StmtAssembler.getInstanceMethod(ObjectClass, "getClass", new Class[0]);
        isArray = StmtAssembler.getInstanceMethod(ClassClass, "isArray", new Class[0]);
        encodeFor = StmtAssembler.getStaticMethod(CFPageClass, "EncodeFor", new Class[]{ObjectClass, StringClass});
        iteratorForCFC = StmtAssembler.getStaticMethod(CfJspPageClass, "__iteratorForCFC", new Class[]{ObjectClass});
        udfMethodIteratorConstructor = StmtAssembler.getConstructor(udfMethodIteratorClass, new Class[]{UDFMethodClass});
        attrValidators = new HashMap(10);
        attrValidators.put(booleanClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, booleanClass, StringClass}));
        attrValidators.put(doubleClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, doubleClass, StringClass}));
        attrValidators.put(floatClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, floatClass, StringClass}));
        attrValidators.put(longClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, longClass, StringClass}));
        attrValidators.put(intClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, intClass, StringClass}));
        attrValidators.put(shortClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, shortClass, StringClass}));
        attrValidators.put(byteClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, byteClass, StringClass}));
        attrValidators.put(charClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, charClass, StringClass}));
        attrValidators.put(DateClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, DateClass, StringClass}));
        attrValidators.put(StringClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, StringClass, StringClass}));
        attrValidators.put(ObjectClass, StmtAssembler.getStaticMethod(CfJspPageClass, "_validateTagAttrValue", new Class[]{StringClass, StringClass, ObjectClass, StringClass}));
        tagsToSkipWhiteSpaceOptimization = new ArrayList<String>();
        tagsToSkipWhiteSpaceOptimization.add("cfoutput");
        tagsToSkipWhiteSpaceOptimization.add("cfquery");
        tagsToSkipWhiteSpaceOptimization.add("cfmail");
        tagsToSkipWhiteSpaceOptimization.add("cfmailpart");
    }
}

