/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.RequiredAttributeException;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.TagAttributeNotFoundException;
import coldfusion.compiler.TagClassNotFoundException;
import coldfusion.compiler.Token;
import coldfusion.jsp.JRunTagLibraryInfo;
import coldfusion.jsp.JSTTagInfo;
import coldfusion.osgi.scanner.ModulesCodeScannerValidator;
import coldfusion.server.ServiceFactory;
import coldfusion.server.felix.FelixUtil;
import coldfusion.util.OrderedCaseInsensitiveHashtable;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class TagNode
extends StatementNode {
    ASTexprlist attrList;
    Hashtable attrMap;
    Token tagName;
    String tagVar;
    boolean runtimeValidation;
    boolean calledFromScript;
    String switchAttrList;
    String switchAttrName;
    JSTTagInfo templateInfo = null;
    TagInfo tagInfo = null;
    int tagCount;
    int slot;
    private boolean isEmpty;
    Class tagClass;
    private Map distributedAttrs = null;

    public TagNode(int id) {
        super(id);
    }

    void setTagName(Token name) {
        this.tagName = name;
    }

    void setTagName(String name) {
        this.tagName = this.tagName != null ? Token.copyToken(this.tagName) : Token.copyToken(this.getStartToken());
        this.tagName.image = name;
    }

    String getPrefix() {
        int colon = this.tagName.image.indexOf(58);
        if (colon != -1) {
            return this.tagName.image.substring(0, colon);
        }
        return null;
    }

    public String getTagName() {
        if (this.tagName != null) {
            return this.tagName.image;
        }
        return null;
    }

    String getTagVar() {
        return this.tagVar;
    }

    void setAttrList(ASTexprlist e) {
        this.attrList = e;
        e.jjtSetParent(this);
    }

    void initAttr() throws ParseException {
        if (this.attrMap == null) {
            this.attrMap = new OrderedCaseInsensitiveHashtable();
            if (this.attrList != null) {
                this.attrList.populateMap(this.attrMap);
            }
        }
    }

    ExprNode getRequiredAttrNode(String attr) throws ParseException {
        ExprNode node = this.getAttrNode(attr);
        if (node != null) {
            return node;
        }
        throw new RequiredAttributeException(this.tagName, attr);
    }

    void putAttrNode(String name, ExprNode node) throws ParseException {
        this.initAttr();
        this.attrMap.put(name, node);
    }

    public ExprNode getAttrNode(String str) throws ParseException {
        this.initAttr();
        Object o = this.attrMap.get(str);
        if (o instanceof ExprNode) {
            return (ExprNode)o;
        }
        return null;
    }

    @Override
    public Node getNamedAttribute(String key) {
        this.initAttr();
        Object o = this.attrMap.get(key);
        if (o instanceof Node) {
            return (Node)o;
        }
        return null;
    }

    @Override
    public void setNamedAttribute(String key, Node value) {
        this.initAttr();
        this.attrMap.put(key, value);
    }

    ExprNode getAttrNode(String attr, String defaultVal) throws ParseException {
        ExprNode n = this.getAttrNode(attr);
        if (n == null) {
            n = new ASTliteral(defaultVal, this);
        }
        return n;
    }

    public void removeAttrNode(String str) throws ParseException {
        this.initAttr();
        this.attrMap.remove(str);
    }

    @Override
    public Enumeration getAttrNames() throws ParseException {
        this.initAttr();
        return this.attrMap.keys();
    }

    boolean hasEndTag() {
        return this.children != null && this.children.length > 0;
    }

    Class getTagClass(TagInfo tagInfo) throws TagClassNotFoundException {
        JRunTagLibraryInfo tld = (JRunTagLibraryInfo)tagInfo.getTagLibrary();
        try {
            return JRunTagLibraryInfo.getTagClass(tagInfo);
        }
        catch (ClassNotFoundException cnfe) {
            String moduleName;
            String tagName = tagInfo.getTagName().toLowerCase();
            if (tagName.startsWith("exchange")) {
                tagName = "exchange";
            }
            if ((moduleName = ModulesCodeScannerValidator.tags.get(tagName.toLowerCase())) != null && moduleName.length() > 0 && !FelixUtil.installed((String)moduleName, null)) {
                throw new ServiceFactory.ModuleNotAvailableException(moduleName);
            }
            throw new TagClassNotFoundException(cnfe, tagInfo);
        }
        catch (Exception ex) {
            throw new TagClassNotFoundException(ex, tagInfo);
        }
    }

    Class getAttributeClass(TagInfo tagInfo, String attrName, Class handlerClass) throws ParseException {
        Method method = ASTruntimeCall.findMethod(handlerClass, "set" + attrName, 1);
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 1) {
            return types[0];
        }
        throw new TagAttributeNotFoundException(tagInfo, attrName);
    }

    TagAttributeInfo getAttributeInfo(TagInfo tagInfo, String attrName) throws TagAttributeNotFoundException {
        TagAttributeInfo[] attrs = tagInfo.getAttributes();
        for (int i = 0; attrs != null && i < attrs.length; ++i) {
            if (!attrs[i].getName().equalsIgnoreCase(attrName)) continue;
            return attrs[i];
        }
        throw new TagAttributeNotFoundException(tagInfo, attrName);
    }

    @Override
    public abstract void accept(JJTreeVisitor var1) throws ParseException;

    public boolean hasParent(String parent) {
        Node parentNode = this.jjtGetParent();
        if (parentNode instanceof TagNode) {
            return parent.equalsIgnoreCase(((TagNode)parentNode).getTagName());
        }
        return false;
    }

    void setEmpty() {
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isCalledFromScript() {
        return this.calledFromScript;
    }

    public void setCalledFromScript(boolean calledFromScript) {
        this.calledFromScript = calledFromScript;
    }

    Class getTagClass() {
        return this.tagClass;
    }

    Map distributeAttributes() throws ParseException {
        if (this.distributedAttrs != null) {
            return this.distributedAttrs;
        }
        Hashtable<String, ExprNode> result = null;
        Enumeration attrNames = this.getAttrNames();
        while (attrNames.hasMoreElements()) {
            try {
                String nextName = attrNames.nextElement().toString();
                if (!this.shouldDistribute(nextName)) continue;
                if (result == null) {
                    result = new Hashtable<String, ExprNode>();
                }
                result.put(nextName, this.getAttrNode(nextName));
                this.removeAttrNode(nextName);
            }
            catch (NoSuchElementException ex) {
                throw new CompilerInternalException((Object)ex);
            }
        }
        this.distributedAttrs = result;
        return result;
    }

    private boolean shouldDistribute(String attrName) {
        if (this.getTagName().equalsIgnoreCase("cfmail")) {
            return !attrName.equalsIgnoreCase("query") && !attrName.equalsIgnoreCase("startRow") && !attrName.equalsIgnoreCase("maxRows") && !attrName.equalsIgnoreCase("group") && !attrName.equalsIgnoreCase("groupCaseSensitive") && !attrName.equalsIgnoreCase("attributecollection");
        }
        return false;
    }

    public void prepareRuntimeAttrValidation(String switchAttrName) throws ParseException {
        StringBuffer attrList = new StringBuffer();
        Enumeration attrNames = this.getAttrNames();
        while (attrNames.hasMoreElements()) {
            attrList.append(attrNames.nextElement().toString().toLowerCase());
            if (!attrNames.hasMoreElements()) continue;
            attrList.append(",");
        }
        this.switchAttrList = attrList.toString();
        this.switchAttrName = switchAttrName;
        this.runtimeValidation = true;
    }

    public ParseException setStartLocation(ParseException pex) {
        Token tErr = pex._getErrorToken();
        if (tErr == null || tErr == this.getStartToken()) {
            pex.setStartToken(this.tagName);
        }
        return pex;
    }

    public boolean containsArgumentsAttr() {
        this.initAttr();
        return this.attrMap.containsKey("attributecollection");
    }

    boolean isDistributedTag() {
        return "cfmail".equalsIgnoreCase(this.getTagName());
    }

    public ASTtagAttribute getAttributeKeyNode(String attributeName) {
        if (this.attrList == null) {
            return null;
        }
        List<Node> children = this.attrList.getAllChildren();
        if (children == null) {
            return null;
        }
        for (Node child : children) {
            if (!(child instanceof ASTtagAttribute) || !((ASTtagAttribute)child).getName().equalsIgnoreCase(attributeName)) continue;
            return (ASTtagAttribute)child;
        }
        return null;
    }

    public static class InvalidAttributeValueException
    extends ParseException {
        public String attribute;
        public String strTag = "cfcomponent tag";

        InvalidAttributeValueException(String a, String t) {
            this.attribute = a;
            if (t != null) {
                this.strTag = t;
            }
        }
    }

    public static class IllegalRuntimeAttributeException
    extends ParseException {
        public String attribute;

        IllegalRuntimeAttributeException(Token t, String a) {
            super(t);
            this.attribute = a;
        }
    }
}

