/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.ParseException;
import coldfusion.util.BOMReader;
import coldfusion.util.EncodingDetector;
import coldfusion.util.IOUtils;
import coldfusion.util.RB;
import coldfusion.util.ReportDecoder;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class TemplateReader
extends BOMReader {
    private static final byte[] ID_HEADER = TemplateReader.toBytes("Allaire Cold Fusion Template\nHeader Size: ");
    private static final byte[] NEW_HEADER = TemplateReader.toBytes("Allaire Cold Fusion Template\nHeader Size: New Version");
    private static final byte[] CFENCODE_HEADER = TemplateReader.toBytes("Adobe Cold Fusion Template\nHeader Size: New Version2");
    private static final byte[] CFR_HEADER = TemplateReader.toBytes("ColdFusion Report Template");
    private static final byte[] CAFEBABE = new byte[]{-54, -2, -70, -66};
    private static final int BUFSIZE = 8192;
    private static Boolean readFullyForEncodingDetection = false;
    private static final String READ_FULLY_FOR_ENCODING_DETECTION = "coldfusion.compile.encoding.detect.readfully";
    private boolean isClasses = false;
    private boolean isReport = false;

    public TemplateReader(InputStream in) throws IOException {
        this(new BufferedInputStream(in, 8192));
    }

    public TemplateReader(BufferedInputStream in) throws IOException {
        if (this.startsWith(in, CAFEBABE)) {
            this.isClasses = true;
            in.reset();
            return;
        }
        if (this.startsWith(in, CFR_HEADER)) {
            this.removeHeader(in);
            in = this.getReport(in);
            this.isReport = true;
        } else if (this.startsWith(in, CFENCODE_HEADER) || this.startsWith(in, ID_HEADER) || this.startsWith(in, NEW_HEADER)) {
            throw new UnsupportedEncodingException(RB.getString(TemplateReader.class, "TemplateReader.invalidEncoding"));
        }
        String encoding = this.getBOMEncoding(in);
        if (encoding != null) {
            this.explicitEncodingSet = true;
        } else {
            EncodingDetector detector = new EncodingDetector(true);
            if (readFullyForEncodingDetection.booleanValue()) {
                byte[] pageBytes = IOUtils.toByteArray(in);
                encoding = detector.detectEncoding(pageBytes);
                ByteArrayInputStream stream = new ByteArrayInputStream(pageBytes);
                in = new BufferedInputStream(stream);
            } else {
                encoding = detector.detectEncoding(in);
            }
            String isDetectEncode = System.getProperty("file.usesystemencoding");
            if (isDetectEncode != null && isDetectEncode.equals("true")) {
                encoding = null;
            }
        }
        this.reader = encoding != null ? new InputStreamReader((InputStream)in, encoding) : new InputStreamReader(in);
        in.mark(8192);
        this.in = in;
    }

    private void removeHeader(InputStream in) throws IOException {
        int c = in.read();
        while (c != 26) {
            if (c == -1) {
                throw new EOFException("Header end character not found");
            }
            c = in.read();
        }
    }

    protected static byte[] toBytes(String s) {
        byte[] b = new byte[s.length()];
        s.getBytes(0, b.length, b, 0);
        return b;
    }

    private BufferedInputStream getReport(InputStream in) throws IOException {
        int count = 0;
        byte[] b1 = new byte[in.available()];
        int b = in.read();
        while (b != -1) {
            if (count == b1.length) {
                byte[] b2 = new byte[2 * count];
                System.arraycopy(b1, 0, b2, 0, count);
                b1 = b2;
            }
            b1[count++] = (byte)b;
            b = in.read();
        }
        in.close();
        try {
            byte[] o = ReportDecoder.getReport(b1);
            return new BufferedInputStream(new ByteArrayInputStream(o));
        }
        catch (Throwable e) {
            throw new IOException("Unable to execute report decoding function: " + e.toString());
        }
    }

    public void resetEncoding(String desiredEncoding) {
        this.resetEncoding(desiredEncoding, null);
    }

    public void resetEncoding(String desiredEncoding, NeoTranslationContext tc) {
        this.explicitEncodingSet = true;
        try {
            this.in.reset();
        }
        catch (IOException ex) {
            if (ex.getMessage().endsWith("invalid mark")) {
                try {
                    this.in = new BufferedInputStream(VFSFileFactory.getInputStream(tc.getPageFile().getAbsolutePath()), 8192);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            throw new InvalidInputStateException(ex);
        }
        try {
            this.reader = new InputStreamReader((InputStream)this.in, desiredEncoding);
        }
        catch (IOException ex) {
            throw new CompilerInternalException((Object)ex);
        }
    }

    public boolean isClasses() {
        return this.isClasses;
    }

    public boolean isReport() {
        return this.isReport;
    }

    static {
        String propertyValue = System.getProperty(READ_FULLY_FOR_ENCODING_DETECTION);
        if (propertyValue != null && propertyValue.length() > 0) {
            readFullyForEncodingDetection = Boolean.valueOf(propertyValue.trim());
        }
    }

    public class InvalidInputStateException
    extends ParseException {
        public Exception rootCause;

        public InvalidInputStateException(Exception rootCause) {
            this.rootCause = rootCause;
        }
    }
}

