/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.AccessModifier;
import coldfusion.compiler.ArrayStructInitializer;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.compiler.cfml40;
import java.util.StringTokenizer;

public abstract class VariableReference
extends ExprNode {
    static final int ARRAY_REFERENCE = 10000;
    static final int RUNTIME_CALL = 10001;
    static final int VARIABLE_REFERENCE = 10002;
    static final int STRUCT_REFERENCE = 10003;
    static final int LOCAL_REFERENCE = 10004;
    static final int STATIC_REFERENCE = 10005;
    static final int FIELD_REFERENCE = 10006;
    boolean isLeafReference = true;
    private VariableReference stem;
    private boolean isStatic = false;
    private boolean isStaticAccessor = false;
    private String accessorReference = "";
    private int accessModifier = 16;

    public void setAccessModifier(String s) {
        this.accessModifier = AccessModifier.getAccessModifier(s);
    }

    public int getAccessModifier() {
        return this.accessModifier;
    }

    protected VariableReference(int id) {
        super(id);
    }

    public VariableReference getStem() {
        return this.stem;
    }

    void setStem(VariableReference stem) {
        this.stem = stem;
        this.setNamedAttribute("STEM", stem);
    }

    @Override
    public void markStatic() {
        this.isStatic = true;
        if (this.stem != null) {
            this.stem.markStatic();
        }
    }

    public void markStaticAccessor(String accessorReference) {
        this.isStaticAccessor = true;
        this.accessorReference = accessorReference;
        if (this.stem != null) {
            this.stem.markStaticAccessor(accessorReference);
        }
    }

    public String getAccessorReference() {
        return this.accessorReference;
    }

    public boolean isStaticAccessor() {
        return this.isStaticAccessor;
    }

    static VariableReference createSimpleReference(Token t, VariableReference root, CFMLParserBase parser) {
        return VariableReference.resolveStructOperators(root, t, parser, false, false, false);
    }

    static VariableReference createSimpleReference(Token t, VariableReference root, CFMLParserBase parser, boolean isSafePreHook, boolean isSafePostHook) {
        return VariableReference.resolveStructOperators(root, t, parser, false, isSafePreHook, isSafePostHook);
    }

    static ASTarrayReference createArrayReference(Token t, ExprNode index, VariableReference root, CFMLParserBase parser, boolean isSafePreHook, boolean isSafePostHook) {
        return new ASTarrayReference(VariableReference.resolveStructOperators(root, t, parser, false, isSafePreHook, isSafePostHook), index, parser);
    }

    static ASTarrayReference createArrayReference(Token t, ExprNode index, VariableReference root, CFMLParserBase parser) {
        return new ASTarrayReference(VariableReference.resolveStructOperators(root, t, parser, false, false, false), index, parser);
    }

    static ASTarrayReference createArrayReference(ExprNode index, VariableReference root, CFMLParserBase parser) {
        return new ASTarrayReference(root, index, parser);
    }

    static VariableReference createMethodCall(Token t, ASTfuncparams param, VariableReference root, cfml40 parser) {
        return VariableReference.createMethodCall(t, param, root, parser, false, false);
    }

    static VariableReference createMethodCall(Token t, ASTfuncparams param, VariableReference root, cfml40 parser, boolean isSafePreHook, boolean isSafePostHook) {
        ASTruntimeCall result = (ASTruntimeCall)VariableReference.resolveStructOperators(root, t, parser, true, isSafePreHook, isSafePostHook);
        result.setArguments(param);
        return result;
    }

    static void createMethodCall(ArrayStructInitializer initializer, ASTfuncparams param, Token token, cfml40 parser) {
        ASTruntimeCall result = new ASTruntimeCall(token.image, token);
        result.jjtSetParent(initializer);
        result.setArguments(param);
        result.setParser(parser);
        initializer.addFunction(result);
    }

    static VariableReference createMethodCall(ExprNode expr, ASTfuncparams params, VariableReference root, cfml40 parser) {
        ASTruntimeCall result = new ASTruntimeCall(expr);
        expr.setParser(parser);
        if (expr instanceof ASTruntimeCall) {
            expr.setType(Object.class);
        }
        expr.jjtSetParent(root);
        result.setAssociativeArrayNotation(true);
        result.setParser(parser);
        result.setArguments(params);
        VariableReference.associateParent(root, result);
        return result;
    }

    static VariableReference createMethodCall(ExprNode exp, Token t1, ASTfuncparams param, cfml40 parser) {
        Token methodNameTok = Token.newToken(0);
        methodNameTok.image = "_createobject";
        ASTruntimeCall result = (ASTruntimeCall)VariableReference.resolveStructOperators(null, methodNameTok, parser, true, false, false);
        result.setArguments(param);
        result.setNew(true);
        if (exp != null) {
            result.setNamedAttribute("newCfcName", exp);
            result.setNewArgumentCfc(exp);
            exp.jjtSetParent(result);
            exp.setType(Object.class);
        } else {
            ASTliteral cfcName = new ASTliteral(t1.image);
            cfcName.setType(Object.class);
            result.setNewArgumentCfc(cfcName);
        }
        return result;
    }

    static VariableReference createMethodCallExtended(ExprNode exp, Token name, ASTfuncparams funcParams, cfml40 parser) {
        if (name != null) {
            if (name.image.equalsIgnoreCase("component")) {
                Node[] incomingParams = funcParams.children;
                if (incomingParams != null && incomingParams.length > 0) {
                    ExprNode cfcNameExpr = (ExprNode)incomingParams[0];
                    ASTfuncparams newFuncParams = new ASTfuncparams(28);
                    int insertedParamCount = 0;
                    for (int elemCount = 1; elemCount < incomingParams.length; ++elemCount) {
                        newFuncParams.jjtAddChild(incomingParams[elemCount], insertedParamCount);
                        ++insertedParamCount;
                    }
                    return VariableReference.createMethodCall(cfcNameExpr, null, newFuncParams, parser);
                }
                return VariableReference.createMethodCall(null, name, funcParams, parser);
            }
            Token methodNameTok = Token.newToken(0);
            methodNameTok.image = "createobject";
            ASTruntimeCall result = (ASTruntimeCall)VariableReference.resolveStructOperators(null, methodNameTok, parser, true, false, false);
            Node[] incomingParams = funcParams.children;
            funcParams.children = null;
            funcParams = new ASTfuncparams(28);
            int count = 0;
            if (name.image.equalsIgnoreCase("dotnet")) {
                name.image = ".NET";
            }
            ASTliteral objectTypeLiteral = new ASTliteral(name.image.trim());
            funcParams.jjtAddChild(objectTypeLiteral, count);
            if (incomingParams != null && incomingParams.length > 0) {
                ++count;
                for (Node param : incomingParams) {
                    funcParams.jjtAddChild(param, count);
                    ++count;
                }
            }
            result.setArguments(funcParams);
            return result;
        }
        return null;
    }

    private static VariableReference resolveStructOperators(VariableReference root, Token t, CFMLParserBase parser, boolean isMethodCall, boolean isSafePreHook, boolean isSafePostHook) {
        boolean isSimpleReference;
        VariableReference result = null;
        String functionName = null;
        boolean isStatic = false;
        boolean isWithinStaticBlock = parser.isWithinStaticBlock();
        if (parser.supportStatic() && t.image.toLowerCase().startsWith("static.")) {
            String string = t.image = t.image.length() > 7 ? t.image.substring(7) : "";
            if (t.image.isEmpty()) {
                throw new InvalidEndDotException(t);
            }
            isStatic = true;
        }
        if (!(!parser.supportStatic() || isStatic || !isWithinStaticBlock || VariableReference.isBuiltinScope(t.image) || isMethodCall && ASTruntimeCall.isBuiltinFunctionName(VariableReference.getFunctionName(t.image)))) {
            isStatic = true;
        }
        boolean hasNoDots = t.image.indexOf(46) == -1;
        boolean bl = isSimpleReference = hasNoDots && root == null;
        if (t.image.endsWith(".")) {
            throw new InvalidEndDotException(t);
        }
        if (hasNoDots && root == null) {
            ASTsimpleVariableReference resultTemp = new ASTsimpleVariableReference(t);
            if (isSafePreHook) {
                resultTemp.setSafePreHook(true);
            }
            result = resultTemp;
            if (isMethodCall) {
                functionName = t.image;
            }
        } else {
            int nStructKeys;
            StringTokenizer tokenizer = new StringTokenizer(t.image, ".");
            if (root == null) {
                Token tPrime = Token.copyToken(t);
                tPrime.image = VariableReference.nextToken(tokenizer);
                root = new ASTsimpleVariableReference(tPrime);
                if (isStatic) {
                    root.markStatic();
                }
            }
            if (tokenizer.countTokens() == 1 && isSafePostHook) {
                isSafePreHook = true;
            }
            int n = nStructKeys = isMethodCall ? tokenizer.countTokens() - 1 : tokenizer.countTokens();
            if (nStructKeys > 0) {
                String[] keys = new String[nStructKeys];
                for (int i = 0; i < nStructKeys; ++i) {
                    keys[i] = VariableReference.nextToken(tokenizer);
                }
                ASTstructureReference resultTemp = new ASTstructureReference(keys);
                if (!isMethodCall && isSafePreHook) {
                    resultTemp.setSafePreHook(isSafePreHook);
                }
                if (isSafePostHook) {
                    resultTemp.setSafePostHook(isSafePostHook);
                }
                result = resultTemp;
            }
            if (isMethodCall) {
                functionName = VariableReference.nextToken(tokenizer);
            }
        }
        if (root != null && result != null) {
            VariableReference.associateParent(root, result);
        }
        if (!isMethodCall && result == null) {
            throw new IllegalStateException("result == null");
        }
        if (isMethodCall) {
            ASTruntimeCall resultPrime = new ASTruntimeCall(functionName, t);
            resultPrime.setSimpleReference(isSimpleReference);
            if (isSafePreHook) {
                resultPrime.setSafePreHook(true);
            }
            if (isSafePostHook && hasNoDots) {
                resultPrime.setSafePostHook(true);
            }
            if (root == null && isSafePreHook) {
                resultPrime.setSafePostHook(true);
            }
            if (result != null) {
                VariableReference.associateParent(result, resultPrime);
            } else {
                if (root == null) {
                    Token tPrime = Token.copyToken(t);
                    tPrime.image = functionName;
                    ASTsimpleVariableReference rootTemp = new ASTsimpleVariableReference(tPrime);
                    rootTemp.setSafePreHook(isSafePreHook);
                    root = rootTemp;
                }
                VariableReference.associateParent(root, resultPrime);
            }
            result = resultPrime;
        }
        if (isStatic) {
            result.markStatic();
        }
        result.setParser(parser);
        result.setStartToken(t);
        return result;
    }

    public static boolean isBuiltinScope(String image) {
        String ref = "";
        if (image.indexOf(46) == -1) {
            ref = image;
        } else {
            StringTokenizer t = new StringTokenizer(image, ".");
            if (t.hasMoreElements()) {
                ref = t.nextToken();
            }
        }
        return ASTsimpleVariableReference.isBuiltinScopeName(ref);
    }

    private static String getFunctionName(String image) {
        if (image.indexOf(46) == -1) {
            return image;
        }
        StringTokenizer t = new StringTokenizer(image, ".");
        String func = null;
        while (t.hasMoreElements()) {
            func = t.nextToken();
        }
        return func;
    }

    private static String getStructKey(CFMLParserBase parser, StringTokenizer tokenizer) {
        return VariableReference.nextToken(tokenizer).toUpperCase();
    }

    @Override
    void setParser(CFMLParserBase p) {
        if (this.stem != null) {
            this.stem.setParser(p);
        }
        super.setParser(p);
    }

    @Override
    public void setNamedAttribute(String key, Node value) {
        super.setNamedAttribute(key, value);
        if ("STEM".equals(key) && value instanceof VariableReference) {
            this.stem = (VariableReference)value;
        }
    }

    private static void associateParent(VariableReference root, VariableReference leaf) {
        leaf.jjtSetParent(root.jjtGetParent());
        leaf.setStem(root);
        root.jjtSetParent(leaf);
        root.isLeafReference = false;
    }

    private static String nextToken(StringTokenizer tokenizer) {
        try {
            return tokenizer.nextToken();
        }
        catch (Exception ex) {
            throw ParseException.wrap(ex, null);
        }
    }

    protected boolean isTruelyStatic() {
        if (this.isStaticAccessor) {
            return true;
        }
        if (this.parser != null && !this.parser.supportStatic()) {
            return false;
        }
        return this.isStatic;
    }

    @Override
    public boolean isStatic() {
        if (this.isStaticAccessor) {
            return true;
        }
        if (this.parser != null && !this.parser.supportStatic()) {
            return false;
        }
        if (this.isStatic) {
            return true;
        }
        if (this.id == 10001 && ((ASTruntimeCall)this).isBuiltin()) {
            return false;
        }
        Node parent = this.jjtGetParent();
        if (parent != null) {
            return parent.isStatic();
        }
        return false;
    }

    public static class InvalidEndDotException
    extends ParseException {
        InvalidEndDotException(Token t) {
            super(t);
        }
    }
}

