/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler.validation;

import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.compiler.validation.CfmlDiagnosticInfo;
import coldfusion.runtime.TemplateException;

public abstract class CFMLValidationException
extends ParseException
implements CfmlDiagnosticInfo {
    public Throwable rootCause;
    public String location = "Code location is not available";
    private int beginLine = -1;
    private int endLine = -1;
    private String remedy;
    private String snippet = null;

    public CFMLValidationException() {
        super((Token)null);
    }

    public CFMLValidationException(Throwable rootCause) {
        this();
        this.rootCause = rootCause;
        if (rootCause instanceof ParseException) {
            ParseException pex = (ParseException)rootCause;
            this.errorToken = pex._getErrorToken();
            this._setPageFile(pex._getPageFile());
        }
    }

    @Override
    public Throwable getRootCause() {
        return this.rootCause;
    }

    @Override
    public String getDescription() {
        return this.getMessage() + this.getDetail();
    }

    @Override
    public String getSeverity() {
        return "Error";
    }

    @Override
    public String getRemedy() {
        if (this.remedy == null || this.remedy.isEmpty()) {
            return new RemedyMessageException().getMessage();
        }
        return this.remedy;
    }

    @Override
    public void setLineNumbers(int beginLine, int endLine) {
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.location = beginLine == endLine ? "line " + beginLine : "line " + beginLine + "-" + endLine;
    }

    @Override
    public void setLineNumbers(Node node) {
        Token token;
        int beginLine = -1;
        int endLine = -1;
        try {
            token = node.getStartToken();
            beginLine = token.beginLine;
            if (this.errorToken == null) {
                this.errorToken = token;
                this._setPageFile(node.getPageFile());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            token = node.getEndToken();
            endLine = token.endLine;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setLineNumbers(beginLine, endLine);
    }

    public void setRemedy(String s) {
        this.remedy = s;
    }

    @Override
    public int getBeginLine() {
        if (this.beginLine != -1 || this.errorToken == null) {
            return this.beginLine;
        }
        return this.getLine();
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public abstract String getFeatureName();

    @Override
    public abstract String getCategory();

    public static class RemedyMessageException
    extends TemplateException {
        RemedyMessageException() {
        }
    }
}

