/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public final class ExecutorUtils {
    public static int getActiveThreadCount(ExecutorService executor) {
        int defaultActive = 0;
        if (executor == null) {
            return defaultActive;
        }
        return ((ThreadPoolExecutor)executor).getActiveCount();
    }

    public static int getQueuedThreadCount(ExecutorService executor) {
        int defaultActive = 0;
        if (executor == null) {
            return defaultActive;
        }
        return ((ThreadPoolExecutor)executor).getQueue().size();
    }

    public static int getCurrentPoolSize(ExecutorService executor) {
        int defaultCurrentPoolSize = 0;
        if (executor == null) {
            return defaultCurrentPoolSize;
        }
        return ((ThreadPoolExecutor)executor).getPoolSize();
    }

    public static int getLargestPoolSize(ExecutorService executor) {
        int defaultLargestPoolSize = 0;
        if (executor == null) {
            return defaultLargestPoolSize;
        }
        return ((ThreadPoolExecutor)executor).getLargestPoolSize();
    }

    public static long getCompletedTaskCount(ExecutorService executor) {
        long defaultCompletedTasks = 0L;
        if (executor == null) {
            return defaultCompletedTasks;
        }
        return ((ThreadPoolExecutor)executor).getCompletedTaskCount();
    }

    public static long getTotalTaskCount(ExecutorService executor) {
        long defaultTotalTasks = 0L;
        if (executor == null) {
            return defaultTotalTasks;
        }
        return ((ThreadPoolExecutor)executor).getTaskCount();
    }
}

