/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debug.core;

import coldfusion.debug.core.Debugger;
import coldfusion.debug.core.EventTable;
import coldfusion.runtime.ExceptionInformation;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.OleDateTime;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.Table;
import coldfusion.tagext.net.HttpTag;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CFMLDebugger
implements Debugger {
    private EventTable table = new EventTable();
    private int COLCOUNT = new EventTable().getColumnCount();
    public int TYPE = this.table.findColumn("type") - 1;
    public int NAME = this.table.findColumn("name") - 1;
    public int TIMESTAMP = this.table.findColumn("timestamp") - 1;
    public int STARTTIME = this.table.findColumn("starttime") - 1;
    public int ENDTIME = this.table.findColumn("endtime") - 1;
    public int TEMPLATE = this.table.findColumn("template") - 1;
    public int PARENT = this.table.findColumn("parent") - 1;
    public int LINE = this.table.findColumn("line") - 1;
    public int URL = this.table.findColumn("url") - 1;
    public int RESULT = this.table.findColumn("result") - 1;
    public int DATASOURCE = this.table.findColumn("datasource") - 1;
    public int ROWCOUNT = this.table.findColumn("rowcount") - 1;
    public int CACHEDQUERY = this.table.findColumn("cachedquery") - 1;
    public int MESSAGE = this.table.findColumn("message") - 1;
    public int BODY = this.table.findColumn("body") - 1;
    public int CATEGORY = this.table.findColumn("category") - 1;
    public int PRIORITY = this.table.findColumn("priority") - 1;
    public int ATTRIBUTES = this.table.findColumn("attributes") - 1;
    public int STACKTRACE = this.table.findColumn("stacktrace") - 1;
    private DebuggingService ds = ServiceFactory.getDebuggingService();

    @Override
    public void cfoql(String statement, String type, List lIDs, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(5)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "ObjectQuery";
                col_data[this.NAME] = type;
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = new Long(startTime);
                col_data[this.ENDTIME] = new Long(endTime);
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = lIDs;
                col_data[this.DATASOURCE] = type == null ? "" : type;
                col_data[this.ROWCOUNT] = new Integer(lIDs.size());
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = statement;
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void exception(Throwable t) {
        try {
            if (this.ds.check(8)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "Exception";
                col_data[this.NAME] = t instanceof NeoException ? ((NeoException)t).getType() : t.getClass().getName();
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = "";
                col_data[this.ENDTIME] = "";
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = "";
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = t.getMessage();
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = t;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void executionTime(long startTime, long endTime) {
        try {
            if (this.ds.check(2)) {
                ExceptionInformation st = new ExceptionInformation(new Exception());
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "ExecutionTime";
                col_data[this.NAME] = "Execution Time";
                col_data[this.TIMESTAMP] = new OleDateTime(startTime);
                col_data[this.STARTTIME] = new Long(startTime);
                col_data[this.ENDTIME] = new Long(endTime);
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = "";
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void http(String url, HttpTag.HttpTagResponse resp, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(200)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "Http";
                col_data[this.NAME] = "";
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = new Long(startTime);
                col_data[this.ENDTIME] = new Long(endTime);
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = url == null ? "" : url;
                col_data[this.RESULT] = resp;
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void ormSql(String statement, Throwable t) {
        try {
            if (this.ds.isEnabled()) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "ORMSqlQuery";
                col_data[this.NAME] = "";
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = new Long(System.currentTimeMillis());
                col_data[this.ENDTIME] = new Long(System.currentTimeMillis());
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = new Table(0, 0);
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = statement;
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sql(String statement, String name, Object datasource, Throwable t, long startTime, long endTime) {
        this.sql(statement, name, datasource, new Table(0, 0), t, 0, startTime, endTime, false, new Vector());
    }

    @Override
    public void sql(String statement, String name, Object datasource, Table result, Throwable t, int count, long startTime, long endTime, boolean cached, Vector params) {
        try {
            if (this.ds.isEnabled()) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "SqlQuery";
                col_data[this.NAME] = name;
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = new Long(startTime);
                col_data[this.ENDTIME] = new Long(endTime);
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = result;
                col_data[this.DATASOURCE] = datasource == null ? "" : datasource;
                col_data[this.ROWCOUNT] = new Integer(count);
                col_data[this.CACHEDQUERY] = new Boolean(cached);
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = statement;
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = params;
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void storedproc(String proc, Object dsn, Vector results, Vector params, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(3)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "StoredProcedure";
                col_data[this.NAME] = proc;
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = new Long(startTime);
                col_data[this.ENDTIME] = new Long(endTime);
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = results;
                col_data[this.DATASOURCE] = dsn == null ? "" : dsn;
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = params;
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void trace(String priority, String category, String var, String text, Date timestamp, long delta) {
        try {
            if (this.ds.check(7)) {
                ExceptionInformation st = new ExceptionInformation(new Exception());
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "Trace";
                col_data[this.NAME] = "";
                col_data[this.TIMESTAMP] = timestamp;
                col_data[this.STARTTIME] = new Long(0L);
                col_data[this.ENDTIME] = new Long(delta);
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = var;
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = text == null ? "" : text;
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = category;
                col_data[this.PRIORITY] = priority;
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void trace(String priority, String category, String var, String text) {
        this.trace(priority, category, var, text, new OleDateTime(System.currentTimeMillis()), 0L);
    }

    @Override
    public void template(String child, long startTime, long endTime) {
        this.template(child, new Exception(), startTime, endTime);
    }

    @Override
    public void template(String child, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(1) && child.toLowerCase().indexOf("/web-inf/cftags/") == -1 && child.toLowerCase().indexOf("/web-inf/exception/") == -1 && child.toLowerCase().indexOf("/web-inf/debug/") == -1 && child.toLowerCase().indexOf("\\web-inf\\cftags\\") == -1 && child.toLowerCase().indexOf("\\web-inf\\exception\\") == -1 && child.toLowerCase().indexOf("\\web-inf\\debug\\") == -1) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "Template";
                col_data[this.NAME] = "";
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = new Long(startTime);
                col_data[this.ENDTIME] = new Long(endTime);
                col_data[this.TEMPLATE] = child;
                col_data[this.PARENT] = st.getTemplate();
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = "";
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = "";
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = st;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void unexpected(Throwable t) {
        try {
            if (this.ds.isEnabled()) {
                ExceptionInformation st = new ExceptionInformation(t);
                Object[] col_data = new Object[this.COLCOUNT];
                col_data[this.TYPE] = "Unexpected";
                col_data[this.NAME] = t instanceof NeoException ? ((NeoException)t).getType() : t.getClass().getName();
                col_data[this.TIMESTAMP] = new OleDateTime(System.currentTimeMillis());
                col_data[this.STARTTIME] = "";
                col_data[this.ENDTIME] = "";
                col_data[this.TEMPLATE] = st.getTemplate();
                col_data[this.PARENT] = "";
                col_data[this.LINE] = new Integer(st.getLine());
                col_data[this.URL] = "";
                col_data[this.RESULT] = "";
                col_data[this.DATASOURCE] = "";
                col_data[this.ROWCOUNT] = "";
                col_data[this.CACHEDQUERY] = Boolean.FALSE;
                col_data[this.MESSAGE] = t.getMessage();
                col_data[this.BODY] = "";
                col_data[this.CATEGORY] = "";
                col_data[this.PRIORITY] = "";
                col_data[this.ATTRIBUTES] = "";
                col_data[this.STACKTRACE] = t;
                this.addRow(col_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void userDefined(Map data) {
        try {
            Object[] col_data = new Object[this.COLCOUNT];
            col_data[this.TYPE] = data.get("type");
            col_data[this.NAME] = data.get("name");
            col_data[this.TIMESTAMP] = data.get("timestamp");
            col_data[this.STARTTIME] = data.get("starttime");
            col_data[this.ENDTIME] = data.get("endtime");
            col_data[this.TEMPLATE] = data.get("template");
            col_data[this.PARENT] = data.get("parent");
            col_data[this.LINE] = data.get("line");
            col_data[this.URL] = data.get("url");
            col_data[this.RESULT] = data.get("result");
            col_data[this.DATASOURCE] = data.get("datasource");
            col_data[this.ROWCOUNT] = data.get("rowcount");
            col_data[this.CACHEDQUERY] = data.get("cachedquery");
            col_data[this.MESSAGE] = data.get("message");
            col_data[this.BODY] = data.get("body");
            col_data[this.CATEGORY] = data.get("category");
            col_data[this.PRIORITY] = data.get("priority");
            col_data[this.ATTRIBUTES] = data.get("attributes");
            col_data[this.STACKTRACE] = data.get("stacktrace");
            this.addRow(col_data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addRow(Object[] row) {
        if (this.table == null) {
            this.table = new EventTable();
        }
        this.table.addRow(row);
    }

    @Override
    public Object getData() {
        return this.table == null ? new EventTable() : this.table;
    }
}

