/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.GatewayServices;
import coldfusion.util.RB;

public abstract class GenericGateway
implements Gateway {
    private String id;
    private GatewayServices svc = null;
    protected int status = 4;
    protected String[] listeners = null;

    @Override
    public String getGatewayID() {
        return this.id;
    }

    @Override
    public void setGatewayID(String id) {
        this.id = id;
    }

    @Override
    public void setCFCListeners(String[] listeners) {
        this.listeners = listeners;
    }

    @Override
    public GatewayHelper getHelper() {
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void start() {
        this.status = 1;
        try {
            this.startGateway();
            this.status = 2;
        }
        catch (Exception e) {
            this.svc.getLogger().error(RB.getString((Object)this, "GenericGateway.errorStarting", (Object)this.id, (Object)e.getLocalizedMessage()), e);
            this.status = 5;
        }
    }

    @Override
    public void stop() {
        this.status = 3;
        try {
            this.stopGateway();
            this.status = 4;
        }
        catch (Exception e) {
            this.svc.getLogger().error(RB.getString((Object)this, "GenericGateway.errorStopping", (Object)this.id, (Object)e.getLocalizedMessage()), e);
            this.status = 5;
        }
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    public GenericGateway(String gatewayID) {
        this.id = gatewayID;
        this.svc = GatewayServices.getGatewayServices();
    }

    protected abstract void startGateway() throws Exception;

    protected abstract void stopGateway() throws Exception;

    protected boolean sendMessage(CFEvent msg) {
        return this.svc.addEvent(msg);
    }

    protected GatewayServices getGatewayServices() {
        return this.svc;
    }

    protected String[] getListeners() {
        return this.listeners;
    }
}

