/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.featurerouter;

import coldfusion.featurerouter.FeatureRouter;
import coldfusion.util.DynamicSemaphore;

public class EFRContext {
    private static ThreadLocal ctxLocal = new ThreadLocal();
    private int cfThreadCreateCount = 0;
    private int cfThreadEndCount = 0;
    private boolean enterpriseLockTaken = false;
    private DynamicSemaphore cfThreadCountSemaphore = null;
    private boolean isRequestThreadEnd = false;

    public synchronized boolean isEnterpriseLockTaken() {
        return this.enterpriseLockTaken;
    }

    public synchronized void setEnterpriseLockTaken(boolean enterpriseLockTaken) {
        this.enterpriseLockTaken = enterpriseLockTaken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCFThreadLock() {
        EFRContext eFRContext = this;
        synchronized (eFRContext) {
            if (this.cfThreadCountSemaphore == null) {
                int maxThreads = FeatureRouter.getInstance().getServerEdition().getMaxSimultaneousCFThreads();
                if (maxThreads < 0) {
                    return;
                }
                this.cfThreadCountSemaphore = new DynamicSemaphore(maxThreads);
            }
        }
        try {
            this.cfThreadCountSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void releaseCFThreadLock() {
        if (this.cfThreadCountSemaphore != null) {
            this.cfThreadCountSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onCFThreadEnd() {
        this.releaseCFThreadLock();
        EFRContext eFRContext = this;
        synchronized (eFRContext) {
            ++this.cfThreadEndCount;
        }
        if (this.enterpriseLockTaken && this.isRequestThreadEnd && this.cfThreadCreateCount == this.cfThreadEndCount) {
            FeatureRouter.getInstance().getServerEdition().releaseEnterpriseFeatureLock();
        }
        EFRContext.setThreadLocal(null);
    }

    public synchronized void onRequestThreadEnd() {
        this.isRequestThreadEnd = true;
        if (this.enterpriseLockTaken && this.cfThreadCreateCount == this.cfThreadEndCount) {
            FeatureRouter.getInstance().getServerEdition().releaseEnterpriseFeatureLock();
        }
        EFRContext.setThreadLocal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCFThreadCreated() {
        EFRContext eFRContext = this;
        synchronized (eFRContext) {
            ++this.cfThreadCreateCount;
        }
    }

    public void onCFThreadStarted() {
        this.getCFThreadLock();
    }

    public static void setThreadLocal(EFRContext ctx) {
        ctxLocal.set(ctx);
    }

    public static EFRContext getThreadLocal() {
        Object obj = ctxLocal.get();
        if (obj == null) {
            return null;
        }
        return (EFRContext)obj;
    }
}

