/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.featurerouter;

import coldfusion.featurerouter.edition.ServerEdition;
import coldfusion.featurerouter.edition.ServerEditionFactory;
import coldfusion.log.CFLogs;
import coldfusion.runtime.EventListeners;
import coldfusion.server.ArchiveDeployService;
import coldfusion.server.MonitoringService;
import coldfusion.server.ServiceFactory;
import coldfusion.thread.CFThreadEventListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FeatureRouter
implements CFThreadEventListener {
    private static final FeatureRouter instance = new FeatureRouter();
    private ServerEdition edition = null;
    private String monitoringConfigPath = null;
    private Object[] securityServiceParams = null;
    private String archiveServiceConfigPath = null;
    private String rootDir;

    private FeatureRouter() {
        String editionName = "developer";
        if (null != ServiceFactory.getLicenseService()) {
            if (ServiceFactory.getLicenseService().isEnterprise()) {
                editionName = "enterprise";
            } else if (ServiceFactory.getLicenseService().isStandard()) {
                editionName = "standard";
            }
        }
        try {
            this.setEdition(editionName);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
        EventListeners.addCFThreadEventListener(this);
    }

    public static FeatureRouter getInstance() {
        return instance;
    }

    private void setEdition(String name) throws Exception {
        if (this.edition != null && this.edition.getEditionName().equalsIgnoreCase(name)) {
            return;
        }
        this.edition = ServerEditionFactory.createServerEdition(name);
        this.createRuntimeServices();
    }

    public void allowFeature(int featureCode, Map params) {
        this.allowFeature(featureCode, "", params);
    }

    private void checkEdition() {
        if (ServiceFactory.getLicenseService() == null) {
            CFLogs.SERVER_LOG.info("LicenseService is not yet initiated");
            return;
        }
        try {
            if (ServiceFactory.getLicenseService().isEnterprise()) {
                this.setEdition("enterprise");
            } else if (ServiceFactory.getLicenseService().isStandard()) {
                this.setEdition("standard");
            } else if (ServiceFactory.getLicenseService().isDeveloper()) {
                this.setEdition("developer");
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
    }

    public void allowFeature(int featureCode, String tagName, Map params) {
        this.edition.allowFeature(featureCode, tagName, params);
    }

    public void onRequestEnd(Map params) {
        this.edition.onRequestEnd(params);
    }

    public ServerEdition getServerEdition() {
        return this.edition;
    }

    @Override
    public void onCFThreadEnd(Throwable t) {
        this.edition.onCFThreadEnd();
    }

    public void onCFThreadCreated() {
        this.edition.onCFThreadCreated();
    }

    @Override
    public void onCFThreadStart() {
        this.edition.onCFThreadStarted();
    }

    public MonitoringService createMonitoringService(File config) {
        try {
            this.monitoringConfigPath = config.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.edition.createMonitoringService(config);
    }

    public boolean isFeatureAllowed(int featureCode) {
        return this.edition.isFeatureAllowed(featureCode);
    }

    public void onEditionChanged() {
        this.checkEdition();
    }

    public ArchiveDeployService createArchiveDeployService(File f, String rootDir) throws Exception {
        this.archiveServiceConfigPath = f.getCanonicalPath();
        return this.edition.createArchiveDeployService(f, rootDir);
    }

    private void createRuntimeServices() throws Exception {
        if (this.monitoringConfigPath != null) {
            File config = new File(this.monitoringConfigPath);
            MonitoringService monitoringService = this.edition.createMonitoringService(config);
            monitoringService.start();
            ServiceFactory.setMonitoringService(monitoringService);
        }
        if (this.archiveServiceConfigPath != null) {
            File f = new File(this.archiveServiceConfigPath);
            ArchiveDeployService service = this.edition.createArchiveDeployService(f, this.rootDir);
            service.start();
            ServiceFactory.setArchiveDeployService(service);
        }
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }
}

