/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.MetadataUtils;
import coldfusion.server.ServiceFactory;
import coldfusion.server.XmlRpcService;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.CFCServlet;
import coldfusion.xml.rpc.WebServiceUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;

public class AxisFilter
extends FusionFilter {
    private static final String WSVERSION = "wsversion";
    private CFCServlet servlet;
    private int method;
    public static final int GET = 1;
    public static final int POST = 2;

    public AxisFilter(CFCServlet servlet, int method) {
        super(null);
        this.servlet = servlet;
        this.method = method;
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        FusionContext oldContext = FusionContext.setCurrent(context);
        boolean oldMaps = context.setUseMappings(true);
        HttpServletRequest request = context.getRequest();
        try {
            ServiceFactory.getXmlRpcService(true);
            context.request.setAttribute("coldfusion.runtime.NeoPageContext", (Object)context.pageContext);
            String version = this.getAxisVersionToDeploy(context);
            if (version.equals("1")) {
                CFLogs.WEBSERVICE_LOG.info(RB.getString((Object)this, "AxisFilter.usingAxis1", (Object)request.getRequestURL().toString()));
                if (this.method == 1) {
                    this.servlet.doAxisGet(context.request, context.response);
                } else {
                    this.servlet.doAxisPost(context.request, context.response);
                }
            } else {
                context.pageContext.setFlushOutput(false);
                context.setAxis2Call();
                CFLogs.WEBSERVICE_LOG.info(RB.getString((Object)this, "AxisFilter.usingAxis2", (Object)request.getRequestURL().toString()));
                if (this.method == 1) {
                    this.servlet.doAxis2Get(context.request, context.response);
                } else {
                    this.servlet.doAxis2Post(context.request, context.response);
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ServiceFactory.ModuleNotAvailableException) {
                throw t;
            }
            throw new WebServiceInvocationException(t);
        }
        finally {
            context.setUseMappings(oldMaps);
            FusionContext.setCurrent(oldContext);
        }
    }

    private String getAxisVersionToDeploy(FusionContext context) throws Throwable {
        String engineVersion = null;
        HttpServletRequest request = context.getRequest();
        String path = Utils.getServletPath(request);
        if (path.endsWith(".jws")) {
            return "1";
        }
        AttributeCollection metadata = (AttributeCollection)MetadataUtils.getComponentMetadata(path = path.substring(0, path.length() - 4), context.pageContext, null);
        engineVersion = (String)metadata.get(WSVERSION);
        if (null == engineVersion) {
            engineVersion = this.getEngineVersionFromApplication(context);
        }
        if (null == engineVersion) {
            engineVersion = this.getEngineVersionFromServerConfiguration();
        }
        if (null == engineVersion) {
            engineVersion = "2";
        }
        this.validateEngineVersion(context, engineVersion);
        if (engineVersion.equals("2")) {
            request.setAttribute("cfcMetadata", (Object)metadata);
            String serviceName = (String)metadata.get("displayname");
            if (null != serviceName) {
                WebServiceUtil.registerServiceName(request.getRequestURL().toString(), serviceName);
            }
        }
        return engineVersion;
    }

    private String getEngineVersionFromServerConfiguration() {
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
        return xmlRpcService.getWSEngineVersion();
    }

    private String getEngineVersionFromApplication(FusionContext context) {
        Map version;
        Map wssettings;
        Map appSettings;
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(context.getApplicationName());
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null && null != (wssettings = (Map)appSettings.get("wssettings")) && null != (version = (Map)wssettings.get("version"))) {
            return (String)version.get("publish");
        }
        return null;
    }

    private void validateEngineVersion(FusionContext context, String engineVersion) {
        String engVersion = engineVersion.trim();
        if (!"1".equals(engVersion) && !"2".equals(engVersion)) {
            throw new InvalidWebServiceEngineVersionException(engineVersion, Utils.getServletPath(context.getRequest()));
        }
    }

    public static class WebServiceInvocationException
    extends ApplicationException {
        WebServiceInvocationException(Throwable t) {
            super(t);
        }
    }

    public static class InvalidWebServiceEngineVersionException
    extends ApplicationException {
        private String version;
        private String url;

        InvalidWebServiceEngineVersionException(String version, String url) {
            this.version = version;
            this.url = url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getURL() {
            return this.url;
        }
    }
}

