/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.CfincludeFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Map;

public class BrowserDebugFilter
extends FusionFilter {
    public static final String DEBUGBISCUIT = "coldfusion.filter.BrowserDebugFilter.biscuit";
    public static final String NODEBUGFLAG = "coldfusion.filter.BrowserDebugFilter.__noDebug";
    private static final Object biscuit = new Object();
    public static final String REQUEST_NODEBUG = "_cf_nodebug";

    public BrowserDebugFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        HttpServletRequest request = context.getRequest();
        long startTime = 0L;
        DebuggingService ds = ServiceFactory.getDebuggingService();
        if (ds == null) {
            return;
        }
        Map urlScope = (Map)context.hiddenScope.get("URL");
        String noDebugStr = (String)urlScope.get(REQUEST_NODEBUG);
        if (noDebugStr == null) {
            Map formScope = (Map)context.hiddenScope.get("FORM");
            noDebugStr = (String)formScope.get(REQUEST_NODEBUG);
        }
        boolean noDebug = noDebugStr != null && noDebugStr.trim().equalsIgnoreCase("true");
        request.setAttribute(NODEBUGFLAG, (Object)new Boolean(noDebug));
        boolean show = !noDebug && ds.isValidIP(request.getRemoteAddr()) && !Utils.getFileFromPath(request.getServletPath()).endsWith(".cfc");
        startTime = System.currentTimeMillis();
        if (show) {
            ds.reset(1);
        }
        this.next.invoke(context);
        if (!noDebug) {
            Boolean cfcNoDebug = null;
            if (context.getPagePath().toLowerCase().endsWith(".cfc")) {
                cfcNoDebug = ds.getShowAjaxDebug() ? Boolean.FALSE : Boolean.TRUE;
            }
            Boolean isIPPresentInAppSetting = ds.isValidIPInAppSetting(request.getRemoteAddr());
            if (cfcNoDebug != null && !cfcNoDebug.booleanValue()) {
                if (isIPPresentInAppSetting != null && isIPPresentInAppSetting.booleanValue() || isIPPresentInAppSetting == null && ds.isValidIP(request.getRemoteAddr())) {
                    show = Boolean.TRUE;
                }
            } else if (cfcNoDebug == null && isIPPresentInAppSetting != null) {
                show = isIPPresentInAppSetting;
            }
        }
        if (show) {
            if (ds.getDebugger() == null) {
                ds.reset(1);
            }
            ds.getDebugger().executionTime(startTime, System.currentTimeMillis());
            if (request.getAttribute(DEBUGBISCUIT) == null) {
                File debugTemplateFile;
                request.setAttribute(DEBUGBISCUIT, biscuit);
                String debugTemplatePath = ds.getDebugTemplate();
                if (debugTemplatePath != null && ds.getShowdebug() && (debugTemplateFile = new File(context.getRealPath(debugTemplatePath))).isFile()) {
                    new CfincludeFilter().include(debugTemplateFile.getPath(), context);
                }
            }
        }
        ds.reset();
    }
}

