/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.CachedBufferedOutputStream;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.io.cache.ehcache.EHcachePageInfo;
import coldfusion.tagext.io.cache.ehcache.GenericResponseWrapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;

public class CachingFilter
extends FusionFilter {
    private static Logger logger = CFLogs.SERVER_LOG;

    public CachingFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        GenericResponseWrapper wrapper = null;
        try {
            wrapper = new GenericResponseWrapper(context.getResponse());
            context.setServletObjects(context.servlet, (ServletRequest)context.request, (ServletResponse)wrapper);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.next.invoke(context);
        if (context.cacheConfig != null && wrapper != null && !wrapper.isOutputAutoFlushed()) {
            byte[] bodyInBytes = ((CachedBufferedOutputStream)wrapper.getOutputStream()).toByteArray();
            if (context.cacheConfig.stripWhitespace && wrapper.getContentType().indexOf("text/html") > -1) {
                try {
                    String tempBody = new String(bodyInBytes, wrapper.getCharacterEncoding());
                    tempBody = CacheTagHelper.stripWhiteSpaces(tempBody);
                    bodyInBytes = tempBody.getBytes(wrapper.getCharacterEncoding());
                }
                catch (Exception e) {
                    logger.error("Error occurred while removing whitespace from response", e);
                }
            }
            EHcachePageInfo newPage = new EHcachePageInfo(wrapper.getStatus(), wrapper.getContentType(), wrapper.getHeaders(), wrapper.getCookies(), bodyInBytes, false);
            GenericCache templateCache = GenericCacheFactory.getCache();
            CacheTO cacheTO = new CacheTO(context.cacheConfig.applicationName, "TEMPLATE", context.cacheConfig.cacheKey, newPage, context.cacheConfig.cacheTimeSpan, context.cacheConfig.cacheIdleTime, context.cacheConfig.cacheRegionKey, false, context.cacheConfig.directory);
            templateCache.put(cacheTO, false);
        }
        context.cacheConfig = null;
        if (wrapper != null) {
            wrapper.clear();
        }
    }
}

