/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.StringValidator;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.OleDate;
import coldfusion.runtime.OleTime;
import coldfusion.runtime.locale.CFLocaleBase;
import coldfusion.runtime.locale.CFLocaleDateFormatException;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.tagext.validation.CFIntegerValidator;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.tagext.validation.InvalidSimpleTypeException;
import coldfusion.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class FieldValidator {
    private static final int _DATE = 0;
    private static final int _EURODATE = 1;
    private static final int _FLOAT = 2;
    private static final int _INTEGER = 3;
    private static final int _RANGE = 4;
    private static final int _REQUIRED = 5;
    private static final int _TIME = 6;
    private static final int _CFFORMDATE = 7;
    private static final int _CFFORMEURODATE = 8;
    private static final int _CFFORMFLOAT = 9;
    private static final int _CFFORMINTEGER = 10;
    private static final int _CFFORMRANGE = 11;
    private static final int _CFFORMREQUIRED = 12;
    private static final int _CFFORMTIME = 13;
    private static final int _CFFORMCREDITCARD = 14;
    private static final int _CFFORMEMAIL = 15;
    private static final int _CFFORMSSN = 16;
    private static final int _CFFORMTELEPHONE = 17;
    private static final int _CFFORMZIPCODE = 18;
    private static final int _CFFORMURL = 19;
    private static final int _CFFORMREGEX = 20;
    private static final int _CFFORMREGULAR_EXPRESSIONS = 21;
    private static final int _CFFORMNOBLANKS = 22;
    private static final int _CFFORMMAXLENGTH = 23;
    private static final int _CFFORMUUID = 24;
    private static final int _CFFORMGUID = 25;
    private static final int _CFFORMBOOLEAN = 26;
    private static final int _CFFORMNUMERIC = 27;
    private static final int _CFFORMUSDATE = 28;
    public static final ArrayList suffixes = new ArrayList(29);
    static Pattern minPattern;
    static Pattern maxPattern;

    public static boolean isSpecialValidator(String fn) {
        String suffix;
        String fnUpper = fn.toUpperCase();
        int suffixIdx = fn.lastIndexOf("_");
        return suffixIdx != -1 && suffixes.contains(suffix = fnUpper.substring(suffixIdx));
    }

    public String validate(String validatorFieldName, String suffix, Map form) {
        Object errorString = "";
        String validatorFieldValue = form.get(validatorFieldName).toString();
        String baseFieldName = validatorFieldName.substring(0, validatorFieldName.length() - suffix.length());
        String baseFieldValue = form.containsKey(baseFieldName) ? form.get(baseFieldName).toString() : "";
        switch (suffixes.indexOf(suffix)) {
            case 5: 
            case 12: {
                if (baseFieldValue.length() != 0) break;
                if (validatorFieldValue.length() == 0) {
                    errorString = (String)errorString + new RequiredValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                    break;
                }
                errorString = (String)errorString + validatorFieldValue + "\n";
                break;
            }
            case 22: {
                if (baseFieldValue.trim().length() != 0) break;
                if (validatorFieldValue.length() == 0) {
                    errorString = (String)errorString + new RequiredValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                    break;
                }
                errorString = (String)errorString + validatorFieldValue + "\n";
                break;
            }
            case 23: {
                if (baseFieldValue.trim().length() <= Integer.parseInt(validatorFieldValue)) break;
                errorString = (String)errorString + new MaxLengthValidatorException(baseFieldName, validatorFieldValue).getMessage() + "\n";
                break;
            }
            case 0: 
            case 7: {
                CFTypeValidator validator;
                if (baseFieldValue.length() <= 0) break;
                try {
                    validator = CFTypeValidatorFactory.getExtendedValidator("DATE");
                    validator.validate(baseFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    if (validatorFieldValue.length() == 0) {
                        errorString = (String)errorString + new ValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                    errorString = (String)errorString + validatorFieldValue + "\n";
                }
                break;
            }
            case 1: 
            case 8: {
                CFTypeValidator validator;
                if (baseFieldValue.length() <= 0) break;
                try {
                    validator = CFTypeValidatorFactory.getExtendedValidator("EURODATE");
                    validator.validate(baseFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    if (validatorFieldValue.length() == 0) {
                        errorString = (String)errorString + new ValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                    errorString = (String)errorString + validatorFieldValue + "\n";
                }
                break;
            }
            case 28: {
                CFTypeValidator validator;
                if (baseFieldValue.length() <= 0) break;
                try {
                    validator = CFTypeValidatorFactory.getExtendedValidator("USDATE");
                    validator.validate(baseFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    if (validatorFieldValue.length() == 0) {
                        errorString = (String)errorString + new ValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                    errorString = (String)errorString + validatorFieldValue + "\n";
                }
                break;
            }
            case 20: 
            case 21: {
                CFTypeValidator validator;
                if (baseFieldValue.length() <= 0) break;
                try {
                    validator = CFTypeValidatorFactory.getExtendedValidator("REGEX");
                    validator.validate(baseFieldValue, validatorFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    errorString = (String)errorString + new RegExValidatorException(baseFieldName, validatorFieldValue).getMessage() + "\n";
                }
                break;
            }
            case 4: 
            case 11: {
                CFNumberValidator validator;
                Perl5Matcher maxMatcher;
                if (baseFieldValue.length() == 0) break;
                Double min = null;
                Double max = null;
                Perl5Matcher minMatcher = new Perl5Matcher();
                if (minMatcher.contains(validatorFieldValue, minPattern)) {
                    MatchResult result = minMatcher.getMatch();
                    if (result.groups() < 2) {
                        // empty if block
                    }
                    try {
                        String minString = result.group(1);
                        min = new Double(minString);
                    }
                    catch (Exception ex) {
                        errorString = (String)errorString + new RangeNotNumericException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                }
                if ((maxMatcher = new Perl5Matcher()).contains(validatorFieldValue, maxPattern)) {
                    MatchResult result = maxMatcher.getMatch();
                    if (result.groups() < 2) {
                        // empty if block
                    }
                    try {
                        String maxString = result.group(1);
                        max = new Double(maxString);
                    }
                    catch (Exception ex) {
                        errorString = (String)errorString + new RangeNotNumericException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                }
                if (min == null && max == null) {
                    errorString = (String)errorString + new RangeMissingException(baseFieldName, baseFieldValue).getMessage() + "\n";
                    break;
                }
                if (min == null && max != null) {
                    try {
                        validator = new CFNumberValidator();
                        validator.setUpperBound(false, max);
                        validator.validate(baseFieldValue);
                    }
                    catch (CFTypeValidationException ex) {
                        errorString = (String)errorString + new RangeValidatorException(baseFieldName, baseFieldValue, min, max).getMessage() + "\n";
                    }
                    break;
                }
                if (min != null && max == null) {
                    try {
                        validator = new CFNumberValidator();
                        validator.setLowerBound(false, min);
                        validator.validate(baseFieldValue);
                    }
                    catch (CFTypeValidationException ex) {
                        errorString = (String)errorString + new RangeValidatorException(baseFieldName, baseFieldValue, min, max).getMessage() + "\n";
                    }
                    break;
                }
                try {
                    validator = new CFNumberValidator();
                    validator.setLowerBound(false, min);
                    validator.setUpperBound(false, max);
                    validator.validate(baseFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    errorString = (String)errorString + new RangeValidatorException(baseFieldName, baseFieldValue, min, max).getMessage() + "\n";
                }
                break;
            }
            default: {
                CFTypeValidator validator;
                if (baseFieldValue.length() <= 0) break;
                try {
                    String type = suffix.substring(1);
                    validator = CFTypeValidatorFactory.getExtendedValidator(type);
                    if (validator == null && (validator = CFTypeValidatorFactory.getExtendedValidator(type = suffix.substring(7))) == null) {
                        throw new CFTypeValidationException();
                    }
                    validator.validate(baseFieldValue);
                }
                catch (InvalidSimpleTypeException ex) {
                    if (validatorFieldValue.length() == 0) {
                        errorString = (String)errorString + new NumberValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                    errorString = (String)errorString + validatorFieldValue + "\n";
                }
                catch (CFIntegerValidator.IntegerParseException ex) {
                    if (validatorFieldValue.length() == 0) {
                        errorString = (String)errorString + new IntegerValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                    errorString = (String)errorString + validatorFieldValue + "\n";
                }
                catch (CFTypeValidationException ex) {
                    if (validatorFieldValue.length() == 0) {
                        errorString = (String)errorString + new ValidatorException(baseFieldName, baseFieldValue).getMessage() + "\n";
                        break;
                    }
                    errorString = (String)errorString + validatorFieldValue + "\n";
                }
                break;
            }
        }
        switch (suffixes.indexOf(suffix)) {
            case 3: 
            case 10: {
                try {
                    if (baseFieldValue.length() > 0) {
                        String str = StringValidator.stripNumericNoise(baseFieldValue, true);
                        int intValue = Integer.parseInt(str);
                        form.put(baseFieldName, String.valueOf(intValue));
                        break;
                    }
                    form.put(baseFieldName, baseFieldValue);
                }
                catch (NumberFormatException ex) {
                    form.put(baseFieldName, baseFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    form.put(baseFieldName, baseFieldValue);
                }
                break;
            }
            case 2: 
            case 9: {
                try {
                    if (baseFieldValue.length() > 0) {
                        String str = StringValidator.stripNumericNoise(baseFieldValue, false);
                        double doubleValue = Double.parseDouble(str);
                        form.put(baseFieldName, String.valueOf(doubleValue));
                        break;
                    }
                    form.put(baseFieldName, baseFieldValue);
                }
                catch (NumberFormatException ex) {
                    form.put(baseFieldName, baseFieldValue);
                }
                catch (CFTypeValidationException ex) {
                    form.put(baseFieldName, baseFieldValue);
                }
                break;
            }
            case 0: 
            case 7: {
                OleDate date;
                if (baseFieldValue.length() > 0) {
                    try {
                        date = new OleDate(DateUtils.parseDateTime(baseFieldValue));
                        form.put(baseFieldName, date.toString());
                    }
                    catch (CFLocaleDateFormatException ex) {
                        form.put(baseFieldName, baseFieldValue);
                    }
                    catch (RuntimeException ex) {
                        form.put(baseFieldName, baseFieldValue);
                    }
                    break;
                }
                form.put(baseFieldName, baseFieldValue);
                break;
            }
            case 1: 
            case 8: {
                OleDate date;
                if (baseFieldValue.length() > 0) {
                    try {
                        date = new OleDate(CFLocaleMgr.getMgr().getCFLocale("English (UK)").ParseDateTime(baseFieldValue));
                        form.put(baseFieldName, date.toString());
                    }
                    catch (CFLocaleBase.InvalidDateTimeException ex) {
                        form.put(baseFieldName, baseFieldValue);
                    }
                    catch (RuntimeException ex) {
                        form.put(baseFieldName, baseFieldValue);
                    }
                    break;
                }
                form.put(baseFieldName, baseFieldValue);
                break;
            }
            case 6: 
            case 13: {
                if (baseFieldValue.length() > 0) {
                    try {
                        OleTime time = new OleTime(DateUtils.parseDateTime(baseFieldValue));
                        form.put(baseFieldName, ((Date)time).toString());
                    }
                    catch (CFLocaleDateFormatException ex) {
                        form.put(baseFieldName, baseFieldValue);
                    }
                    catch (RuntimeException ex) {
                        form.put(baseFieldName, baseFieldValue);
                    }
                    break;
                }
                form.put(baseFieldName, baseFieldValue);
                break;
            }
            default: {
                form.put(baseFieldName, baseFieldValue);
            }
        }
        return errorString;
    }

    static {
        suffixes.add(0, "_DATE");
        suffixes.add(1, "_EURODATE");
        suffixes.add(2, "_FLOAT");
        suffixes.add(3, "_INTEGER");
        suffixes.add(4, "_RANGE");
        suffixes.add(5, "_REQUIRED");
        suffixes.add(6, "_TIME");
        suffixes.add(7, "_CFFORMDATE");
        suffixes.add(8, "_CFFORMEURODATE");
        suffixes.add(9, "_CFFORMFLOAT");
        suffixes.add(10, "_CFFORMINTEGER");
        suffixes.add(11, "_CFFORMRANGE");
        suffixes.add(12, "_CFFORMREQUIRED");
        suffixes.add(13, "_CFFORMTIME");
        suffixes.add(14, "_CFFORMCREDITCARD");
        suffixes.add(15, "_CFFORMEMAIL");
        suffixes.add(16, "_CFFORMSSN");
        suffixes.add(17, "_CFFORMTELEPHONE");
        suffixes.add(18, "_CFFORMZIPCODE");
        suffixes.add(19, "_CFFORMURL");
        suffixes.add(20, "_CFFORMREGEX");
        suffixes.add(21, "_CFFORMREGULAR_EXPRESSIONS");
        suffixes.add(22, "_CFFORMNOBLANKS");
        suffixes.add(23, "_CFFORMMAXLENGTH");
        suffixes.add(24, "_CFFORMUUID");
        suffixes.add(25, "_CFFORMGUID");
        suffixes.add(26, "_CFFORMBOOLEAN");
        suffixes.add(27, "_CFFORMNUMERIC");
        suffixes.add(28, "_CFFORMUSDATE");
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            minPattern = compiler.compile("MIN=([^, ]+)", 32769);
            maxPattern = compiler.compile("MAX=([^, ]+)", 32769);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
        }
    }

    public static class RequiredValidatorException
    extends ValidatorException {
        public RequiredValidatorException(String name, String value) {
            super(name, value);
        }
    }

    public static class MaxLengthValidatorException
    extends ValidatorException {
        public MaxLengthValidatorException(String name, String value) {
            super(name, value);
        }
    }

    public static class ValidatorException
    extends NeoException {
        public String name;
        public String value;

        public ValidatorException(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class RegExValidatorException
    extends ValidatorException {
        public RegExValidatorException(String name, String value) {
            super(name, value);
        }
    }

    public static class RangeNotNumericException
    extends ValidatorException {
        public RangeNotNumericException(String name, String value) {
            super(name, value);
        }
    }

    public static class RangeMissingException
    extends ValidatorException {
        public RangeMissingException(String name, String value) {
            super(name, value);
        }
    }

    public static class RangeValidatorException
    extends ValidatorException {
        public String min;
        public String max;
        private String greaterMsg;
        private String lesserMsg;

        public RangeValidatorException(String name, String value, Double min, Double max) {
            super(name, value);
            if (min != null || max == null) {
                // empty if block
            }
            if (min != null) {
                this.min = min.toString();
            }
            if (max != null) {
                this.max = max.toString();
            }
        }

        @Override
        public String getMessage() {
            if (this.min != null && this.max != null) {
                if (this.msg == null) {
                    this.msg = RangeValidatorException.getString(this, "message", this.locale);
                }
                return this.msg;
            }
            if (this.min != null) {
                if (this.greaterMsg == null) {
                    this.greaterMsg = RangeValidatorException.getString(this, "messageGreater", this.locale);
                }
                return this.greaterMsg;
            }
            if (this.lesserMsg == null) {
                this.lesserMsg = RangeValidatorException.getString(this, "messageLesser", this.locale);
            }
            return this.lesserMsg;
        }
    }

    public static class NumberValidatorException
    extends ValidatorException {
        public NumberValidatorException(String name, String value) {
            super(name, value);
        }
    }

    public static class IntegerValidatorException
    extends ValidatorException {
        public IntegerValidatorException(String name, String value) {
            super(name, value);
        }
    }
}

