/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FieldValidator;
import coldfusion.filter.FormValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.filter.GridFieldProcessor;
import coldfusion.log.CFLogs;
import coldfusion.pdf.core.PDFFormFieldNamesConverter;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Struct;
import coldfusion.runtime.Variable;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.FastHashtable;
import coldfusion.util.Hex;
import coldfusion.util.Key;
import coldfusion.util.OrderedProperties;
import coldfusion.util.RB;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.entity.ContentType;

public class FormScope
extends LocalScope {
    private MultipartParser parser;
    private List partsArray = null;
    private InputStream sis = null;
    private static boolean markResetForMultipart = Boolean.getBoolean("coldfusion.markResetForMultiPart");
    private static boolean bufferOctetStream = Boolean.getBoolean("coldfusion.bufferoctetstream");
    private boolean serverSideFormValidationDefault = true;
    private String charset = RuntimeServiceImpl.getDefaultCharset();
    private FastHashtable tempFileFHt;
    private OrderedProperties postHt;

    public void setEncoding(String charset, HttpServletRequest request, ServletContext application) throws IOException {
        this.charset = charset;
        try {
            if (this.sis != null) {
                if (this.sis.markSupported()) {
                    this.sis.reset();
                    this.clear();
                    this.fillMultipart(request);
                    this.fillForm(request, application);
                    this.processSpecialFields();
                } else {
                    this.parseHTMLFormData();
                    this.processSpecialFields();
                }
            } else {
                List parts;
                if (!this.getEncoding().equalsIgnoreCase(RuntimeServiceImpl.getDefaultCharset()) && (parts = this.getPartsArray()) != null) {
                    Part part;
                    int i;
                    for (i = 0; i < parts.size(); ++i) {
                        part = (Part)parts.get(i);
                        if (part.isFile()) continue;
                        this.table.remove(Key.getInstance(part.getName()));
                    }
                    for (i = 0; i < parts.size(); ++i) {
                        part = (Part)parts.get(i);
                        if (!part.isFile()) {
                            this.populateFieldValues(part.getName().toUpperCase(), ((ParamPart)part).getStringValue(this.getEncoding()));
                            continue;
                        }
                        FilePart fp = (FilePart)part;
                        String encDispInfo = fp.getEncodedBytes(this.getEncoding());
                        String[] dispInfo = this.parser.extractDispositionInfo(encDispInfo);
                        fp.setFileName(dispInfo[2]);
                        fp.setFilePath(dispInfo[3]);
                    }
                }
                this.parseHTMLFormData();
                this.processSpecialFields();
            }
            FormScope.reProcessFormScope();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.sis = null;
        }
    }

    public void setEncoding(String charset) {
        this.charset = charset;
    }

    public String getEncoding() {
        return this.charset;
    }

    public FastHashtable getTempFiles() {
        if (this.tempFileFHt == null) {
            this.tempFileFHt = new FastHashtable();
        }
        return this.tempFileFHt;
    }

    public static FormScope getFormScope() {
        return FusionContext.getCurrent().formScope;
    }

    public static void reProcessFormScope() {
        FormScope fs = FusionContext.getCurrent().formScope;
        if (fs == null) {
            return;
        }
        boolean bSameNameFieldAsArraySetting = false;
        Object sameNameFieldAsArraySetting = AppHelper.getApplicationSetting("sameformfieldsasarray");
        if (sameNameFieldAsArraySetting != null) {
            try {
                bSameNameFieldAsArraySetting = Cast._boolean(sameNameFieldAsArraySetting);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (String fieldName : fs.keySet()) {
            Object fieldValue = fs.get(fieldName);
            if (!(fieldValue instanceof List)) continue;
            List fieldList = (List)fieldValue;
            ArrayList<String> fieldFinalValuesList = new ArrayList<String>();
            for (int index = 0; index < fieldList.size(); ++index) {
                Object OfieldItemVal = fieldList.get(index);
                if (OfieldItemVal == null) continue;
                String string = OfieldItemVal.toString();
                if (!bSameNameFieldAsArraySetting && (string.trim().length() <= 0 && index != 0 || string.length() <= 0)) continue;
                fieldFinalValuesList.add(string);
            }
            if (bSameNameFieldAsArraySetting) {
                Array valArray = new Array();
                for (Object e : fieldFinalValuesList) {
                    valArray.add(e);
                }
                fs.put(fieldName, (Object)valArray);
                continue;
            }
            fs.put(fieldName, (Object)String.join((CharSequence)",", fieldFinalValuesList));
        }
        Object serverSideFormValidation = AppHelper.getApplicationSetting("serverSideFormValidation");
        if (fs.isServerSideFormValidationDefault() && (serverSideFormValidation == null || Cast._boolean(serverSideFormValidation)) || !fs.isServerSideFormValidationDefault() && serverSideFormValidation != null && Cast._boolean(serverSideFormValidation)) {
            String fieldsString = (String)fs.get("FIELDNAMES");
            if (fieldsString == null) {
                return;
            }
            StringBuffer fieldNames = new StringBuffer();
            StringTokenizer st = new StringTokenizer(fieldsString, ",");
            boolean foundSpecialValidatorField = false;
            while (st.hasMoreTokens()) {
                String field = st.nextToken();
                if (FieldValidator.isSpecialValidator(field)) continue;
                if (fieldNames.length() > 0) {
                    fieldNames.append(',');
                }
                fieldNames.append(field);
                foundSpecialValidatorField = true;
            }
            if (foundSpecialValidatorField) {
                fs.put("FIELDNAMES", (Object)fieldNames.toString());
            }
        }
    }

    void fillMultipart(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
            Object bufferredRequest = request;
            if (markResetForMultipart) {
                bufferredRequest = FusionContext.getCurrent().getBufferedRequest();
                this.sis = bufferredRequest.getInputStream();
                int contentLength = request.getContentLength();
                if (this.sis.markSupported()) {
                    this.sis.mark(contentLength * 2);
                }
            }
            RuntimeService runtimeService = ServiceFactory.getRuntimeService();
            String postSize = bufferredRequest.getParameter("MAX_FILE_SIZE");
            long size = (long)runtimeService.getPostSizeLimit() * 1024L * 1024L;
            if (postSize != null && !postSize.trim().equals("")) {
                try {
                    size = Long.parseLong(postSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.parser = new MultipartParser((HttpServletRequest)bufferredRequest, size);
        }
    }

    /*
     * Unable to fully structure code
     */
    void fillForm(HttpServletRequest request, ServletContext application) throws IOException {
        try {
            if ("post".equalsIgnoreCase(request.getMethod())) {
                contentString = "";
                ct = request.getContentType();
                if (ct != null) {
                    contentType = ContentType.parse((String)ct);
                    contentString = contentType.getMimeType();
                    cs = contentType.getCharset();
                    if (cs != null) {
                        this.setEncoding(cs.toString());
                    }
                }
                if (contentString.equalsIgnoreCase("multipart/form-data")) {
                    this.serverSideFormValidationDefault = false;
                    fieldNames = new StringBuffer();
                    tempDir = (File)application.getAttribute("jakarta.servlet.context.tempdir");
                    if (this.parser != null) {
                        encoding = this.getEncoding();
                        this.parser.setEncoding(encoding);
                        tempFileArray = null;
                        while ((part = this.parser.readNextPart()) != null) {
                            if (this.partsArray == null) {
                                this.partsArray = new ArrayList<E>();
                            }
                            this.partsArray.add(part);
                            field = part.getName().toUpperCase();
                            if (part.isFile()) {
                                tempFile = File.createTempFile("neotmp", ".tmp", tempDir);
                                try {
                                    ((FilePart)part).writeTo(tempFile);
                                    fieldTempFile = this.getTempFiles().get(field);
                                    if (fieldTempFile != null) {
                                        if (fieldTempFile instanceof FastArray) {
                                            tempFileArray = (FastArray)fieldTempFile;
                                        } else {
                                            tempFileArray = new Array();
                                            tempFileArray.add(fieldTempFile);
                                        }
                                        tempFileArray.add(tempFile);
                                        this.getTempFiles().put(field, (Object)tempFileArray);
                                        if (((FilePart)part).getFileName() == null) ** GOTO lbl57
                                        this.populateFieldValues(field, tempFile.getCanonicalPath());
                                    }
                                    this.getTempFiles().put(field, (Object)tempFile);
                                    if (((FilePart)part).getFileName() != null) {
                                        this.populateFieldValues(field, tempFile.getCanonicalPath());
                                    }
                                    this.populateFieldValues(field, "");
                                }
                                catch (IOException e) {
                                    tempFile.delete();
                                    throw e;
                                }
                            } else {
                                this.populateFieldValues(field, ((ParamPart)part).getStringValue());
                            }
lbl57:
                            // 5 sources

                            if (fieldNames.length() > 0) {
                                fieldNames.append(',');
                            }
                            fieldNames.append(field);
                        }
                    }
                    this.put("FIELDNAMES", (Object)fieldNames.toString());
                    if (FormScope.markResetForMultipart && this.sis != null && this.sis.markSupported()) {
                        this.sis.reset();
                    }
                } else if (contentString.equalsIgnoreCase("application/x-www-form-urlencoded")) {
                    bufferedRequest = FusionContext.getCurrent().getBufferedRequest();
                    requestContent = FusionContext.getCurrent().getRequestContent();
                    if (requestContent.length == 0) {
                        return;
                    }
                    this.sis = new ByteArrayInputStream(requestContent);
                    sisLen = request.getContentLength();
                    if (ServerlessUtil.isLambdaEnv() && sisLen < 0) {
                        sisLen = requestContent.length;
                    }
                    if (this.sis.markSupported()) {
                        this.sis.mark(sisLen * 2);
                    }
                    this.postHt = this.parsePostData(sisLen, this.sis);
                    parameterMap = new HashMap<String, String[]>(this.postHt.size());
                    for (Object name : this.postHt.keySet()) {
                        parameterMap.put(name.toString(), (String[])this.postHt.get(name));
                    }
                    bufferedRequest.setParameterMap(parameterMap);
                    this.parseHTMLFormData();
                    this.manipulatePDFHTTPPost(request);
                } else if (FormScope.bufferOctetStream && contentString.equalsIgnoreCase("application/octet-stream")) {
                    this.serverSideFormValidationDefault = false;
                    bufferedRequest = FusionContext.getCurrent().getBufferedRequest();
                    requestContent = FusionContext.getCurrent().getRequestContent();
                    if (requestContent.length == 0) {
                        return;
                    }
                    this.sis = new ByteArrayInputStream(requestContent);
                    sisLen = request.getContentLength();
                    if (this.sis.markSupported()) {
                        this.sis.mark(sisLen * 2);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.sendBadRequest(e);
        }
    }

    private OrderedProperties parsePostData(int len, InputStream in) throws IOException {
        if (len <= 0) {
            return new OrderedProperties();
        }
        if (in == null) {
            throw new IllegalArgumentException();
        }
        byte[] postedBytes = new byte[len];
        try {
            int inputLen;
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = "err.io.short_read";
                throw new IllegalArgumentException(msg);
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            String postedBody = new String(postedBytes, 0, len, this.getEncoding());
            return this.parseQueryString(postedBody);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void sendBadRequest(IllegalArgumentException e) throws IOException {
        HttpServletResponse response = FusionContext.getCurrent().getResponse();
        CFLogs.SERVER_LOG.error(e);
        String error = e.getMessage();
        if (error != null) {
            response.sendError(400, error);
        } else {
            response.sendError(400);
        }
    }

    private OrderedProperties parseQueryString(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        OrderedProperties ht = new OrderedProperties();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        int postParamLimit = ServiceFactory.getRuntimeService().getPostParametersLimit();
        while (st.hasMoreTokens()) {
            String[] valArray;
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = FormScope.parseName(pair.substring(0, pos), sb);
            String val = FormScope.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (ht.containsKey(key)) {
                String[] oldVals = (String[])ht.get(key);
                if (key.startsWith("__CFGRID") && val.equals("")) continue;
                valArray = new String[oldVals.length + 1];
                System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                valArray[oldVals.length] = val;
            } else {
                if (key.startsWith("__CFGRID") && val.equals("")) continue;
                valArray = new String[]{val};
            }
            ht.put(key, valArray);
            if (ht.size() <= postParamLimit) continue;
            String error = RB.getString(this, "FormScope.postParamLimitExceeded");
            String logError = RB.getString((Object)this, "FormScope.postParamLimitExceededLogs", postParamLimit);
            CFLogs.SERVER_LOG.error(logError);
            HttpServletResponse response = FusionContext.getCurrent().getResponse();
            response.sendError(400, error);
            break;
        }
        return ht;
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        int length = s.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block4;
                }
                case '%': {
                    if (i + 1 == length) {
                        sb.append('%');
                        continue block4;
                    }
                    if (i + 2 == length) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        ++i;
                        continue block4;
                    }
                    String hex = s.substring(i + 1, i + 3);
                    if (Hex.isHexString(hex)) {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block4;
                    }
                    sb.append('%');
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private void parseHTMLFormData() {
        StringBuffer fieldNames = new StringBuffer();
        HashSet<String> hFieldNames = new HashSet<String>();
        if (this.postHt != null) {
            this.clear();
            try {
                Enumeration eParameters = this.postHt.propertyNames();
                while (eParameters.hasMoreElements()) {
                    List sciptProtect;
                    String parameter_name = (String)eParameters.nextElement();
                    String[] parameters = (String[])this.postHt.get(parameter_name);
                    if (parameters == null) continue;
                    Array paramValueList = null;
                    if (parameters.length >= 2) {
                        paramValueList = new Array(1);
                    }
                    StringBuffer parameter = new StringBuffer();
                    for (int i = 0; i < parameters.length; ++i) {
                        if (paramValueList != null) {
                            ((FastArray)paramValueList).add(this.convert(parameters[i]));
                            continue;
                        }
                        parameter.append(this.convert(parameters[i]));
                    }
                    if (paramValueList != null && paramValueList.size() == 1 && parameters.length <= 1) {
                        parameter.append(paramValueList.get(0));
                        paramValueList = null;
                    }
                    String field = this.convert(parameter_name).toUpperCase();
                    String paramValue = parameter.toString();
                    FusionContext ctx = FusionContext.getCurrent();
                    if (ctx != null && (sciptProtect = ctx.getScriptProtect()) != null && sciptProtect.contains("FORM")) {
                        paramValue = ServiceFactory.getSecurityService().crossSiteProtectString(paramValue);
                    }
                    if (!this.table.containsKey(Key.getInstance(field))) {
                        if (paramValueList != null) {
                            this.put(field, (Object)paramValueList);
                        } else {
                            this.put(field, (Object)paramValue);
                        }
                    } else {
                        Object finalParams = this.get(field);
                        if (finalParams instanceof FastArray) {
                            if (paramValueList != null) {
                                ((FastArray)finalParams).addAll((Collection)paramValueList);
                            } else {
                                ((FastArray)finalParams).add(paramValue);
                            }
                        } else if (paramValueList != null) {
                            if (paramValueList.size() > 0) {
                                ArrayUtil.ArrayInsertAt(paramValueList, 1, finalParams);
                            }
                            finalParams = paramValueList;
                        } else {
                            finalParams = CFPage.ListToArray(finalParams + "," + paramValue);
                        }
                        this.put(field, finalParams);
                    }
                    if (hFieldNames.contains(field)) continue;
                    if (fieldNames.length() > 0) {
                        fieldNames.append(',');
                    }
                    fieldNames.append(field);
                    hFieldNames.add(field);
                }
            }
            catch (IllegalArgumentException e) {
                CFLogs.SERVER_LOG.error(e);
            }
            catch (UnsupportedEncodingException ex) {
                throw new UnsupportedCharacterEncodingException(this.charset);
            }
        }
        if (fieldNames.toString().length() > 0) {
            this.put("FIELDNAMES", (Object)fieldNames.toString());
        }
    }

    @Override
    public synchronized void clear() {
        this.table.clear();
        if (this.partsArray != null) {
            this.partsArray.clear();
        }
        if (this.tempFileFHt != null) {
            Enumeration en = this.tempFileFHt.elements();
            while (en.hasMoreElements()) {
                Object element = en.nextElement();
                if (element instanceof File) {
                    File f = (File)element;
                    f.delete();
                    continue;
                }
                if (!(element instanceof FastArray)) continue;
                FastArray arr = (FastArray)element;
                Iterator itr = arr.iterator();
                while (itr.hasNext()) {
                    ((File)itr.next()).delete();
                }
            }
        }
    }

    public List getPartsArray() {
        return this.partsArray;
    }

    public void processSpecialFields() {
        if (this.table.size() == 0) {
            return;
        }
        ArrayList validatorErrors = new ArrayList();
        Object[] keys = this.table.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            int formNameEnd;
            String fieldName = ((Key)keys[i]).getUCasedString();
            if (fieldName.startsWith("__CFGRID__")) {
                GridFieldProcessor.decode(this, fieldName);
                continue;
            }
            if (fieldName.startsWith("__CFTEXT__")) {
                if (fieldName.length() < 14) {
                    throw new CorruptFieldException("cftextinput", fieldName);
                }
                formNameEnd = fieldName.indexOf("__", 10);
                if (formNameEnd == -1 || fieldName.length() <= formNameEnd + 2 || !fieldName.substring(formNameEnd, formNameEnd + 2).equals("__")) {
                    throw new CorruptFieldException("cftextinput", fieldName);
                }
                String textinputName = fieldName.substring(formNameEnd + 2);
                if (textinputName.length() == 0) {
                    throw new CorruptFieldException("cftextinput", fieldName);
                }
                this.put(textinputName, (Object)this.get(fieldName).toString());
                continue;
            }
            if (!fieldName.startsWith("__CFSLIDER__")) continue;
            if (fieldName.length() < 16) {
                throw new CorruptFieldException("cfslider", fieldName);
            }
            formNameEnd = fieldName.indexOf("__", 12);
            if (formNameEnd == -1 || fieldName.length() <= formNameEnd + 2 || !fieldName.substring(formNameEnd, formNameEnd + 2).equals("__")) {
                throw new CorruptFieldException("cfslider", fieldName);
            }
            String sliderName = fieldName.substring(formNameEnd + 2);
            if (sliderName.length() == 0) {
                throw new CorruptFieldException("cfslider", fieldName);
            }
            this.put(sliderName, (Object)this.get(fieldName).toString());
        }
        if (validatorErrors.size() > 0) {
            throw new FormValidationException(validatorErrors);
        }
    }

    public void processServerSideValidation() {
        if (this.table.size() == 0) {
            return;
        }
        FieldValidator fieldValidator = null;
        ArrayList<String> validatorErrors = new ArrayList<String>();
        Iterator iter = this.table.keySet().iterator();
        while (iter.hasNext()) {
            String errorString;
            String suffix;
            String fieldName = ((Key)iter.next()).getUCasedString();
            if (fieldName.length() < 6 || fieldName.indexOf("_") == -1 || !FieldValidator.suffixes.contains(suffix = fieldName.substring(fieldName.lastIndexOf("_")).toUpperCase())) continue;
            String baseFieldName = fieldName.substring(0, fieldName.length() - suffix.length());
            if (this.table.containsKey(Key.getInstance(baseFieldName))) {
                if (fieldValidator == null) {
                    fieldValidator = new FieldValidator();
                }
                if ((errorString = fieldValidator.validate(fieldName, suffix, this)).length() <= 0) continue;
                validatorErrors.add(errorString);
                continue;
            }
            if (!suffix.equalsIgnoreCase("_REQUIRED")) continue;
            errorString = this.get(fieldName).toString();
            if (errorString.length() == 0) {
                errorString = new FieldValidator.RequiredValidatorException(baseFieldName, "").getMessage();
            }
            validatorErrors.add(errorString);
        }
        if (validatorErrors.size() > 0) {
            throw new FormValidationException(validatorErrors);
        }
    }

    private void manipulatePDFHTTPPost(HttpServletRequest request) {
        if (request.getHeader("Acrobat-Version") != null) {
            Variable fieldnames = this.getBacking().get(Key.getInstance("FIELDNAMES"));
            String fieldNamesValue = null;
            if (fieldnames != null) {
                fieldNamesValue = (String)fieldnames.getValue();
            }
            if (fieldNamesValue != null && (fieldNamesValue.indexOf(35) != -1 || fieldNamesValue.indexOf(91) != -1)) {
                PDFFormFieldNamesConverter pdfFormFieldNamesConverter = new PDFFormFieldNamesConverter();
                FormScope clonedFormScope = new FormScope();
                clonedFormScope.cloneScope(this);
                StringBuffer modFieldNamesValue = new StringBuffer(fieldNamesValue.replaceAll("#", ""));
                for (Map.Entry e : clonedFormScope.entrySet()) {
                    String newKey;
                    String key = ((Key)e.getKey()).getUCasedString();
                    String value = (String)e.getValue();
                    boolean hasHash = false;
                    if (key.indexOf(35) != -1) {
                        hasHash = true;
                        newKey = key.replaceAll("#", "");
                        this.getBacking().remove(Key.getInstance(key));
                    } else {
                        newKey = key;
                    }
                    boolean translationSuccess = pdfFormFieldNamesConverter.extractFieldDetail(newKey, value);
                    if (!translationSuccess && hasHash) {
                        this.put(newKey, (Object)value);
                        continue;
                    }
                    if (translationSuccess && !hasHash) {
                        this.getBacking().remove(Key.getInstance(newKey));
                        this.replaceOccurance(modFieldNamesValue, newKey, "");
                        continue;
                    }
                    if (!translationSuccess || !hasHash) continue;
                    this.replaceOccurance(modFieldNamesValue, newKey, "");
                }
                Struct convertedMap = pdfFormFieldNamesConverter.getConvertedMap();
                for (Map.Entry entry : convertedMap.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                    if (!"".equals(modFieldNamesValue.toString().trim())) {
                        modFieldNamesValue.append(',');
                    }
                    modFieldNamesValue.append(entry.getKey());
                }
                fieldnames.setValue(modFieldNamesValue.toString());
            }
        }
    }

    private String convert(String str) throws UnsupportedEncodingException {
        if (this.charset != null) {
            return new String(str.getBytes("ISO-8859-1"), this.charset);
        }
        return str;
    }

    private void replaceOccurance(StringBuffer originalString, String replacekey, String replaceValue) {
        try {
            int start = originalString.indexOf(replacekey);
            int length = replacekey.length();
            int end = start + length;
            if (start == 0) {
                end = start + length + 1;
            }
            if (end == originalString.length()) {
                --start;
            }
            if (start != 0 && end != originalString.length()) {
                ++end;
            }
            originalString.replace(start, end, replaceValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populateFieldValues(String field, String value) {
        List sciptProtect;
        FusionContext ctx = FusionContext.getCurrent();
        if (ctx != null && (sciptProtect = ctx.getScriptProtect()) != null && sciptProtect.contains("FORM")) {
            value = ServiceFactory.getSecurityService().crossSiteProtectString(value);
        }
        if (!this.table.containsKey(Key.getInstance(field))) {
            this.put(field, (Object)value);
        } else if (this.get(field) instanceof List) {
            ((List)this.get(field)).add(value);
        } else {
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(this.get(field));
            valueList.add(value);
            this.put(field, (Object)valueList);
        }
    }

    public boolean isServerSideFormValidationDefault() {
        return this.serverSideFormValidationDefault;
    }

    public static class UnsupportedCharacterEncodingException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String charset;

        UnsupportedCharacterEncodingException(String charset) {
            this.charset = charset;
        }
    }

    public static class CorruptFieldException
    extends NeoException {
        public String control;
        public String fieldName;
        public String fieldValue;

        public CorruptFieldException(String control, String fieldName, String fieldValue) {
            this.control = control;
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public CorruptFieldException(String control, String fieldName) {
            this(control, fieldName, null);
        }
    }
}

