/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.NeoException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class GridFieldProcessor {
    public static void decode(Map form, String fieldName) {
        if (fieldName.length() < 14) {
            throw new CorruptGridFieldException(fieldName);
        }
        int formNameEnd = fieldName.indexOf("__", 10);
        if (formNameEnd == -1 || fieldName.length() <= formNameEnd + 2 || !fieldName.substring(formNameEnd, formNameEnd + 2).equals("__")) {
            throw new CorruptGridFieldException(fieldName);
        }
        String gridName = fieldName.substring(formNameEnd + 2);
        if (gridName.length() == 0) {
            throw new CorruptGridFieldException(fieldName);
        }
        String fieldValue = form.get(fieldName).toString();
        if (fieldValue.length() >= 17 && fieldValue.startsWith("__CFGRID__EDIT__=")) {
            int c;
            StringTokenizer subTokenizer;
            StringTokenizer fieldTokenizer = fieldValue.indexOf("\u0004") > -1 ? new StringTokenizer(fieldValue.substring(17, fieldValue.length()), "\u0004") : new StringTokenizer(fieldValue.substring(17, fieldValue.length()), "\u0001");
            if (!fieldTokenizer.hasMoreTokens()) {
                throw new CorruptGridFieldException(fieldName, fieldValue);
            }
            int columnCount = Integer.parseInt(fieldTokenizer.nextToken());
            if (fieldTokenizer.countTokens() <= columnCount) {
                throw new CorruptGridFieldException(fieldName, fieldValue);
            }
            String[] columnNames = new String[columnCount];
            boolean[] columnEditable = new boolean[columnCount];
            for (int c2 = 0; c2 < columnCount; ++c2) {
                subTokenizer = new StringTokenizer(fieldTokenizer.nextToken(), "\u0002");
                if (!subTokenizer.hasMoreTokens()) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                columnNames[c2] = subTokenizer.nextToken().toUpperCase();
                if (!subTokenizer.hasMoreTokens()) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                String editable = subTokenizer.nextToken();
                if (editable.equals("Y")) {
                    columnEditable[c2] = true;
                    continue;
                }
                if (editable.equals("N")) {
                    columnEditable[c2] = false;
                    continue;
                }
                throw new CorruptGridFieldException(fieldName, fieldValue);
            }
            fieldTokenizer.nextToken();
            Array actions = new Array();
            ArrayList<Array> newColumns = new ArrayList<Array>(columnCount);
            ArrayList<Array> oldColumns = new ArrayList<Array>(columnCount);
            for (c = 0; c < columnCount; ++c) {
                newColumns.add(new Array());
                oldColumns.add(new Array());
            }
            while (fieldTokenizer.hasMoreTokens()) {
                String value;
                subTokenizer = new StringTokenizer(fieldTokenizer.nextToken(), "\u0002");
                if (!subTokenizer.hasMoreTokens()) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                String action = subTokenizer.nextToken();
                ArrayUtil.ArrayAppend(actions, action);
                if (action.equals("U")) {
                    for (c = 0; c < columnCount; ++c) {
                        if (!subTokenizer.hasMoreTokens()) {
                            throw new CorruptGridFieldException(fieldName, fieldValue);
                        }
                        value = subTokenizer.nextToken();
                        if (value.equals("\u0003")) {
                            value = "";
                        }
                        ArrayUtil.ArrayAppend((Array)newColumns.get(c), value);
                        if (columnEditable[c]) {
                            if (!subTokenizer.hasMoreTokens()) {
                                throw new CorruptGridFieldException(fieldName, fieldValue);
                            }
                            value = subTokenizer.nextToken();
                            if (value.equals("\u0003")) {
                                value = "";
                            }
                        }
                        ArrayUtil.ArrayAppend((Array)oldColumns.get(c), value);
                    }
                    continue;
                }
                if (action.equals("I")) {
                    for (c = 0; c < columnCount; ++c) {
                        if (columnEditable[c]) {
                            if (!subTokenizer.hasMoreTokens()) {
                                throw new CorruptGridFieldException(fieldName, fieldValue);
                            }
                            value = subTokenizer.nextToken();
                            if (value.equals("\u0003")) {
                                value = "";
                            }
                        } else {
                            value = "";
                        }
                        ArrayUtil.ArrayAppend((Array)newColumns.get(c), value);
                        ArrayUtil.ArrayAppend((Array)oldColumns.get(c), "");
                    }
                    continue;
                }
                if (!action.equals("D")) continue;
                if (subTokenizer.countTokens() != columnCount) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                for (c = 0; c < columnCount; ++c) {
                    ArrayUtil.ArrayAppend((Array)newColumns.get(c), "");
                    value = subTokenizer.nextToken();
                    if (value.equals("\u0003")) {
                        value = "";
                    }
                    ArrayUtil.ArrayAppend((Array)oldColumns.get(c), value);
                }
            }
            for (c = 0; c < columnCount; ++c) {
                form.put(gridName + "." + columnNames[c], (Array)newColumns.get(c));
                form.put(gridName + ".ORIGINAL." + columnNames[c], (Array)oldColumns.get(c));
            }
            form.put(gridName + ".ROWSTATUS.ACTION", actions);
        } else if (fieldValue.length() >= 19 && fieldValue.substring(0, 19).equals("__CFGRID__COLUMN__=")) {
            StringTokenizer fieldTokenizer = new StringTokenizer(fieldValue, ";");
            while (fieldTokenizer.hasMoreTokens()) {
                StringTokenizer pairTokenizer = new StringTokenizer(fieldTokenizer.nextToken(), "=");
                if (pairTokenizer.countTokens() != 2 || !pairTokenizer.nextToken().trim().equals("__CFGRID__COLUMN__")) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                String columnName = pairTokenizer.nextToken().toUpperCase();
                if (!fieldTokenizer.hasMoreTokens()) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                pairTokenizer = new StringTokenizer(fieldTokenizer.nextToken(), "=");
                if (pairTokenizer.countTokens() == 1) {
                    form.put(gridName + "." + columnName, "");
                    continue;
                }
                if (!pairTokenizer.nextToken().equals(" __CFGRID__DATA__")) {
                    throw new CorruptGridFieldException(fieldName, fieldValue);
                }
                form.put(gridName + "." + columnName, pairTokenizer.nextToken());
            }
        } else if (fieldValue.length() == 0) {
            form.put(gridName, "");
        } else {
            throw new CorruptGridFieldException(fieldName, fieldValue);
        }
    }

    public static class CorruptGridFieldException
    extends NeoException {
        public String fieldName;
        public String fieldValue;

        public CorruptGridFieldException(String fieldName, String fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public CorruptGridFieldException(String fieldName) {
            this(fieldName, (String)null);
        }
    }
}

