/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.runtime.CFPage;
import coldfusion.runtime.NeoException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class IPFilterUtils {
    private static final String[] RESTRICTED_INTERNAL_PATHS = new String[]{"/restplay", "/cfide/restplay", "/cfide/administrator", "/cfide/adminapi", "/cfide/main", "/cfide/componentutils", "/cfide/wizards", "/cfide/servermanager", "/cfide/lockdown"};
    private static final String SLASH = "/";
    private static final String DOT = ".";

    public static void checkAdminAccess(HttpServletRequest req) {
        String uri = Utils.getServletPath(req);
        uri = Utils.canonicalizeURI(uri.toLowerCase());
        uri = IPFilterUtils.sanitizeUri(uri);
        Arrays.stream(RESTRICTED_INTERNAL_PATHS).filter(uri::startsWith).findFirst().ifPresent(restrictedPath -> {
            String ip = req.getRemoteAddr();
            if (!IPFilterUtils.isAllowedIP(ip)) {
                throw new AdminAccessdeniedException(ServiceFactory.getSecurityService().getAllowedAdminIPList(), ip);
            }
        });
    }

    private static String sanitizeUri(String uri) {
        String[] uriParts;
        StringBuilder uriBuilder = new StringBuilder();
        for (String uriPart : uriParts = uri.split(SLASH)) {
            if ((uriPart = uriPart.trim()).isEmpty()) continue;
            uriPart = IPFilterUtils.removeTrailingDots(uriPart);
            uriBuilder.append(SLASH).append(uriPart);
        }
        return uriBuilder.toString();
    }

    private static String removeTrailingDots(String uriPart) {
        while (uriPart.trim().endsWith(DOT)) {
            uriPart = uriPart.substring(0, uriPart.length() - 1);
        }
        return uriPart;
    }

    private static boolean isAllowedIP(String ip) {
        List allowedIPList = CFPage.ListToArray(ServiceFactory.getSecurityService().getAllowedAdminIPList());
        if (IPAddressUtils.isLocalHost(ip) || allowedIPList == null || allowedIPList.size() == 0) {
            return true;
        }
        boolean allowed = false;
        boolean isIPv6 = false;
        boolean isAllowedIPv6 = false;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            if (addr instanceof Inet6Address) {
                isIPv6 = true;
            }
            ip = addr.getHostAddress();
            Iterator iter = allowedIPList.iterator();
            while (iter.hasNext()) {
                boolean matched;
                isAllowedIPv6 = false;
                String allowedIP = (String)iter.next();
                if (allowedIP.indexOf(58) != -1) {
                    isAllowedIPv6 = true;
                }
                if (isIPv6 != isAllowedIPv6 || !(matched = IPAddressUtils.matchIP(ip, allowedIP, isIPv6))) continue;
                allowed = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allowed;
    }

    public static class AdminAccessdeniedException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String allowedipaddr;
        public String requestipaddr;

        public AdminAccessdeniedException(String allowedipaddr, String reqipaddr) {
            this.allowedipaddr = allowedipaddr;
            this.requestipaddr = reqipaddr;
        }
    }
}

