/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.server.SystemInfo;
import coldfusion.server.felix.FelixUtil;
import coldfusion.serverless.ServerlessUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ModuleCheckFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        String ctx = ((HttpServletRequest)request).getContextPath();
        if (ctx == null) {
            ctx = "";
        }
        if (!ServerlessUtil.isLambdaEnv()) {
            String uri = ((HttpServletRequest)request).getRequestURI();
            String module = "";
            boolean installed = true;
            if ((uri = uri.replace("\\", "/").toLowerCase()).contains("cfide/administrator")) {
                if (!FelixUtil.isAdministratorInstalled()) {
                    installed = false;
                    module = "administrator";
                }
            } else if (uri.contains("cfide/adminapi") && !FelixUtil.isAdminapiInstalled()) {
                installed = false;
                module = "adminapi";
            }
            if (!installed) {
                String scriptName = "cfpm.bat";
                if (!SystemInfo.isWindows()) {
                    scriptName = "cfpm.sh";
                }
                String path = "CF_ROOT/bin/" + scriptName;
                res.sendRedirect(ctx + "/CFIDE/adminnotinstalled.cfm?script=" + path + "&module=" + module);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

