/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.log.CFLogs;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceListener;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.MemorySemaphore;
import coldfusion.util.RB;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

public class RequestThrottleFilter
extends FusionFilter {
    private static int DEFAULT_THROTTLE = 2;
    private static int DEFAULT_TOTAL_MEM = 200;
    private static long requestThrottleThreshold;
    private static long allowedTotalMemory;
    private static final String THROTTLE_THRESHOLD = "throttle-threshold";
    public static final String TOTAL_THROTTLE_MEMORY = "total-throttle-memory";
    private static MemorySemaphore semaphore;

    public static void reInitialize() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        Map requestThrottleSettings = runtimeService.getRequestThrottleSettings();
        Number threshold = (Number)requestThrottleSettings.get(THROTTLE_THRESHOLD);
        Number totalMem = (Number)requestThrottleSettings.get(TOTAL_THROTTLE_MEMORY);
        if (threshold == null || totalMem == null) {
            return;
        }
        requestThrottleThreshold = threshold.longValue() * 1024L * 1024L;
        allowedTotalMemory = totalMem.longValue() * 1024L * 1024L;
        semaphore.setMaxAllowedMemory(allowedTotalMemory);
    }

    private static void init() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        Map requestThrottleSettings = runtimeService.getRequestThrottleSettings();
        Number threshold = (Number)requestThrottleSettings.get(THROTTLE_THRESHOLD);
        if (threshold == null || threshold.intValue() <= 0) {
            threshold = new Integer(DEFAULT_THROTTLE);
            requestThrottleSettings.put(THROTTLE_THRESHOLD, threshold);
        }
        requestThrottleThreshold = threshold.longValue() * 1024L * 1024L;
        Number totalMem = (Number)requestThrottleSettings.get(TOTAL_THROTTLE_MEMORY);
        if (totalMem == null || totalMem.intValue() <= 0 || totalMem.intValue() < threshold.intValue()) {
            totalMem = new Integer(DEFAULT_TOTAL_MEM);
            requestThrottleSettings.put(TOTAL_THROTTLE_MEMORY, totalMem);
        }
        allowedTotalMemory = totalMem.longValue() * 1024L * 1024L;
        semaphore.setMaxAllowedMemory(allowedTotalMemory);
        runtimeService.addServiceListener(new ServiceListener(){

            @Override
            public void serviceModified() {
                RequestThrottleFilter.reInitialize();
            }
        });
    }

    public RequestThrottleFilter(FusionFilter next) {
        super(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(FusionContext context) throws Throwable {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        int contentLength = request.getContentLength();
        if (ServerlessUtil.isLambdaEnv() && contentLength < 0) {
            contentLength = context.getRequestContent().length;
        }
        if ((float)contentLength > runtimeService.getPostSizeLimit() * 1024.0f * 1024.0f) {
            String error = RB.getString(this, "RequestThrottleFilter.postSizeLimitExceeded");
            String logError = RB.getString((Object)this, "RequestThrottleFilter.postSizeLimitExceededLogs", Float.valueOf(runtimeService.getPostSizeLimit()));
            CFLogs.SERVER_LOG.error(logError);
            response.sendError(400, error);
            return;
        }
        boolean lockAcquired = false;
        try {
            if ((long)contentLength >= requestThrottleThreshold) {
                semaphore.acquire(contentLength);
                lockAcquired = true;
                RequestMonitorEventProcessor.onThrottle(contentLength);
            }
            this.next.invoke(context);
        }
        finally {
            if (lockAcquired) {
                semaphore.release(contentLength);
            }
        }
    }

    static {
        semaphore = MemorySemaphore.getInstance(RequestThrottleFilter.class.getName());
        RequestThrottleFilter.init();
    }
}

