/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.CommonUtil;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.FastHashtable;
import coldfusion.util.HTMLTools;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;

public class UrlScope
extends LocalScope {
    private String charset = RuntimeServiceImpl.getDefaultCharset();
    private FastHashtable urlHt = null;

    public void setEncoding(String charset) {
        this.charset = charset;
        this.fillUrl();
    }

    public String getEncoding() {
        return this.charset;
    }

    protected void fillUrl(HttpServletRequest request) {
        String qs = Utils.getQueryString(request);
        if (qs != null && qs.length() > 0) {
            try {
                this.urlHt = HTMLTools.parseQueryString(qs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fillUrl();
    }

    private void fillUrl() {
        if (this.urlHt != null) {
            this.clear();
            try {
                Enumeration eParameters = this.urlHt.keys();
                Enumeration eValues = this.urlHt.elements();
                if (eParameters != null && eParameters.hasMoreElements()) {
                    FusionContext fusContext = FusionContext.getCurrent();
                    List sciptProtect = null;
                    SecurityService secSrvc = ServiceFactory.getSecurityService();
                    boolean hasNullParam = false;
                    if (fusContext != null) {
                        sciptProtect = fusContext.getScriptProtect();
                    }
                    while (eParameters.hasMoreElements()) {
                        String parameter_name = (String)eParameters.nextElement();
                        String[] parameters = (String[])eValues.nextElement();
                        if (parameters == null) continue;
                        StringBuffer parameter = new StringBuffer();
                        for (int i = 0; i < parameters.length; ++i) {
                            if (i > 0) {
                                parameter.append(",");
                            }
                            String value = parameters[i];
                            if (sciptProtect != null && sciptProtect.contains("URL")) {
                                value = secSrvc.crossSiteProtectString(parameters[i]);
                            }
                            parameter.append(this.convert(value));
                        }
                        String convParamName = this.convert(parameter_name);
                        this.put(convParamName, (Object)parameter.toString());
                        if (hasNullParam || !CommonUtil.checkNullKey(convParamName)) continue;
                        hasNullParam = true;
                    }
                    if (hasNullParam && fusContext != null) {
                        fusContext.setHasNullParamInURL(true);
                    }
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new UnsupportedCharacterEncodingException(this.charset);
            }
        }
    }

    private String convert(String str) throws UnsupportedEncodingException {
        if (this.charset != null) {
            return new String(str.getBytes("ISO-8859-1"), this.charset);
        }
        return str;
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    public static class UnsupportedCharacterEncodingException
    extends ExpressionException {
        public String charset;

        UnsupportedCharacterEncodingException(String charset) {
            this.charset = charset;
        }
    }
}

