/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.IChartConstants;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CfJspPage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ChartAttributeMapper
implements IChartConstants {
    private static HashMap<String, Object> attributeNameMapper = new HashMap(24);
    private static HashMap<String, String> background = new HashMap(10, 1.0f);
    private static HashMap<String, String> fill = new HashMap(4, 1.0f);
    private static HashMap<String, String> border = new HashMap(4, 1.0f);
    private static HashMap<String, String> bevel = new HashMap(6, 1.0f);
    private static HashMap<String, String> shadow = new HashMap(4, 1.0f);
    private static HashMap<String, Integer> animationEffects = new HashMap(13, 1.0f);
    private static HashMap<String, Integer> animationMethods = new HashMap(6, 1.0f);
    private static HashMap<String, Integer> animationSequences = new HashMap(4, 1.0f);
    private static HashMap<String, HashMap<String, Integer>> animationPropertyMapper = new HashMap(3, 1.0f);
    private static int EFFECT_MIN = 1;
    private static int EFFECT_MAX = 13;
    private static int METHOD_MIN = 0;
    private static int METHOD_MAX = 5;
    private static int SEQUENCE_MIN = 0;
    private static int SEQUENCE_MAX = 3;
    public static final String ASPECT3D = "aspect3d";
    public static final String ASPECT_3D_MAPPED = "3d-aspect";
    public static final String CROSSHAIR_X = "crosshair-x";
    public static final String HOVER_MARKER = "hover-marker";

    public static String getChartEngineAttributeName(String[] name) {
        if (name == null) {
            return null;
        }
        try {
            Object mappedName = attributeNameMapper.get(name[0]);
            if (mappedName == null) {
                return name[0];
            }
            if (mappedName instanceof Map) {
                String innerName = (String)((Map)mappedName).get(name[1]);
                if (innerName == null) {
                    return name[1];
                }
                return innerName;
            }
            return (String)mappedName;
        }
        catch (Exception exception) {
            return name[0];
        }
    }

    public static Map getAnimation(Map animation) {
        if (animation.containsKey("effect")) {
            animation.put("effect", ChartAttributeMapper.getAnimationProperty("effect", animation.get("effect"), EFFECT_MIN, EFFECT_MAX));
        }
        if (animation.containsKey("method")) {
            animation.put("method", ChartAttributeMapper.getAnimationProperty("method", animation.get("method"), METHOD_MIN, METHOD_MAX));
        }
        if (animation.containsKey("sequence")) {
            animation.put("sequence", ChartAttributeMapper.getAnimationProperty("sequence", animation.get("sequence"), SEQUENCE_MIN, SEQUENCE_MAX));
        }
        return animation;
    }

    private static int parseDouble(String propertyKey, Object value) {
        double propertyVal;
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            propertyVal = Double.parseDouble((String)value);
        } else if (value instanceof CFDouble) {
            propertyVal = ((CFDouble)value).doubleValue();
        } else if (value instanceof Double) {
            propertyVal = (Double)value;
        } else {
            throw new InvalidPropertyValueException(propertyKey);
        }
        if (propertyVal - (double)((int)propertyVal) == 0.0) {
            return (int)propertyVal;
        }
        throw new InvalidPropertyValueException(propertyKey);
    }

    private static int getAnimationProperty(String propertyKey, Object property, int start, int end) {
        if (CfJspPage.internalIsNumeric(property)) {
            int propertyVal = ChartAttributeMapper.parseDouble(propertyKey, property);
            if (propertyVal > end || propertyVal < start) {
                throw new AnimatePropertyRangeException(propertyKey, start, end);
            }
            return propertyVal;
        }
        Integer propertyVal = animationPropertyMapper.get(propertyKey).get((String)property);
        if (propertyVal != null) {
            return propertyVal;
        }
        throw new AnimatePropertyException((String)property, propertyKey);
    }

    static {
        attributeNameMapper.put(ASPECT3D, ASPECT_3D_MAPPED);
        attributeNameMapper.put("xaxis", "scale-x");
        attributeNameMapper.put("yaxis", "scale-y");
        attributeNameMapper.put("xaxis2", "scale-x-2");
        attributeNameMapper.put("yaxis2", "scale-y-2");
        attributeNameMapper.put("background", background);
        attributeNameMapper.put("fill", fill);
        attributeNameMapper.put("border", border);
        attributeNameMapper.put("bevel", bevel);
        attributeNameMapper.put("shadow", shadow);
        attributeNameMapper.put("crosshair", CROSSHAIR_X);
        attributeNameMapper.put("hovermarker", HOVER_MARKER);
        background.put("color", "background-color");
        background.put("color-1", "background-color-1");
        background.put("color-2", "background-color-2");
        background.put("fit", "background-fit");
        background.put("image", "background-image");
        background.put("position", "background-position");
        background.put("repeat", "background-repeat");
        background.put("transparent", "background-transparent");
        border.put("color", "border-color");
        border.put("radius", "border-radius");
        border.put("width", "border-width");
        fill.put("angle", "fill-angle");
        fill.put("offset-x", "fill-offset-x");
        fill.put("offset-y", "fill-offset-y");
        bevel.put("blur-x", "bevel-blur-x");
        bevel.put("blur-y", "bevel-blur-y");
        bevel.put("angle", "bevel-angle");
        bevel.put("color", "bevel-color");
        bevel.put("distance", "bevel-distance");
        animationEffects.put("fadein", 1);
        animationEffects.put("expandvertical", 2);
        animationEffects.put("expandup", 3);
        animationEffects.put("expanddown", 4);
        animationEffects.put("expandleft", 5);
        animationEffects.put("expandright", 6);
        animationEffects.put("expandhorizontal", 7);
        animationEffects.put("slideleft", 8);
        animationEffects.put("slideright", 9);
        animationEffects.put("slideup", 10);
        animationEffects.put("slidedown", 11);
        animationEffects.put("stretchhorizontal", 12);
        animationEffects.put("stretchvertical", 13);
        animationMethods.put("linear", 0);
        animationMethods.put("backeaseout", 1);
        animationMethods.put("elasticeaseout", 2);
        animationMethods.put("bounceeaseout", 3);
        animationMethods.put("strongeaseout", 4);
        animationMethods.put("regulareaseout", 5);
        animationSequences.put("nosequence", 0);
        animationSequences.put("plot", 1);
        animationSequences.put("node", 2);
        animationSequences.put("plotandnode", 3);
        animationPropertyMapper.put("effect", animationEffects);
        animationPropertyMapper.put("method", animationMethods);
        animationPropertyMapper.put("sequence", animationSequences);
        shadow.put("alpha", "shadow-alpha");
    }

    public static class InvalidPropertyValueException
    extends ApplicationException {
        public String propertyKey;

        InvalidPropertyValueException(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }

    public static class AnimatePropertyRangeException
    extends ApplicationException {
        public String propertyKey;
        public int start;
        public int end;

        AnimatePropertyRangeException(String propertyKey, int start, int end) {
            this.propertyKey = propertyKey;
            this.start = start;
            this.end = end;
        }
    }

    public static class AnimatePropertyException
    extends ApplicationException {
        public String property;
        public String propertyKey;
        public static String supportedProperties;

        AnimatePropertyException(String property, String propertyKey) {
            this.property = property;
            this.propertyKey = propertyKey;
            Set<String> propertySet = animationPropertyMapper.get(propertyKey).keySet();
            supportedProperties = String.join((CharSequence)",", propertySet);
        }
    }
}

