/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.GraphException;
import java.util.HashMap;

public abstract class GraphCommon {
    private static HashMap _shapeStyleByChartType = new HashMap(11);
    private static HashMap _validChartTypes;
    private static HashMap _validPlaceStyles;
    private static HashMap _validPaintStyles;
    private static HashMap _validDataLabelStyles;
    private static HashMap _validMarkerStyles;
    private static HashMap _namedColors;
    private String _chartType = "AREA CHART";
    private String _shapeStyle;
    private String _placeStyle;
    private String _foreColor;
    private String _paintStyle = "PS_PLAIN";
    private String _markerStyle = "MRS_RECTANGLE";
    private String _dataLabelStyle = "NONE";

    public boolean isValidChartType(String style) {
        return _validChartTypes.containsKey(style.toLowerCase());
    }

    public boolean isValidPaintStyle(String style) {
        return _validPaintStyles.containsKey(style.toLowerCase());
    }

    public boolean isValidDataLabelStyle(String style) {
        return _validDataLabelStyles.containsKey(style.toLowerCase());
    }

    public static boolean isValidPlaceStyle(String style) {
        return _validPlaceStyles.containsKey(style.toLowerCase());
    }

    public boolean isValidMarkerStyle(String style) {
        return _validMarkerStyles.containsKey(style.toLowerCase());
    }

    public String getShapeStyle() {
        return this._shapeStyle;
    }

    public void setChartType(String chartType) throws GraphException {
        if (!this.isValidChartType(chartType.toLowerCase())) {
            throw new InvalidChartTypeException(chartType);
        }
        this._chartType = (String)_validChartTypes.get(chartType.toLowerCase());
        this._shapeStyle = (String)_shapeStyleByChartType.get(chartType.toLowerCase());
    }

    public String getChartType() {
        return this._chartType;
    }

    public void setPlaceStyle(String placeStyle) throws GraphException {
        if (!GraphCommon.isValidPlaceStyle(placeStyle.toLowerCase())) {
            throw new InvalidPlaceStyleException(placeStyle);
        }
        this._placeStyle = (String)_validPlaceStyles.get(placeStyle.toLowerCase());
    }

    public String getPlaceStyle() {
        return this._placeStyle;
    }

    public void setForeColor(String foreColor) {
        this._foreColor = GraphCommon.getHexColor(foreColor);
    }

    public String getForeColor() {
        return this._foreColor;
    }

    public void setPaintStyle(String paintStyle) throws GraphException {
        if (!this.isValidPaintStyle(paintStyle.toLowerCase())) {
            throw new InvalidPaintStyleException(paintStyle);
        }
        this._paintStyle = (String)_validPaintStyles.get(paintStyle.toLowerCase());
    }

    public String getPaintStyle() {
        return this._paintStyle;
    }

    public void setMarkerStyle(String markerStyle) throws GraphException {
        if (!this.isValidMarkerStyle(markerStyle.toLowerCase())) {
            throw new InvalidMarkerStyleException(markerStyle);
        }
        this._markerStyle = (String)_validMarkerStyles.get(markerStyle.toLowerCase());
    }

    public String getMarkerStyle() {
        return this._markerStyle;
    }

    public void setDataLabelStyle(String dataLabelStyle) throws GraphException {
        if (!this.isValidDataLabelStyle(dataLabelStyle.toLowerCase())) {
            throw new InvalidDataLabelStyleException(dataLabelStyle);
        }
        this._dataLabelStyle = (String)_validDataLabelStyles.get(dataLabelStyle.toLowerCase());
    }

    public String getDataLabelStyle() {
        return this._dataLabelStyle;
    }

    public static String getHexColor(String colorName) throws GraphException {
        String hex = (String)_namedColors.get(colorName.trim().toLowerCase());
        if (hex != null) {
            return hex;
        }
        return GraphCommon.toValidHexFormat(colorName);
    }

    static String toValidHexFormat(String colorName) throws GraphException {
        Object validHexString = colorName.trim();
        String hexString = null;
        if (((String)validHexString).startsWith("#")) {
            hexString = ((String)validHexString).substring(1);
        } else {
            hexString = validHexString;
            validHexString = "#" + hexString;
        }
        if (hexString == null || hexString.length() != 6 && hexString.length() != 8) {
            throw new UnsupportedColorException(colorName);
        }
        block3: for (int i = 0; i < hexString.length(); ++i) {
            switch (hexString.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    continue block3;
                }
                default: {
                    throw new UnsupportedColorException(colorName);
                }
            }
        }
        return validHexString;
    }

    static {
        _shapeStyleByChartType.put("bar", "SS_BAR");
        _shapeStyleByChartType.put("line", "SS_LINE");
        _shapeStyleByChartType.put("pyramid", "SS_PYRAMID");
        _shapeStyleByChartType.put("area", "SS_AREA");
        _shapeStyleByChartType.put("cone", "SS_CONE");
        _shapeStyleByChartType.put("curve", "SS_CURVE");
        _shapeStyleByChartType.put("cylinder", "SS_CYLINDER");
        _shapeStyleByChartType.put("step", "SS_STEP");
        _shapeStyleByChartType.put("scatter", "SS_SCATTER");
        _shapeStyleByChartType.put("horizontalbar", "SS_COLUMN");
        _shapeStyleByChartType.put("pie", null);
        _validChartTypes = new HashMap(11);
        _validChartTypes.put("bar", "AREA CHART");
        _validChartTypes.put("line", "AREA CHART");
        _validChartTypes.put("pyramid", "AREA CHART");
        _validChartTypes.put("area", "AREA CHART");
        _validChartTypes.put("cone", "AREA CHART");
        _validChartTypes.put("curve", "AREA CHART");
        _validChartTypes.put("cylinder", "AREA CHART");
        _validChartTypes.put("step", "AREA CHART");
        _validChartTypes.put("scatter", "AREA CHART");
        _validChartTypes.put("pie", "PIE CHART");
        _validChartTypes.put("ring", "PIE CHART");
        _validChartTypes.put("horizontalbar", "AREA CHART");
        _validChartTypes.put("varea", "AREA CHART");
        _validChartTypes.put("curvedarea", "AREA CHART");
        _validChartTypes.put("steppedarea", "AREA CHART");
        _validChartTypes.put("boxplot", "AREA CHART");
        _validChartTypes.put("hboxplot", "AREA CHART");
        _validPlaceStyles = new HashMap(9);
        _validPlaceStyles.put("default", "PLS_DEFAULT");
        _validPlaceStyles.put("cluster", "PLS_CLUSTER");
        _validPlaceStyles.put("stacked", "PLS_STACKED");
        _validPlaceStyles.put("percent", "PLS_PERCENT");
        _validPaintStyles = new HashMap(4);
        _validPaintStyles.put("plain", "PS_PLAIN");
        _validPaintStyles.put("raise", "PS_RAISE");
        _validPaintStyles.put("shade", "PS_SHADE");
        _validPaintStyles.put("light", "PS_LIGHT");
        _validDataLabelStyles = new HashMap(4);
        _validDataLabelStyles.put("none", "NONE");
        _validDataLabelStyles.put("value", "VALUE");
        _validDataLabelStyles.put("rowlabel", "ROWLABEL");
        _validDataLabelStyles.put("columnlabel", "COLUMNLABEL");
        _validDataLabelStyles.put("pattern", "PATTERN");
        _validMarkerStyles = new HashMap(9);
        _validMarkerStyles.put("rectangle", "MRS_RECTANGLE");
        _validMarkerStyles.put("triangle", "MRS_TRIANGLE");
        _validMarkerStyles.put("diamond", "MRS_ROMB");
        _validMarkerStyles.put("circle", "MRS_CIRCLE");
        _validMarkerStyles.put("letterx", "MRS_LETTERX");
        _validMarkerStyles.put("mcross", "MRS_MCROSS");
        _validMarkerStyles.put("snow", "MRS_SNOW");
        _validMarkerStyles.put("rcross", "MRS_RCROSS");
        _validMarkerStyles.put("none", "MRS_NONE");
        _namedColors = new HashMap(16);
        _namedColors.put("black", "#000000");
        _namedColors.put("silver", "#C0C0C0");
        _namedColors.put("gray", "#808080");
        _namedColors.put("white", "#FFFFFF");
        _namedColors.put("maroon", "#800000");
        _namedColors.put("red", "#FF0000");
        _namedColors.put("purple", "#800080");
        _namedColors.put("fuchsia", "#FF00FF");
        _namedColors.put("green", "#008000");
        _namedColors.put("lime", "#00FF00");
        _namedColors.put("olive", "#808000");
        _namedColors.put("yellow", "#FFFF00");
        _namedColors.put("navy", "#000080");
        _namedColors.put("blue", "#0000FF");
        _namedColors.put("teal", "#008080");
        _namedColors.put("aqua", "#00FFFF");
    }

    public static class InvalidChartTypeException
    extends GraphException {
        private String _type;

        public InvalidChartTypeException(String type) {
            this._type = type;
        }

        @Override
        public String getType() {
            return this._type;
        }
    }

    public static class InvalidPlaceStyleException
    extends GraphException {
        private String _seriesPlacement;

        public InvalidPlaceStyleException(String seriesPlacement) {
            this._seriesPlacement = seriesPlacement;
        }

        public String getSeriesPlacement() {
            return this._seriesPlacement;
        }
    }

    public class InvalidPaintStyleException
    extends GraphException {
        private String _paintStyle;

        public InvalidPaintStyleException(String paintStyle) {
            this._paintStyle = paintStyle;
        }

        public String getPaintStyle() {
            return this._paintStyle;
        }
    }

    public static class InvalidMarkerStyleException
    extends GraphException {
        private String _marker;

        public InvalidMarkerStyleException(String marker) {
            this._marker = marker;
        }

        public String getMarker() {
            return this._marker;
        }
    }

    public class InvalidDataLabelStyleException
    extends GraphException {
        private String _dataLabelStyle;

        public InvalidDataLabelStyleException(String dataLabelStyle) {
            this._dataLabelStyle = dataLabelStyle;
        }

        public String getDataLabelStyle() {
            return this._dataLabelStyle;
        }
    }

    public static class UnsupportedColorException
    extends GraphException {
        private String _color;

        public UnsupportedColorException(String color) {
            this._color = color;
        }

        public String getColor() {
            return this._color;
        }
    }
}

