/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.IChartConstants;
import coldfusion.graph.InteractiveChart;
import coldfusion.graph.JSONManipulator;
import coldfusion.graph.StyleFileResolver;
import coldfusion.runtime.ObjectDuplicator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StyleApplicator
implements IChartConstants {
    private static Map<String, Object> defaultStyleJSON = new HashMap<String, Object>(3);
    private static Map<String, Object> style;
    private static List<Map<String, String>> colorList;
    private static final String COLORS = "colors";
    private static final String STYLE = "style";

    static void applyStyle(int seriesNum, Map<String, Object> graph, Map<String, Object> series, String outerChartType) {
        String chartType = (String)series.get("type");
        if (chartType == null) {
            chartType = outerChartType;
        }
        if (chartType == null) {
            return;
        }
        if (chartType.endsWith("3d")) {
            chartType = chartType.substring(0, chartType.length() - 2);
        }
        if (style != null) {
            Map chartSpecificStyle = (Map)style.get(chartType);
            Map clonedShartSpecificStyle = null;
            try {
                clonedShartSpecificStyle = (Map)ObjectDuplicator.duplicate(chartSpecificStyle);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (clonedShartSpecificStyle != null) {
                Map plot = (Map)graph.get("plot");
                Iterator iterator = clonedShartSpecificStyle.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = ((String)iterator.next()).toString();
                    if (plot != null && plot.get(key) != null || series.get(key) != null) continue;
                    series.put(key, clonedShartSpecificStyle.get(key));
                }
            }
        }
        if (colorList != null) {
            String color = null;
            String color2 = null;
            try {
                String backgroundColor = (String)series.get("background-color");
                String backgroundColor2 = (String)series.get("background-color-2");
                if (backgroundColor != null && backgroundColor2 != null) {
                    color = backgroundColor;
                    color = backgroundColor2;
                } else {
                    Map<String, String> colors = colorList.get(seriesNum);
                    color = colors.get("color");
                    color2 = colors.get("color-2");
                }
            }
            catch (IndexOutOfBoundsException backgroundColor) {
                // empty catch block
            }
            if ("area".equalsIgnoreCase(chartType) || "bar".equalsIgnoreCase(chartType) || "gauge".equalsIgnoreCase(chartType) || "hbar".equalsIgnoreCase(chartType) || "vfunnel".equalsIgnoreCase(chartType) || "hfunnel".equalsIgnoreCase(chartType) || "funnel".equalsIgnoreCase(chartType) || "piano".equalsIgnoreCase(chartType)) {
                if (color != null) {
                    series.put("background-color", color);
                }
                if (color2 != null) {
                    series.put("background-color-2", color2);
                }
            } else if ("bubble".equalsIgnoreCase(chartType)) {
                if (color != null) {
                    marker = InteractiveChart.retrieveMapFragment(series, "marker");
                    marker.put("background-color-2", color);
                    series.put("background-color", color);
                }
                if (color2 != null) {
                    marker = InteractiveChart.retrieveMapFragment(series, "marker");
                    marker.put("background-color", color2);
                }
            } else if ("vbullet".equalsIgnoreCase(chartType) || "hbullet".equalsIgnoreCase(chartType) || "bullet".equalsIgnoreCase(chartType)) {
                Map<String, Object> goal = InteractiveChart.retrieveMapFragment(series, "goal");
                if (color != null) {
                    series.put("background-color", color);
                }
                if (color2 != null) {
                    series.put("background-color-2", color2);
                    goal.put("background-color", color);
                    goal.put("background-color-2", color);
                }
            } else if ("line".equalsIgnoreCase(chartType)) {
                if (color2 != null) {
                    series.put("line-color", color);
                }
            } else if ("pie".equalsIgnoreCase(chartType) || "nestedpie".equalsIgnoreCase(chartType) || "pie3d".equalsIgnoreCase(chartType) || "ring".equalsIgnoreCase(chartType) || "ring3d".equalsIgnoreCase(chartType)) {
                if (color != null) {
                    series.put("background-color-2", color);
                }
                if (color2 != null) {
                    series.put("background-color", color2);
                }
            } else if ("scatter".equalsIgnoreCase(chartType)) {
                if (color != null) {
                    marker = InteractiveChart.retrieveMapFragment(series, "marker");
                    marker.put("background-color", color);
                    series.put("background-color", color);
                }
                if (color2 != null) {
                    marker = InteractiveChart.retrieveMapFragment(series, "marker");
                    marker.put("background-color-2", color2);
                }
            } else if ("radar".equalsIgnoreCase(chartType)) {
                if (color != null) {
                    series.put("background-color-2", color);
                    marker = InteractiveChart.retrieveMapFragment(series, "marker");
                    marker.put("background-color-2", color);
                }
                if (color2 != null) {
                    series.put("background-color", color2);
                    marker = InteractiveChart.retrieveMapFragment(series, "marker");
                    marker.put("background-color", color2);
                }
            } else if ("venn".equalsIgnoreCase(chartType)) {
                if (color != null) {
                    series.put("background-color", color);
                }
                if (color2 != null) {
                    series.put("background-color-2", color2);
                    series.put("border-color", color2);
                }
            }
            StyleApplicator.setLineColor(series, color, chartType);
        }
    }

    private static void setLineColor(Map<String, Object> series, String color, String chartType) {
        if ("bubble".equalsIgnoreCase(chartType) || "gauge".equalsIgnoreCase(chartType) || "piano".equalsIgnoreCase(chartType) || "radar".equalsIgnoreCase(chartType) || "scatter".equalsIgnoreCase(chartType) || "area".equalsIgnoreCase(chartType) || "funnel".equalsIgnoreCase(chartType) || "vfunnel".equalsIgnoreCase(chartType) || "hfunnel".equalsIgnoreCase(chartType)) {
            series.put("line-color", color);
        }
    }

    static {
        String styleJSONStr = StyleFileResolver.readDefaultXDStyles();
        Object styleJSON = JSONManipulator.deserializeJSON(styleJSONStr);
        defaultStyleJSON = (Map)styleJSON;
        colorList = (List)defaultStyleJSON.get(COLORS);
        style = (Map)defaultStyleJSON.get(STYLE);
    }
}

