/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.filter.FusionContext;
import coldfusion.graph.InteractiveChart;
import coldfusion.graph.JSONManipulator;
import coldfusion.runtime.AppHelper;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.ChartTag;
import coldfusion.util.IOUtils;
import coldfusion.util.Utils;
import coldfusion.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class StyleFileResolver {
    private String chartType;
    private String style;
    private String defaultStyle;
    private String theme;
    public static final String REL_STYLE_DIR = "charting/styles/";
    public static final String REL_THEME_DIR = "charting/themes/";
    public static final String DEFAULT_STYLE_TYPE = "bar";
    private static final String DEFAULT_XD_STYLE = "default";
    private static final String CHART_STYLE_DIRECTORY = "chartStyleDirectory";
    private static final String CHART_THEME_DIRECTORY = "chartThemeDirectory";
    private static final String BASE_STYLE_CONTENT = "{\"graphset\" : [{\"legend\" : {}}]}";

    public StyleFileResolver(String chartType, String style, boolean isThemeDefined) {
        this.chartType = chartType;
        this.style = style;
        String mappedChartType = InteractiveChart.getChartType(chartType);
        if (mappedChartType != null) {
            this.chartType = mappedChartType;
        }
        if (style == null && !isThemeDefined) {
            this.defaultStyle = this.chartType;
            if (this.defaultStyle != null) {
                if (this.defaultStyle.endsWith("3d")) {
                    this.defaultStyle = chartType.substring(0, chartType.length() - 2);
                }
            } else {
                this.defaultStyle = DEFAULT_STYLE_TYPE;
            }
        }
    }

    public StyleFileResolver(String theme) {
        this.theme = theme;
    }

    Object readStyle() throws FileNotFoundException {
        String tempStyle = this.style;
        String aDefaultStyle = this.defaultStyle;
        try {
            return this.readStyle(tempStyle, aDefaultStyle, false);
        }
        catch (ChartTag.UnknownStyleFileException usfex) {
            int indexOf3D = -1;
            if (tempStyle != null && (indexOf3D = tempStyle.indexOf("3d")) != -1) {
                tempStyle = tempStyle.substring(0, indexOf3D);
            }
            if (aDefaultStyle != null && (indexOf3D = aDefaultStyle.indexOf("3d")) != -1) {
                aDefaultStyle = aDefaultStyle.substring(0, indexOf3D);
            }
            return this.readStyle(tempStyle, aDefaultStyle, false);
        }
    }

    public String readTheme() throws FileNotFoundException {
        return (String)this.readStyle(this.theme, null, true);
    }

    private Object readStyle(String aStyle, String aDefaultStyle, boolean isThemeDefined) throws FileNotFoundException {
        String styleFile = null;
        if (aStyle != null) {
            String cfroot;
            String templatePath = Utils.getTemplatePathBaseDir();
            File styleFileFromTemplate = new File(templatePath + aStyle);
            if (styleFileFromTemplate.exists()) {
                return StyleFileResolver.readFileContent(styleFileFromTemplate);
            }
            Object chartStyleDir = (String)AppHelper.getApplicationSetting(isThemeDefined ? CHART_THEME_DIRECTORY : CHART_STYLE_DIRECTORY);
            if (chartStyleDir != null) {
                FusionContext context = FusionContext.getCurrent();
                if (context == null) {
                    return null;
                }
                Object appCFCpath = context.getApplicationPath();
                if (appCFCpath != null) {
                    if (!((String)appCFCpath).endsWith(File.separator)) {
                        appCFCpath = (String)appCFCpath + File.separator;
                    }
                    if ((styleFile = this.getStyleFromBasePath(aStyle, (String)appCFCpath + (String)chartStyleDir)) != null && new File(styleFile).exists()) {
                        return StyleFileResolver.readFileContent(styleFile);
                    }
                }
                if (!((String)chartStyleDir).endsWith(File.separator)) {
                    chartStyleDir = (String)chartStyleDir + File.separator;
                }
                if ((styleFile = this.getStyleFromBasePath(aStyle, (String)chartStyleDir)) != null && new File(styleFile).exists()) {
                    return StyleFileResolver.readFileContent(styleFile);
                }
            }
            if ((styleFile = this.getStyleFromBasePath(aStyle, (cfroot = StyleFileResolver.getCFRoot()) + (isThemeDefined ? REL_THEME_DIR : REL_STYLE_DIR))) != null) {
                try {
                    return this.readDefaultServerStyle(styleFile);
                }
                catch (FileNotFoundException fne) {
                    if (JSONManipulator.isJSON(aStyle)) {
                        return aStyle;
                    }
                    if (isThemeDefined) {
                        throw new ChartTag.UnknownThemeFileException(aStyle);
                    }
                    throw new ChartTag.UnknownStyleFileException(aStyle);
                }
            }
            if (isThemeDefined) {
                throw new ChartTag.UnknownThemeFileException(aStyle);
            }
            throw new ChartTag.UnknownStyleFileException(aStyle);
        }
        String cfroot = StyleFileResolver.getCFRoot();
        styleFile = this.getStyleFromBasePath(aDefaultStyle, cfroot + REL_STYLE_DIR);
        if (styleFile != null) {
            try {
                return this.readDefaultServerStyle(styleFile);
            }
            catch (FileNotFoundException fne) {
                throw new ChartTag.UnknownStyleFileException(aDefaultStyle);
            }
        }
        return BASE_STYLE_CONTENT;
    }

    private static Object readFileContent(File styleFile) throws FileNotFoundException {
        if (styleFile.getAbsolutePath().endsWith(".xml")) {
            try {
                return XmlUtils.getDocument(styleFile);
            }
            catch (Exception e) {
                throw new ChartTag.UnknownStyleFileException(styleFile.getAbsolutePath());
            }
        }
        String style = IOUtils.toString(new FileReader(styleFile));
        if (style != null) {
            style = style.replaceAll("\r\n", "");
            style = style.replaceAll("\n", "");
        }
        return style;
    }

    private Object readDefaultServerStyle(final String styleFile) throws FileNotFoundException {
        Object style;
        block3: {
            style = null;
            try {
                style = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws FileNotFoundException {
                        if (!styleFile.toLowerCase().endsWith(".xml")) {
                            try {
                                return XmlUtils.getDocument(styleFile + ("pie".equalsIgnoreCase(StyleFileResolver.this.chartType) || "ring".equalsIgnoreCase(StyleFileResolver.this.chartType) ? "_pie" : "") + ".xml");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return IOUtils.toString(new FileReader(styleFile));
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                if (!(paex.getException() instanceof FileNotFoundException)) break block3;
                throw (FileNotFoundException)paex.getException();
            }
        }
        if (style != null && style instanceof String) {
            style = style.toString().replaceAll("\r\n", "");
            style = style.toString().replaceAll("\n", "");
        }
        return style;
    }

    private static Object readFileContent(String styleFile) throws FileNotFoundException {
        return StyleFileResolver.readFileContent(new File(styleFile));
    }

    private static String getCFRoot() {
        RuntimeService rtm = ServiceFactory.getRuntimeService();
        Object rootDir = rtm.getRootDir();
        if (!((String)rootDir).endsWith(File.separator)) {
            rootDir = (String)rootDir + File.separator;
        }
        return rootDir;
    }

    static String readDefaultXDStyles() {
        String style;
        block2: {
            style = null;
            final String styleFileStr = StyleFileResolver.getDefaultChartingStylesDir() + File.separator + DEFAULT_XD_STYLE;
            try {
                style = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws FileNotFoundException {
                        return StyleFileResolver.readFileContent(styleFileStr).toString();
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                if (!(paex.getException() instanceof FileNotFoundException)) break block2;
                throw new ChartTag.UnknownStyleFileException(DEFAULT_XD_STYLE);
            }
        }
        return style;
    }

    static String getDefaultChartingStylesDir() {
        return StyleFileResolver.getCFRoot() + REL_STYLE_DIR;
    }

    private String getStyleFromBasePath(String stylePath, String basePath) {
        if (stylePath == null) {
            return null;
        }
        if (stylePath.startsWith("/") || stylePath.startsWith("\\")) {
            stylePath = stylePath.substring(1);
        }
        String styleFile = basePath + stylePath;
        return styleFile;
    }
}

