/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.ChartSeries;
import coldfusion.graph.GraphCommon;
import coldfusion.graph.IChartConstants;
import coldfusion.graph.InteractiveChart;
import coldfusion.graph.JSONManipulator;
import coldfusion.util.IOUtils;
import coldfusion.util.XmlUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLToJSON
implements IChartConstants {
    private Document styleDoc = null;
    private Map graph = null;
    private boolean show3D;
    private String outline = null;

    public boolean isShow3D() {
        return this.show3D;
    }

    public void setShow3D(boolean show3d) {
        this.show3D = show3d;
    }

    public XMLToJSON(Document styleDoc, Map graph) {
        this.styleDoc = styleDoc;
        this.graph = graph;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Path to XML file is required.");
            return;
        }
        String xmlPath = args[0];
        File styleFile = new File(xmlPath);
        if (styleFile.getAbsolutePath().endsWith(".xml")) {
            try {
                String style = IOUtils.toString(new FileReader(args[1] + "charting/styles/bar"));
                if (style != null) {
                    style = style.replaceAll("\r\n", "");
                    style = style.replaceAll("\n", "");
                }
                Object styleJSON = JSONManipulator.deserializeJSON(style);
                Map jsonMap = (Map)styleJSON;
                List graphset = (List)jsonMap.get("graphset");
                Map graph = (Map)graphset.get(0);
                Document styleDoc = XmlUtils.getDocument(styleFile);
                XMLToJSON xmlToJSON = new XMLToJSON(styleDoc, graph);
                graph = xmlToJSON.convert();
                File jsonFile = new File(xmlPath.substring(0, xmlPath.lastIndexOf(".")));
                FileWriter jsonWriter = new FileWriter(jsonFile);
                jsonWriter.write(JSONManipulator.serializeJSON(jsonMap));
                jsonWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map convert() {
        this.handleFrameChart();
        this.handlePieChart();
        this.handleFrame();
        this.handleAxes();
        this.handleLegend();
        this.handleElements();
        this.handleTitle();
        this.handleDataLabels();
        this.handlePopup();
        this.handleMixedCharts();
        this.handleDefaults();
        return this.graph;
    }

    private void handleDefaults() {
        this.graph.remove("border-width");
    }

    private void handleMixedCharts() {
        Map seriesMap;
        ArrayList seriesMapList = (ArrayList)this.graph.get("series");
        if (seriesMapList == null) {
            return;
        }
        Object baseChartTypeObj = this.graph.get("type");
        String baseChartType = null;
        if (baseChartTypeObj != null) {
            baseChartType = baseChartTypeObj.toString();
        }
        Object currentSeriesTypeObj = null;
        String currentSeriesType = null;
        String baseSeriesType = null;
        Boolean mixed = false;
        for (Object seriesMapObj : seriesMapList) {
            seriesMap = (Map)seriesMapObj;
            currentSeriesTypeObj = seriesMap.get("type");
            currentSeriesType = currentSeriesTypeObj != null ? currentSeriesTypeObj.toString() : null;
            if (currentSeriesType == null) continue;
            if (baseSeriesType != null && !baseSeriesType.equalsIgnoreCase(currentSeriesType)) {
                mixed = true;
                continue;
            }
            baseSeriesType = currentSeriesType;
        }
        if (mixed.booleanValue()) {
            for (Object seriesMapObj : seriesMapList) {
                seriesMap = (Map)seriesMapObj;
                currentSeriesTypeObj = seriesMap.get("type");
                if (currentSeriesTypeObj != null) continue;
                currentSeriesType = baseChartType;
            }
            this.graph.put("type", "mixed");
        } else if (baseSeriesType != null && !baseChartType.equalsIgnoreCase(baseSeriesType)) {
            this.graph.put("type", baseSeriesType);
        }
    }

    private void handlePieChart() {
        String type;
        Node chart = this.getElementByName(this.styleDoc, "pieChart");
        if (chart == null) {
            return;
        }
        NamedNodeMap nodeMap = chart.getAttributes();
        String is3D = this.getNamedItemFromNodeMap(nodeMap, "is3D");
        if (is3D != null && is3D.equalsIgnoreCase("true")) {
            this.graph.put("type", "pie3d");
            this.setShow3D(Boolean.parseBoolean(is3D));
        } else {
            this.graph.put("type", "pie");
        }
        String fontNode = this.getNamedItemFromNodeMap(nodeMap, "font");
        this.handleWebChartsFont(this.graph, fontNode, true);
        String foreground = this.getNamedItemFromNodeMap(nodeMap, "foreground");
        InteractiveChart.handleXMLForegroundColor(this.graph, foreground, "color");
        this.handleBackground(this.getFirstLevelElementByName(chart, "background"), this.graph);
        this.handleInsets(this.getFirstLevelElementByName(chart, "insets"), InteractiveChart.retrieveMapFragment(this.graph, "plotarea"));
        Map<String, Object> plot = InteractiveChart.retrieveMapFragment(this.graph, "plot");
        String style = this.getNamedItemFromNodeMap(nodeMap, "style");
        if (style != null && style.equalsIgnoreCase("sliced")) {
            plot.put("offset", 20);
        }
        if ((type = this.getNamedItemFromNodeMap(nodeMap, "type")) != null) {
            if (type.equalsIgnoreCase("SmallNut")) {
                plot.put("slice", 20);
            } else if (type.equalsIgnoreCase("MediumNut")) {
                plot.put("slice", 33);
            } else if (type.equalsIgnoreCase("LargeNut")) {
                plot.put("slice", 50);
            } else if (type.equalsIgnoreCase("Doughnut") || type.equalsIgnoreCase("RaisedDoughnut")) {
                this.graph.put("type", "nestedpie");
            }
        }
    }

    private void handleInsets(Node insets, Map<String, Object> graph) {
        if (insets != null) {
            NamedNodeMap nodeMap = insets.getAttributes();
            String[] marginDirs = new String[]{"bottom", "left", "top", "right"};
            for (int i = 0; i < marginDirs.length; ++i) {
                String marginDir = marginDirs[i];
                String marginValue = this.getNamedItemFromNodeMap(nodeMap, marginDir);
                if (marginValue == null || marginValue == "") continue;
                graph.put("margin-" + marginDir, marginValue);
            }
        }
    }

    private void handlePopup() {
        Node popup = this.getElementByName(this.styleDoc, "popup");
        if (popup == null) {
            return;
        }
        NamedNodeMap nodeMap = popup.getAttributes();
        Map<String, Object> tooltip = InteractiveChart.retrieveMapFragment(this.graph, "tooltip");
        Object bgcolor = this.getNamedItemFromNodeMap(nodeMap, "background");
        if (bgcolor != null && ((String)bgcolor).length() == 9) {
            bgcolor = "#" + ((String)bgcolor).substring(3);
        }
        InteractiveChart.handleColor(tooltip, (String)bgcolor, "background-color");
        String font = this.getNamedItemFromNodeMap(nodeMap, "font");
        this.handleWebChartsFont(tooltip, font, false);
        String foreground = this.getNamedItemFromNodeMap(nodeMap, "foreground");
        if (foreground != null) {
            tooltip.put("color", foreground);
        }
    }

    private void handleDataLabels() {
        Node dataLabels = this.getElementByName(this.styleDoc, "dataLabels");
        if (dataLabels == null) {
            return;
        }
        NamedNodeMap nodeMap = dataLabels.getAttributes();
        Map<String, Object> plot = InteractiveChart.retrieveMapFragment(this.graph, "plot");
        Map<String, Object> valueBox = null;
        String background = this.getNamedItemFromNodeMap(nodeMap, "background");
        String font = this.getNamedItemFromNodeMap(nodeMap, "font");
        String foreground = this.getNamedItemFromNodeMap(nodeMap, "foreground");
        if (background != null || font != null || foreground != null) {
            valueBox = InteractiveChart.retrieveMapFragment(plot, "value-box");
        }
        this.handleDataLabelStyle(dataLabels, plot);
        if (background != null) {
            valueBox.put("background-color", background);
        }
        this.handleWebChartsFont(valueBox, font, false);
        if (foreground != null) {
            valueBox.put("color", foreground);
        }
    }

    public static String getCharacterDataFromElement(Element e) {
        NodeList list = e.getChildNodes();
        for (int index = 0; index < list.getLength(); ++index) {
            CharacterData child;
            String data;
            if (!(list.item(index) instanceof CharacterData) || (data = (child = (CharacterData)list.item(index)).getData()) == null || data.trim().length() <= 0) continue;
            return child.getData();
        }
        return null;
    }

    private void handleDataLabelStyle(Node dataLabels, Map parentMapFragment) {
        if (dataLabels == null) {
            return;
        }
        NamedNodeMap nodeMap = dataLabels.getAttributes();
        String dataLabelStyle = this.getNamedItemFromNodeMap(nodeMap, "style");
        if (dataLabelStyle == null) {
            if (InteractiveChart.retrieveMapFragment(parentMapFragment, "value-box", false) == null) {
                return;
            }
            dataLabelStyle = "none";
        }
        Object baseChartTypeObj = this.graph.get("type");
        String baseChartType = null;
        if (baseChartTypeObj != null) {
            baseChartType = baseChartTypeObj.toString();
        }
        Map<String, Object> valueBox = InteractiveChart.retrieveMapFragment(parentMapFragment, "value-box");
        if ("value".equalsIgnoreCase(dataLabelStyle)) {
            valueBox.put("text", "%v");
        } else if ("columnlabel".equalsIgnoreCase(dataLabelStyle)) {
            if ("pie".equalsIgnoreCase(baseChartType) || "pie3d".equalsIgnoreCase(baseChartType)) {
                valueBox.put("text", "%t");
            } else {
                valueBox.put("text", "%k");
            }
        } else if ("pattern".equalsIgnoreCase(dataLabelStyle)) {
            String cDataSection = XMLToJSON.getCharacterDataFromElement((Element)dataLabels);
            if (cDataSection != null) {
                valueBox.put("text", this.getZCPattern(cDataSection.trim()));
            } else if ("pie".equalsIgnoreCase(baseChartType) || "pie3d".equalsIgnoreCase(baseChartType)) {
                valueBox.put("text", "%v , %t");
            } else {
                valueBox.put("text", "%v , %k");
            }
        } else if ("none".equalsIgnoreCase(dataLabelStyle)) {
            valueBox.put("text", "");
        } else if ("rowlabel".equalsIgnoreCase(dataLabelStyle)) {
            valueBox.put("text", "%t");
        } else {
            valueBox.put("text", dataLabelStyle);
        }
    }

    private Object getZCPattern(String WCPattern) {
        HashMap<String, String> patternTokens = new HashMap<String, String>(30);
        patternTokens.put("$(colIndex)", "%i");
        patternTokens.put("$(rowIndex)", "%p");
        patternTokens.put("$(colLabel)", "%k");
        patternTokens.put("$(rowLabel)", "%t");
        patternTokens.put("$(value)", "%v");
        patternTokens.put("$(colTotal)", "%psum");
        patternTokens.put("$(rowTotal)", "%total");
        patternTokens.put("$(colPercent)", "%pper");
        patternTokens.put("$(rowPercent)", "%npv");
        String cData = WCPattern;
        for (Map.Entry entry : patternTokens.entrySet()) {
            cData = cData.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return cData;
    }

    private void handleBackground(Node background, Map<String, Object> graph) {
        if (background != null) {
            String imageLocation;
            NamedNodeMap nodeMap = background.getAttributes();
            String type = this.getNamedItemFromNodeMap(nodeMap, "type");
            if (type != null) {
                String maxColor = this.getNamedItemFromNodeMap(nodeMap, "maxColor");
                if (maxColor != null && !"PlainColor".equalsIgnoreCase(type)) {
                    this.handleColor(graph, maxColor, "background-color-2");
                } else {
                    graph.remove("background-color-2");
                }
                String minColor = this.getNamedItemFromNodeMap(nodeMap, "minColor");
                if (minColor != null) {
                    this.handleColor(graph, minColor, "background-color");
                }
                if ("transparent".equalsIgnoreCase(type)) {
                    graph.put("alpha", 0);
                } else if ("verticalgradient".equalsIgnoreCase(type)) {
                    graph.put("fill-angle", 0);
                } else if ("horizontalgradient".equalsIgnoreCase(type)) {
                    graph.put("fill-angle", 90);
                } else if ("DiagonalRtLbGradient".equalsIgnoreCase(type)) {
                    graph.put("fill-angle", 315);
                } else if ("DiagonalLtRbGradient".equalsIgnoreCase(type)) {
                    graph.put("fill-angle", 45);
                }
            }
            if ((imageLocation = this.getNamedItemFromNodeMap(nodeMap, "imageLocation")) != null) {
                graph.put("background-image", imageLocation);
                graph.put("background-repeat", "false");
                String imagePlacement = this.getNamedItemFromNodeMap(nodeMap, "imagePlacement");
                if (imagePlacement != null) {
                    if (imagePlacement.equalsIgnoreCase("scaled")) {
                        graph.put("background-fit", "xy");
                    } else if (imagePlacement.equalsIgnoreCase("LeftTop")) {
                        graph.put("background-position", "0% 0%");
                    } else if (imagePlacement.equalsIgnoreCase("RightTop")) {
                        graph.put("background-position", "100% 0%");
                    } else if (imagePlacement.equalsIgnoreCase("LeftBottom")) {
                        graph.put("background-position", "0% 100%");
                    } else if (imagePlacement.equalsIgnoreCase("RightBottom")) {
                        graph.put("background-position", "100% 100%");
                    }
                }
            }
        }
    }

    private String getNamedItemFromNodeMap(NamedNodeMap nodeMap, String nodeName) {
        Node namedItem = nodeMap.getNamedItem(nodeName);
        if (namedItem != null) {
            return namedItem.getNodeValue();
        }
        return null;
    }

    private void handleFrame() {
        String gridStroke;
        String gridColor;
        Map<String, Object> scaleXGuide;
        String isVGridVisible;
        String isHGridVisible;
        String dashSize;
        Node frame = this.getElementByName(this.styleDoc, "frame");
        if (frame == null) {
            return;
        }
        NamedNodeMap nodeMap = frame.getAttributes();
        if (frame instanceof Element) {
            this.handleBackground(this.getElementByName((Element)frame, "background"), InteractiveChart.retrieveMapFragment(this.graph, "plotarea"));
        }
        if ((dashSize = this.getNamedItemFromNodeMap(nodeMap, "dashSize")) != null) {
            Map<String, Object> scaleXTick = InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-x:tick");
            Map<String, Object> scaleYTick = InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-y:tick");
            scaleXTick.put("size", dashSize);
            scaleYTick.put("size", dashSize);
        }
        if ((isHGridVisible = this.getNamedItemFromNodeMap(nodeMap, "isHGridVisible")) != null && isHGridVisible.equalsIgnoreCase("false")) {
            Map<String, Object> scaleY = InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-y");
            Map<String, Object> scaleYGuide = InteractiveChart.retrieveNestedMapFragment(scaleY, "guide");
            scaleYGuide.put("visible", false);
        }
        if ((isVGridVisible = this.getNamedItemFromNodeMap(nodeMap, "isVGridVisible")) != null && isVGridVisible.equalsIgnoreCase("true")) {
            Map<String, Object> scaleX = InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-x");
            scaleXGuide = InteractiveChart.retrieveNestedMapFragment(scaleX, "guide");
            scaleXGuide.put("line-width", 1);
            scaleXGuide.put("line-gap-size", 0);
            scaleXGuide.put("line-color", "#000000");
        }
        if ((gridColor = this.getNamedItemFromNodeMap(nodeMap, "gridColor")) != null) {
            scaleXGuide = InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-x:guide");
            Map<String, Object> scaleYGuide = InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-y:guide");
            InteractiveChart.handleColor(scaleXGuide, gridColor, "line-color");
            InteractiveChart.handleColor(scaleYGuide, gridColor, "line-color");
            scaleXGuide.put("line-gap-size", 0);
            scaleYGuide.put("line-gap-size", 0);
        }
        if ((gridStroke = this.getNamedItemFromNodeMap(nodeMap, "gridStroke")) != null) {
            this.handleLineStroke(gridStroke, InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-x:guide"));
            this.handleLineStroke(gridStroke, InteractiveChart.retrieveNestedMapFragment(this.graph, "scale-y:guide"));
        }
        String outline = this.getNamedItemFromNodeMap(nodeMap, "outline");
        InteractiveChart.handlePlotAreaOutline(this.graph, outline);
        this.outline = outline;
        String xDepth = this.getNamedItemFromNodeMap(nodeMap, "xDepth");
        if (xDepth != null) {
            Map<String, Object> aspect3D = InteractiveChart.retrieveMapFragment(this.graph, "3d-aspect");
            aspect3D.put("depth", xDepth);
        }
    }

    private void handleLineStroke(String gridStroke, Map<String, Object> mapFragment) {
        if (gridStroke != null) {
            if (gridStroke.equalsIgnoreCase("Solid")) {
                mapFragment.put("line-gap-size", 0);
            } else if (gridStroke.equalsIgnoreCase("Dotted")) {
                mapFragment.put("line-dotted", 1);
                mapFragment.put("line-segment-size", 1);
                mapFragment.put("line-gap-size", 3);
            } else if (gridStroke.equalsIgnoreCase("Dashed")) {
                mapFragment.put("line-dashed", 1);
                mapFragment.put("line-segment-size", 6);
                mapFragment.put("line-gap-size", 2);
            }
        }
    }

    private void handleFrameChart() {
        Node frameChart = this.getElementByName(this.styleDoc, "frameChart");
        if (frameChart != null) {
            NamedNodeMap nodeMap = frameChart.getAttributes();
            this.setShow3D(Boolean.parseBoolean(this.getNamedItemFromNodeMap(nodeMap, "is3D")));
            String fontNode = this.getNamedItemFromNodeMap(nodeMap, "font");
            this.handleWebChartsFont(this.graph, fontNode, true);
            String foreground = this.getNamedItemFromNodeMap(nodeMap, "foreground");
            InteractiveChart.handleXMLForegroundColor(this.graph, foreground, "color");
            this.handleBackground(this.getFirstLevelElementByName(frameChart, "background"), this.graph);
            this.handleInsets(this.getFirstLevelElementByName(frameChart, "insets"), InteractiveChart.retrieveMapFragment(this.graph, "plotarea"));
        }
    }

    private void handleTitle() {
        Node titleNode = this.getElementByName(this.styleDoc, "title");
        if (titleNode != null) {
            NamedNodeMap nodeMap = titleNode.getAttributes();
            Map<String, Object> title = InteractiveChart.retrieveMapFragment(this.graph, "title");
            String background = this.getNamedItemFromNodeMap(nodeMap, "background");
            InteractiveChart.handleColor(title, background, "background-color");
            String font = this.getNamedItemFromNodeMap(nodeMap, "font");
            this.handleWebChartsFont(title, font, false);
            String foreground = this.getNamedItemFromNodeMap(nodeMap, "foreground");
            if (foreground != null) {
                title.put("color", foreground);
            }
            this.handlePlacement(titleNode, title);
            this.handleInsets(this.getElementByName(titleNode, "insets"), title);
            title.put("text", titleNode.getTextContent().trim());
        }
    }

    private void handleAxes() {
        this.handleCommonAxisElements(this.getElementByName(this.styleDoc, "xAxis"), "scale-x");
        this.handleCommonAxisElements(this.getElementByName(this.styleDoc, "yAxis"), "scale-y");
        this.handleCommonAxisElements(this.getElementByName(this.styleDoc, "yAxis2"), "scale-y-2");
    }

    private void handleCommonAxisElements(Node axisNode, String axisStructName) {
        if (axisNode != null) {
            Node titleStyle;
            NamedNodeMap nodeMap = axisNode.getAttributes();
            Map<String, Object> axisMap = InteractiveChart.retrieveMapFragment(this.graph, axisStructName);
            String isVisible = this.getNamedItemFromNodeMap(nodeMap, "isVisible");
            if ("false".equalsIgnoreCase(isVisible)) {
                axisMap.put("visible", "false");
                return;
            }
            Node labelStyle = this.getElementByName(axisNode, "labelStyle");
            if (labelStyle != null) {
                NamedNodeMap labelStyleAttrMap = labelStyle.getAttributes();
                String color = this.getNamedItemFromNodeMap(labelStyleAttrMap, "color");
                Map<String, Object> scaleXItem = InteractiveChart.retrieveMapFragment(axisMap, "item");
                InteractiveChart.handleColor(scaleXItem, color, "color");
                String orientation = this.getNamedItemFromNodeMap(labelStyleAttrMap, "orientation");
                if (orientation != null) {
                    if (orientation.equalsIgnoreCase("Slanted")) {
                        scaleXItem.put("font-angle", -45);
                    } else if (orientation.equalsIgnoreCase("Vertical")) {
                        scaleXItem.put("font-angle", -90);
                    }
                }
            }
            if ((titleStyle = this.getElementByName(axisNode, "titleStyle")) != null) {
                NamedNodeMap titleStyleAttrMap = titleStyle.getAttributes();
                String titleFont = this.getNamedItemFromNodeMap(titleStyleAttrMap, "font");
                this.handleWebChartsFont(axisMap, titleFont, false);
                String titleForeground = this.getNamedItemFromNodeMap(titleStyleAttrMap, "foreground");
                InteractiveChart.handleColor(axisMap, titleForeground, "color");
                Map<String, Object> axisLabelMap = InteractiveChart.retrieveMapFragment(axisMap, "label");
                axisLabelMap.put("text", titleStyle.getTextContent().trim());
            }
            if (this.outline != null) {
                InteractiveChart.handleColor(axisMap, this.outline, "line-color");
                axisMap.put("line-width", 1);
            }
        }
    }

    private void handleLegend() {
        Node legendNode = this.getElementByName(this.styleDoc, "legend");
        if (legendNode != null) {
            NamedNodeMap nodeMap = legendNode.getAttributes();
            Map<String, Object> legend = InteractiveChart.retrieveMapFragment(this.graph, "legend");
            String isVisible = this.getNamedItemFromNodeMap(nodeMap, "isVisible");
            if ("false".equalsIgnoreCase(isVisible)) {
                legend.put("visible", "false");
                return;
            }
            String background = this.getNamedItemFromNodeMap(nodeMap, "background");
            InteractiveChart.handleColor(legend, background, "background-color");
            Map<String, Object> item = InteractiveChart.retrieveMapFragment(legend, "item");
            String font = this.getNamedItemFromNodeMap(nodeMap, "font");
            this.handleWebChartsFont(item, font, false);
            String foreground = this.getNamedItemFromNodeMap(nodeMap, "foreground");
            if (foreground != null) {
                InteractiveChart.handleColor(item, foreground, "color");
            }
            this.handlePlacement(legendNode, legend);
            this.handleInsets(this.getElementByName(legendNode, "insets"), legend);
        }
    }

    private void handleWebChartsFont(Map<String, Object> graph, String font, Boolean global) {
        if (font == null) {
            return;
        }
        String[] fontTokens = font.split("-");
        int fontTokenCount = fontTokens.length;
        int currentTokenIndex = 0;
        this.handleLocalGlobalFont(graph, fontTokens[currentTokenIndex], "font-family", global);
        if (++currentTokenIndex > fontTokenCount - 1) {
            return;
        }
        this.handleLocalGlobalFont(graph, fontTokens[currentTokenIndex], "font-size", global);
        if (++currentTokenIndex > fontTokenCount - 1) {
            return;
        }
        if (fontTokens[currentTokenIndex].equalsIgnoreCase("bold")) {
            this.handleLocalGlobalFont(graph, "true", "bold", global);
        } else {
            this.handleLocalGlobalFont(graph, "true", "italic", global);
        }
        if (++currentTokenIndex > fontTokenCount - 1) {
            return;
        }
        this.handleLocalGlobalFont(graph, "true", "italic", global);
    }

    private void handleLocalGlobalFont(Map<String, Object> graph, String attributeValue, String attributeName, Boolean global) {
        if (global.booleanValue()) {
            InteractiveChart.handleFont(graph, attributeValue, attributeName);
        } else {
            graph.put(attributeName, attributeValue);
        }
    }

    private void handlePlacement(Node parentNode, Map<String, Object> graph) {
        NamedNodeMap nodeMap = parentNode.getAttributes();
        String hAlign = this.getNamedItemFromNodeMap(nodeMap, "halign");
        String positionX = "50%";
        if ("left".equalsIgnoreCase(hAlign)) {
            positionX = "0%";
        } else if ("right".equalsIgnoreCase(hAlign)) {
            positionX = "100%";
        }
        String vAlign = this.getNamedItemFromNodeMap(nodeMap, "valign");
        String positionY = "50%";
        if ("top".equalsIgnoreCase(vAlign)) {
            positionY = "0%";
        } else if ("bottom".equalsIgnoreCase(vAlign)) {
            positionY = "100%";
        }
        String placement = this.getNamedItemFromNodeMap(nodeMap, "placement");
        if (placement != null && !placement.equalsIgnoreCase("top")) {
            if (placement.equalsIgnoreCase("bottom")) {
                graph.put("layout", "1x");
                graph.put("position", positionX + " 100%");
            } else if (placement.equalsIgnoreCase("left")) {
                graph.put("layout", "x1");
                graph.put("position", "0% " + positionY);
            } else if (placement.equalsIgnoreCase("right")) {
                graph.put("layout", "x1");
                graph.put("position", "100% " + positionY);
            }
        } else if (hAlign != null) {
            graph.put("layout", "1x");
            graph.put("position", positionX + " 0%");
        }
    }

    private Node getElementByName(Node styleNode, String tagname) {
        NodeList nodeList = null;
        if (styleNode == null) {
            return null;
        }
        if (styleNode instanceof Element) {
            nodeList = ((Element)styleNode).getElementsByTagName(tagname);
        } else if (styleNode instanceof Document) {
            nodeList = ((Document)styleNode).getElementsByTagName(tagname);
        }
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    private Node getFirstLevelElementByName(Node styleNode, String tagname) {
        NodeList nodeList = null;
        if (styleNode == null) {
            return null;
        }
        if (styleNode instanceof Element) {
            nodeList = ((Element)styleNode).getChildNodes();
        } else if (styleNode instanceof Document) {
            nodeList = ((Document)styleNode).getChildNodes();
        }
        if (nodeList != null && nodeList.getLength() > 0) {
            for (Node currentNode = nodeList.item(0); currentNode != null; currentNode = currentNode.getNextSibling()) {
                if (!currentNode.getNodeName().equalsIgnoreCase(tagname)) continue;
                return currentNode;
            }
        }
        return null;
    }

    private void handleElements() {
        Node elements = this.getElementByName(this.styleDoc, "elements");
        if (elements != null) {
            NodeList seriesNodeList;
            String showMarkers;
            String drawOutline;
            String outline;
            String markerSize;
            String lineWidth;
            String drawShadow;
            String annotation;
            NamedNodeMap elementsAttrMap = elements.getAttributes();
            Map<String, Object> plot = InteractiveChart.retrieveMapFragment(this.graph, "plot");
            String action = this.getNamedItemFromNodeMap(elementsAttrMap, "action");
            if (action != null) {
                plot.put("url", action);
            }
            if ((annotation = XMLToJSON.getCharacterDataFromElement((Element)elements)) != null) {
                Map<String, Object> tooltip = InteractiveChart.retrieveMapFragment(this.graph, "tooltip");
                tooltip.put("text", this.getZCPattern(annotation.trim()));
            }
            if ((drawShadow = this.getNamedItemFromNodeMap(elementsAttrMap, "drawShadow")) != null) {
                if (drawShadow.equalsIgnoreCase("true")) {
                    plot.put("shadow", "true");
                    plot.put("shadow-alpha", "1");
                    plot.put("shadow-color", "#000000");
                } else {
                    plot.put("shadow", false);
                }
            }
            if ((lineWidth = this.getNamedItemFromNodeMap(elementsAttrMap, "lineWidth")) != null) {
                plot.put("shadow-distance", lineWidth);
            }
            if ((markerSize = this.getNamedItemFromNodeMap(elementsAttrMap, "markerSize")) != null) {
                Map<String, Object> marker = InteractiveChart.retrieveMapFragment(plot, "marker");
                if (Integer.parseInt(markerSize) > 0) {
                    marker.put("size", markerSize);
                } else {
                    marker.put("visible", false);
                }
            }
            if ((outline = this.getNamedItemFromNodeMap(elementsAttrMap, "outline")) != null) {
                InteractiveChart.handleOutline(plot, outline);
            }
            if ((drawOutline = this.getNamedItemFromNodeMap(elementsAttrMap, "drawOutline")) != null && drawOutline.equalsIgnoreCase("false")) {
                plot.remove("border-width");
                plot.remove("border-color");
            }
            String place = this.getNamedItemFromNodeMap(elementsAttrMap, "place");
            this.handlePlace(this.graph, place);
            String shape = this.getNamedItemFromNodeMap(elementsAttrMap, "shape");
            this.handleShape(shape, this.graph, true);
            String shapeSize = this.getNamedItemFromNodeMap(elementsAttrMap, "shapeSize");
            if (shapeSize != null) {
                plot.put("bar-width", Integer.parseInt(shapeSize) / 5);
            }
            if ((showMarkers = this.getNamedItemFromNodeMap(elementsAttrMap, "showMarkers")) != null && showMarkers.equalsIgnoreCase("false")) {
                Map<String, Object> marker = InteractiveChart.retrieveMapFragment(plot, "marker");
                marker.put("type", "none");
            }
            if ((seriesNodeList = ((Element)elements).getElementsByTagName("series")) != null && seriesNodeList.getLength() > 0) {
                ArrayList<HashMap<String, Object>> seriesMapList = (ArrayList<HashMap<String, Object>>)this.graph.get("series");
                if (seriesMapList == null) {
                    seriesMapList = new ArrayList<HashMap<String, Object>>(seriesNodeList.getLength());
                    this.graph.put("series", seriesMapList);
                }
                for (int i = 0; i < seriesNodeList.getLength(); ++i) {
                    Node seriesNode = seriesNodeList.item(i);
                    NamedNodeMap seriesAttrMap = seriesNode.getAttributes();
                    HashMap<String, Object> seriesMap = null;
                    try {
                        seriesMap = (HashMap<String, Object>)seriesMapList.get(i);
                    }
                    catch (IndexOutOfBoundsException ioe) {
                        seriesMap = new HashMap<String, Object>();
                        seriesMapList.add(seriesMap);
                    }
                    this.handleSeries(seriesNode, seriesMap);
                }
            }
        }
    }

    private void handleShape(String shape, Map mapFragment, boolean global) {
        if (shape != null) {
            if (!InteractiveChart.isValidChartType(shape = shape.toLowerCase())) {
                throw new GraphCommon.InvalidChartTypeException(shape);
            }
            mapFragment.put("type", InteractiveChart.handleOldChartTypes(shape));
            if (global) {
                mapFragment = InteractiveChart.retrieveMapFragment(this.graph, "plot");
            }
            if ("curve".equalsIgnoreCase(shape)) {
                mapFragment.put("aspect", "spline");
            } else if ("step".equalsIgnoreCase(shape)) {
                mapFragment.put("aspect", "stepped");
            }
            if ("cone".equalsIgnoreCase(shape)) {
                mapFragment.put("aspect", "cone");
                if (mapFragment.get("alpha") == null) {
                    mapFragment.put("alpha", "0.75");
                }
            } else if ("cylinder".equalsIgnoreCase(shape)) {
                mapFragment.put("aspect", "cylinder");
                if (mapFragment.get("alpha") == null) {
                    mapFragment.put("alpha", "0.75");
                }
            } else if ("pyramid".equalsIgnoreCase(shape)) {
                mapFragment.put("aspect", "pyramid");
                if (mapFragment.get("alpha") == null) {
                    mapFragment.put("alpha", "0.75");
                }
            }
        }
    }

    private void handleSeries(Node seriesNode, Map<String, Object> seriesMap) {
        String color;
        NamedNodeMap markerAttrMap;
        String markerType;
        Node markerNode;
        String annotation;
        NamedNodeMap seriesAttrMap = seriesNode.getAttributes();
        String action = this.getNamedItemFromNodeMap(seriesAttrMap, "action");
        if (action != null) {
            seriesMap.put("url", action);
        }
        if ((annotation = XMLToJSON.getCharacterDataFromElement((Element)seriesNode)) != null) {
            Map<String, Object> tooltip = InteractiveChart.retrieveMapFragment(seriesMap, "tooltip");
            tooltip.put("text", this.getZCPattern(annotation.trim()));
        }
        this.handleDataLabelStyle(this.getElementByName(seriesNode, "dataLabel"), seriesMap);
        String lineStroke = this.getNamedItemFromNodeMap(seriesAttrMap, "lineStroke");
        this.handleLineStroke(lineStroke, seriesMap);
        String lineWidth = this.getNamedItemFromNodeMap(seriesAttrMap, "lineWidth");
        if (lineWidth != null) {
            seriesMap.put("line-width", lineWidth);
        }
        if ((markerNode = this.getElementByName(seriesNode, "marker")) != null && (markerType = this.getNamedItemFromNodeMap(markerAttrMap = markerNode.getAttributes(), "type")) != null) {
            Map<String, Object> marker = InteractiveChart.retrieveMapFragment(seriesMap, "marker");
            marker.put("type", markerType);
        }
        this.handleShape(this.getNamedItemFromNodeMap(seriesAttrMap, "shape"), seriesMap, false);
        Node paint = this.getElementByName(seriesNode, "paint");
        if (paint != null && (color = this.getNamedItemFromNodeMap(paint.getAttributes(), "color")) != null) {
            seriesMap.put("background-color", color);
            seriesMap.put("background-color-2", color);
        }
    }

    private void handlePlace(Map<String, Object> graph, String place) {
        if (place != null) {
            if (place.equalsIgnoreCase("stacked")) {
                graph.put("stacked", "true");
            } else if (place.equalsIgnoreCase("percent")) {
                graph.put("stacked", "true");
                graph.put("stack-type", "100%");
            }
        }
    }

    private void handleColor(Map<String, Object> graph, String color, String attributeName) {
        if (!color.startsWith("#")) {
            color = ChartSeries.toHexColor(color);
        }
        graph.put(attributeName, color);
    }
}

