/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.java;

import coldfusion.compiler.NeoTranslator;
import coldfusion.filter.FusionContext;
import coldfusion.osgi.services.LanguageService;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.security.SecurityManager;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.tagext.security.JavaTag;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class LanguageImpl
implements LanguageService {
    private static final String CLASS_NAME_PREFIX = "cfjava_";
    private static Map<String, String> datatypeMap = new HashMap<String, String>();
    private static Map<String, Class> datatypeClassMap;
    private Map<String, Class> classCache = new HashMap<String, Class>();

    @Override
    public Object runJava(String content, String execute, CfJspPage page, Object[] args) throws Exception {
        ServiceFactory.getSecurityService().checkPermission(SecurityManager.ALLOW_JAVA_NATIVE_CALLS);
        content = this.trimBraces(content);
        String className = this.extractClassName(content);
        if (className == null) {
            className = this.getClassName(content);
            content = this.wrapWithClass(content, className, args);
        }
        return this._runJava(content, className, execute, page, args);
    }

    private String getClassName(String content) {
        return CLASS_NAME_PREFIX + NeoTranslator.getClassName(new File(FusionContext.getCurrent().getPagePath())) + "_" + Math.abs(content.hashCode());
    }

    private Object _runJava(String content, String className, String execute, CfJspPage page, Object[] args) throws Exception {
        Path javaFile = null;
        try {
            javaFile = this.saveSource(content, className);
        }
        catch (IOException e) {
            throw new JavaTag.SourceNotSavedException();
        }
        Class clazz = this.compileSource(javaFile, className);
        try {
            Object o = this.runClass(clazz, execute, className, page, args);
            return o;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException e) {
            throw new JavaTag.ClassCanNotRunException(e.getCause().toString());
        }
    }

    @Override
    public Object runJava(String content, String execute) throws Exception {
        ServiceFactory.getSecurityService().checkPermission(SecurityManager.ALLOW_JAVA_NATIVE_CALLS);
        content = this.trimBraces(content);
        String className = this.extractClassName(content);
        if (className == null) {
            className = this.getClassName(content);
            content = this.wrapWithClass(content, className);
        }
        return this._runJava(content, className, execute, null, new Object[0]);
    }

    private String trimBraces(String content) {
        content.trim();
        if (content.startsWith("{")) {
            content = content.substring(1, content.length() - 1);
        }
        if (content.toLowerCase().startsWith("java")) {
            content = content.substring(content.indexOf("$") + 1, content.length() - 1);
        }
        return content;
    }

    private String wrapWithClass(String content, String classname) {
        String returnType = "void";
        if (((String)content).contains("return ")) {
            returnType = "Object";
        }
        content = "public " + returnType + "  execute(){" + (String)content + "}";
        content = "public class " + classname + "{" + (String)content + "}";
        return content;
    }

    public static Map structToMap(Object ss) {
        Struct s = (Struct)ss;
        HashMap m = new HashMap();
        for (Object o : s.keySet()) {
            m.put(o, s.get(o));
        }
        return m;
    }

    private String wrapWithClass(String code, String classname, Object[] argNames) {
        String returnType = "void";
        if (code.contains("return ")) {
            returnType = "Object";
        }
        Object content = " public " + returnType + "  execute( ";
        int i = 0;
        Object converts = "";
        boolean isStruct = false;
        for (Object obj : argNames) {
            String str = (String)obj;
            if (i++ % 2 == 0) {
                String jType = datatypeMap.get(str.toLowerCase());
                boolean isClass = false;
                try {
                    Class.forName(str);
                    isClass = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (isClass) {
                    jType = str;
                }
                if (str.equalsIgnoreCase("struct")) {
                    jType = "Object";
                    isStruct = true;
                }
                if (jType == null) {
                    jType = "Object";
                }
                content = (String)content + jType + " ";
                continue;
            }
            if (isStruct) {
                converts = (String)converts + "java.util.Map " + str + "= coldfusion.java.LanguageImpl.structToMap(" + str + "temp);";
                content = (String)content + str + "temp,";
                isStruct = false;
                continue;
            }
            content = (String)content + str + ",";
        }
        if (((String)content).endsWith(",")) {
            content = ((String)content).substring(0, ((String)content).length() - 1);
        }
        content = (String)content + "){" + (String)converts + code + "}";
        content = "public class " + classname + "{" + (String)content + "}";
        return content;
    }

    @Override
    public Object runJavascript(String content) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        try {
            engine.eval(content);
            Invocable inv = (Invocable)((Object)engine);
            Object ret = inv.invokeFunction("execute", new Object[0]);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String extractClassName(String content) {
        boolean next = false;
        String[] splits = content.split("\\s+");
        String className = null;
        int count = 0;
        for (String split : splits) {
            ++count;
            split = split.trim();
            if (next) {
                if (split.endsWith("{")) {
                    split = split.substring(0, split.length() - 1);
                }
                className = split;
                break;
            }
            if (!split.equalsIgnoreCase("class") || !splits[count - 2].equalsIgnoreCase("public")) continue;
            next = true;
        }
        return className;
    }

    private Path saveSource(String source, String className) throws IOException {
        String tmpProperty = System.getProperty("java.io.tmpdir");
        Path sourcePath = Paths.get(tmpProperty, className + ".java");
        Files.write(sourcePath, source.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        return sourcePath;
    }

    private static String buildClassPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (path.endsWith("*")) {
                File pathFile = new File(path = path.substring(0, path.length() - 1));
                if (pathFile == null || !pathFile.exists()) continue;
                for (File file : pathFile.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith(".jar") || file.getName().toLowerCase().contains("jakarta")) continue;
                    sb.append(path);
                    sb.append(file.getName());
                    sb.append(System.getProperty("path.separator"));
                }
                continue;
            }
            sb.append(path);
            sb.append(System.getProperty("path.separator"));
        }
        return sb.toString();
    }

    private Class compileSource(Path javaFile, String className) throws Exception {
        Path classPath = javaFile.getParent().resolve(className + ".class");
        if (this.classCache.get(className) != null) {
            boolean trustedCache = ServiceFactory.getRuntimeService().isTrustedCache();
            if (trustedCache) {
                return this.classCache.get(className);
            }
            long lastModifiedCFFile = TemplateClassLoader.getLastModifiedTime(FusionContext.getCurrent().getPagePath());
            long lastModifiedClassFile = classPath.toFile().lastModified();
            if (lastModifiedClassFile > lastModifiedCFFile) {
                return this.classCache.get(className);
            }
        }
        File[] javaFiles = new File[]{new File(javaFile.toFile().getAbsolutePath())};
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(javaFiles));
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.clear();
        Object cpList = LanguageImpl.buildClassPath(ServiceFactory.getRuntimeService().getLibDir() + File.separator + "*");
        cpList = (String)cpList + System.getProperty("path.separator") + LanguageImpl.buildClassPath(ServiceFactory.getRuntimeService().getLibDir() + File.separator + ".." + File.separator + "runtime" + File.separator + "lib" + File.separator + "*");
        cpList = (String)cpList + this.getJavaSettingClasspath();
        if (ServerlessUtil.isLambdaEnv()) {
            cpList = LanguageImpl.buildClassPath("/var/task/lib/*");
        }
        optionList.addAll(Arrays.asList("-classpath", cpList));
        JavaCompiler.CompilationTask task2 = compiler.getTask(null, fileManager, diagnostics, optionList, null, compilationUnits);
        task2.call();
        List errors = diagnostics.getDiagnostics();
        if (errors.size() > 0) {
            Object compilationErrors = "";
            int count = 0;
            for (Diagnostic diag : errors) {
                if (!diag.getKind().equals((Object)Diagnostic.Kind.ERROR)) continue;
                compilationErrors = (String)compilationErrors + ++count + "." + diag.toString() + "\n";
            }
            if (((String)compilationErrors).length() > 0) {
                throw new JavaTag.CompilationException((String)compilationErrors);
            }
        }
        Class clazz = this.getClass(classPath, className);
        return clazz;
    }

    private void resolveLoadPaths(List<String> loadPaths, String applicationCFCPath) {
        for (int i = 0; i < loadPaths.size(); ++i) {
            String realPath;
            File realFile;
            File appCFC;
            File f;
            String userPath = loadPaths.get(i);
            String path = userPath.replace("\\", "/");
            if (applicationCFCPath != null && (f = new File((appCFC = new File(applicationCFCPath)).getParentFile().getAbsolutePath(), path)).exists()) {
                loadPaths.set(i, f.getAbsolutePath());
                continue;
            }
            if (path.startsWith("/") && (realFile = new File(realPath = FusionContext.getCurrent().getRealPath(path))).exists()) {
                loadPaths.set(i, realFile.getAbsolutePath());
                continue;
            }
            File pathFile = new File(path);
            if (!pathFile.exists() || !pathFile.isAbsolute()) continue;
            loadPaths.set(i, pathFile.getAbsolutePath());
        }
    }

    private Object runClass(Class clazz, String execute, String className, CfJspPage page, Object[] argNames) throws Exception {
        if (null == execute) {
            execute = "execute";
        }
        JavaProxy jp = new JavaProxy(clazz);
        if (className.startsWith(CLASS_NAME_PREFIX)) {
            Object inst = clazz.newInstance();
            try {
                Class[] clsAry = new Class[argNames.length / 2];
                int y = 0;
                int z = 0;
                for (Object argName : argNames) {
                    if (y++ % 2 != 0) continue;
                    String type = (String)argName;
                    Class<Object> jClass = datatypeClassMap.get(type.toLowerCase());
                    try {
                        jClass = Class.forName(type);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (jClass == null) {
                        jClass = Object.class;
                    }
                    clsAry[z++] = jClass;
                }
                Method met = clazz.getMethod(execute, clsAry);
                Object[] args = new Object[argNames.length / 2];
                int x = 0;
                int i = 0;
                for (Object argName : argNames) {
                    if (i++ % 2 != 1) continue;
                    Object val = page._get((String)argName);
                    if (val instanceof CFBoolean) {
                        val = Cast._boolean(val);
                    } else if (val instanceof Array) {
                        val = this.cfArrayToJavaArray(val);
                    }
                    if (val instanceof CFDouble) {
                        val = Cast._double(val);
                    }
                    args[x++] = val;
                }
                return met.invoke(inst, args);
            }
            catch (Throwable e) {
                if (e.getCause() != null) {
                    throw new Exception(e.getCause());
                }
                throw new Exception(e);
            }
        }
        return jp;
    }

    private Class getClass(Path javaClass, String className) throws Exception {
        URL classUrl = javaClass.getParent().toFile().toURI().toURL();
        Object cp = LanguageImpl.buildClassPath(ServiceFactory.getRuntimeService().getLibDir() + File.separator + "*");
        cp = (String)cp + System.getProperty("path.separator") + LanguageImpl.buildClassPath(ServiceFactory.getRuntimeService().getLibDir() + File.separator + ".." + File.separator + "runtime" + File.separator + "lib" + File.separator + "*");
        cp = (String)cp + this.getJavaSettingClasspath();
        if (ServerlessUtil.isLambdaEnv()) {
            cp = LanguageImpl.buildClassPath("/var/task/lib/*");
        }
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(classUrl);
        URLClassLoader classLoader = null;
        if (!className.startsWith(CLASS_NAME_PREFIX)) {
            for (String c : ((String)cp).split(System.getProperty("path.separator"))) {
                list.add(new File(c).toURI().toURL());
                classLoader = URLClassLoader.newInstance(list.toArray(new URL[list.size()]));
            }
        } else {
            classLoader = URLClassLoader.newInstance(list.toArray(new URL[list.size()]), this.getClass().getClassLoader());
        }
        Class<?> clazz = Class.forName(className, true, classLoader);
        this.classCache.put(className, clazz);
        return clazz;
    }

    private String getJavaSettingClasspath() {
        List loadPaths;
        Map javaSetting;
        Map settingsMap;
        if (FusionContext.getCurrent() == null || FusionContext.getCurrent().getApplicationName() == null) {
            return "";
        }
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        Object cp = "";
        if (appScope != null && (settingsMap = appScope.getApplicationSettingsMap()) != null && (javaSetting = (Map)settingsMap.get("javaSettings")) != null && (loadPaths = (List)javaSetting.get("loadpaths")) != null) {
            this.resolveLoadPaths(loadPaths, appScope.getApplicationPath());
            Object path = "";
            for (String p : loadPaths) {
                if (p.toLowerCase().endsWith(".jar")) {
                    path = (String)path + System.getProperty("path.separator") + p;
                    continue;
                }
                path = (String)path + System.getProperty("path.separator") + LanguageImpl.buildClassPath(p + File.separator + "*");
            }
            cp = (String)cp + System.getProperty("path.separator") + (String)path;
        }
        return cp;
    }

    private Object cfArrayToJavaArray(Object val) {
        Array arr = (Array)val;
        Object firstval = arr.get(0);
        val = firstval instanceof String ? Cast.toJavaArray("String", (List)val) : Cast.toJavaArray("double", (List)val);
        return val;
    }

    static {
        datatypeMap.put("string", "String");
        datatypeMap.put("numeric", "java.lang.Integer");
        datatypeMap.put("numeric[]", "double[]");
        datatypeMap.put("string[]", "String[]");
        datatypeMap.put("boolean", "boolean");
        datatypeClassMap = new HashMap<String, Class>();
        datatypeClassMap.put("string", String.class);
        datatypeClassMap.put("numeric", Integer.class);
        datatypeClassMap.put("numeric[]", double[].class);
        datatypeClassMap.put("string[]", String[].class);
        datatypeClassMap.put("boolean", Boolean.TYPE);
    }
}

