/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.log;

import coldfusion.log.LogService;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class CFLogLevel {
    public static final String PRIORITY_FATAL = "Fatal";
    public static final String PRIORITY_ERROR = "Error";
    public static final String PRIORITY_WARN = "Warning";
    public static final String PRIORITY_WARN2 = "Warn";
    public static final String PRIORITY_INFO = "Information";
    public static final String PRIORITY_INFO2 = "Info";
    public static final String PRIORITY_DEBUG = "Debug";
    public static final String NO_LOG = "Off";
    public static String cliLogLevel;
    public static String logLevel;
    private static Map<String, Level> levelTable;
    private static Map<String, String> levelToIntegerTable;

    static String getCliArgLogLevel() {
        if (!(cliLogLevel.equals(PRIORITY_FATAL) || cliLogLevel.equals(PRIORITY_ERROR) || cliLogLevel.equals(PRIORITY_INFO) || cliLogLevel.equals(PRIORITY_INFO2) || cliLogLevel.equals(PRIORITY_WARN) || cliLogLevel.equals(PRIORITY_WARN2) || cliLogLevel.equals(PRIORITY_DEBUG))) {
            cliLogLevel = PRIORITY_ERROR;
        }
        return cliLogLevel;
    }

    public static String getFelixLogLevel() {
        return levelToIntegerTable.getOrDefault(logLevel, "1");
    }

    static Level toLog4J2Level(String level) {
        String levelString = level.toLowerCase();
        Level l = levelTable.get(levelString);
        if (l == null) {
            throw new LogService.UnknownPriorityException(level);
        }
        return l;
    }

    static {
        levelTable = new HashMap<String, Level>();
        levelTable.put(PRIORITY_FATAL.toLowerCase(), Level.FATAL);
        levelTable.put(PRIORITY_ERROR.toLowerCase(), Level.ERROR);
        levelTable.put(PRIORITY_WARN.toLowerCase(), Level.WARN);
        levelTable.put(PRIORITY_WARN2.toLowerCase(), Level.WARN);
        levelTable.put(PRIORITY_INFO.toLowerCase(), Level.INFO);
        levelTable.put(PRIORITY_INFO2.toLowerCase(), Level.INFO);
        levelTable.put(PRIORITY_DEBUG.toLowerCase(), Level.DEBUG);
        levelToIntegerTable = new HashMap<String, String>();
        levelToIntegerTable.put(NO_LOG, "0");
        levelToIntegerTable.put(PRIORITY_FATAL, "1");
        levelToIntegerTable.put(PRIORITY_ERROR, "1");
        levelToIntegerTable.put(PRIORITY_WARN, "2");
        levelToIntegerTable.put(PRIORITY_WARN2, "2");
        levelToIntegerTable.put(PRIORITY_INFO, "3");
        levelToIntegerTable.put(PRIORITY_INFO2, "3");
        levelToIntegerTable.put(PRIORITY_DEBUG, "4");
        if (System.getSecurityManager() == null) {
            cliLogLevel = System.getProperty("coldfusion.cli.log.level", PRIORITY_ERROR);
            logLevel = System.getProperty("coldfusion.felix.log.level", PRIORITY_ERROR);
        } else {
            cliLogLevel = AccessController.doPrivileged(() -> System.getProperty("coldfusion.cli.log.level", PRIORITY_ERROR));
            logLevel = AccessController.doPrivileged(() -> System.getProperty("coldfusion.felix.log.level", PRIORITY_ERROR));
        }
    }
}

