/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.log;

import coldfusion.log.CFLogLevel;
import coldfusion.log.CFLogs;
import coldfusion.log.CFPatternLayout;
import coldfusion.log.CFRollingFileAppender;
import coldfusion.log.Logger;
import coldfusion.runtime.NeoException;
import coldfusion.server.ConfigMap;
import coldfusion.server.LoggingService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.SystemInfo;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogService
extends ServiceBase
implements LoggingService {
    public static final long DEFAULT_MAX_FILE_SIZE = 10000000L;
    public static final int DEFAULT_MAX_FILE_BACKUP = 10;
    public static final String CF5_PATTERN = "\"%p\",\"%t\",%d{\"MM/dd/yy\",\"HH:mm:ss\"},%a,\"%m%x\"%n";
    public static final String DEFAULT_PATTERN = "\"%p\",\"%t\",%d{\"MM/dd/yy\",\"HH:mm:ss\"},%a,\"%m%x\"%n";
    private String _logDirectoryPath;
    private boolean _hasStarted = false;
    private URL _logConfig;
    private Map<String, Logger> _userLogs = new HashMap<String, Logger>();
    private Map<String, Logger> _archiveLogs = new HashMap<String, Logger>();
    private File _configFile;
    private boolean isCommandLine = false;
    private HashMap<String, RollingFileAppender> _fileAppenders = new HashMap();
    private HashMap<String, Logger> _fileNameVsLogger = new HashMap();
    private ConfigMap _settings;
    private List<String> disabledForLogging;
    private static HashSet<String> systemLogs = new HashSet();

    public LogService() {
    }

    public LogService(File f, String logDir, boolean isCommandLine) {
        this._configFile = f;
        this._logDirectoryPath = logDir;
        this.isCommandLine = isCommandLine;
        this.setWatchFile(this._configFile);
    }

    public LogService(File f, String logDir) {
        this._configFile = f;
        this._logDirectoryPath = logDir;
        this.setWatchFile(this._configFile);
    }

    private void updatePathsOfLogs() {
        File log4j2Config = this.getLog4J2Config();
        Path path = log4j2Config.toPath();
        ArrayList<String> fileContent = null;
        try {
            fileContent = new ArrayList<String>(Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(e);
        }
        Object logsDirectory = this.getLogDirectory();
        if (!((String)logsDirectory).endsWith(File.separator)) {
            logsDirectory = (String)logsDirectory + File.separator;
        }
        String basePathKey = "property.basepath";
        Object basePathNewValue = basePathKey + " = " + (String)logsDirectory;
        if (SystemInfo.isWindows()) {
            basePathNewValue = ((String)basePathNewValue).replace("\\", "\\\\");
        }
        for (int i = 0; i < fileContent.size(); ++i) {
            if (!((String)fileContent.get(i)).contains(basePathKey)) continue;
            fileContent.set(i, (String)basePathNewValue);
            break;
        }
        try {
            Files.write(path, fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        try {
            this.createLogsDir();
            this.loadLoggers();
            this.stopDisabledLogs();
            this._hasStarted = true;
            this._settings.setConfigMapListener(this);
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            org.apache.logging.log4j.core.Logger axisLogger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)"org.apache.axis");
            org.apache.logging.log4j.core.Logger webSocketExceptionLogger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)"coldfusion.tagext.net.websocket");
            File log4j2config = this.getLog4J2Config();
            if (log4j2config != null && log4j2config.exists() && !ServerlessUtil.isLambdaEnv()) {
                this.updatePathsOfLogs();
            } else {
                axisLogger.setAdditive(false);
                axisLogger.setLevel(CFLogLevel.toLog4J2Level("WARN"));
                PatternLayout axisLayout = PatternLayout.newBuilder().withPattern("%d [%t] AXIS %-5p %c - %m%n").build();
                ConsoleAppender axisConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("AxisConsoleAppender")).setLayout((Layout)axisLayout)).build();
                axisConsoleAppender.start();
                config.addAppender((Appender)axisConsoleAppender);
                webSocketExceptionLogger.setAdditive(false);
                webSocketExceptionLogger.setLevel(CFLogLevel.toLog4J2Level("ERROR"));
                PatternLayout wsLayout = PatternLayout.newBuilder().withPattern("%d [%t] WebSocket %-5p %c - %m%n").build();
                ConsoleAppender wsConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("WebSocketConsoleAppender")).setLayout((Layout)wsLayout)).build();
                wsConsoleAppender.start();
                config.addAppender((Appender)wsConsoleAppender);
                ctx.updateLoggers();
            }
        }
        catch (Exception e) {
            if (Logger.isLogger("coldfusion.server")) {
                CFLogs.SERVER_LOG.fatal(e);
            }
            throw new ServiceException(e);
        }
    }

    private File getLog4J2Config() {
        return new File(this._configFile.getParent(), "log4j2.properties");
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this._configFile);
            this.disabledForLogging = (List)v.elementAt(0);
            this._settings = (ConfigMap)v.elementAt(1);
            Vector localv = (Vector)this.deserialize(this._configFile, true);
            ConfigMap _localsettings = (ConfigMap)localv.elementAt(1);
            String _logDir = (String)_localsettings.get("logDirectory");
            if (_logDir == null) {
                _logDir = this.getLogDirectory();
            }
            this._settings.put("logDirectory", (Object)_logDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.store(true);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.disabledForLogging);
        v.addElement(this._settings);
        this.serialize(v, this._configFile, broadcast, key, value, oldValue);
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.disabledForLogging);
        v.addElement(this._settings);
        this.serialize(v, this._configFile, broadcast);
    }

    @Override
    public void setSettings(Map settings) {
        if (this._settings == null) {
            this._settings = new ConfigMap();
        }
        this._settings.putAll(settings);
    }

    @Override
    public Map getSettings() {
        return this._settings;
    }

    List<String> getDisabledForLogging() {
        return this.disabledForLogging;
    }

    void setDisabledForLogging(List<String> disabledForLogging) {
        this.disabledForLogging = disabledForLogging;
    }

    @Override
    public String getLogDirectory() {
        String logDirectory = (String)this._settings.get("logDirectory");
        if (logDirectory == null || logDirectory.isEmpty()) {
            logDirectory = this._logDirectoryPath;
        } else if (logDirectory.contains("#")) {
            logDirectory = Utils.getResolvedPath(logDirectory, new File(this._logDirectoryPath).getParent());
        }
        return logDirectory;
    }

    public void setLogDirectory(String path) {
        String logDirectoryPath;
        this._logDirectoryPath = logDirectoryPath = Utils.getResolvedPath(path, new File(this._logDirectoryPath).getParent());
        this._settings.put("logDirectory", (Object)logDirectoryPath);
        this.createLogsDir();
        try {
            this.store(false);
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public boolean isConsoleVisible() {
        return new Boolean(this._settings.get("consoleVisible").toString());
    }

    public void setXMLConfiguration(URL config) {
        this._logConfig = config;
    }

    public boolean isOsLoggingEnabled() {
        return new Boolean(this._settings.get("enableOSLogging").toString());
    }

    public void setOsLoggingEnabled(boolean b) {
        this._settings.put("enableOSLogging", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public int getMaxFileSize() {
        return (int)new Double(this._settings.get("maxFileSize").toString()).longValue() / 1000;
    }

    public void setMaxFileSize(int kbyteCount) {
        int maxFileSize = kbyteCount * 1000;
        this._settings.put("maxFileSize", (Object)new Long(maxFileSize));
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public int getMaxFileBackup() {
        return new Float(this._settings.get("maxFileBackup").toString()).intValue();
    }

    public void setMaxFileBackup(int count) {
        this._settings.put("maxFileBackup", (Object)new Integer(count));
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public String getPriority() {
        return (String)this._settings.get("priority");
    }

    public void setPriority(String priority) {
        CFLogLevel.toLog4J2Level(priority);
        this._settings.put("priority", (Object)priority);
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public String getPattern() {
        if (ServerlessUtil.isLambdaEnv()) {
            return this.getConsolePattern();
        }
        return (String)this._settings.get("pattern");
    }

    public String getConsolePattern() {
        String consolePattern = (String)this._settings.get("consolePattern");
        if (consolePattern == null) {
            consolePattern = "%d{MMM d, yyyy HH:mm:ss} %p [%t] - %m%n";
            this._settings.put("consolePattern", (Object)consolePattern);
            try {
                this.store();
            }
            catch (ServiceException ex) {
                throw new ServiceRuntimeException(ex);
            }
        }
        return consolePattern;
    }

    public void setPattern(String p) {
        this._settings.put("pattern", (Object)p);
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getUserLog(String fileName) {
        Logger l = this._userLogs.get(fileName.toLowerCase());
        if (l == null) {
            LogService logService = this;
            synchronized (logService) {
                l = this._userLogs.get(fileName.toLowerCase());
                if (l == null) {
                    l = this.getLogger("coldfusion.user." + fileName);
                    try {
                        this.createFileAppender(l.getWrappedLogger(), fileName + ".log");
                        HashMap<String, Logger> logs = new HashMap<String, Logger>(this._userLogs);
                        logs.put(fileName.toLowerCase(), l);
                        this._userLogs = logs;
                    }
                    catch (Throwable th) {
                        CFLogs.SERVER_LOG.error(th);
                    }
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getArchiveLog(String fileName) {
        Logger l = this._archiveLogs.get(fileName.toLowerCase());
        if (l == null) {
            LogService logService = this;
            synchronized (logService) {
                l = this._archiveLogs.get(fileName.toLowerCase());
                if (l == null) {
                    l = this.getLogger("coldfusion.car." + fileName);
                    try {
                        this.createFileAppender(l.getWrappedLogger(), fileName + ".log", false, false);
                        HashMap<String, Logger> logs = new HashMap<String, Logger>(this._archiveLogs);
                        logs.put(fileName.toLowerCase(), l);
                        this._archiveLogs = logs;
                    }
                    catch (Throwable th) {
                        CFLogs.SERVER_LOG.error(th);
                    }
                } else {
                    this.rollOverForArchive(l);
                }
            }
        } else {
            this.rollOverForArchive(l);
        }
        return l;
    }

    private void rollOverForArchive(Logger l) {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)l.getWrappedLogger();
        for (Appender appender : logger.getAppenders().values()) {
            if (!(appender instanceof RollingFileAppender)) continue;
            RollingFileAppender rollingFileAppender = (RollingFileAppender)appender;
            ((RollingFileManager)rollingFileAppender.getManager()).rollover();
            break;
        }
    }

    public void rollLogs() {
        for (String name : this._fileAppenders.keySet()) {
            RollingFileAppender rollingFileAppender = this._fileAppenders.get(name);
            ((RollingFileManager)rollingFileAppender.getManager()).rollover();
        }
    }

    public void deleteLog(String logPath) throws IOException {
        File f = new File(logPath);
        String path = Utils.getCanonicalPath(f);
        if (path.startsWith(this.getLogDirectory()) && !f.delete()) {
            throw new FileDeleteFailedException(logPath);
        }
    }

    public void enableLogging(String fileName) throws ServiceException {
        Logger l = this._fileNameVsLogger.get(fileName = fileName.toLowerCase());
        if (l == null) {
            l = this._getUserlogsLogger(fileName);
        }
        if (l == null) {
            throw new InvalidLogFileException(fileName);
        }
        l.setLoggingEnabled(true);
        this.disabledForLogging.remove(fileName);
        this.store(fileName + "-enable", "true", "false");
    }

    private Logger _getUserlogsLogger(String fileName) {
        Logger l = this._userLogs.get(fileName.toLowerCase().split("\\.")[0]);
        return l;
    }

    public void disableLogging(String fileName) throws ServiceException {
        Logger l = this._fileNameVsLogger.get(fileName = fileName.toLowerCase());
        if (l == null) {
            l = this._getUserlogsLogger(fileName);
        }
        if (l == null) {
            throw new InvalidLogFileException(fileName);
        }
        l.setLoggingEnabled(false);
        this.disabledForLogging.add(fileName);
        this.store(fileName + "-disable", "true", "false");
    }

    public boolean isLoggingEnable(String fileName) {
        Logger l = this._fileNameVsLogger.get(fileName.toLowerCase());
        if (l == null) {
            l = this._getUserlogsLogger(fileName);
        }
        if (l == null) {
            return true;
        }
        return l.isLoggingEnabled();
    }

    public static boolean isSystemLog(String fileName) {
        return systemLogs.contains(fileName.toLowerCase());
    }

    public void rollLog(String logPath) {
        File f = new File(logPath);
        String path = Utils.getCanonicalPath(f);
        RollingFileAppender rollingFileAppender = this._fileAppenders.get(path);
        if (rollingFileAppender != null) {
            ((RollingFileManager)rollingFileAppender.getManager()).rollover();
        } else {
            String logName = f.getName();
            if (logName.endsWith(".log")) {
                logName = logName.substring(0, logName.length() - 4);
            }
            this.getUserLog(logName);
            rollingFileAppender = this._fileAppenders.get(path);
            if (rollingFileAppender == null) {
                throw new IllegalStateException("unable to roll log: " + path);
            }
            ((RollingFileManager)rollingFileAppender.getManager()).rollover();
        }
    }

    private void createLogsDir() {
        String logsDir = this.getLogDirectory();
        File f = new File(logsDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            throw new InvalidLogDirectoryException(logsDir);
        }
    }

    private void loadLoggers() {
        org.apache.logging.log4j.Logger rootLog4jLogger = LogManager.getRootLogger();
        this.createFileAppender(CFLogs.APPLICATION_LOG.getWrappedLogger(), "application.log");
        this._fileNameVsLogger.put("application.log", CFLogs.APPLICATION_LOG);
        this.createFileAppender(CFLogs.CAR_LOG.getWrappedLogger(), "car.log");
        this._fileNameVsLogger.put("car.log", CFLogs.CAR_LOG);
        this.createFileAppender(CFLogs.CUSTOMTAG_LOG.getWrappedLogger(), "customtag.log");
        this._fileNameVsLogger.put("customtag.log", CFLogs.CUSTOMTAG_LOG);
        this.createFileAppender(CFLogs.MAIL_LOG.getWrappedLogger(), "mail.log");
        this._fileNameVsLogger.put("mail.log", CFLogs.MAIL_LOG);
        this.createFileAppender(CFLogs.MAILSENT_LOG.getWrappedLogger(), "mailsent.log");
        this._fileNameVsLogger.put("mailsent.log", CFLogs.MAILSENT_LOG);
        this.createFileAppender(CFLogs.RDS_LOG.getWrappedLogger(), "rds.log");
        this._fileNameVsLogger.put("rds.log", CFLogs.RDS_LOG);
        this.createFileAppender(CFLogs.REMOTE_LOG.getWrappedLogger(), "remote.log");
        this._fileNameVsLogger.put("remote.log", CFLogs.REMOTE_LOG);
        this.createFileAppender(CFLogs.SCHEDULER_LOG.getWrappedLogger(), "scheduler.log");
        this._fileNameVsLogger.put("scheduler.log", CFLogs.SCHEDULER_LOG);
        this.createFileAppender(CFLogs.SERVER_LOG.getWrappedLogger(), "server.log");
        if (this.isCommandLine) {
            Configurator.setLevel((String)CFLogs.SERVER_LOG.getWrappedLogger().getName(), (Level)CFLogLevel.toLog4J2Level(CFLogLevel.getCliArgLogLevel()));
        }
        this._fileNameVsLogger.put("server.log", CFLogs.SERVER_LOG);
        this.createFileAppender(CFLogs.WEBSERVER_LOG.getWrappedLogger(), "webserver.log");
        this._fileNameVsLogger.put("webserver.log", CFLogs.WEBSERVER_LOG);
        this.createFileAppender(CFLogs.FLASH_LOG.getWrappedLogger(), "flash.log");
        this._fileNameVsLogger.put("flash.log", CFLogs.FLASH_LOG);
        this.createFileAppender(CFLogs.EVENT_LOG.getWrappedLogger(), "eventgateway.log");
        this._fileNameVsLogger.put("eventgateway.log", CFLogs.EVENT_LOG);
        this.createFileAppender(CFLogs.MONITOR_LOG.getWrappedLogger(), "monitor.log");
        this._fileNameVsLogger.put("monitor.log", CFLogs.MONITOR_LOG);
        this.createFileAppender(CFLogs.PRINT_LOG.getWrappedLogger(), "print.log");
        this._fileNameVsLogger.put("print.log", CFLogs.PRINT_LOG);
        this.createFileAppender(CFLogs.DOTNET_LOG.getWrappedLogger(), "dotnet.log");
        this._fileNameVsLogger.put("dotnet.log", CFLogs.DOTNET_LOG);
        this.createFileAppender(CFLogs.REPORT_LOG.getWrappedLogger(), "reporting.log");
        this._fileNameVsLogger.put("reporting.log", CFLogs.REPORT_LOG);
        this.createFileAppender(CFLogs.PORTLET_LOG.getWrappedLogger(), "cfportlet.log");
        this._fileNameVsLogger.put("cfportlet.log", CFLogs.PORTLET_LOG);
        this.createFileAppender(CFLogs.DERBY_LOG.getWrappedLogger(), "derby.log");
        this._fileNameVsLogger.put("derby.log", CFLogs.DERBY_LOG);
        this.createFileAppender(CFLogs.HTTP_LOG.getWrappedLogger(), "http.log");
        this._fileNameVsLogger.put("http.log", CFLogs.HTTP_LOG);
        this.createFileAppender(CFLogs.LDAP_LOG.getWrappedLogger(), "ldap.log");
        this._fileNameVsLogger.put("ldap.log", CFLogs.LDAP_LOG);
        this.createFileAppender(CFLogs.WEBSERVICE_LOG.getWrappedLogger(), "webservice.log");
        this._fileNameVsLogger.put("webservice.log", CFLogs.WEBSERVICE_LOG);
        this.createFileAppender(CFLogs.FTP_LOG.getWrappedLogger(), "ftp.log");
        this._fileNameVsLogger.put("ftp.log", CFLogs.FTP_LOG);
        this.createFileAppender(CFLogs.FEED_LOG.getWrappedLogger(), "feed.log");
        this._fileNameVsLogger.put("feed.log", CFLogs.FEED_LOG);
        this.createFileAppender(CFLogs.ESAPI_LOG.getWrappedLogger(), "esapi.log");
        this._fileNameVsLogger.put("esapi.log", CFLogs.ESAPI_LOG);
        this.createFileAppender(CFLogs.RESTSERVICE_LOG.getWrappedLogger(), "restservice.log");
        this._fileNameVsLogger.put("restservice.log", CFLogs.RESTSERVICE_LOG);
        this.createFileAppender(CFLogs.AUDIT_LOG.getWrappedLogger(), "audit.log");
        this._fileNameVsLogger.put("audit.log", CFLogs.AUDIT_LOG);
        this.createFileAppender(CFLogs.WEBSOCKET_LOG.getWrappedLogger(), "websocket.log");
        this._fileNameVsLogger.put("websocket.log", CFLogs.WEBSOCKET_LOG);
        this.createFileAppender(CFLogs.WEBSOCKETPROXY_LOG.getWrappedLogger(), "websocketproxy.log");
        this._fileNameVsLogger.put("websocketproxy.log", CFLogs.WEBSOCKETPROXY_LOG);
        this.createFileAppender(CFLogs.SECURITY_LOG.getWrappedLogger(), "security.log");
        this._fileNameVsLogger.put("security.log", CFLogs.SECURITY_LOG);
        this.createFileAppender(CFLogs.METRICS_LOG.getWrappedLogger(), "metrics.log");
        this._fileNameVsLogger.put("metrics.log", CFLogs.METRICS_LOG);
        this.createFileAppender(CFLogs.PDFA2_ARCHIVE_LOG.getWrappedLogger(), "pdfarchive.log");
        this._fileNameVsLogger.put("pdfarchive.log", CFLogs.PDFA2_ARCHIVE_LOG);
        this.createFileAppender(CFLogs.USAGEDATA_LOG.getWrappedLogger(), "usagedata.log");
        this._fileNameVsLogger.put("usagedata.log", CFLogs.USAGEDATA_LOG);
        this.createFileAppender(CFLogs.LICENSINGDATA_LOG.getWrappedLogger(), "license.log");
        this._fileNameVsLogger.put("license.log", CFLogs.LICENSINGDATA_LOG);
        this.createFileAppender(CFLogs.AWSS3_LOG.getWrappedLogger(), "awss3.log");
        this._fileNameVsLogger.put("awss3.log", CFLogs.AWSS3_LOG);
        this.createFileAppender(CFLogs.WDDX_LOG.getWrappedLogger(), "wddx.log");
        this._fileNameVsLogger.put("wddx.log", CFLogs.WDDX_LOG);
        this.createFileAppender(rootLog4jLogger, "exception.log", true);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig rootLoggerConfig = config.getRootLogger();
        ConsoleAppender consoleAppender = null;
        for (Appender appender : config.getAppenders().values()) {
            if (!(appender instanceof ConsoleAppender)) continue;
            consoleAppender = (ConsoleAppender)appender;
            break;
        }
        if (consoleAppender != null) {
            PatternLayout layout = CFPatternLayout.INSTANCE.getPatternLayout(config, this.getConsolePattern(), false, this.isCommandLine);
            ConsoleAppender newAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)consoleAppender.newBuilder().setName(consoleAppender.getName())).setLayout((Layout)layout)).build();
            newAppender.start();
            config.addAppender((Appender)newAppender);
            rootLoggerConfig.removeAppender(consoleAppender.getName());
            rootLoggerConfig.addAppender((Appender)newAppender, null, null);
        }
        if (this.isCommandLine) {
            Configurator.setRootLevel((Level)CFLogLevel.toLog4J2Level(CFLogLevel.getCliArgLogLevel()));
        } else {
            Configurator.setRootLevel((Level)CFLogLevel.toLog4J2Level(this.getPriority()));
        }
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            if (loggerConfig.getName() == null || loggerConfig.getName().equals("org.quartz")) continue;
            loggerConfig.setLevel(rootLoggerConfig.getLevel());
        }
        context.updateLoggers();
    }

    private void stopDisabledLogs() {
        for (String s : this.disabledForLogging) {
            Logger l = this._fileNameVsLogger.get(s.toLowerCase());
            if (l == null) {
                return;
            }
            l.setLoggingEnabled(false);
        }
    }

    private RollingFileAppender createFileAppender(org.apache.logging.log4j.Logger logger, String fileName) {
        return this.createFileAppender(logger, fileName, false);
    }

    private RollingFileAppender createFileAppender(org.apache.logging.log4j.Logger logger, String fileName, boolean logExceptions) {
        return this.createFileAppender(logger, fileName, logExceptions, true);
    }

    private RollingFileAppender createFileAppender(org.apache.logging.log4j.Logger logger, String fileName, boolean logExceptions, boolean append) {
        File f = new File(new File(this.getLogDirectory()), fileName);
        fileName = Utils.getCanonicalPath(f);
        String loggerName = logger.getName();
        if (loggerName.isEmpty()) {
            loggerName = "ExceptionLogAppender";
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        RollingFileAppender appender = this.getRollingFileAppender(config, loggerName, fileName, logExceptions, append);
        appender.start();
        config.addAppender((Appender)appender);
        if (!ServerlessUtil.isLambdaEnv()) {
            ((org.apache.logging.log4j.core.Logger)logger).addAppender(config.getAppender(loggerName));
        }
        ctx.updateLoggers();
        this._fileAppenders.put(fileName, appender);
        return appender;
    }

    private RollingFileAppender getRollingFileAppender(Configuration config, String loggerName, String fileName, boolean logExceptions, boolean append) {
        return CFRollingFileAppender.INSTANCE.getRollingFileAppender(config, loggerName, fileName, logExceptions, this.isCommandLine, append, this.getPattern(), this.getMaxFileSize(), this.getMaxFileBackup());
    }

    @Override
    public Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    static {
        systemLogs.add("wddx.log");
        systemLogs.add("application.log");
        systemLogs.add("exception.log");
        systemLogs.add("server.log");
        systemLogs.add("audit.log");
        systemLogs.add("restservice.log");
        systemLogs.add("esapiconfig.log");
        systemLogs.add("axis2.log");
        systemLogs.add("hibernatesql.log");
        systemLogs.add("migration.log");
        systemLogs.add("coldfusion-out.log");
        systemLogs.add("coldfusion-error.log");
        systemLogs.add("usagedata.log");
    }

    public static class FileDeleteFailedException
    extends NeoException {
        public String fileName;

        FileDeleteFailedException(String file) {
            this.fileName = file;
        }
    }

    public static class InvalidLogFileException
    extends NeoException {
        public String logFile;

        InvalidLogFileException(String path) {
            this.logFile = path;
        }
    }

    public static class InvalidLogDirectoryException
    extends NeoException {
        public String logDirectory;

        InvalidLogDirectoryException(String path) {
            this.logDirectory = path;
        }
    }

    public static class UnknownPriorityException
    extends NeoException {
        public String priority;

        UnknownPriorityException(String p) {
            this.priority = p;
        }
    }

    public static class SyslogInitializationException
    extends NeoException {
        SyslogInitializationException(Throwable th) {
            super(th);
        }
    }

    public static class WindowsEventLogInitializationException
    extends InternalException {
        WindowsEventLogInitializationException(Throwable th) {
            super(th);
        }
    }

    public static class InternalException
    extends NeoException {
        protected Throwable _rootCause;

        InternalException(Throwable th) {
            this._rootCause = th;
        }

        @Override
        public Throwable getRootCause() {
            return this._rootCause;
        }
    }

    public static class ConfigurationNotFoundException
    extends NeoException {
    }
}

